/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.ChannelListener;
import org.jgroups.JChannelFactory;
import org.jgroups.MembershipListener;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.blocks.RequestHandler;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.util.RspList;

public class RpcDispatcherMultiplexerTest
implements MembershipListener,
RequestHandler,
ChannelListener {
    Channel channel;
    JChannelFactory factory = null;
    RpcDispatcher disp;
    String props = null;
    boolean spurious_channel_created = false;

    public static void main(String[] args) throws Exception {
        String props = null;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (!arg.equals("-props")) {
                RpcDispatcherMultiplexerTest.help();
                return;
            }
            props = args[++i];
        }
        new RpcDispatcherMultiplexerTest().start(props);
    }

    private void start(String props) throws Exception {
        if (this.factory == null) {
            this.factory = new JChannelFactory();
        }
        this.props = props == null ? "stacks.xml" : props;
        this.factory.setMultiplexerConfig(this.props);
        this.channel = this.factory.createMultiplexerChannel("udp", "MyId");
        if (!this.spurious_channel_created) {
            Channel tmp = this.factory.createMultiplexerChannel("udp", "tempChannel");
            tmp.connect("bla");
            this.spurious_channel_created = true;
        }
        this.channel.addChannelListener(this);
        this.channel.setOpt(5, Boolean.TRUE);
        this.disp = new RpcDispatcher(this.channel, null, (MembershipListener)this, (Object)this, false, true);
        this.channel.connect("MessageDispatcherTestGroup");
        this.mainLoop();
    }

    private void stop() {
        this.disp.stop();
        this.channel.close();
    }

    private void mainLoop() throws Exception {
        while (true) {
            System.in.skip(System.in.available());
            System.out.println("\n[1] Send [2] Start service [3] Stop service [4] Print view [q] Quit");
            int c = System.in.read();
            switch (c) {
                case -1: {
                    break;
                }
                case 49: {
                    this.invokeGroupMethod();
                    break;
                }
                case 50: {
                    this.start(this.props);
                    break;
                }
                case 51: {
                    this.stop();
                    break;
                }
                case 52: {
                    View v = this.channel.getView();
                    System.out.println("View: " + v);
                    break;
                }
                case 113: {
                    this.channel.close();
                    return;
                }
            }
        }
    }

    public Object helloWorld() {
        System.out.println("method helloWorld() was called");
        return "same to you";
    }

    private void invokeGroupMethod() {
        View v = this.channel.getView();
        if (v == null) {
            return;
        }
        Vector<Address> members = new Vector<Address>(v.getMembers());
        System.out.println("sending to " + members);
        RspList rsp_list = this.disp.callRemoteMethods(members, "helloWorld", null, (String[])null, 2, 0L);
        System.out.println("responses:\n" + rsp_list);
    }

    private static void help() {
        System.out.println("MessageDispatcherShunTest [-help] [-props <props>]");
    }

    public Object handle(Message msg) {
        return "same to you";
    }

    public void viewAccepted(View new_view) {
        System.out.println("-- view: " + new_view);
    }

    public void suspect(Address suspected_mbr) {
    }

    public void block() {
    }

    public void channelConnected(Channel channel) {
    }

    public void channelDisconnected(Channel channel) {
    }

    public void channelClosed(Channel channel) {
    }

    public void channelShunned() {
    }

    public void channelReconnected(Address addr) {
    }
}

