/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webservice.cs.mail;

import java.util.ArrayList;
import java.util.List;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;
import org.exoplatform.contact.service.ContactFilter;
import org.exoplatform.contact.service.ContactService;
import org.exoplatform.contact.service.DataStorage;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.mail.service.CheckingInfo;
import org.exoplatform.mail.service.MailService;
import org.exoplatform.mail.service.MessageFilter;
import org.exoplatform.mail.service.Utils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.webservice.cs.bean.AccountsData;
import org.exoplatform.webservice.cs.bean.ContactData;
import org.exoplatform.webservice.cs.bean.FoldersTagsData;
import org.exoplatform.webservice.cs.bean.MessageData;

@Path(value="private/cs/mail")
public class MailWebservice
implements ResourceContainer {
    public static final String TEXT_XML = "text/xml".intern();
    public static final String JSON = "application/json".intern();
    public static final String TEXT = "plain/text".intern();
    public static final int MIN_SLEEP_TIMEOUT = 100;
    public static final int MAX_TIMEOUT = 16;
    private static final Log log = ExoLogger.getLogger((String)"cs.mail.webservice");

    @GET
    @Path(value="/checkmail/{username}/{accountId}/{folderId}/")
    public Response checkMail(@PathParam(value="username") String userName, @PathParam(value="accountId") String accountId, @PathParam(value="folderId") String folderId) throws Exception {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        if (!this.isAuthorized(userName)) {
            return Response.ok((Object)Response.Status.UNAUTHORIZED).cacheControl(cacheControl).build();
        }
        MailService mailService = (MailService)PortalContainer.getInstance().getComponentInstanceOfType(MailService.class);
        CheckingInfo checkingInfo = mailService.getCheckingInfo(userName, accountId);
        if (checkingInfo == null || checkingInfo.getStatusCode() == 200 || checkingInfo.getStatusCode() == 102 || checkingInfo.getStatusCode() == 103 || checkingInfo.getStatusCode() == 104) {
            mailService.checkMail(userName, accountId, folderId);
        } else if (checkingInfo != null) {
            checkingInfo.setHasChanged(true);
            mailService.updateCheckingMailStatusByCometd(userName, accountId, checkingInfo);
        }
        StringBuffer buffer = new StringBuffer("");
        return Response.ok((Object)buffer.toString(), (String)"text/xml").cacheControl(cacheControl).build();
    }

    @GET
    @Path(value="/synchfolders/{username}/{accountId}/")
    public Response synchFolders(@PathParam(value="username") String userName, @PathParam(value="accountId") String accountId) throws Exception {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        if (!this.isAuthorized(userName)) {
            return Response.ok((Object)Response.Status.UNAUTHORIZED).cacheControl(cacheControl).build();
        }
        MailService mailService = (MailService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(MailService.class);
        CheckingInfo checkingInfo = mailService.getCheckingInfo(userName, accountId);
        if (checkingInfo == null || checkingInfo.getSyncFolderStatus() == 302) {
            mailService.synchImapFolders(userName, accountId);
            checkingInfo = mailService.getCheckingInfo(userName, accountId);
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("<info>");
        buffer.append("  <checkingmail>");
        if (checkingInfo != null) {
            buffer.append("    <status>" + checkingInfo.getSyncFolderStatus() + "</status>");
        }
        buffer.append("  </checkingmail>");
        buffer.append("</info>");
        return Response.ok((Object)buffer.toString(), (String)"text/xml").cacheControl(cacheControl).build();
    }

    @GET
    @Path(value="/stopcheckmail/{username}/{accountId}/")
    public Response stopCheckMail(@PathParam(value="username") String userName, @PathParam(value="accountId") String accountId) throws Exception {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        if (!this.isAuthorized(userName)) {
            return Response.ok((Object)Response.Status.UNAUTHORIZED).cacheControl(cacheControl).build();
        }
        MailService mailService = (MailService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(MailService.class);
        StringBuffer buffer = new StringBuffer();
        CheckingInfo checkingInfo = mailService.getCheckingInfo(userName, accountId);
        if (checkingInfo == null) {
            Response.status((int)500);
            return Response.ok().build();
        }
        buffer.append("<info>");
        buffer.append("  <checkingmail>");
        buffer.append("    <status>" + checkingInfo.getStatusCode() + "</status>");
        buffer.append("    <statusmsg>" + checkingInfo.getStatusMsg() + "</statusmsg>");
        buffer.append("  </checkingmail>");
        buffer.append("</info>");
        mailService.stopCheckMail(userName, accountId);
        return Response.ok((Object)buffer.toString(), (String)"text/xml").cacheControl(cacheControl).build();
    }

    @GET
    @Path(value="/checkmailjobinfo/{username}/{accountId}/")
    public Response getCheckMailJobInfo(@PathParam(value="username") String userName, @PathParam(value="accountId") String accountId) throws Exception {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        if (!this.isAuthorized(userName)) {
            return Response.ok((Object)Response.Status.UNAUTHORIZED).cacheControl(cacheControl).build();
        }
        MailService mailService = (MailService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(MailService.class);
        CheckingInfo checkingInfo = mailService.getCheckingInfo(userName, accountId);
        StringBuffer buffer = new StringBuffer();
        if (checkingInfo == null) {
            Thread.sleep(100L);
            checkingInfo = mailService.getCheckingInfo(userName, accountId);
            buffer.append("<info>");
            buffer.append("  <checkingmail>");
            buffer.append("    <status>1000</status>");
            buffer.append("  </checkingmail>");
            buffer.append("</info>");
            return Response.ok((Object)buffer.toString(), (String)"text/xml").cacheControl(cacheControl).build();
        }
        if (checkingInfo != null && !checkingInfo.hasChanged()) {
            Thread.sleep(100L);
            for (int i = 1; i < 1600 && !checkingInfo.hasChanged(); ++i) {
                Thread.sleep(100L);
            }
        }
        if (checkingInfo != null) {
            if (checkingInfo.getStatusCode() == 200 || checkingInfo.getStatusCode() == 102 || checkingInfo.getStatusCode() == 103 || checkingInfo.getStatusCode() == 101) {
                buffer.append("<info>");
                buffer.append("  <checkingmail>");
                buffer.append("    <status>" + checkingInfo.getStatusCode() + "</status>");
                buffer.append("    <statusmsg>" + checkingInfo.getStatusMsg() + "</statusmsg>");
                buffer.append("  </checkingmail>");
                buffer.append("</info>");
                if (checkingInfo.getStatusCode() == 200) {
                    // empty if block
                }
                return Response.ok((Object)buffer.toString(), (String)"text/xml").cacheControl(cacheControl).build();
            }
            if (checkingInfo.hasChanged()) {
                buffer.append("<info>");
                buffer.append("  <checkingmail>");
                buffer.append("    <status>150</status>");
                buffer.append("    <statusmsg>" + checkingInfo.getStatusMsg() + "</statusmsg>");
                buffer.append("    <total>" + checkingInfo.getTotalMsg() + "</total>");
                buffer.append("    <syncFolderStatus>" + checkingInfo.getSyncFolderStatus() + "</syncFolderStatus>");
                buffer.append("    <completed>" + checkingInfo.getFetching() + "</completed>");
                buffer.append("    <fetchingtofolders>" + checkingInfo.getFetchingToFolders() + "</fetchingtofolders>");
                if (checkingInfo.getMsgId() != null && !checkingInfo.getMsgId().equals("")) {
                    buffer.append("    <messageid>" + checkingInfo.getMsgId().replace("<", "&lt;").replace(">", "&gt;") + "</messageid>");
                }
                buffer.append("  </checkingmail>");
                buffer.append("</info>");
                checkingInfo.setHasChanged(false);
            } else {
                buffer.append("<info>");
                buffer.append("  <checkingmail>");
                buffer.append("    <status>201</status>");
                buffer.append("    <statusmsg>" + checkingInfo.getStatusMsg() + "</statusmsg>");
                buffer.append("  </checkingmail>");
                buffer.append("</info>");
            }
        }
        return Response.ok((Object)buffer.toString(), (String)"text/xml").cacheControl(cacheControl).build();
    }

    @GET
    @Path(value="/searchemail/{keywords}")
    @Produces(value={"application/json"})
    public Response searchemail(@PathParam(value="keywords") String keywords) throws Exception {
        ContactService contactSvr = (ContactService)PortalContainer.getInstance().getComponentInstanceOfType(ContactService.class);
        ContactData fullData = new ContactData();
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        try {
            if (ConversationState.getCurrent().getIdentity() == null) {
                return Response.ok((Object)Response.Status.UNAUTHORIZED).cacheControl(cacheControl).build();
            }
            String username = ConversationState.getCurrent().getIdentity().getUserId();
            if (username == null) {
                return Response.ok((Object)Response.Status.UNAUTHORIZED).cacheControl(cacheControl).build();
            }
            ContactFilter filter = new ContactFilter();
            filter.setType(DataStorage.PERSONAL);
            filter.searchByAnd(false);
            filter.setFullName(keywords);
            filter.setNickName(keywords);
            filter.setLimit(10);
            filter.setEmailAddress(keywords);
            fullData.setInfo(contactSvr.searchEmailsByFilter(username, filter));
        }
        catch (Exception e) {
            log.error((Object)"error search email", (Throwable)e);
            return Response.ok((Object)Response.Status.INTERNAL_SERVER_ERROR).cacheControl(cacheControl).build();
        }
        return Response.ok((Object)fullData, (String)"application/json").cacheControl(cacheControl).build();
    }

    @GET
    @Path(value="/unreadMail/{accountId}/{folderId}/{tagId}/{limit}")
    @Produces(value={"application/json"})
    public Response unreadMail(@PathParam(value="accountId") String accountId, @PathParam(value="folderId") String folderId, @PathParam(value="tagId") String tagId, @PathParam(value="limit") int limit) throws Exception {
        List messList;
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        MailService mailService = (MailService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(MailService.class);
        String username = ConversationState.getCurrent().getIdentity().getUserId();
        MessageFilter filter = new MessageFilter("Folder");
        MessageData data = new MessageData();
        if (Utils.isEmptyField((String)accountId) || accountId.equals("_")) {
            return Response.ok((Object)data, (String)"application/json").cacheControl(cacheControl).build();
        }
        filter.setAccountId(accountId);
        if (!Utils.isEmptyField((String)folderId) && !folderId.equals("_")) {
            filter.setFolder(new String[]{folderId});
        }
        if (!Utils.isEmptyField((String)tagId) && !tagId.equals("_")) {
            filter.setTag(new String[]{tagId});
        }
        filter.setViewQuery("@" + Utils.EXO_ISUNREAD + "='true'");
        filter.setOrderBy(Utils.EXO_LAST_UPDATE_TIME);
        try {
            messList = mailService.getMessages(username, filter);
        }
        catch (Exception e) {
            return Response.ok((Object)data, (String)"application/json").cacheControl(cacheControl).build();
        }
        try {
            data.setInfo(messList.subList(0, limit));
        }
        catch (IndexOutOfBoundsException e) {
            data.setInfo(messList.subList(0, messList.size()));
        }
        return Response.ok((Object)data, (String)"application/json").cacheControl(cacheControl).build();
    }

    @GET
    @Path(value="/getAccounts/")
    @Produces(value={"application/json"})
    public Response getAccounts() throws Exception {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        MailService mailService = (MailService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(MailService.class);
        String username = ConversationState.getCurrent().getIdentity().getUserId();
        List accounts = mailService.getAccounts(username);
        AccountsData data = new AccountsData();
        if (accounts.size() > 0) {
            data.setInfo(accounts);
        }
        return Response.ok((Object)data, (String)"application/json").cacheControl(cacheControl).build();
    }

    @GET
    @Path(value="/getFoldersTags/{accountId}")
    @Produces(value={"application/json"})
    public Response getFoldersTags(@PathParam(value="accountId") String accountId) throws Exception {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        MailService mailService = (MailService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(MailService.class);
        String username = ConversationState.getCurrent().getIdentity().getUserId();
        FoldersTagsData data = new FoldersTagsData();
        data.setFolders(mailService.getFolders(username, accountId));
        data.setTags(mailService.getTags(username, accountId));
        return Response.ok((Object)data, (String)"application/json").cacheControl(cacheControl).build();
    }

    private boolean isAuthorized(String usename) {
        return ConversationState.getCurrent() != null && ConversationState.getCurrent().getIdentity() != null && ConversationState.getCurrent().getIdentity().getUserId() != null && ConversationState.getCurrent().getIdentity().getUserId().equals(usename);
    }

    @GET
    @Path(value="/checkforsupportedtypes/{mechs}/{username}/{protocol}/{host}")
    @Produces(value={"application/json"})
    public Response checkForSupportedTypes(@PathParam(value="mechs") String mechanisms, @PathParam(value="username") String username, @PathParam(value="protocol") String proto, @PathParam(value="host") String host) throws Exception {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        StringBuilder data = new StringBuilder();
        String[] mechs = mechanisms.split(",");
        int i = 0;
        for (String m : mechs) {
            if (m.equalsIgnoreCase("kerberos-gssapi")) {
                mechs[i] = m.substring(m.indexOf("-"));
            }
            mechs[i] = m;
            i = 1;
        }
        SaslClient sasl = Sasl.createSaslClient(mechs, username, proto, host, null, null);
        if (sasl != null) {
            log.info((Object)sasl.getMechanismName());
        }
        if (mechs != null && mechs.length > 0) {
            for (String mech : mechs) {
                data.append(mech);
            }
        }
        return Response.ok((Object)data, (String)"application/json").cacheControl(cacheControl).build();
    }

    @GET
    @Path(value="/searchuser/{keywords}")
    @Produces(value={"application/json"})
    public Response searchUser(@PathParam(value="keywords") String keywords) throws Exception {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        ContactData fullData = new ContactData();
        try {
            OrganizationService service = (OrganizationService)PortalContainer.getInstance().getComponentInstanceOfType(OrganizationService.class);
            List user = service.getUserHandler().findUsers(new Query()).getAll();
            ArrayList<String> userList = new ArrayList<String>();
            if (user != null && user.size() > 0) {
                for (User u : user) {
                    String username = u.getUserName();
                    if (!username.contains(keywords)) continue;
                    username = "<div class='AutoCompleteItem'>" + username.replace(keywords, "<b>" + keywords + "</b>") + "</div>";
                    userList.add(username);
                }
            }
            fullData.setInfo(userList);
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).cacheControl(cacheControl).build();
        }
        return Response.ok((Object)fullData, (String)"application/json").cacheControl(cacheControl).build();
    }
}

