/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.rest.json;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.rest.RESTOrganizationServiceAbstractImpl;
import org.exoplatform.services.organization.rest.json.CountBean;
import org.exoplatform.services.organization.rest.json.UserBean;
import org.exoplatform.services.organization.rest.json.UserListBean;
import org.exoplatform.services.rest.resource.ResourceContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Path(value="/organization/json/")
public class RESTOrganizationServiceJSONImpl
extends RESTOrganizationServiceAbstractImpl
implements ResourceContainer {
    protected static final String JSON_CONTENT_TYPE = "application/json";
    private static final String ASCENDING = "ascending";
    private static final String DESCENDING = "descending";
    private static final String USERNAME = "username";
    private static final String FIRSTNAME = "firstname";
    private static final String LASTNAME = "lastname";
    private static final CacheControl cc = new CacheControl();

    public RESTOrganizationServiceJSONImpl(OrganizationService organizationService) {
        super(organizationService);
    }

    @GET
    @Path(value="/user/find-all/")
    @Produces(value={"application/json"})
    public Response findUsers(@Context UriInfo uriInfo, @QueryParam(value="username") String username, @QueryParam(value="firstname") String firstname, @QueryParam(value="lastname") String lastname, @QueryParam(value="email") String email, @QueryParam(value="fromLoginDate") String fromLoginDate, @QueryParam(value="toLogindate") String toLoginDate) {
        try {
            Query query = new Query();
            query.setUserName(username);
            query.setFirstName(firstname);
            query.setLastName(lastname);
            query.setEmail(email);
            if (fromLoginDate != null) {
                try {
                    query.setFromLoginDate(DateFormat.getDateTimeInstance().parse(fromLoginDate));
                }
                catch (ParseException e) {
                    LOGGER.warn((Object)("Thrown exception : " + e));
                }
            }
            if (toLoginDate != null) {
                try {
                    query.setToLoginDate(DateFormat.getDateTimeInstance().parse(toLoginDate));
                }
                catch (ParseException e) {
                    LOGGER.warn((Object)("Thrown exception : " + e));
                }
            }
            PageList pageList = this.organizationService_.getUserHandler().findUsers(query);
            ArrayList list = new ArrayList();
            int pages = pageList.getAvailablePage();
            for (int i = 1; i <= pages; ++i) {
                list.addAll(pageList.getPage(i));
            }
            ArrayList<UserBean> listBean = new ArrayList<UserBean>();
            for (User user : list) {
                if (user == null) continue;
                listBean.add(new UserBean(user));
            }
            UserListBean user_list = new UserListBean(listBean);
            return Response.ok((Object)user_list, (String)JSON_CONTENT_TYPE).cacheControl(cc).build();
        }
        catch (Exception e) {
            LOGGER.error((Object)("Thrown exception : " + e));
            return Response.status((int)500).entity((Object)("Thrown exception : " + e)).build();
        }
    }

    @GET
    @Path(value="/user/find-user-in-range/")
    @Produces(value={"application/json"})
    public Response findUsersRange(@Context UriInfo uriInfo, @QueryParam(value="question") String question, @QueryParam(value="from") Integer from, @QueryParam(value="to") Integer to, @QueryParam(value="sort-order") String sortOrder, @QueryParam(value="sort-field") String sortField) {
        try {
            List temp = new ArrayList();
            Comparator<User> comparator = this.getComparator(sortField, sortOrder);
            if (comparator == null) {
                LOGGER.error((Object)("You set wrong parameters fo sorting! sort-order = [ascending, descending], sort-field = [username, lastname, firstname]. You set sort-field = " + sortField + " sort-order = " + sortOrder));
                return Response.status((int)400).entity((Object)("You set wrong parameters fo sorting! sort-order = [ascending, descending], sort-field = [username, lastname, firstname]. You set sort-field = " + sortField + " sort-order = " + sortOrder)).build();
            }
            TreeSet<User> users = new TreeSet<User>(comparator);
            int numResult = to - from;
            if (numResult <= 0) {
                return Response.noContent().cacheControl(cc).build();
            }
            Query query = new Query();
            query.setUserName(question);
            PageList pageList = this.userHandler.findUsers(query);
            int totalUsers = 0;
            Iterator i = null;
            if ("*".equals(question.trim())) {
                pageList.setPageSize(numResult);
                int page = from / numResult + 1;
                temp = pageList.getPage(page);
                for (User user : temp) {
                    if (users.contains(user)) continue;
                    users.add(user);
                }
                totalUsers = pageList.getAvailable();
                i = users.iterator();
            } else {
                temp = pageList.getAll();
                for (User user : temp) {
                    if (users.contains(user)) continue;
                    users.add(user);
                }
                query = new Query();
                query.setFirstName(question);
                pageList = this.userHandler.findUsers(query);
                temp = pageList.getAll();
                for (User user : temp) {
                    if (users.contains(user)) continue;
                    users.add(user);
                }
                query = new Query();
                query.setLastName(question);
                pageList = this.userHandler.findUsers(query);
                temp = pageList.getAll();
                for (User user : temp) {
                    if (users.contains(user)) continue;
                    users.add(user);
                }
                totalUsers = users.size();
                List list = new ArrayList<User>();
                list.addAll(users);
                int page = from / numResult + 1;
                int f = (page - 1) * numResult;
                int t = page * numResult;
                if (t > totalUsers) {
                    t = totalUsers;
                }
                list = list.subList(f, t);
                i = list.iterator();
            }
            ArrayList<UserBean> uList = new ArrayList<UserBean>();
            while (i.hasNext()) {
                User user = (User)i.next();
                uList.add(new UserBean(user));
            }
            UserListBean user_list = new UserListBean(uList);
            user_list.setTotalUser(totalUsers);
            return Response.ok((Object)user_list, (String)JSON_CONTENT_TYPE).cacheControl(cc).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error((Object)("Thrown exception : " + e));
            return Response.status((int)500).entity((Object)("Thrown exception : " + e)).build();
        }
    }

    @Override
    @GET
    @Path(value="/user/info/{username}/")
    @Produces(value={"application/json"})
    public Response getUser(@PathParam(value="username") String username) {
        try {
            User user = this.userHandler.findUserByName(username);
            if (user == null) {
                return Response.status((int)404).entity((Object)("User '" + username + "' not found.")).build();
            }
            return Response.ok((Object)user).cacheControl(cc).build();
        }
        catch (Exception e) {
            LOGGER.error((Object)("Thrown exception : " + e));
            return Response.status((int)500).entity((Object)("Thrown exception : " + e)).build();
        }
    }

    @GET
    @Path(value="/users/")
    @Produces(value={"application/json"})
    public Response getUsers(@Context UriInfo uriInfo) {
        return Response.noContent().cacheControl(cc).build();
    }

    @Override
    @GET
    @Path(value="/user/count/")
    @Produces(value={"application/json"})
    public Response getUsersCount() {
        try {
            int number = this.userHandler.getUserPageList(20).getAvailable();
            return Response.ok((Object)new CountBean(number), (String)JSON_CONTENT_TYPE).cacheControl(cc).build();
        }
        catch (Exception e) {
            LOGGER.error((Object)("Thrown exception : " + e));
            return Response.status((int)500).entity((Object)("Thrown exception : " + e)).build();
        }
    }

    private Comparator<User> getComparator(String sortField, String sortOrder) {
        if (sortOrder == null || sortOrder.length() == 0) {
            sortOrder = ASCENDING;
        }
        if (sortField == null || sortField.length() == 0) {
            sortField = USERNAME;
        }
        if (sortOrder.equalsIgnoreCase(ASCENDING)) {
            if (sortField.equalsIgnoreCase(FIRSTNAME)) {
                return new FirstNameComporatorAsc();
            }
            if (sortField.equalsIgnoreCase(LASTNAME)) {
                return new LastNameComporatorAsc();
            }
            if (sortField.equalsIgnoreCase(USERNAME)) {
                return new UserNameComporatorAsc();
            }
        } else if (sortOrder.equalsIgnoreCase(DESCENDING)) {
            if (sortField.equalsIgnoreCase(FIRSTNAME)) {
                return new FirstNameComporatorDesc();
            }
            if (sortField.equalsIgnoreCase(LASTNAME)) {
                return new LastNameComporatorDesc();
            }
            if (sortField.equalsIgnoreCase(USERNAME)) {
                return new UserNameComporatorDesc();
            }
        }
        return null;
    }

    static {
        cc.setNoCache(true);
        cc.setNoStore(true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LastNameComporatorDesc
    implements Comparator<User> {
        private LastNameComporatorDesc() {
        }

        @Override
        public int compare(User u1, User u2) {
            if (u1.getLastName() == null) {
                return -1;
            }
            if (u2.getLastName() == null) {
                return 1;
            }
            return -u1.getLastName().compareTo(u2.getLastName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LastNameComporatorAsc
    implements Comparator<User> {
        private LastNameComporatorAsc() {
        }

        @Override
        public int compare(User u1, User u2) {
            if (u1.getLastName() == null) {
                return 1;
            }
            if (u2.getLastName() == null) {
                return -1;
            }
            return u1.getLastName().compareTo(u2.getLastName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FirstNameComporatorDesc
    implements Comparator<User> {
        private FirstNameComporatorDesc() {
        }

        @Override
        public int compare(User u1, User u2) {
            if (u1.getFirstName() == null) {
                return -1;
            }
            if (u2.getFirstName() == null) {
                return 1;
            }
            return -u1.getFirstName().compareTo(u2.getFirstName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FirstNameComporatorAsc
    implements Comparator<User> {
        private FirstNameComporatorAsc() {
        }

        @Override
        public int compare(User u1, User u2) {
            if (u1.getFirstName() == null) {
                return 1;
            }
            if (u2.getFirstName() == null) {
                return -1;
            }
            return u1.getFirstName().compareTo(u2.getFirstName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UserNameComporatorDesc
    implements Comparator<User> {
        private UserNameComporatorDesc() {
        }

        @Override
        public int compare(User u1, User u2) {
            return -u1.getUserName().compareTo(u2.getUserName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UserNameComporatorAsc
    implements Comparator<User> {
        private UserNameComporatorAsc() {
        }

        @Override
        public int compare(User u1, User u2) {
            return u1.getUserName().compareTo(u2.getUserName());
        }
    }
}

