/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.jmx;

import java.lang.reflect.Method;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.component.ComponentLifecycle;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.Component;
import org.exoplatform.container.xml.ExternalComponentPlugins;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.PicoContainer;
import org.picocontainer.defaults.AbstractComponentAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MX4JComponentAdapter
extends AbstractComponentAdapter {
    private static final long serialVersionUID = -9001193588034229411L;
    private volatile Object instance_;
    private Log log = ExoLogger.getLogger((String)"exo.kernel.container.MX4JComponentAdapter");

    public MX4JComponentAdapter(Object key, Class implementation) {
        super(key, implementation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getComponentInstance(PicoContainer container) {
        if (this.instance_ != null) {
            return this.instance_;
        }
        ExoContainer exocontainer = (ExoContainer)container;
        Component component = null;
        try {
            ExternalComponentPlugins ecplugins;
            ConfigurationManager manager;
            String componentKey;
            InitParams params = null;
            boolean debug = false;
            MX4JComponentAdapter mX4JComponentAdapter = this;
            synchronized (mX4JComponentAdapter) {
                if (this.instance_ != null) {
                    return this.instance_;
                }
                Object key = this.getComponentKey();
                componentKey = key instanceof String ? (String)key : ((Class)key).getName();
                manager = (ConfigurationManager)exocontainer.getComponentInstanceOfType(ConfigurationManager.class);
                component = manager.getComponent(componentKey);
                if (component != null) {
                    params = component.getInitParams();
                    debug = component.getShowDeployInfo();
                }
                Object instance = exocontainer.createComponent(this.getComponentImplementation(), params);
                if (this.instance_ != null) {
                    return this.instance_;
                }
                this.instance_ = instance;
            }
            if (debug) {
                this.log.debug((Object)("==> create  component : " + this.instance_));
            }
            if (component != null && component.getComponentPlugins() != null) {
                this.addComponentPlugin(debug, this.instance_, component.getComponentPlugins(), exocontainer);
            }
            if ((ecplugins = manager.getConfiguration().getExternalComponentPlugins(componentKey)) != null) {
                this.addComponentPlugin(debug, this.instance_, ecplugins.getComponentPlugins(), exocontainer);
            }
            if (this.instance_ instanceof ComponentLifecycle) {
                ComponentLifecycle lc = (ComponentLifecycle)this.instance_;
                lc.initComponent(exocontainer);
            }
        }
        catch (Exception ex) {
            String msg = "Cannot instantiate component " + this.getComponentImplementation();
            if (component != null) {
                msg = "Cannot instantiate component key=" + component.getKey() + " type=" + component.getType() + " found at " + component.getDocumentURL();
            }
            throw new RuntimeException(msg, ex);
        }
        return this.instance_;
    }

    private void addComponentPlugin(boolean debug, final Object component, List<org.exoplatform.container.xml.ComponentPlugin> plugins, ExoContainer container) throws Exception {
        if (plugins == null) {
            return;
        }
        for (org.exoplatform.container.xml.ComponentPlugin plugin : plugins) {
            try {
                Class<?> pluginClass = Class.forName(plugin.getType());
                ComponentPlugin cplugin = (ComponentPlugin)container.createComponent(pluginClass, plugin.getInitParams());
                cplugin.setName(plugin.getName());
                cplugin.setDescription(plugin.getDescription());
                Class<?> clazz = component.getClass();
                final Method m = this.getSetMethod(clazz, plugin.getSetMethod(), pluginClass);
                if (m == null) {
                    this.log.error((Object)("Cannot find the method '" + plugin.getSetMethod() + "' that has only one parameter of type '" + pluginClass.getName() + "' in the class '" + clazz.getName() + "'."));
                    continue;
                }
                final Object[] params = new Object[]{cplugin};
                SecurityHelper.doPrivilegedExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        m.invoke(component, params);
                        return null;
                    }
                });
                if (debug) {
                    this.log.debug((Object)("==> add component plugin: " + cplugin));
                }
                cplugin.setName(plugin.getName());
                cplugin.setDescription(plugin.getDescription());
            }
            catch (Exception ex) {
                this.log.error((Object)("Failed to instanciate plugin " + plugin.getName() + "for component " + component + ": " + ex.getMessage()), (Throwable)ex);
            }
        }
    }

    private Method getSetMethod(Class clazz, String name, Class pluginClass) {
        Method[] methods = clazz.getMethods();
        Method bestCandidate = null;
        int depth = -1;
        for (Method m : methods) {
            Class<?>[] types;
            if (!name.equals(m.getName()) || (types = m.getParameterTypes()) == null || types.length != 1 || !ComponentPlugin.class.isAssignableFrom(types[0])) continue;
            int currentDepth = MX4JComponentAdapter.getClosestMatchDepth(pluginClass, types[0]);
            if (currentDepth == 0) {
                return m;
            }
            if (depth != -1 && depth <= currentDepth) continue;
            bestCandidate = m;
            depth = currentDepth;
        }
        return bestCandidate;
    }

    private static int getClosestMatchDepth(Class pluginClass, Class type) {
        return MX4JComponentAdapter.getClosestMatchDepth(pluginClass, type, 0);
    }

    private static int getClosestMatchDepth(Class pluginClass, Class type, int depth) {
        if (pluginClass == null || pluginClass.isAssignableFrom(type)) {
            return depth;
        }
        return MX4JComponentAdapter.getClosestMatchDepth(pluginClass.getSuperclass(), type, depth + 1);
    }

    public void verify(PicoContainer container) {
    }
}

