/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.management.jmx.impl;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.modelmbean.ModelMBeanInfo;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.impl.ExoMBeanInfoBuilder;
import org.exoplatform.management.jmx.impl.ExoModelMBean;
import org.exoplatform.management.jmx.impl.JMX;
import org.exoplatform.management.jmx.impl.MBeanScopingData;
import org.exoplatform.management.jmx.impl.PropertiesInfo;
import org.exoplatform.management.spi.ManagedResource;
import org.exoplatform.management.spi.ManagementProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class JMXManagementProvider
implements ManagementProvider {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.kernel.container.JMXManagementProvider");
    private final MBeanServer server;

    public JMXManagementProvider() {
        this(MBeanServerFactory.createMBeanServer());
    }

    public JMXManagementProvider(MBeanServer server) {
        this.server = server;
    }

    public Object manage(ManagedResource context) {
        ExoModelMBean mbean = null;
        try {
            ExoMBeanInfoBuilder infoBuilder = new ExoMBeanInfoBuilder(context.getMetaData());
            ModelMBeanInfo info = infoBuilder.build();
            mbean = new ExoModelMBean(context, context.getResource(), info);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (mbean != null) {
            ObjectName on = null;
            PropertiesInfo oni = PropertiesInfo.resolve(context.getResource().getClass(), NameTemplate.class);
            if (oni != null) {
                try {
                    MBeanScopingData foo = oni.resolve(context.getResource());
                    on = JMX.createObjectName("exo", foo);
                }
                catch (MalformedObjectNameException e) {
                    e.printStackTrace();
                }
            }
            if (on != null) {
                try {
                    Hashtable<String, String> props = new Hashtable<String, String>();
                    List<MBeanScopingData> list = context.getScopingData(MBeanScopingData.class);
                    for (MBeanScopingData scopingData : list) {
                        props.putAll(scopingData);
                    }
                    Iterator<Object> i$ = on.getKeyPropertyList().entrySet().iterator();
                    while (i$.hasNext()) {
                        Map.Entry o;
                        Map.Entry entry = o = (Map.Entry)i$.next();
                        String key = (String)entry.getKey();
                        String value = (String)entry.getValue();
                        props.put(key, value);
                    }
                    on = JMX.createObjectName(on.getDomain(), props);
                    this.attemptToRegister(on, mbean);
                    return on;
                }
                catch (MalformedObjectNameException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void attemptToRegister(final ObjectName name, final Object mbean) {
        MBeanServer mBeanServer = this.server;
        synchronized (mBeanServer) {
            if (this.server.isRegistered(name)) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("The MBean '" + name + " has already been registered, it will be unregistered and then re-registered"));
                }
                try {
                    SecurityHelper.doPrivilegedExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                        @Override
                        public Void run() throws Exception {
                            JMXManagementProvider.this.server.unregisterMBean(name);
                            return null;
                        }
                    });
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to unregister MBean '" + name + " due to " + e.getMessage(), e);
                }
            }
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        JMXManagementProvider.this.server.registerMBean(mbean, name);
                        return null;
                    }
                });
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to register MBean '" + name + " due to " + e.getMessage(), e);
            }
        }
    }

    public void unmanage(Object key) {
        final ObjectName name = (ObjectName)key;
        try {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        JMXManagementProvider.this.server.unregisterMBean(name);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                Throwable cause = pae.getCause();
                if (cause instanceof InstanceNotFoundException) {
                    throw (InstanceNotFoundException)cause;
                }
                if (cause instanceof MBeanRegistrationException) {
                    throw (MBeanRegistrationException)cause;
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new RuntimeException(cause);
            }
        }
        catch (InstanceNotFoundException e) {
            e.printStackTrace();
        }
        catch (MBeanRegistrationException e) {
            e.printStackTrace();
        }
    }
}

