/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.command.impl;

import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import org.apache.commons.chain.config.ConfigParser;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class CommonsXMLConfigurationPlugin
extends BaseComponentPlugin {
    private static Log log = ExoLogger.getLogger((String)"exo.kernel.component.cache.CommonsXMLConfigurationPlugin");

    public CommonsXMLConfigurationPlugin(InitParams params, ConfigurationManager configurationManager) throws Exception {
        ValueParam confFile = params.getValueParam("config-file");
        if (confFile != null) {
            final String path = confFile.getValue();
            final ConfigParser parser = new ConfigParser();
            URL res = AccessController.doPrivileged(new PrivilegedAction<URL>(){

                @Override
                public URL run() {
                    return Thread.currentThread().getContextClassLoader().getResource(path);
                }
            });
            if (res == null) {
                res = configurationManager.getResource(path);
            }
            if (res == null) {
                throw new Exception("Resource not found " + path);
            }
            log.info((Object)("Catalog configuration found at " + res));
            final URL fRes = res;
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    parser.parse(fRes);
                    return null;
                }
            });
        }
    }
}

