/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.mop.core.api.workspace;

import org.chromattic.api.annotations.FormattedBy;
import org.chromattic.api.annotations.Id;
import org.chromattic.api.annotations.MappedBy;
import org.chromattic.api.annotations.Name;
import org.chromattic.api.annotations.NamingPrefix;
import org.chromattic.api.annotations.OneToOne;
import org.chromattic.api.annotations.Owner;
import org.chromattic.api.annotations.PrimaryType;
import org.chromattic.ext.format.BaseEncodingObjectFormatter;
import org.gatein.mop.api.content.CustomizationContext;
import org.gatein.mop.api.workspace.ObjectType;
import org.gatein.mop.api.workspace.WorkspaceObject;
import org.gatein.mop.core.api.AttributesImpl;
import org.gatein.mop.core.api.ModelImpl;
import org.gatein.mop.core.api.workspace.PageImpl;
import org.gatein.mop.core.api.workspace.SiteImpl;
import org.gatein.mop.core.api.workspace.UIWindowImpl;
import org.gatein.mop.core.api.workspace.WorkspaceCustomizationContextImpl;
import org.gatein.mop.core.api.workspace.WorkspaceImpl;

@NamingPrefix(value="mop")
@FormattedBy(value=BaseEncodingObjectFormatter.class)
@PrimaryType(name="mop:workspaceobject")
public abstract class WorkspaceObjectImpl
implements WorkspaceObject {
    public ModelImpl model;

    @Name
    public abstract String getNodeName();

    public abstract void setNodeName(String var1);

    @Id
    public abstract String getObjectId();

    @OneToOne
    @MappedBy(value="mop:attributes")
    @Owner
    public abstract AttributesImpl getAttributes();

    public <A> A adapt(Class<A> adaptedType) {
        return this.model.getAdapter(this, adaptedType, true);
    }

    public boolean isAdapted(Class<?> adaptedType) {
        return this.model.getAdapter(this, adaptedType, false) != null;
    }

    public String getName() {
        return this.getNodeName();
    }

    public String toString() {
        ObjectType objectType = this.getObjectType();
        Class javaType = objectType.getJavaType();
        String typeName = javaType.getSimpleName();
        String name = this.getNodeName();
        String id = this.getObjectId();
        return typeName + "[name=" + name + ",id=" + id + "]";
    }

    static boolean contains(CustomizationContext container, CustomizationContext contained) {
        return WorkspaceObjectImpl.contains(((WorkspaceCustomizationContextImpl)container).getOwner(), contained);
    }

    private static boolean contains(WorkspaceObjectImpl container, CustomizationContext contained) {
        if (container == null) {
            throw new NullPointerException("No null container accepted");
        }
        if (contained == null) {
            throw new NullPointerException("No null contained accepted");
        }
        if (container == contained) {
            return true;
        }
        if (container instanceof WorkspaceImpl) {
            if (contained instanceof SiteImpl) {
                SiteImpl site = (SiteImpl)contained;
                return WorkspaceObjectImpl.contains(container, (CustomizationContext)site.getWorkspace().getCustomizationContext());
            }
            if (contained instanceof PageImpl) {
                PageImpl page = (PageImpl)contained;
                return WorkspaceObjectImpl.contains(container, (CustomizationContext)page.getSite().getCustomizationContext());
            }
            if (contained instanceof UIWindowImpl) {
                UIWindowImpl window = (UIWindowImpl)contained;
                return WorkspaceObjectImpl.contains(container, (CustomizationContext)window.getPage().getCustomizationContext());
            }
        }
        if (container instanceof SiteImpl) {
            if (contained instanceof PageImpl) {
                PageImpl page = (PageImpl)contained;
                return WorkspaceObjectImpl.contains(container, (CustomizationContext)page.getSite().getCustomizationContext());
            }
            if (contained instanceof UIWindowImpl) {
                UIWindowImpl window = (UIWindowImpl)contained;
                return WorkspaceObjectImpl.contains(container, (CustomizationContext)window.getPage().getCustomizationContext());
            }
        }
        if (container instanceof PageImpl && contained instanceof UIWindowImpl) {
            UIWindowImpl window = (UIWindowImpl)contained;
            return WorkspaceObjectImpl.contains(container, (CustomizationContext)window.getPage().getCustomizationContext());
        }
        return false;
    }
}

