/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ws.frameworks.json.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.exoplatform.ws.frameworks.json.JsonWriter;
import org.exoplatform.ws.frameworks.json.impl.JsonException;
import org.exoplatform.ws.frameworks.json.impl.JsonStack;
import org.exoplatform.ws.frameworks.json.impl.JsonUtils;

public class JsonWriterImpl
implements JsonWriter {
    private final JsonStack<JsonUtils.JsonToken> stack;
    private final Writer writer;
    private boolean commaFirst;

    public JsonWriterImpl(Writer writer) {
        this.writer = writer;
        this.stack = new JsonStack();
        this.commaFirst = false;
    }

    public JsonWriterImpl(OutputStream out) {
        this(new OutputStreamWriter(out, JsonUtils.DEFAULT_CHARSET));
    }

    public void writeStartObject() throws JsonException {
        JsonUtils.JsonToken token = this.stack.peek();
        if (token != null && token != JsonUtils.JsonToken.key && token != JsonUtils.JsonToken.array) {
            throw new JsonException("Syntax error. Unexpected element '{'.");
        }
        try {
            if (this.commaFirst) {
                this.writer.write(44);
            }
            this.writer.write(123);
            if (token == JsonUtils.JsonToken.key) {
                this.stack.pop();
            }
            this.stack.push(JsonUtils.JsonToken.object);
            this.commaFirst = false;
        }
        catch (IOException e) {
            throw new JsonException(e.getMessage(), e);
        }
    }

    public void writeEndObject() throws JsonException {
        try {
            JsonUtils.JsonToken token = this.stack.pop();
            if (token != JsonUtils.JsonToken.object) {
                System.out.println((Object)token);
                throw new JsonException("Sysntax error. Unexpected element '}'.");
            }
            this.writer.write(125);
            this.commaFirst = true;
        }
        catch (IOException e) {
            throw new JsonException(e.getMessage(), e);
        }
    }

    public void writeStartArray() throws JsonException {
        JsonUtils.JsonToken token = this.stack.peek();
        if (token != null && token != JsonUtils.JsonToken.key && token != JsonUtils.JsonToken.array) {
            throw new JsonException("Sysntax error. Unexpected element '['.");
        }
        try {
            if (this.commaFirst) {
                this.writer.write(44);
            }
            this.writer.write(91);
            if (token == JsonUtils.JsonToken.key) {
                this.stack.pop();
            }
            this.stack.push(JsonUtils.JsonToken.array);
            this.commaFirst = false;
        }
        catch (IOException e) {
            throw new JsonException(e.getMessage(), e);
        }
    }

    public void writeEndArray() throws JsonException {
        JsonUtils.JsonToken token = this.stack.pop();
        try {
            if (token != JsonUtils.JsonToken.array) {
                throw new JsonException("Sysntax error. Unexpected element ']'.");
            }
            this.writer.write(93);
            this.commaFirst = true;
        }
        catch (IOException e) {
            throw new JsonException(e.getMessage(), e);
        }
    }

    public void writeKey(String key) throws JsonException {
        if (key == null) {
            throw new JsonException("Key is null.");
        }
        JsonUtils.JsonToken token = this.stack.peek();
        if (token != JsonUtils.JsonToken.object) {
            throw new JsonException("Sysntax error. Unexpected characters '" + key + "'.");
        }
        try {
            if (this.commaFirst) {
                this.writer.write(44);
            }
            this.writer.write(JsonUtils.getJsonString(key));
            this.writer.write(58);
            this.commaFirst = false;
            this.stack.push(JsonUtils.JsonToken.key);
        }
        catch (IOException e) {
            throw new JsonException(e.getMessage(), e);
        }
    }

    public void writeString(String value) throws JsonException {
        this.write(JsonUtils.getJsonString(value));
    }

    public void writeValue(long value) throws JsonException {
        this.write(Long.toString(value));
    }

    public void writeValue(double value) throws JsonException {
        this.write(Double.toString(value));
    }

    public void writeValue(boolean value) throws JsonException {
        this.write(Boolean.toString(value));
    }

    public void writeNull() throws JsonException {
        this.write("null");
    }

    private void write(String value) throws JsonException {
        JsonUtils.JsonToken token = this.stack.peek();
        try {
            if (token != JsonUtils.JsonToken.key && token != JsonUtils.JsonToken.array) {
                throw new JsonException("Sysntax error. Unexpected characters '" + value + "'.");
            }
            if (this.commaFirst) {
                this.writer.write(44);
            }
            this.writer.write(value);
            this.commaFirst = true;
            if (token == JsonUtils.JsonToken.key) {
                this.stack.pop();
            }
        }
        catch (IOException e) {
            throw new JsonException(e.getMessage(), e);
        }
    }

    public void flush() throws JsonException {
        try {
            this.writer.flush();
        }
        catch (IOException e) {
            new JsonException(e.getMessage(), e);
        }
    }

    public void close() throws JsonException {
        try {
            this.writer.close();
        }
        catch (IOException e) {
            new JsonException(e.getMessage(), e);
        }
    }
}

