/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.backup.impl.rdbms;

import java.io.IOException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.access.AccessManager;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.ext.backup.impl.rdbms.RdbmsWorkspaceInitializer;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.NamespaceRegistryImpl;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeManagerImpl;
import org.exoplatform.services.jcr.impl.core.value.ValueFactoryImpl;
import org.exoplatform.services.jcr.impl.dataflow.persistent.CacheableWorkspaceDataManager;
import org.exoplatform.services.jcr.impl.storage.jdbc.backup.CleanException;
import org.exoplatform.services.jcr.impl.util.io.FileCleanerHolder;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class RdbmsBackupWorkspaceInitializer
extends RdbmsWorkspaceInitializer {
    protected static final Log log = ExoLogger.getLogger("exo.jcr.component.core.RdbmsBackupWorkspaceInitializer");

    public RdbmsBackupWorkspaceInitializer(WorkspaceEntry config, RepositoryEntry repConfig, CacheableWorkspaceDataManager dataManager, NamespaceRegistryImpl namespaceRegistry, LocationFactory locationFactory, NodeTypeManagerImpl nodeTypeManager, ValueFactoryImpl valueFactory, AccessManager accessManager, RepositoryService repositoryService, FileCleanerHolder cleanerHolder) throws RepositoryConfigurationException, PathNotFoundException, RepositoryException {
        super(config, repConfig, dataManager, namespaceRegistry, locationFactory, nodeTypeManager, valueFactory, accessManager, repositoryService, cleanerHolder);
    }

    public NodeData initWorkspace() throws RepositoryException {
        if (this.isWorkspaceInitialized()) {
            return (NodeData)this.dataManager.getItemData("00exo0jcr0root0uuid0000000000000");
        }
        long start = System.currentTimeMillis();
        try {
            this.fullRdbmsRestore();
            this.incrementalRead();
        }
        catch (Throwable e) {
            try {
                this.rollback();
            }
            catch (RepositoryConfigurationException e1) {
                log.error("Can't rollback changes", e1);
            }
            catch (CleanException e1) {
                log.error("Can't rollback changes", e1);
            }
            catch (IOException e1) {
                log.error("Can't rollback changes", e1);
            }
            throw new RepositoryException(e);
        }
        NodeData root = (NodeData)this.dataManager.getItemData("00exo0jcr0root0uuid0000000000000");
        log.info("Workspace [" + this.workspaceName + "] restored from storage " + this.restorePath + " in " + (double)(System.currentTimeMillis() - start) * 1.0 / 1000.0 + "sec");
        return root;
    }
}

