/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.script.groovy;

import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyResourceLoader;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.ErrorCollector;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.io.ReaderSource;
import org.codehaus.groovy.control.io.URLReaderSource;
import org.exoplatform.services.jcr.ext.script.groovy.JcrGroovyResourceLoader;
import org.exoplatform.services.rest.ext.groovy.ExtendedGroovyClassLoader;
import org.exoplatform.services.rest.ext.groovy.GroovyClassLoaderProvider;
import org.exoplatform.services.rest.ext.groovy.SourceFile;
import org.exoplatform.services.rest.ext.groovy.SourceFolder;

public class JcrGroovyClassLoaderProvider
extends GroovyClassLoaderProvider {
    public JcrGroovyClassLoaderProvider() {
        super((ExtendedGroovyClassLoader)AccessController.doPrivileged(new PrivilegedAction<JcrGroovyClassLoader>(){

            @Override
            public JcrGroovyClassLoader run() {
                return new JcrGroovyClassLoader(JcrGroovyClassLoaderProvider.class.getClassLoader());
            }
        }));
    }

    public ExtendedGroovyClassLoader getGroovyClassLoader(SourceFolder[] sources) throws MalformedURLException {
        if (sources == null || sources.length == 0) {
            return this.getGroovyClassLoader();
        }
        URL[] roots = new URL[sources.length];
        for (int i = 0; i < sources.length; ++i) {
            roots[i] = sources[i].getPath();
        }
        ExtendedGroovyClassLoader parent = this.getGroovyClassLoader();
        JcrGroovyClassLoader classLoader = AccessController.doPrivileged(new PrivilegedAction<JcrGroovyClassLoader>((GroovyClassLoader)parent){
            final /* synthetic */ GroovyClassLoader val$parent;
            {
                this.val$parent = groovyClassLoader;
            }

            @Override
            public JcrGroovyClassLoader run() {
                return new JcrGroovyClassLoader(this.val$parent);
            }
        });
        classLoader.setResourceLoader((GroovyResourceLoader)new JcrGroovyResourceLoader(roots));
        return classLoader;
    }

    private static class HierarchicalResourceLoader
    implements GroovyResourceLoader {
        private final GroovyResourceLoader actual;
        private final GroovyResourceLoader parent;

        HierarchicalResourceLoader(GroovyResourceLoader actual, GroovyResourceLoader parent) throws MalformedURLException {
            this.actual = actual;
            this.parent = parent;
        }

        public URL loadGroovySource(String filename) throws MalformedURLException {
            URL resource = null;
            if (this.actual != null) {
                resource = this.actual.loadGroovySource(filename);
            }
            if (resource == null && this.parent != null) {
                resource = this.parent.loadGroovySource(filename);
            }
            return resource;
        }
    }

    public static class JcrSourceUnit
    extends SourceUnit {
        private URL url;

        public JcrSourceUnit(File source, CompilerConfiguration configuration, GroovyClassLoader loader, ErrorCollector er) {
            super(source, configuration, loader, er);
        }

        public JcrSourceUnit(String name, ReaderSource source, CompilerConfiguration flags, GroovyClassLoader loader, ErrorCollector er) {
            super(name, source, flags, loader, er);
        }

        public JcrSourceUnit(String name, String source, CompilerConfiguration configuration, GroovyClassLoader loader, ErrorCollector er) {
            super(name, source, configuration, loader, er);
        }

        public JcrSourceUnit(URL source, CompilerConfiguration configuration, GroovyClassLoader loader, ErrorCollector er) {
            super("jcr".equals(source.getProtocol()) ? source.getRef() : source.getPath(), (ReaderSource)new URLReaderSource(source, configuration), configuration, loader, er);
            this.url = source;
        }

        public URL getUrl() {
            return this.url;
        }
    }

    public static class JcrCompilationUnit
    extends CompilationUnit {
        public JcrCompilationUnit() {
        }

        public JcrCompilationUnit(CompilerConfiguration configuration, CodeSource security, GroovyClassLoader loader, GroovyClassLoader transformLoader) {
            super(configuration, security, loader, transformLoader);
        }

        public JcrCompilationUnit(CompilerConfiguration configuration, CodeSource security, GroovyClassLoader loader) {
            super(configuration, security, loader);
        }

        public JcrCompilationUnit(CompilerConfiguration configuration) {
            super(configuration);
        }

        public JcrCompilationUnit(GroovyClassLoader loader) {
            super(loader);
        }

        public SourceUnit addSource(URL url) {
            return this.addSource(new JcrSourceUnit(url, this.configuration, this.classLoader, this.getErrorCollector()));
        }
    }

    public static class JcrGroovyClassLoader
    extends ExtendedGroovyClassLoader {
        public JcrGroovyClassLoader(ClassLoader classLoader) {
            super(classLoader);
        }

        public JcrGroovyClassLoader(GroovyClassLoader parent) {
            super(parent);
        }

        protected CompilationUnit createCompilationUnit(CompilerConfiguration config, CodeSource cs) {
            return new JcrCompilationUnit(config, cs, (GroovyClassLoader)this);
        }

        public URL[] findDependencies(SourceFolder[] sources, SourceFile[] files) throws IOException {
            return this.findDependencies(sources, files, 4, null);
        }

        private URL[] findDependencies(SourceFolder[] sources, SourceFile[] files, int phase, CompilerConfiguration config) throws IOException {
            CodeSource cs = new CodeSource(this.getCodeSource(), (Certificate[])null);
            JcrGroovyResourceLoader actualLoader = null;
            URL[] roots = null;
            if (sources != null && sources.length > 0) {
                roots = new URL[sources.length];
                for (int i = 0; i < sources.length; ++i) {
                    roots[i] = sources[i].getPath();
                }
                actualLoader = new JcrGroovyResourceLoader(roots);
            }
            final HierarchicalResourceLoader loader = new HierarchicalResourceLoader((GroovyResourceLoader)actualLoader, this.getResourceLoader());
            JcrCompilationUnit cunit = new JcrCompilationUnit(config, cs, (GroovyClassLoader)new JcrGroovyClassLoader(JcrGroovyClassLoaderProvider.class.getClassLoader()){

                public GroovyResourceLoader getResourceLoader() {
                    return loader;
                }
            });
            for (int i = 0; i < files.length; ++i) {
                cunit.addSource(files[i].getPath());
            }
            cunit.compile(phase);
            List classNodes = cunit.getAST().getClasses();
            ArrayList<URL> dependencies = new ArrayList<URL>(classNodes.size());
            for (ClassNode classNode : classNodes) {
                SourceUnit currentSunit;
                ModuleNode module = classNode.getModule();
                if (module == null || !((currentSunit = module.getContext()) instanceof JcrSourceUnit)) continue;
                dependencies.add(((JcrSourceUnit)currentSunit).getUrl());
            }
            return dependencies.toArray(new URL[dependencies.size()]);
        }
    }
}

