/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.page;

import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.webui.application.UIPortlet;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.portal.webui.page.UIPageBody;
import org.exoplatform.portal.webui.page.UIPageLifecycle;
import org.exoplatform.portal.webui.portal.UIPortalComponentActionListener;
import org.exoplatform.portal.webui.portal.UIPortalComposer;
import org.exoplatform.portal.webui.util.PortalDataMapper;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIEditInlineWorkspace;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.portal.webui.workspace.UIPortalToolPanel;
import org.exoplatform.portal.webui.workspace.UIWorkingWorkspace;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(lifecycle=UIPageLifecycle.class, template="system:/groovy/portal/webui/page/UIPage.gtmpl", events={@EventConfig(listeners={UIPortalComponentActionListener.MoveChildActionListener.class}), @EventConfig(name="EditCurrentPage", listeners={EditCurrentPageActionListener.class})})
public class UIPage
extends UIContainer {
    private String pageId;
    private String ownerId;
    private String ownerType;
    private String editPermission;
    private boolean showMaxWindow = false;
    private UIPortlet maximizedUIPortlet;
    public static String DEFAULT_FACTORY_ID = "Default";

    public String getOwnerId() {
        return this.ownerId;
    }

    public void setOwnerId(String s) {
        this.ownerId = s;
    }

    public boolean isShowMaxWindow() {
        return this.showMaxWindow;
    }

    public void setShowMaxWindow(Boolean showMaxWindow) {
        this.showMaxWindow = showMaxWindow;
    }

    public String getEditPermission() {
        return this.editPermission;
    }

    public void setEditPermission(String editPermission) {
        this.editPermission = editPermission;
    }

    public String getPageId() {
        return this.pageId;
    }

    public void setPageId(String id) {
        this.pageId = id;
    }

    public UIPortlet getMaximizedUIPortlet() {
        return this.maximizedUIPortlet;
    }

    public String getOwnerType() {
        return this.ownerType;
    }

    public void setOwnerType(String ownerType) {
        this.ownerType = ownerType;
    }

    public void setMaximizedUIPortlet(UIPortlet maximizedUIPortlet) {
        this.maximizedUIPortlet = maximizedUIPortlet;
    }

    public void switchToEditMode() throws Exception {
        Page page = PortalDataMapper.toPageModel(this);
        this.switchToEditMode(page);
    }

    public void switchToEditMode(Page page) throws Exception {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        UserACL userACL = (UserACL)this.getApplicationComponent(UserACL.class);
        if (!userACL.hasEditPermission(page)) {
            context.getUIApplication().addMessage(new ApplicationMessage("UIPortalManagement.msg.Invalid-EditPage-Permission", null));
            return;
        }
        UIPortalApplication uiApp = Util.getUIPortalApplication();
        UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)uiApp.getChildById("UIWorkingWorkspace");
        uiWorkingWS.setRenderedChild(UIEditInlineWorkspace.class);
        UIPortalComposer portalComposer = (UIPortalComposer)((UIPortalComposer)uiWorkingWS.findFirstComponentOfType(UIPortalComposer.class)).setRendered(true);
        portalComposer.setComponentConfig(UIPortalComposer.class, "UIPageEditor");
        portalComposer.setId("UIPageEditor");
        portalComposer.setShowControl(true);
        portalComposer.setEditted(false);
        portalComposer.setCollapse(false);
        UIPortalToolPanel uiToolPanel = (UIPortalToolPanel)uiWorkingWS.findFirstComponentOfType(UIPortalToolPanel.class);
        uiToolPanel.setShowMaskLayer(false);
        uiApp.setModeState(1);
        UIPage newUIPage = (UIPage)uiWorkingWS.createUIComponent(UIPage.class, null, null);
        PortalDataMapper.toUIPage(newUIPage, page);
        uiToolPanel.setWorkingComponent((UIComponent)newUIPage);
        UIPageBody pageBody = (UIPageBody)uiWorkingWS.findFirstComponentOfType(UIPageBody.class);
        pageBody.setUIComponent(null);
        PortalRequestContext prContext = Util.getPortalRequestContext();
        prContext.addUIComponentToUpdateByAjax((UIComponent)uiWorkingWS);
        prContext.setFullRender(true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EditCurrentPageActionListener
    extends EventListener<UIPage> {
        public void execute(Event<UIPage> event) throws Exception {
            ((UIPage)((Object)event.getSource())).switchToEditMode();
        }
    }
}

