/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow.persistent.infinispan;

import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.transaction.TransactionManager;
import org.exoplatform.services.jcr.impl.dataflow.persistent.infinispan.CacheKey;
import org.exoplatform.services.jcr.impl.dataflow.persistent.infinispan.CompressedISPNChangesBuffer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.context.Flag;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.CacheContainer;
import org.infinispan.util.concurrent.NotifyingFuture;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BufferedISPNCache
implements Cache<Serializable, Object> {
    private final AdvancedCache<Serializable, Object> parentCache;
    private final ThreadLocal<CompressedISPNChangesBuffer> changesList = new ThreadLocal();
    private ThreadLocal<Boolean> local = new ThreadLocal();
    private final Boolean allowLocalChanges;
    protected static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.BufferedISPNCache");

    public BufferedISPNCache(Cache<Serializable, Object> parentCache, Boolean allowLocalChanges) {
        this.parentCache = parentCache.getAdvancedCache();
        this.allowLocalChanges = allowLocalChanges;
    }

    public NotifyingFuture<Void> clearAsync() {
        return this.parentCache.clearAsync();
    }

    public void compact() {
        this.parentCache.compact();
    }

    public void endBatch(boolean successful) {
        this.parentCache.endBatch(successful);
    }

    public Set<Map.Entry<Serializable, Object>> entrySet() {
        return this.parentCache.entrySet();
    }

    public void evict(Serializable key) {
        this.parentCache.evict((Object)key);
    }

    public AdvancedCache<Serializable, Object> getAdvancedCache() {
        return this.parentCache.getAdvancedCache();
    }

    public CacheContainer getCacheManager() {
        return this.parentCache.getCacheManager();
    }

    public Configuration getConfiguration() {
        return this.parentCache.getConfiguration();
    }

    public String getName() {
        return this.parentCache.getName();
    }

    public ComponentStatus getStatus() {
        return this.parentCache.getStatus();
    }

    public String getVersion() {
        return this.parentCache.getVersion();
    }

    public Set<Serializable> keySet() {
        return this.parentCache.keySet();
    }

    public Object put(Serializable key, Object value, long lifespan, TimeUnit unit) {
        return this.parentCache.put((Object)key, value, lifespan, unit);
    }

    public Object put(Serializable key, Object value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return this.parentCache.put((Object)key, value, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
    }

    public void putAll(Map<? extends Serializable, ? extends Object> map, long lifespan, TimeUnit unit) {
        this.parentCache.putAll(map, lifespan, unit);
    }

    public void putAll(Map<? extends Serializable, ? extends Object> map, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        this.parentCache.putAll(map, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
    }

    public NotifyingFuture<Void> putAllAsync(Map<? extends Serializable, ? extends Object> data) {
        return this.parentCache.putAllAsync(data);
    }

    public NotifyingFuture<Void> putAllAsync(Map<? extends Serializable, ? extends Object> data, long lifespan, TimeUnit unit) {
        return this.parentCache.putAllAsync(data, lifespan, unit);
    }

    public NotifyingFuture<Void> putAllAsync(Map<? extends Serializable, ? extends Object> data, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return this.parentCache.putAllAsync(data, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    public NotifyingFuture<Object> putAsync(Serializable key, Object value) {
        return this.parentCache.putAsync((Object)key, value);
    }

    public NotifyingFuture<Object> putAsync(Serializable key, Object value, long lifespan, TimeUnit unit) {
        return this.parentCache.putAsync((Object)key, value, lifespan, unit);
    }

    public NotifyingFuture<Object> putAsync(Serializable key, Object value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return this.parentCache.putAsync((Object)key, value, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    public void putForExternalRead(Serializable key, Object value) {
        this.parentCache.putForExternalRead((Object)key, value);
    }

    public Object putIfAbsent(Serializable key, Object value, long lifespan, TimeUnit unit) {
        return this.parentCache.putIfAbsent((Object)key, value, lifespan, unit);
    }

    public Object putIfAbsent(Serializable key, Object value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return this.parentCache.putIfAbsent((Object)key, value, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
    }

    public NotifyingFuture<Object> putIfAbsentAsync(Serializable key, Object value) {
        return this.parentCache.putIfAbsentAsync((Object)key, value);
    }

    public NotifyingFuture<Object> putIfAbsentAsync(Serializable key, Object value, long lifespan, TimeUnit unit) {
        return this.parentCache.putIfAbsentAsync((Object)key, value, lifespan, unit);
    }

    public NotifyingFuture<Object> putIfAbsentAsync(Serializable key, Object value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return this.parentCache.putIfAbsentAsync((Object)key, value, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    public NotifyingFuture<Object> removeAsync(Object key) {
        return this.parentCache.removeAsync(key);
    }

    public NotifyingFuture<Boolean> removeAsync(Object key, Object value) {
        return this.parentCache.removeAsync(key, value);
    }

    public Object replace(Serializable key, Object value, long lifespan, TimeUnit unit) {
        return this.parentCache.replace((Object)key, value, lifespan, unit);
    }

    public boolean replace(Serializable key, Object oldValue, Object value, long lifespan, TimeUnit unit) {
        return this.parentCache.replace((Object)key, oldValue, value, lifespan, unit);
    }

    public Object replace(Serializable key, Object value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return this.parentCache.replace((Object)key, value, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
    }

    public boolean replace(Serializable key, Object oldValue, Object value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return this.parentCache.replace((Object)key, oldValue, value, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
    }

    public NotifyingFuture<Object> replaceAsync(Serializable key, Object value) {
        return this.parentCache.replaceAsync((Object)key, value);
    }

    public NotifyingFuture<Boolean> replaceAsync(Serializable key, Object oldValue, Object newValue) {
        return this.parentCache.replaceAsync((Object)key, oldValue, newValue);
    }

    public NotifyingFuture<Object> replaceAsync(Serializable key, Object value, long lifespan, TimeUnit unit) {
        return this.parentCache.replaceAsync((Object)key, value, lifespan, unit);
    }

    public NotifyingFuture<Boolean> replaceAsync(Serializable key, Object oldValue, Object newValue, long lifespan, TimeUnit unit) {
        return this.parentCache.replaceAsync((Object)key, oldValue, newValue, lifespan, unit);
    }

    public NotifyingFuture<Object> replaceAsync(Serializable key, Object value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return this.parentCache.replaceAsync((Object)key, value, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    public NotifyingFuture<Boolean> replaceAsync(Serializable key, Object oldValue, Object newValue, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return this.parentCache.replaceAsync((Object)key, oldValue, newValue);
    }

    public boolean startBatch() {
        return this.parentCache.startBatch();
    }

    public Collection<Object> values() {
        return this.parentCache.values();
    }

    public Object putIfAbsent(Serializable key, Object value) {
        return this.parentCache.putIfAbsent((Object)key, value);
    }

    public boolean remove(Object key, Object value) {
        return this.parentCache.remove(key, value);
    }

    public Object replace(Serializable key, Object value) {
        return this.parentCache.replace((Object)key, value);
    }

    public boolean replace(Serializable key, Object oldValue, Object newValue) {
        return this.parentCache.replace((Object)key, oldValue, newValue);
    }

    public void clear() {
        this.parentCache.clear();
    }

    public boolean containsKey(Object key) {
        return this.parentCache.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.parentCache.containsValue(value);
    }

    public Object get(Object key) {
        return this.parentCache.get(key);
    }

    public boolean isEmpty() {
        return this.parentCache.isEmpty();
    }

    public Object put(CacheKey key, Object value) {
        return this.put(key, value, false);
    }

    public Object put(final CacheKey key, Object value, final boolean withReturnValue) {
        CompressedISPNChangesBuffer changesContainer = this.getChangesBufferSafe();
        changesContainer.add(new PutObjectContainer(key, value, this.parentCache, changesContainer.getHistoryIndex(), (boolean)this.local.get(), this.allowLocalChanges));
        PrivilegedAction<Object> action = new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return withReturnValue ? BufferedISPNCache.this.parentCache.get((Object)key) : null;
            }
        };
        return AccessController.doPrivileged(action);
    }

    public Object put(Serializable key, Object value) {
        throw new UnsupportedOperationException("Unexpected method call use put(CacheKey key, Object value)");
    }

    public void putAll(Map<? extends Serializable, ? extends Object> m) {
        this.parentCache.putAll(m);
    }

    public Object remove(Object key) {
        CompressedISPNChangesBuffer changesContainer = this.getChangesBufferSafe();
        changesContainer.add(new RemoveObjectContainer((CacheKey)key, this.parentCache, changesContainer.getHistoryIndex(), this.local.get(), this.allowLocalChanges));
        return null;
    }

    public int size() {
        return this.parentCache.size();
    }

    public void start() {
        PrivilegedAction<Object> action = new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                BufferedISPNCache.this.parentCache.start();
                return null;
            }
        };
        AccessController.doPrivileged(action);
    }

    public void stop() {
        PrivilegedAction<Object> action = new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                BufferedISPNCache.this.parentCache.stop();
                return null;
            }
        };
        AccessController.doPrivileged(action);
    }

    public void addListener(Object listener) {
        this.parentCache.addListener(listener);
    }

    public Set<Object> getListeners() {
        return this.parentCache.getListeners();
    }

    public void removeListener(Object listener) {
        this.parentCache.removeListener(listener);
    }

    public void beginTransaction() {
        this.changesList.set(new CompressedISPNChangesBuffer());
        this.local.set(false);
    }

    public boolean isTransactionActive() {
        return this.changesList.get() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitTransaction() {
        CompressedISPNChangesBuffer changesContainer = this.getChangesBufferSafe();
        try {
            List<ChangesContainer> containers = changesContainer.getSortedList();
            for (ChangesContainer cacheChange : containers) {
                cacheChange.apply();
            }
            Object var6_5 = null;
            this.changesList.set(null);
            changesContainer = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.changesList.set(null);
            changesContainer = null;
            throw throwable;
        }
    }

    public void rollbackTransaction() {
        this.changesList.set(null);
    }

    public void setLocal(boolean local) {
        if (local && this.changesList.get() == null) {
            this.beginTransaction();
        }
        if (local || this.local.get().booleanValue()) {
            // empty if block
        }
        this.local.set(local);
    }

    private CompressedISPNChangesBuffer getChangesBufferSafe() {
        CompressedISPNChangesBuffer changesContainer = this.changesList.get();
        if (changesContainer == null) {
            throw new IllegalStateException("changesContainer should not be empty");
        }
        return changesContainer;
    }

    public TransactionManager getTransactionManager() {
        return this.parentCache.getTransactionManager();
    }

    public void addToList(CacheKey key, Object value, boolean forceModify) {
        CompressedISPNChangesBuffer changesContainer = this.getChangesBufferSafe();
        changesContainer.add(new AddToListContainer(key, value, this.parentCache, forceModify, changesContainer.getHistoryIndex(), this.local.get(), this.allowLocalChanges));
    }

    public Object putInBuffer(CacheKey key, Object value) {
        CompressedISPNChangesBuffer changesContainer = this.getChangesBufferSafe();
        Object prevObject = this.getObjectFromChangesContainer(changesContainer, key);
        changesContainer.add(new PutObjectContainer(key, value, this.parentCache, changesContainer.getHistoryIndex(), (boolean)this.local.get(), this.allowLocalChanges));
        if (prevObject != null) {
            return prevObject;
        }
        return this.parentCache.get((Object)key);
    }

    private Object getObjectFromChangesContainer(CompressedISPNChangesBuffer changesContainer, CacheKey key) {
        List<ChangesContainer> changes = changesContainer.getSortedList();
        Object object = null;
        for (ChangesContainer change : changes) {
            if (!change.getChangesType().equals((Object)ChangesType.PUT) || !change.getKey().equals(key)) continue;
            object = ((PutObjectContainer)change).value;
        }
        return object;
    }

    public void removeFromList(CacheKey key, Object value) {
        CompressedISPNChangesBuffer changesContainer = this.getChangesBufferSafe();
        changesContainer.add(new RemoveFromListContainer(key, value, this.parentCache, changesContainer.getHistoryIndex(), (boolean)this.local.get(), this.allowLocalChanges));
    }

    public Object getFromBuffer(CacheKey key) {
        CompressedISPNChangesBuffer changesContainer = this.getChangesBufferSafe();
        Object objectFromBuffer = this.getObjectFromChangesContainer(changesContainer, key);
        if (objectFromBuffer != null) {
            return objectFromBuffer;
        }
        return this.parentCache.get((Object)key);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RemoveObjectContainer
    extends ChangesContainer {
        public RemoveObjectContainer(CacheKey key, AdvancedCache<Serializable, Object> cache, int historicalIndex, boolean local, Boolean allowLocalChanges) {
            super(key, ChangesType.REMOVE, cache, historicalIndex, local, allowLocalChanges);
        }

        @Override
        public void apply() {
            this.setCacheLocalMode();
            this.cache.remove((Object)this.key);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RemoveFromListContainer
    extends ChangesContainer {
        private final Object value;

        public RemoveFromListContainer(CacheKey key, Object value, AdvancedCache<Serializable, Object> cache, int historicalIndex, boolean local, Boolean allowLocalChanges) {
            super(key, ChangesType.REMOVE, cache, historicalIndex, local, allowLocalChanges);
            this.value = value;
        }

        @Override
        public void apply() {
            this.cache.withFlags(new Flag[]{Flag.FORCE_WRITE_LOCK});
            this.setCacheLocalMode();
            Object existingObject = this.cache.get((Object)this.key);
            if (existingObject instanceof Set) {
                HashSet newSet = new HashSet((Set)existingObject);
                newSet.remove(this.value);
                this.setCacheLocalMode();
                this.cache.put((Object)this.key, newSet);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddToListContainer
    extends ChangesContainer {
        private final Object value;
        private final boolean forceModify;

        public AddToListContainer(CacheKey key, Object value, AdvancedCache<Serializable, Object> cache, boolean forceModify, int historicalIndex, boolean local, Boolean allowLocalChanges) {
            super(key, ChangesType.PUT, cache, historicalIndex, local, allowLocalChanges);
            this.value = value;
            this.forceModify = forceModify;
        }

        @Override
        public void apply() {
            this.cache.withFlags(new Flag[]{Flag.FORCE_WRITE_LOCK});
            Object existingObject = this.cache.get((Object)this.key);
            HashSet<Object> newSet = new HashSet<Object>();
            if (existingObject instanceof Set || existingObject == null && this.forceModify) {
                if (existingObject instanceof Set) {
                    newSet.addAll((Set)existingObject);
                }
                newSet.add(this.value);
                this.setCacheLocalMode();
                this.cache.put((Object)this.key, newSet);
            } else if (existingObject != null) {
                LOG.error((Object)("Unexpected object found by key " + this.key.toString() + ". Expected Set, but found:" + existingObject.getClass().getName()));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PutObjectContainer
    extends ChangesContainer {
        private final Object value;

        public PutObjectContainer(CacheKey key, Object value, AdvancedCache<Serializable, Object> cache, int historicalIndex, boolean local, Boolean allowLocalChanges) {
            super(key, ChangesType.PUT, cache, historicalIndex, local, allowLocalChanges);
            this.value = value;
        }

        @Override
        public void apply() {
            this.setCacheLocalMode();
            this.cache.put((Object)this.key, this.value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class ChangesContainer
    implements Comparable<ChangesContainer> {
        protected final CacheKey key;
        protected final ChangesType changesType;
        protected final AdvancedCache<Serializable, Object> cache;
        protected final int historicalIndex;
        protected final boolean localMode;
        private final Boolean allowLocalChanges;

        public ChangesContainer(CacheKey key, ChangesType changesType, AdvancedCache<Serializable, Object> cache, int historicalIndex, boolean localMode, Boolean allowLocalChanges) {
            this.key = key;
            this.changesType = changesType;
            this.cache = cache;
            this.historicalIndex = historicalIndex;
            this.localMode = localMode;
            this.allowLocalChanges = allowLocalChanges;
        }

        public CacheKey getKey() {
            return this.key;
        }

        public int getHistoricalIndex() {
            return this.historicalIndex;
        }

        public ChangesType getChangesType() {
            return this.changesType;
        }

        public String toString() {
            return this.key.toString() + " type=" + (Object)((Object)this.changesType) + " historysIndex=" + this.historicalIndex;
        }

        @Override
        public int compareTo(ChangesContainer o) {
            int result = this.key.compareTo(o.getKey());
            return result == 0 ? this.historicalIndex - o.getHistoricalIndex() : result;
        }

        protected void setCacheLocalMode() {
            if (this.localMode) {
                if (this.allowLocalChanges == null) {
                    Configuration.CacheMode cacheMode = this.cache.getConfiguration().getCacheMode();
                    if (cacheMode != Configuration.CacheMode.DIST_ASYNC && cacheMode != Configuration.CacheMode.DIST_SYNC) {
                        this.cache.withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL});
                    }
                } else if (this.allowLocalChanges.booleanValue()) {
                    this.cache.withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL});
                }
            }
        }

        public abstract void apply();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ChangesType {
        REMOVE,
        PUT;

    }
}

