/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.value.fs.operations;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.exoplatform.commons.utils.PrivilegedFileHelper;
import org.exoplatform.services.jcr.impl.storage.value.ValueDataResourceHolder;
import org.exoplatform.services.jcr.impl.storage.value.ValueOperation;
import org.exoplatform.services.jcr.impl.storage.value.fs.FileLockException;
import org.exoplatform.services.jcr.impl.storage.value.fs.operations.ValueFileIOHelper;
import org.exoplatform.services.jcr.impl.storage.value.fs.operations.ValueLockSupport;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public abstract class ValueFileOperation
extends ValueFileIOHelper
implements ValueOperation {
    public static final String TEMP_FILE_EXTENSION = ".temp";
    public static final String LOCK_FILE_EXTENSION = ".lock";
    protected static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.ValueFileOperation");
    protected final FileCleaner cleaner;
    protected final ValueDataResourceHolder resources;
    protected final String operationInfo;
    protected final File tempDir;
    private boolean performed = false;

    ValueFileOperation(ValueDataResourceHolder resources, FileCleaner cleaner, File tempDir) {
        String localAddr;
        this.cleaner = cleaner;
        this.resources = resources;
        this.tempDir = tempDir;
        try {
            InetAddress local = null;
            PrivilegedExceptionAction<InetAddress> action = new PrivilegedExceptionAction<InetAddress>(){

                @Override
                public InetAddress run() throws Exception {
                    return InetAddress.getLocalHost();
                }
            };
            try {
                local = AccessController.doPrivileged(action);
            }
            catch (PrivilegedActionException pae) {
                Throwable cause = pae.getCause();
                if (cause instanceof UnknownHostException) {
                    throw (UnknownHostException)cause;
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new RuntimeException(cause);
            }
            localAddr = local.getHostAddress() + " (" + local.getHostName() + ")";
        }
        catch (UnknownHostException e) {
            LOG.warn((Object)("Cannot read host address " + e));
            localAddr = "no address, " + e;
        }
        this.operationInfo = System.currentTimeMillis() + " " + localAddr;
    }

    protected boolean isPerformed() {
        return this.performed;
    }

    protected void makePerformed() throws IOException {
        if (this.performed) {
            throw new IOException("Operation cannot be performed twice");
        }
        this.performed = true;
    }

    class ValueFileLock {
        private final File file;

        ValueFileLock(File file) {
            this.file = file;
        }

        public boolean lock() throws IOException {
            try {
                return ValueFileOperation.this.resources.aquire(PrivilegedFileHelper.getAbsolutePath((File)this.file), new ValueFileLockHolder(this.file));
            }
            catch (InterruptedException e) {
                throw new FileLockException("Lock error on " + PrivilegedFileHelper.getAbsolutePath((File)this.file), e);
            }
        }

        public boolean unlock() throws IOException {
            return ValueFileOperation.this.resources.release(PrivilegedFileHelper.getAbsolutePath((File)this.file));
        }
    }

    class ValueFileLockHolder
    implements ValueLockSupport {
        private final File targetFile;
        private File lockFile;
        private FileOutputStream lockFileStream;

        ValueFileLockHolder(File file) {
            this.targetFile = file;
        }

        public void lock() throws IOException {
            this.lockFile = new File(ValueFileOperation.this.tempDir, this.targetFile.getName() + ValueFileOperation.LOCK_FILE_EXTENSION);
            FileOutputStream lout = PrivilegedFileHelper.fileOutputStream((File)this.lockFile, (boolean)true);
            lout.write(ValueFileOperation.this.operationInfo.getBytes());
            lout.getChannel().lock();
            this.lockFileStream = lout;
        }

        public void share(ValueLockSupport anotherLock) throws IOException {
            if (!(anotherLock instanceof ValueFileLockHolder)) {
                throw new IOException("Cannot share lock with " + anotherLock.getClass());
            }
            ValueFileLockHolder al = (ValueFileLockHolder)anotherLock;
            this.lockFile = al.lockFile;
            this.lockFileStream = al.lockFileStream;
        }

        public void unlock() throws IOException {
            if (this.lockFileStream != null) {
                this.lockFileStream.close();
            }
            if (!PrivilegedFileHelper.delete((File)this.lockFile)) {
                LOG.warn((Object)("Cannot delete lock file " + PrivilegedFileHelper.getAbsolutePath((File)this.lockFile) + ". Add to the FileCleaner"));
                ValueFileOperation.this.cleaner.addFile(this.lockFile);
            }
        }
    }
}

