/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.transaction.jbosscache;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import javax.transaction.xa.Xid;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.transaction.ExoResource;
import org.exoplatform.services.transaction.TransactionService;
import org.jboss.cache.transaction.TransactionManagerLookup;

public class GenericTransactionService
implements TransactionService {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.GenericTransactionService");
    private static final int DEFAULT_TIME_OUT = 60;
    protected final TransactionManagerLookup tmLookup;
    protected final int defaultTimeout;
    protected final boolean forceTimeout;
    private volatile TransactionManager tm;

    public GenericTransactionService(TransactionManagerLookup tmLookup) {
        this(tmLookup, null);
    }

    public GenericTransactionService(TransactionManagerLookup tmLookup, InitParams params) {
        this.tmLookup = tmLookup;
        if (params != null && params.getValueParam("timeout") != null) {
            this.defaultTimeout = Integer.parseInt(params.getValueParam("timeout").getValue());
            this.forceTimeout = true;
        } else {
            this.defaultTimeout = 60;
            this.forceTimeout = false;
        }
    }

    public Xid createXid() {
        throw new UnsupportedOperationException("Method createXid() not supported");
    }

    public void delistResource(final ExoResource exores) throws RollbackException, SystemException {
        TransactionManager tm = this.getTransactionManager();
        final Transaction tx = tm.getTransaction();
        if (tx != null) {
            PrivilegedExceptionAction<Object> action = new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    tx.delistResource(exores.getXAResource(), 0);
                    return null;
                }
            };
            try {
                AccessController.doPrivileged(action);
            }
            catch (PrivilegedActionException pae) {
                Throwable cause = pae.getCause();
                if (cause instanceof RollbackException) {
                    throw (RollbackException)cause;
                }
                if (cause instanceof IllegalStateException) {
                    throw (IllegalStateException)cause;
                }
                if (cause instanceof SystemException) {
                    throw (SystemException)cause;
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new RuntimeException(cause);
            }
        } else {
            this.delistResourceOnTxMissing(tm, exores);
        }
    }

    public void enlistResource(final ExoResource exores) throws RollbackException, SystemException {
        TransactionManager tm = this.getTransactionManager();
        final Transaction tx = tm.getTransaction();
        if (tx != null) {
            PrivilegedExceptionAction<Object> action = new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    tx.enlistResource(exores.getXAResource());
                    return null;
                }
            };
            try {
                AccessController.doPrivileged(action);
            }
            catch (PrivilegedActionException pae) {
                Throwable cause = pae.getCause();
                if (cause instanceof RollbackException) {
                    throw (RollbackException)cause;
                }
                if (cause instanceof IllegalStateException) {
                    throw (IllegalStateException)cause;
                }
                if (cause instanceof SystemException) {
                    throw (SystemException)cause;
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new RuntimeException(cause);
            }
        } else {
            this.enlistResourceOnTxMissing(tm, exores);
        }
    }

    public int getDefaultTimeout() {
        return this.defaultTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionManager getTransactionManager() {
        if (this.tm == null) {
            GenericTransactionService genericTransactionService = this;
            synchronized (genericTransactionService) {
                if (this.tm == null) {
                    TransactionManager tm;
                    try {
                        tm = (TransactionManager)SecurityHelper.doPrivilegedExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<TransactionManager>(){

                            @Override
                            public TransactionManager run() throws Exception {
                                return GenericTransactionService.this.tmLookup.getTransactionManager();
                            }
                        });
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Transaction manager not found", e);
                    }
                    if (this.forceTimeout) {
                        tm = new TransactionManagerTxTimeoutAware(tm, this.defaultTimeout);
                    }
                    this.tm = tm;
                }
            }
        }
        return this.tm;
    }

    public UserTransaction getUserTransaction() {
        throw new UnsupportedOperationException("Method UserTransaction() not supported");
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        TransactionManager tm = this.getTransactionManager();
        tm.setTransactionTimeout(seconds);
    }

    protected void enlistResourceOnTxMissing(TransactionManager tm, ExoResource exores) throws RollbackException, SystemException {
    }

    protected void delistResourceOnTxMissing(TransactionManager tm, ExoResource exores) throws RollbackException, SystemException {
    }

    private static class TransactionManagerTxTimeoutAware
    implements TransactionManager {
        private final TransactionManager tm;
        private final int defaultTimeout;
        private final ThreadLocal<Boolean> timeoutHasBeenSet = new ThreadLocal();

        public TransactionManagerTxTimeoutAware(TransactionManager tm, int defaultTimeout) {
            this.tm = tm;
            this.defaultTimeout = defaultTimeout;
        }

        public void begin() throws NotSupportedException, SystemException {
            if (this.timeoutHasBeenSet.get() != null) {
                this.timeoutHasBeenSet.set(null);
            } else {
                try {
                    this.tm.setTransactionTimeout(this.defaultTimeout);
                }
                catch (Exception e) {
                    LOG.warn((Object)"Cannot set the transaction timeout", (Throwable)e);
                }
            }
            PrivilegedExceptionAction<Object> action = new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    TransactionManagerTxTimeoutAware.this.tm.begin();
                    return null;
                }
            };
            try {
                AccessController.doPrivileged(action);
            }
            catch (PrivilegedActionException pae) {
                Throwable cause = pae.getCause();
                if (cause instanceof NotSupportedException) {
                    throw (NotSupportedException)cause;
                }
                if (cause instanceof SystemException) {
                    throw (SystemException)cause;
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new RuntimeException(cause);
            }
        }

        public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
            PrivilegedExceptionAction<Object> action = new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    TransactionManagerTxTimeoutAware.this.tm.commit();
                    return null;
                }
            };
            try {
                AccessController.doPrivileged(action);
            }
            catch (PrivilegedActionException pae) {
                Throwable cause = pae.getCause();
                if (cause instanceof RollbackException) {
                    throw (RollbackException)cause;
                }
                if (cause instanceof HeuristicMixedException) {
                    throw (HeuristicMixedException)cause;
                }
                if (cause instanceof HeuristicRollbackException) {
                    throw (HeuristicRollbackException)cause;
                }
                if (cause instanceof SecurityException) {
                    throw (SecurityException)cause;
                }
                if (cause instanceof IllegalStateException) {
                    throw (IllegalStateException)cause;
                }
                if (cause instanceof SystemException) {
                    throw (SystemException)cause;
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new RuntimeException(cause);
            }
        }

        public int getStatus() throws SystemException {
            return this.tm.getStatus();
        }

        public Transaction getTransaction() throws SystemException {
            try {
                return (Transaction)SecurityHelper.doPrivilegedExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Transaction>(){

                    @Override
                    public Transaction run() throws Exception {
                        return TransactionManagerTxTimeoutAware.this.tm.getTransaction();
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                Throwable cause = pae.getCause();
                if (cause instanceof SystemException) {
                    throw (SystemException)cause;
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new RuntimeException(cause);
            }
        }

        public void resume(final Transaction tx) throws InvalidTransactionException, IllegalStateException, SystemException {
            PrivilegedExceptionAction<Object> action = new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    TransactionManagerTxTimeoutAware.this.tm.resume(tx);
                    return null;
                }
            };
            try {
                AccessController.doPrivileged(action);
            }
            catch (PrivilegedActionException pae) {
                Throwable cause = pae.getCause();
                if (cause instanceof InvalidTransactionException) {
                    throw (InvalidTransactionException)cause;
                }
                if (cause instanceof IllegalStateException) {
                    throw (IllegalStateException)cause;
                }
                if (cause instanceof SystemException) {
                    throw (SystemException)cause;
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new RuntimeException(cause);
            }
        }

        public void rollback() throws IllegalStateException, SecurityException, SystemException {
            PrivilegedExceptionAction<Object> action = new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    TransactionManagerTxTimeoutAware.this.tm.rollback();
                    return null;
                }
            };
            try {
                AccessController.doPrivileged(action);
            }
            catch (PrivilegedActionException pae) {
                Throwable cause = pae.getCause();
                if (cause instanceof IllegalStateException) {
                    throw (IllegalStateException)cause;
                }
                if (cause instanceof SecurityException) {
                    throw (SecurityException)cause;
                }
                if (cause instanceof SystemException) {
                    throw (SystemException)cause;
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new RuntimeException(cause);
            }
        }

        public void setRollbackOnly() throws IllegalStateException, SystemException {
            this.tm.setRollbackOnly();
        }

        public void setTransactionTimeout(int timeout) throws SystemException {
            this.tm.setTransactionTimeout(timeout);
            this.timeoutHasBeenSet.set(true);
        }

        public Transaction suspend() throws SystemException {
            PrivilegedExceptionAction<Transaction> action = new PrivilegedExceptionAction<Transaction>(){

                @Override
                public Transaction run() throws Exception {
                    return TransactionManagerTxTimeoutAware.this.tm.suspend();
                }
            };
            try {
                return AccessController.doPrivileged(action);
            }
            catch (PrivilegedActionException pae) {
                Throwable cause = pae.getCause();
                if (cause instanceof SystemException) {
                    throw (SystemException)cause;
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new RuntimeException(cause);
            }
        }
    }
}

