/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mail.service.impl;

import com.sun.mail.util.LineOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import javax.mail.MessagingException;
import javax.mail.internet.InternetHeaders;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class DispositionNotification {
    private Log log = ExoLogger.getLogger(this.getClass());
    private static boolean debug = false;
    protected InternetHeaders notifications;

    public DispositionNotification() throws MessagingException {
        this.notifications = new InternetHeaders();
    }

    public DispositionNotification(InputStream is) throws MessagingException, IOException {
        this.notifications = new InternetHeaders(is);
        if (debug) {
            this.log.info((Object)"MDN: got notification content");
        }
    }

    public InternetHeaders getNotifications() {
        return this.notifications;
    }

    public void setNotifications(InternetHeaders notifications) {
        this.notifications = notifications;
    }

    public void writeTo(OutputStream os) throws IOException, MessagingException {
        LineOutputStream los = null;
        los = os instanceof LineOutputStream ? (LineOutputStream)os : new LineOutputStream(os);
        DispositionNotification.writeInternetHeaders(this.notifications, los);
        los.writeln();
    }

    private static void writeInternetHeaders(InternetHeaders h, LineOutputStream los) throws IOException {
        Enumeration e = h.getAllHeaderLines();
        try {
            while (e.hasMoreElements()) {
                los.writeln((String)e.nextElement());
            }
        }
        catch (MessagingException mex) {
            Exception ex = mex.getNextException();
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            throw new IOException("Exception writing headers: " + (Object)((Object)mex));
        }
    }

    public String toString() {
        return "DispositionNotification: Reporting-UA=" + this.notifications.getHeader("Reporting-UA", null);
    }
}

