/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.portlet.container;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gatein.pc.api.NoSuchPortletException;
import org.gatein.pc.api.Portlet;
import org.gatein.pc.api.PortletContext;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.pc.api.PortletStateType;
import org.gatein.pc.api.info.PortletInfo;
import org.gatein.pc.api.invocation.InvocationException;
import org.gatein.pc.api.invocation.PortletInvocation;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.gatein.pc.api.state.DestroyCloneFailure;
import org.gatein.pc.api.state.PropertyChange;
import org.gatein.pc.api.state.PropertyMap;
import org.gatein.pc.portlet.PortletInvokerInterceptor;
import org.gatein.pc.portlet.container.PortletContainer;
import org.gatein.pc.portlet.impl.info.ContainerPortletInfo;
import org.gatein.pc.portlet.impl.info.ContainerPreferenceInfo;
import org.gatein.pc.portlet.impl.info.ContainerPreferencesInfo;
import org.gatein.pc.portlet.state.SimplePropertyMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerPortletInvoker
extends PortletInvokerInterceptor {
    public static final String PORTLET_CONTAINER = "PORTLET_CONTAINER";
    private Map<String, Portlet> portlets = new HashMap<String, Portlet>();

    public void addPortletContainer(PortletContainer portletContainer) {
        HashMap<String, Portlet> portlets = new HashMap<String, Portlet>(this.portlets);
        PortletImpl portlet = new PortletImpl(portletContainer);
        portlets.put(portlet.getContext().getId(), portlet);
        this.portlets = portlets;
    }

    public void removePortletContainer(PortletContainer portletContainer) {
        HashMap<String, Portlet> portlets = new HashMap<String, Portlet>(this.portlets);
        PortletImpl portlet = new PortletImpl(portletContainer);
        portlets.remove(portlet.getContext().getId());
        this.portlets = portlets;
    }

    @Override
    public Set<Portlet> getPortlets() {
        return new HashSet<Portlet>(this.portlets.values());
    }

    @Override
    public Portlet getPortlet(PortletContext portletContext) throws IllegalArgumentException, PortletInvokerException {
        if (portletContext == null) {
            throw new IllegalArgumentException("No null portlet id accepted");
        }
        String portletId = portletContext.getId();
        PortletImpl portlet = (PortletImpl)this.portlets.get(portletId);
        if (portlet == null) {
            throw new NoSuchPortletException(portletId);
        }
        return portlet;
    }

    @Override
    public PortletInvocationResponse invoke(PortletInvocation invocation) throws PortletInvokerException, InvocationException {
        PortletContext ctx = invocation.getTarget();
        PortletImpl portlet = (PortletImpl)this.getPortlet(ctx);
        PortletContainer container = portlet.container;
        try {
            invocation.setAttribute(PORTLET_CONTAINER, (Object)container);
            PortletInvocationResponse portletInvocationResponse = super.invoke(invocation);
            return portletInvocationResponse;
        }
        catch (Exception e) {
            if (e instanceof PortletInvokerException) {
                throw (PortletInvokerException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new PortletInvokerException((Throwable)e);
        }
        finally {
            invocation.removeAttribute((Object)PORTLET_CONTAINER);
        }
    }

    @Override
    public PropertyMap getProperties(PortletContext portletContext, Set<String> keys) throws IllegalArgumentException, PortletInvokerException, UnsupportedOperationException {
        PortletImpl portlet = (PortletImpl)this.portlets.get(portletContext.getId());
        if (portlet == null) {
            throw new NoSuchPortletException(portletContext.getId());
        }
        ContainerPortletInfo info = (ContainerPortletInfo)portlet.getInfo();
        ContainerPreferencesInfo prefs = info.getPreferences();
        SimplePropertyMap result = new SimplePropertyMap();
        for (String key : keys) {
            ContainerPreferenceInfo pref = prefs.getContainerPreference(key);
            if (pref == null) continue;
            result.put(key, pref.getDefaultValue());
        }
        return result;
    }

    @Override
    public PropertyMap getProperties(PortletContext portletContext) throws IllegalArgumentException, PortletInvokerException, UnsupportedOperationException {
        PortletImpl portlet = (PortletImpl)this.portlets.get(portletContext.getId());
        if (portlet == null) {
            throw new NoSuchPortletException(portletContext.getId());
        }
        ContainerPortletInfo info = (ContainerPortletInfo)portlet.getInfo();
        ContainerPreferencesInfo prefs = info.getPreferences();
        SimplePropertyMap result = new SimplePropertyMap();
        for (String key : prefs.getKeys()) {
            ContainerPreferenceInfo pref = prefs.getContainerPreference(key);
            if (pref == null) continue;
            result.put(key, pref.getDefaultValue());
        }
        return result;
    }

    @Override
    public PortletContext createClone(PortletStateType stateType, PortletContext portletContext) throws IllegalArgumentException, PortletInvokerException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<DestroyCloneFailure> destroyClones(List<PortletContext> portletContexts) throws IllegalArgumentException, PortletInvokerException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public PortletContext setProperties(PortletContext portletContext, PropertyChange[] changes) throws IllegalArgumentException, PortletInvokerException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    private static class PortletImpl
    implements Portlet {
        private final PortletContainer container;
        private final PortletContext context;

        public PortletImpl(PortletContainer container) {
            this.container = container;
            this.context = PortletContext.createPortletContext((String)container.getPortletApplication().getId(), (String)container.getId());
        }

        public PortletContext getContext() {
            return this.context;
        }

        public PortletInfo getInfo() {
            return this.container.getInfo();
        }

        public boolean isRemote() {
            return false;
        }

        public String toString() {
            return "Portlet[context=" + this.context + ",container=" + this.container + "]";
        }
    }
}

