/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import org.apache.tomcat.util.net.PoolTcpEndpoint;

public class TcpConnection {
    static int MAX_SHUTDOWN_TRIES = 20;
    PoolTcpEndpoint endpoint;
    Socket socket;

    public static void setMaxShutdownTries(int mst) {
        MAX_SHUTDOWN_TRIES = mst;
    }

    public void setEndpoint(PoolTcpEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    public PoolTcpEndpoint getEndpoint() {
        return this.endpoint;
    }

    public void setSocket(Socket socket) {
        this.socket = socket;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public void recycle() {
        this.endpoint = null;
        this.socket = null;
    }

    public static int readLine(InputStream in, byte[] b, int off, int len) throws IOException {
        int c;
        if (len <= 0) {
            return 0;
        }
        int count = 0;
        while ((c = in.read()) != -1) {
            b[off++] = (byte)c;
            if (c != 10 && ++count != len) continue;
        }
        return count > 0 ? count : -1;
    }

    public static void shutdownInput(Socket socket) throws IOException {
        try {
            InputStream is = socket.getInputStream();
            int available = is.available();
            int count = 0;
            while (available > 0 && count++ < MAX_SHUTDOWN_TRIES) {
                is.skip(available);
                available = is.available();
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

