/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.itemfilters.QPathEntryFilter;
import org.exoplatform.services.jcr.impl.dataflow.ValueDataConvertor;
import org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.CQJDBCStorageConnection;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.jcr.storage.value.ValueStoragePluginProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiDbJDBCConnection
extends CQJDBCStorageConnection {
    protected static final String FIND_NODES_BY_PARENTID_CQ_QUERY = "select I.*, P.NAME AS PROP_NAME, V.ORDER_NUM, V.DATA from JCR_MITEM I, JCR_MITEM P, JCR_MVALUE V where I.I_CLASS=1 and I.PARENT_ID=? and P.I_CLASS=2 and P.PARENT_ID=I.ID and (P.NAME='[http://www.jcp.org/jcr/1.0]primaryType' or P.NAME='[http://www.jcp.org/jcr/1.0]mixinTypes' or P.NAME='[http://www.exoplatform.com/jcr/exo/1.0]owner' or P.NAME='[http://www.exoplatform.com/jcr/exo/1.0]permissions') and V.PROPERTY_ID=P.ID order by I.N_ORDER_NUM, I.ID";
    protected static final String FIND_PROPERTIES_BY_PARENTID_CQ_QUERY = "select I.ID, I.PARENT_ID, I.NAME, I.VERSION, I.I_CLASS, I.I_INDEX, I.N_ORDER_NUM, I.P_TYPE, I.P_MULTIVALUED, V.ORDER_NUM, V.DATA, V.STORAGE_DESC from JCR_MITEM I LEFT OUTER JOIN JCR_MVALUE V ON (V.PROPERTY_ID=I.ID) where I.I_CLASS=2 and I.PARENT_ID=? order by I.NAME";
    protected static final String FIND_ITEM_QPATH_BY_ID_CQ_QUERY = "select I.ID, I.PARENT_ID, I.NAME, I.I_INDEX from JCR_MITEM I, (SELECT ID, PARENT_ID from JCR_MITEM where ID=?) J where I.ID = J.ID or I.ID = J.PARENT_ID";
    protected String PATTERN_ESCAPE_STRING = "\\";

    public MultiDbJDBCConnection(Connection dbConnection, boolean readOnly, String containerName, ValueStoragePluginProvider valueStorageProvider, int maxBufferSize, File swapDirectory, FileCleaner swapCleaner) throws SQLException {
        super(dbConnection, readOnly, containerName, valueStorageProvider, maxBufferSize, swapDirectory, swapCleaner);
    }

    @Override
    protected String getIdentifier(String internalId) {
        return internalId;
    }

    @Override
    protected String getInternalId(String identifier) {
        return identifier;
    }

    @Override
    protected void prepareQueries() throws SQLException {
        this.JCR_PK_ITEM = "JCR_PK_MITEM";
        this.JCR_FK_ITEM_PARENT = "JCR_FK_MITEM_PARENT";
        this.JCR_IDX_ITEM_PARENT = "JCR_IDX_MITEM_PARENT";
        this.JCR_IDX_ITEM_PARENT_NAME = "JCR_IDX_MITEM_PARENT_NAME";
        this.JCR_IDX_ITEM_PARENT_ID = "JCR_IDX_MITEM_PARENT_ID";
        this.JCR_PK_VALUE = "JCR_PK_MVALUE";
        this.JCR_FK_VALUE_PROPERTY = "JCR_FK_MVALUE_PROPERTY";
        this.JCR_IDX_VALUE_PROPERTY = "JCR_IDX_MVALUE_PROPERTY";
        this.JCR_PK_REF = "JCR_PK_MREF";
        this.JCR_IDX_REF_PROPERTY = "JCR_IDX_MREF_PROPERTY";
        this.FIND_ITEM_BY_ID = "select * from JCR_MITEM where ID=?";
        this.FIND_ITEM_BY_NAME = "select * from JCR_MITEM where PARENT_ID=? and NAME=? and I_INDEX=? order by I_CLASS, VERSION DESC";
        this.FIND_PROPERTY_BY_NAME = "select V.DATA from JCR_MITEM I, JCR_MVALUE V where I.I_CLASS=2 and I.PARENT_ID=? and I.NAME=? and I.ID=V.PROPERTY_ID order by V.ORDER_NUM";
        this.FIND_REFERENCES = "select P.ID, P.PARENT_ID, P.VERSION, P.P_TYPE, P.P_MULTIVALUED, P.NAME from JCR_MREF R, JCR_MITEM P where R.NODE_ID=? and P.ID=R.PROPERTY_ID and P.I_CLASS=2";
        this.FIND_VALUES_BY_PROPERTYID = "select PROPERTY_ID, ORDER_NUM, DATA, STORAGE_DESC from JCR_MVALUE where PROPERTY_ID=? order by ORDER_NUM";
        this.FIND_VALUES_VSTORAGE_DESC_BY_PROPERTYID = "select distinct STORAGE_DESC from JCR_MVALUE where PROPERTY_ID=?";
        this.FIND_NODES_BY_PARENTID = "select * from JCR_MITEM where I_CLASS=1 and PARENT_ID=? order by N_ORDER_NUM";
        this.FIND_NODES_BY_PARENTID_CQ = FIND_NODES_BY_PARENTID_CQ_QUERY;
        this.FIND_NODE_MAIN_PROPERTIES_BY_PARENTID_CQ = "select I.NAME, V.DATA, V.ORDER_NUM from JCR_MITEM I, JCR_MVALUE V where I.I_CLASS=2 and I.PARENT_ID=? and (I.NAME='[http://www.jcp.org/jcr/1.0]primaryType' or I.NAME='[http://www.jcp.org/jcr/1.0]mixinTypes' or I.NAME='[http://www.exoplatform.com/jcr/exo/1.0]owner' or I.NAME='[http://www.exoplatform.com/jcr/exo/1.0]permissions') and I.ID=V.PROPERTY_ID";
        this.FIND_ITEM_QPATH_BY_ID_CQ = FIND_ITEM_QPATH_BY_ID_CQ_QUERY;
        this.FIND_LAST_ORDER_NUMBER_BY_PARENTID = "select count(*), max(N_ORDER_NUM) from JCR_MITEM where I_CLASS=1 and PARENT_ID=?";
        this.FIND_NODES_COUNT_BY_PARENTID = "select count(ID) from JCR_MITEM where I_CLASS=1 and PARENT_ID=?";
        this.FIND_PROPERTIES_BY_PARENTID = "select * from JCR_MITEM where I_CLASS=2 and PARENT_ID=? order by NAME";
        this.FIND_PROPERTIES_BY_PARENTID_CQ = FIND_PROPERTIES_BY_PARENTID_CQ_QUERY;
        this.FIND_PROPERTIES_BY_PARENTID_AND_PATTERN_CQ_TEMPLATE = "select I.ID, I.PARENT_ID, I.NAME, I.VERSION, I.I_CLASS, I.I_INDEX, I.N_ORDER_NUM, I.P_TYPE, I.P_MULTIVALUED, V.ORDER_NUM, V.DATA, V.STORAGE_DESC from JCR_MITEM I LEFT OUTER JOIN JCR_MVALUE V ON (V.PROPERTY_ID=I.ID)";
        this.FIND_NODES_BY_PARENTID_AND_PATTERN_CQ_TEMPLATE = "select I.*, P.NAME AS PROP_NAME, V.ORDER_NUM, V.DATA from JCR_MITEM I, JCR_MITEM P, JCR_MVALUE V";
        this.FIND_MAX_PROPERTY_VERSIONS = "select max(VERSION) FROM JCR_MITEM WHERE PARENT_ID=? and NAME=? and I_INDEX=? and I_CLASS=2";
        this.INSERT_NODE = "insert into JCR_MITEM(ID, PARENT_ID, NAME, VERSION, I_CLASS, I_INDEX, N_ORDER_NUM) VALUES(?,?,?,?,1,?,?)";
        this.INSERT_PROPERTY = "insert into JCR_MITEM(ID, PARENT_ID, NAME, VERSION, I_CLASS, I_INDEX, P_TYPE, P_MULTIVALUED) VALUES(?,?,?,?,2,?,?,?)";
        this.INSERT_VALUE = "insert into JCR_MVALUE(DATA, ORDER_NUM, PROPERTY_ID, STORAGE_DESC) VALUES(?,?,?,?)";
        this.INSERT_REF = "insert into JCR_MREF(NODE_ID, PROPERTY_ID, ORDER_NUM) VALUES(?,?,?)";
        this.RENAME_NODE = "update JCR_MITEM set PARENT_ID=?, NAME =?, VERSION=?, I_INDEX =?, N_ORDER_NUM =? where ID=?";
        this.UPDATE_NODE = "update JCR_MITEM set VERSION=?, I_INDEX=?, N_ORDER_NUM=? where ID=?";
        this.UPDATE_PROPERTY = "update JCR_MITEM set VERSION=?, P_TYPE=? where ID=?";
        this.DELETE_ITEM = "delete from JCR_MITEM where ID=?";
        this.DELETE_VALUE = "delete from JCR_MVALUE where PROPERTY_ID=?";
        this.DELETE_REF = "delete from JCR_MREF where PROPERTY_ID=?";
        this.FIND_NODES_AND_PROPERTIES = "select J.*, P.ID AS P_ID, P.NAME AS P_NAME, P.VERSION AS P_VERSION, P.P_TYPE, P.P_MULTIVALUED, V.DATA, V.ORDER_NUM, V.STORAGE_DESC from JCR_MVALUE V, JCR_MITEM P join (select I.ID, I.PARENT_ID, I.NAME, I.VERSION, I.I_INDEX, I.N_ORDER_NUM from JCR_MITEM I where I.I_CLASS=1 AND I.ID > ? order by I.ID LIMIT ? OFFSET ?) J on P.PARENT_ID = J.ID where P.I_CLASS=2 and V.PROPERTY_ID=P.ID  order by J.ID";
        this.FIND_PROPERTY_BY_ID = "select I.P_TYPE, V.STORAGE_DESC from JCR_MITEM I, JCR_MVALUE V where I.ID = ? and V.PROPERTY_ID = I.ID";
        this.DELETE_VALUE_BY_ORDER_NUM = "delete from JCR_MVALUE where PROPERTY_ID=? and ORDER_NUM >= ?";
        this.UPDATE_VALUE = "update JCR_MVALUE set DATA=?, STORAGE_DESC=? where PROPERTY_ID=? and ORDER_NUM=?";
        this.FIND_NODES_BY_PARENTID_LAZILY_CQ = "select I.*, P.NAME AS PROP_NAME, V.ORDER_NUM, V.DATA from JCR_MITEM I, JCR_MITEM P, JCR_MVALUE V where I.I_CLASS=1 and I.PARENT_ID=? and I.N_ORDER_NUM >= ? and I.N_ORDER_NUM <= ? and P.I_CLASS=2 and P.PARENT_ID=I.ID and (P.NAME='[http://www.jcp.org/jcr/1.0]primaryType' or P.NAME='[http://www.jcp.org/jcr/1.0]mixinTypes' or P.NAME='[http://www.exoplatform.com/jcr/exo/1.0]owner' or P.NAME='[http://www.exoplatform.com/jcr/exo/1.0]permissions') and V.PROPERTY_ID=P.ID order by I.N_ORDER_NUM, I.ID";
        this.FIND_ACL_HOLDERS = "select I.PARENT_ID, I.P_TYPE  from JCR_MITEM I where I.I_CLASS=2 and (I.NAME='[http://www.exoplatform.com/jcr/exo/1.0]owner' or I.NAME='[http://www.exoplatform.com/jcr/exo/1.0]permissions')";
    }

    @Override
    protected int addNodeRecord(NodeData data) throws SQLException {
        if (this.insertNode == null) {
            this.insertNode = this.dbConnection.prepareStatement(this.INSERT_NODE);
        } else {
            this.insertNode.clearParameters();
        }
        this.insertNode.setString(1, data.getIdentifier());
        this.insertNode.setString(2, data.getParentIdentifier() == null ? Constants.ROOT_PARENT_UUID : data.getParentIdentifier());
        this.insertNode.setString(3, data.getQPath().getName().getAsString());
        this.insertNode.setInt(4, data.getPersistedVersion());
        this.insertNode.setInt(5, data.getQPath().getIndex());
        this.insertNode.setInt(6, data.getOrderNumber());
        return this.insertNode.executeUpdate();
    }

    @Override
    protected int addPropertyRecord(PropertyData data) throws SQLException {
        if (this.insertProperty == null) {
            this.insertProperty = this.dbConnection.prepareStatement(this.INSERT_PROPERTY);
        } else {
            this.insertProperty.clearParameters();
        }
        this.insertProperty.setString(1, data.getIdentifier());
        this.insertProperty.setString(2, data.getParentIdentifier());
        this.insertProperty.setString(3, data.getQPath().getName().getAsString());
        this.insertProperty.setInt(4, data.getPersistedVersion());
        this.insertProperty.setInt(5, data.getQPath().getIndex());
        this.insertProperty.setInt(6, data.getType());
        this.insertProperty.setBoolean(7, data.isMultiValued());
        return this.insertProperty.executeUpdate();
    }

    @Override
    protected int addReference(PropertyData data) throws SQLException, IOException {
        if (this.insertReference == null) {
            this.insertReference = this.dbConnection.prepareStatement(this.INSERT_REF);
        } else {
            this.insertReference.clearParameters();
        }
        if (data.getQPath().getAsString().indexOf("versionableUuid") > 0) {
            LOG.info((Object)("add ref versionableUuid " + data.getQPath().getAsString()));
        }
        List<ValueData> values = data.getValues();
        int added = 0;
        for (int i = 0; i < values.size(); ++i) {
            ValueData vdata = values.get(i);
            String refNodeIdentifier = ValueDataConvertor.readString(vdata);
            this.insertReference.setString(1, refNodeIdentifier);
            this.insertReference.setString(2, data.getIdentifier());
            this.insertReference.setInt(3, i);
            added += this.insertReference.executeUpdate();
        }
        return added;
    }

    @Override
    protected int deleteReference(String propertyIdentifier) throws SQLException {
        if (this.deleteReference == null) {
            this.deleteReference = this.dbConnection.prepareStatement(this.DELETE_REF);
        } else {
            this.deleteReference.clearParameters();
        }
        this.deleteReference.setString(1, propertyIdentifier);
        return this.deleteReference.executeUpdate();
    }

    @Override
    protected int deleteItemByIdentifier(String identifier) throws SQLException {
        if (this.deleteItem == null) {
            this.deleteItem = this.dbConnection.prepareStatement(this.DELETE_ITEM);
        } else {
            this.deleteItem.clearParameters();
        }
        this.deleteItem.setString(1, identifier);
        return this.deleteItem.executeUpdate();
    }

    @Override
    protected int updateNodeByIdentifier(int version, int index, int orderNumb, String identifier) throws SQLException {
        if (this.updateNode == null) {
            this.updateNode = this.dbConnection.prepareStatement(this.UPDATE_NODE);
        } else {
            this.updateNode.clearParameters();
        }
        this.updateNode.setInt(1, version);
        this.updateNode.setInt(2, index);
        this.updateNode.setInt(3, orderNumb);
        this.updateNode.setString(4, identifier);
        return this.updateNode.executeUpdate();
    }

    @Override
    protected int updatePropertyByIdentifier(int version, int type, String identifier) throws SQLException {
        if (this.updateProperty == null) {
            this.updateProperty = this.dbConnection.prepareStatement(this.UPDATE_PROPERTY);
        } else {
            this.updateProperty.clearParameters();
        }
        this.updateProperty.setInt(1, version);
        this.updateProperty.setInt(2, type);
        this.updateProperty.setString(3, identifier);
        return this.updateProperty.executeUpdate();
    }

    @Override
    protected ResultSet findItemByName(String parentId, String name, int index) throws SQLException {
        if (this.findItemByName == null) {
            this.findItemByName = this.dbConnection.prepareStatement(this.FIND_ITEM_BY_NAME);
        } else {
            this.findItemByName.clearParameters();
        }
        this.findItemByName.setString(1, parentId);
        this.findItemByName.setString(2, name);
        this.findItemByName.setInt(3, index);
        return this.findItemByName.executeQuery();
    }

    @Override
    protected ResultSet findPropertyByName(String parentId, String name) throws SQLException {
        if (this.findPropertyByName == null) {
            this.findPropertyByName = this.dbConnection.prepareStatement(this.FIND_PROPERTY_BY_NAME);
        } else {
            this.findPropertyByName.clearParameters();
        }
        this.findPropertyByName.setString(1, parentId);
        this.findPropertyByName.setString(2, name);
        return this.findPropertyByName.executeQuery();
    }

    @Override
    protected ResultSet findItemByIdentifier(String identifier) throws SQLException {
        if (this.findItemById == null) {
            this.findItemById = this.dbConnection.prepareStatement(this.FIND_ITEM_BY_ID);
        } else {
            this.findItemById.clearParameters();
        }
        this.findItemById.setString(1, identifier);
        return this.findItemById.executeQuery();
    }

    @Override
    protected ResultSet findReferences(String nodeIdentifier) throws SQLException {
        if (this.findReferences == null) {
            this.findReferences = this.dbConnection.prepareStatement(this.FIND_REFERENCES);
        } else {
            this.findReferences.clearParameters();
        }
        this.findReferences.setString(1, nodeIdentifier);
        return this.findReferences.executeQuery();
    }

    @Override
    protected ResultSet findChildNodesByParentIdentifier(String parentIdentifier) throws SQLException {
        if (this.findNodesByParentId == null) {
            this.findNodesByParentId = this.dbConnection.prepareStatement(this.FIND_NODES_BY_PARENTID);
        } else {
            this.findNodesByParentId.clearParameters();
        }
        this.findNodesByParentId.setString(1, parentIdentifier);
        return this.findNodesByParentId.executeQuery();
    }

    @Override
    protected ResultSet findChildNodesByParentIdentifierCQ(String parentIdentifier) throws SQLException {
        if (this.findNodesByParentIdCQ == null) {
            this.findNodesByParentIdCQ = this.dbConnection.prepareStatement(this.FIND_NODES_BY_PARENTID_CQ);
        } else {
            this.findNodesByParentIdCQ.clearParameters();
        }
        this.findNodesByParentIdCQ.setString(1, parentIdentifier);
        return this.findNodesByParentIdCQ.executeQuery();
    }

    @Override
    protected ResultSet findChildNodesByParentIdentifierCQ(String parentIdentifier, List<QPathEntryFilter> pattern) throws SQLException {
        if (pattern.isEmpty()) {
            throw new SQLException("Pattern list is empty.");
        }
        if (this.findNodesByParentIdAndComplexPatternCQ == null) {
            this.findNodesByParentIdAndComplexPatternCQ = this.dbConnection.createStatement();
        }
        StringBuilder query = new StringBuilder(this.FIND_NODES_BY_PARENTID_AND_PATTERN_CQ_TEMPLATE);
        query.append(" where I.I_CLASS=1 and I.PARENT_ID='");
        query.append(parentIdentifier);
        query.append("' and ( ");
        this.appendPattern(query, pattern.get(0).getQPathEntry(), true);
        for (int i = 1; i < pattern.size(); ++i) {
            query.append(" or ");
            this.appendPattern(query, pattern.get(i).getQPathEntry(), true);
        }
        query.append(" ) and P.I_CLASS=2 and P.PARENT_ID=I.ID and (P.NAME='[http://www.jcp.org/jcr/1.0]primaryType'");
        query.append(" or P.NAME='[http://www.jcp.org/jcr/1.0]mixinTypes'");
        query.append(" or P.NAME='[http://www.exoplatform.com/jcr/exo/1.0]owner'");
        query.append(" or P.NAME='[http://www.exoplatform.com/jcr/exo/1.0]permissions')");
        query.append(" and V.PROPERTY_ID=P.ID order by I.N_ORDER_NUM, I.ID");
        return this.findNodesByParentIdAndComplexPatternCQ.executeQuery(query.toString());
    }

    @Override
    protected ResultSet findLastOrderNumberByParentIdentifier(String parentIdentifier) throws SQLException {
        if (this.findLastOrderNumberByParentId == null) {
            this.findLastOrderNumberByParentId = this.dbConnection.prepareStatement(this.FIND_LAST_ORDER_NUMBER_BY_PARENTID);
        } else {
            this.findLastOrderNumberByParentId.clearParameters();
        }
        this.findLastOrderNumberByParentId.setString(1, parentIdentifier);
        return this.findLastOrderNumberByParentId.executeQuery();
    }

    @Override
    protected ResultSet findChildNodesCountByParentIdentifier(String parentIdentifier) throws SQLException {
        if (this.findNodesCountByParentId == null) {
            this.findNodesCountByParentId = this.dbConnection.prepareStatement(this.FIND_NODES_COUNT_BY_PARENTID);
        } else {
            this.findNodesCountByParentId.clearParameters();
        }
        this.findNodesCountByParentId.setString(1, parentIdentifier);
        return this.findNodesCountByParentId.executeQuery();
    }

    @Override
    protected ResultSet findChildPropertiesByParentIdentifier(String parentIdentifier) throws SQLException {
        if (this.findPropertiesByParentId == null) {
            this.findPropertiesByParentId = this.dbConnection.prepareStatement(this.FIND_PROPERTIES_BY_PARENTID);
        } else {
            this.findPropertiesByParentId.clearParameters();
        }
        this.findPropertiesByParentId.setString(1, parentIdentifier);
        return this.findPropertiesByParentId.executeQuery();
    }

    @Override
    protected ResultSet findChildPropertiesByParentIdentifierCQ(String parentCid, List<QPathEntryFilter> pattern) throws SQLException {
        if (pattern.isEmpty()) {
            throw new SQLException("Pattern list is empty.");
        }
        if (this.findPropertiesByParentIdAndComplexPatternCQ == null) {
            this.findPropertiesByParentIdAndComplexPatternCQ = this.dbConnection.createStatement();
        }
        StringBuilder query = new StringBuilder(this.FIND_PROPERTIES_BY_PARENTID_AND_PATTERN_CQ_TEMPLATE);
        query.append(" where I.I_CLASS=2 and I.PARENT_ID='");
        query.append(parentCid);
        query.append("' and ( ");
        this.appendPattern(query, pattern.get(0).getQPathEntry(), false);
        for (int i = 1; i < pattern.size(); ++i) {
            query.append(" or ");
            this.appendPattern(query, pattern.get(i).getQPathEntry(), false);
        }
        query.append(" ) order by I.NAME");
        return this.findPropertiesByParentIdAndComplexPatternCQ.executeQuery(query.toString());
    }

    @Override
    protected ResultSet findChildNodesByParentIdentifier(String parentCid, int fromOrderNum, int toOrderNum) throws SQLException {
        if (this.findNodesByParentIdLazilyCQ == null) {
            this.findNodesByParentIdLazilyCQ = this.dbConnection.prepareStatement(this.FIND_NODES_BY_PARENTID_LAZILY_CQ);
        } else {
            this.findNodesByParentIdLazilyCQ.clearParameters();
        }
        this.findNodesByParentIdLazilyCQ.setString(1, parentCid);
        this.findNodesByParentIdLazilyCQ.setInt(2, fromOrderNum);
        this.findNodesByParentIdLazilyCQ.setInt(3, toOrderNum);
        return this.findNodesByParentIdLazilyCQ.executeQuery();
    }

    @Override
    protected int addValueData(String cid, int orderNumber, InputStream stream, int streamLength, String storageDesc) throws SQLException {
        if (this.insertValue == null) {
            this.insertValue = this.dbConnection.prepareStatement(this.INSERT_VALUE);
        } else {
            this.insertValue.clearParameters();
        }
        if (stream == null) {
            this.insertValue.setNull(1, -2);
            this.insertValue.setString(4, storageDesc);
        } else {
            this.insertValue.setBinaryStream(1, stream, streamLength);
            this.insertValue.setNull(4, 12);
        }
        this.insertValue.setInt(2, orderNumber);
        this.insertValue.setString(3, cid);
        return this.insertValue.executeUpdate();
    }

    @Override
    protected int deleteValueData(String cid) throws SQLException {
        if (this.deleteValue == null) {
            this.deleteValue = this.dbConnection.prepareStatement(this.DELETE_VALUE);
        } else {
            this.deleteValue.clearParameters();
        }
        this.deleteValue.setString(1, cid);
        return this.deleteValue.executeUpdate();
    }

    @Override
    protected ResultSet findValuesByPropertyId(String cid) throws SQLException {
        if (this.findValuesByPropertyId == null) {
            this.findValuesByPropertyId = this.dbConnection.prepareStatement(this.FIND_VALUES_BY_PROPERTYID);
        } else {
            this.findValuesByPropertyId.clearParameters();
        }
        this.findValuesByPropertyId.setString(1, cid);
        return this.findValuesByPropertyId.executeQuery();
    }

    @Override
    protected int renameNode(NodeData data) throws SQLException {
        if (this.renameNode == null) {
            this.renameNode = this.dbConnection.prepareStatement(this.RENAME_NODE);
        } else {
            this.renameNode.clearParameters();
        }
        this.renameNode.setString(1, data.getParentIdentifier() == null ? Constants.ROOT_PARENT_UUID : data.getParentIdentifier());
        this.renameNode.setString(2, data.getQPath().getName().getAsString());
        this.renameNode.setInt(3, data.getPersistedVersion());
        this.renameNode.setInt(4, data.getQPath().getIndex());
        this.renameNode.setInt(5, data.getOrderNumber());
        this.renameNode.setString(6, data.getIdentifier());
        return this.renameNode.executeUpdate();
    }

    @Override
    protected ResultSet findValuesStorageDescriptorsByPropertyId(String cid) throws SQLException {
        if (this.findValuesStorageDescriptorsByPropertyId == null) {
            this.findValuesStorageDescriptorsByPropertyId = this.dbConnection.prepareStatement(this.FIND_VALUES_VSTORAGE_DESC_BY_PROPERTYID);
        } else {
            this.findValuesStorageDescriptorsByPropertyId.clearParameters();
        }
        this.findValuesStorageDescriptorsByPropertyId.setString(1, cid);
        return this.findValuesStorageDescriptorsByPropertyId.executeQuery();
    }

    @Override
    protected ResultSet findChildPropertiesByParentIdentifierCQ(String parentIdentifier) throws SQLException {
        if (this.findPropertiesByParentIdCQ == null) {
            this.findPropertiesByParentIdCQ = this.dbConnection.prepareStatement(this.FIND_PROPERTIES_BY_PARENTID_CQ);
        } else {
            this.findPropertiesByParentIdCQ.clearParameters();
        }
        this.findPropertiesByParentIdCQ.setString(1, parentIdentifier);
        return this.findPropertiesByParentIdCQ.executeQuery();
    }

    @Override
    protected ResultSet findNodeMainPropertiesByParentIdentifierCQ(String parentIdentifier) throws SQLException {
        if (this.findNodeMainPropertiesByParentIdentifierCQ == null) {
            this.findNodeMainPropertiesByParentIdentifierCQ = this.dbConnection.prepareStatement(this.FIND_NODE_MAIN_PROPERTIES_BY_PARENTID_CQ);
        } else {
            this.findNodeMainPropertiesByParentIdentifierCQ.clearParameters();
        }
        this.findNodeMainPropertiesByParentIdentifierCQ.setString(1, parentIdentifier);
        return this.findNodeMainPropertiesByParentIdentifierCQ.executeQuery();
    }

    @Override
    protected ResultSet findItemQPathByIdentifierCQ(String identifier) throws SQLException {
        if (this.findItemQPathByIdentifierCQ == null) {
            this.findItemQPathByIdentifierCQ = this.dbConnection.prepareStatement(this.FIND_ITEM_QPATH_BY_ID_CQ);
        } else {
            this.findItemQPathByIdentifierCQ.clearParameters();
        }
        this.findItemQPathByIdentifierCQ.setString(1, identifier);
        return this.findItemQPathByIdentifierCQ.executeQuery();
    }

    @Override
    protected int deleteValueDataByOrderNum(String id, int orderNum) throws SQLException {
        if (this.deleteValueDataByOrderNum == null) {
            this.deleteValueDataByOrderNum = this.dbConnection.prepareStatement(this.DELETE_VALUE_BY_ORDER_NUM);
        } else {
            this.deleteValueDataByOrderNum.clearParameters();
        }
        this.deleteValueDataByOrderNum.setString(1, id);
        this.deleteValueDataByOrderNum.setInt(2, orderNum);
        return this.deleteValueDataByOrderNum.executeUpdate();
    }

    @Override
    protected ResultSet findPropertyById(String id) throws SQLException {
        if (this.findPropertyById == null) {
            this.findPropertyById = this.dbConnection.prepareStatement(this.FIND_PROPERTY_BY_ID);
        } else {
            this.findPropertyById.clearParameters();
        }
        this.findPropertyById.setString(1, id);
        return this.findPropertyById.executeQuery();
    }

    @Override
    protected int updateValueData(String cid, int orderNumber, InputStream stream, int streamLength, String storageDesc) throws SQLException {
        if (this.updateValue == null) {
            this.updateValue = this.dbConnection.prepareStatement(this.UPDATE_VALUE);
        } else {
            this.updateValue.clearParameters();
        }
        if (stream == null) {
            this.updateValue.setNull(1, -2);
            this.updateValue.setString(2, storageDesc);
        } else {
            this.updateValue.setBinaryStream(1, stream, streamLength);
            this.updateValue.setNull(2, 12);
        }
        this.updateValue.setString(3, cid);
        this.updateValue.setInt(4, orderNumber);
        return this.updateValue.executeUpdate();
    }

    @Override
    protected ResultSet findNodesAndProperties(String lastNodeId, int offset, int limit) throws SQLException {
        if (this.findNodesAndProperties == null) {
            this.findNodesAndProperties = this.dbConnection.prepareStatement(this.FIND_NODES_AND_PROPERTIES);
        } else {
            this.findNodesAndProperties.clearParameters();
        }
        this.findNodesAndProperties.setString(1, lastNodeId);
        this.findNodesAndProperties.setInt(2, limit);
        this.findNodesAndProperties.setInt(3, offset);
        return this.findNodesAndProperties.executeQuery();
    }

    protected String fixEscapeSymbols(String pattern) {
        char[] chars = pattern.toCharArray();
        StringBuilder sb = new StringBuilder();
        block4: for (int i = 0; i < chars.length; ++i) {
            switch (chars[i]) {
                case '*': {
                    sb.append('%');
                    continue block4;
                }
                case '%': 
                case '_': {
                    sb.append(this.getWildcardEscapeSymbold());
                }
                default: {
                    sb.append(chars[i]);
                }
            }
        }
        return sb.toString();
    }

    protected void appendPattern(StringBuilder sb, QPathEntry entry, boolean indexConstraint) {
        String pattern = entry.getAsString(false);
        sb.append("(I.NAME");
        if (pattern.contains("*")) {
            sb.append(" LIKE '");
            sb.append(this.fixEscapeSymbols(pattern));
            sb.append("' ESCAPE '");
            sb.append(this.getLikeExpressionEscape());
            sb.append("'");
        } else {
            sb.append("='");
            sb.append(pattern);
            sb.append("'");
        }
        if (indexConstraint && entry.getIndex() != -1) {
            sb.append(" and I.I_INDEX=");
            sb.append(entry.getIndex());
        }
        sb.append(")");
    }

    protected String getWildcardEscapeSymbold() {
        return this.PATTERN_ESCAPE_STRING;
    }

    protected String getLikeExpressionEscape() {
        return this.PATTERN_ESCAPE_STRING;
    }

    @Override
    protected ResultSet findACLHolders() throws SQLException {
        if (this.findACLHolders == null) {
            this.findACLHolders = this.dbConnection.prepareStatement(this.FIND_ACL_HOLDERS);
        }
        return this.findACLHolders.executeQuery();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void deleteLockProperties() throws SQLException {
        SQLException e22;
        PreparedStatement removeItemsStatement;
        block11: {
            PreparedStatement removeValuesStatement = null;
            removeItemsStatement = null;
            try {
                removeValuesStatement = this.dbConnection.prepareStatement("DELETE FROM JCR_MVALUE WHERE PROPERTY_ID IN (SELECT ID FROM JCR_MITEM WHERE NAME = '[http://www.jcp.org/jcr/1.0]lockIsDeep' OR NAME = '[http://www.jcp.org/jcr/1.0]lockOwner')");
                removeItemsStatement = this.dbConnection.prepareStatement("DELETE FROM JCR_MITEM WHERE NAME = '[http://www.jcp.org/jcr/1.0]lockIsDeep' OR NAME = '[http://www.jcp.org/jcr/1.0]lockOwner'");
                removeValuesStatement.executeUpdate();
                removeItemsStatement.executeUpdate();
                Object var4_3 = null;
                if (removeValuesStatement == null) break block11;
            }
            catch (Throwable throwable) {
                SQLException e22;
                Object var4_4 = null;
                if (removeValuesStatement != null) {
                    try {
                        removeValuesStatement.close();
                    }
                    catch (SQLException e22) {
                        LOG.error((Object)"Can't close statement", (Throwable)e22);
                    }
                }
                if (removeItemsStatement != null) {
                    try {
                        removeItemsStatement.close();
                    }
                    catch (SQLException e22) {
                        LOG.error((Object)"Can't close statement", (Throwable)e22);
                    }
                }
                throw throwable;
            }
            try {
                removeValuesStatement.close();
            }
            catch (SQLException e22) {
                LOG.error((Object)"Can't close statement", (Throwable)e22);
            }
        }
        if (removeItemsStatement != null) {
            try {
                removeItemsStatement.close();
            }
            catch (SQLException e22) {
                LOG.error((Object)"Can't close statement", (Throwable)e22);
            }
        }
    }

    @Override
    protected ResultSet findMaxPropertyVersion(String parentId, String name, int index) throws SQLException {
        if (this.findMaxPropertyVersions == null) {
            this.findMaxPropertyVersions = this.dbConnection.prepareStatement(this.FIND_MAX_PROPERTY_VERSIONS);
        }
        this.findMaxPropertyVersions.setString(1, this.getInternalId(parentId));
        this.findMaxPropertyVersions.setString(2, name);
        this.findMaxPropertyVersions.setInt(3, index);
        return this.findMaxPropertyVersions.executeQuery();
    }
}

