/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.ancillary.opt;

import com.google.caja.ancillary.opt.OptScope;
import com.google.caja.ancillary.opt.Symbol;
import com.google.caja.ancillary.opt.Var;
import com.google.caja.lexer.FilePosition;
import com.google.caja.parser.AncestorChain;
import com.google.caja.parser.MutableParseTreeNode;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.js.ArrayConstructor;
import com.google.caja.parser.js.Block;
import com.google.caja.parser.js.Declaration;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.FormalParam;
import com.google.caja.parser.js.FunctionConstructor;
import com.google.caja.parser.js.FunctionDeclaration;
import com.google.caja.parser.js.Identifier;
import com.google.caja.parser.js.IntegerLiteral;
import com.google.caja.parser.js.Literal;
import com.google.caja.parser.js.MultiDeclaration;
import com.google.caja.parser.js.ObjProperty;
import com.google.caja.parser.js.ObjectConstructor;
import com.google.caja.parser.js.Operation;
import com.google.caja.parser.js.Operator;
import com.google.caja.parser.js.Reference;
import com.google.caja.parser.js.RegexpLiteral;
import com.google.caja.parser.js.Statement;
import com.google.caja.parser.js.StringLiteral;
import com.google.caja.parser.js.ValueProperty;
import com.google.caja.parser.js.scope.ES5ScopeAnalyzer;
import com.google.caja.parser.js.scope.ScopeListener;
import com.google.caja.parser.js.scope.ScopeType;
import com.google.caja.util.Maps;
import com.google.caja.util.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Optimizer {
    final Set<Var> vars = Sets.newLinkedHashSet();
    final Map<AncestorChain<?>, Integer> positions = Maps.newHashMap();
    boolean changed;

    Optimizer() {
    }

    void examine(AncestorChain<?> program) {
        ES5ScopeAnalyzer<OptScope> sa = new ES5ScopeAnalyzer<OptScope>(new ScopeListener<OptScope>(){

            @Override
            public void assigned(AncestorChain<Identifier> id, OptScope useSite, OptScope definingSite) {
                if (definingSite != null) {
                    definingSite.requireSymbol((String)((Identifier)id.node).getName()).writes.add(id);
                }
            }

            @Override
            public OptScope createScope(ScopeType t, AncestorChain<?> root, OptScope parent) {
                return new OptScope(parent, t, root);
            }

            @Override
            public void declaration(AncestorChain<Identifier> id, OptScope s) {
                s.requireSymbol((String)((Identifier)id.node).getName()).decls.add(id);
            }

            @Override
            public void duplicate(AncestorChain<Identifier> id, OptScope scope) {
            }

            @Override
            public void enterScope(OptScope Scope2) {
            }

            @Override
            public void exitScope(OptScope scope) {
                block1: {
                    if (scope.t != ScopeType.FUNCTION) break block1;
                    AncestorChain<FunctionConstructor> fc = scope.root.cast(FunctionConstructor.class);
                    AncestorChain<Block> body = fc.child(((FunctionConstructor)fc.node).getBody());
                    for (Statement statement : ((Block)body.node).children()) {
                        if (!Optimizer.this.examineDeclaration(body.child(statement), scope)) break;
                    }
                }
            }

            @Override
            public void inScope(AncestorChain<?> ac, OptScope scope) {
                int pos = Optimizer.this.positions.size();
                Optimizer.this.positions.put(ac, pos);
                OptScope dc = scope;
                while (!dc.t.isDeclarationContainer) {
                    dc = dc.containing;
                }
                if (dc.earliestNonLocalXfer == Integer.MAX_VALUE && ac.node instanceof Operation) {
                    Operator op = ((Operation)ac.node).getOperator();
                    switch (op) {
                        case FUNCTION_CALL: 
                        case CONSTRUCTOR: 
                        case MEMBER_ACCESS: 
                        case SQUARE_BRACKET: {
                            dc.earliestNonLocalXfer = pos;
                            break;
                        }
                    }
                }
            }

            @Override
            public void masked(AncestorChain<Identifier> id, OptScope inner, OptScope outer) {
            }

            @Override
            public void read(AncestorChain<Identifier> id, OptScope useSite, OptScope definingSite) {
                if (definingSite != null) {
                    definingSite.requireSymbol((String)((Identifier)id.node).getName()).reads.add(id);
                }
            }

            @Override
            public void splitInitialization(AncestorChain<Identifier> declared, OptScope declScope, AncestorChain<Identifier> initialized, OptScope maskingScope) {
            }
        });
        sa.apply(program);
    }

    private boolean examineDeclaration(AncestorChain<Statement> ac, OptScope s) {
        Statement stmt = (Statement)ac.node;
        if (stmt instanceof MultiDeclaration) {
            for (Declaration declaration : ((MultiDeclaration)stmt).children()) {
                if (this.examineDeclaration(ac.child(declaration), s)) continue;
                return false;
            }
            return true;
        }
        if (stmt instanceof Declaration) {
            this.vars.add(new Var(((Declaration)stmt).getIdentifier(), s));
            return true;
        }
        return false;
    }

    void finish() {
        block4: for (Var v : this.vars) {
            boolean isConst;
            Expression value;
            int initPos;
            AncestorChain<Identifier> write;
            if ("arguments".equals(v.name)) continue;
            Symbol s = v.s.getSymbol(v.name);
            switch (s.writes.size()) {
                case 1: {
                    write = s.writes.get(0);
                    if (!(write.parent.node instanceof Declaration)) continue block4;
                    initPos = write.parent.node instanceof FunctionDeclaration ? -1 : this.positions.get(write);
                    AncestorChain<Declaration> d = write.parent.cast(Declaration.class);
                    value = ((Declaration)d.node).getInitializer();
                    isConst = Optimizer.isConst(value);
                    if (isConst || Optimizer.isSinglyInlineable(value) && s.reads.size() <= 1) break;
                    continue block4;
                }
                case 0: {
                    initPos = -1;
                    value = null;
                    write = null;
                    isConst = true;
                    break;
                }
                default: {
                    continue block4;
                }
            }
            int nInlined = 0;
            for (AncestorChain<Identifier> read : s.reads) {
                Expression repl;
                if (this.positions.get(read) < initPos || write != null && !Optimizer.inSameFn(write, read) && (!isConst || initPos > v.s.earliestNonLocalXfer)) continue;
                AncestorChain<Reference> toReplace = read.parent.cast(Reference.class);
                if (value == null) {
                    FilePosition fp = ((Reference)toReplace.node).getFilePosition();
                    repl = Operation.create(fp, Operator.VOID, new IntegerLiteral(fp, 0L));
                } else {
                    repl = (Expression)value.clone();
                }
                ((MutableParseTreeNode)toReplace.parent.cast(MutableParseTreeNode.class).node).replaceChild(repl, (ParseTreeNode)toReplace.node);
                ++nInlined;
                this.changed = true;
            }
            if (nInlined != s.reads.size()) continue;
            for (AncestorChain<Identifier> decl : s.decls) {
                AncestorChain<? extends ParseTreeNode> toRemove = decl.parent;
                if (toRemove.node instanceof FormalParam) continue;
                if (toRemove.parent.node instanceof MultiDeclaration && toRemove.parent.node.children().size() == 1) {
                    toRemove = toRemove.parent;
                }
                ((MutableParseTreeNode)toRemove.parent.cast(MutableParseTreeNode.class).node).removeChild((ParseTreeNode)toRemove.node);
                this.changed = true;
            }
        }
    }

    private static boolean isSinglyInlineable(Expression expr) {
        return Optimizer.isConst(expr) || expr instanceof StringLiteral || expr instanceof RegexpLiteral || expr instanceof ObjectConstructor && Optimizer.areSinglyInlineableProps(((ObjectConstructor)expr).children()) || expr instanceof ArrayConstructor && Optimizer.areSinglyInlineable(((ArrayConstructor)expr).children()) || expr instanceof FunctionConstructor;
    }

    private static boolean areSinglyInlineable(List<? extends Expression> exprs) {
        for (Expression expression : exprs) {
            if (Optimizer.isSinglyInlineable(expression)) continue;
            return false;
        }
        return true;
    }

    private static boolean areSinglyInlineableProps(List<? extends ObjProperty> props) {
        for (ObjProperty objProperty : props) {
            if (!(objProperty instanceof ValueProperty) || Optimizer.isSinglyInlineable(((ValueProperty)objProperty).getValueExpr())) continue;
            return false;
        }
        return true;
    }

    private static boolean isConst(Expression expr) {
        if (expr instanceof Literal) {
            if (expr instanceof RegexpLiteral) {
                return false;
            }
            if (expr instanceof StringLiteral) {
                return ((StringLiteral)expr).getValue().length() < 20;
            }
            return true;
        }
        return Operation.is((ParseTreeNode)expr, Operator.VOID) && Optimizer.areConst(((Operation)expr).children());
    }

    private static boolean areConst(List<? extends Expression> exprs) {
        for (Expression expression : exprs) {
            if (Optimizer.isConst(expression)) continue;
            return false;
        }
        return true;
    }

    private static boolean inSameFn(AncestorChain<?> a, AncestorChain<?> b) {
        while (a != null && !(a.node instanceof FunctionConstructor)) {
            a = a.parent;
        }
        while (b != null && !(b.node instanceof FunctionConstructor)) {
            b = b.parent;
        }
        return a != null && a.equals(b);
    }
}

