/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.lang.css;

import com.google.caja.lang.css.CssPropertyPatterns;
import com.google.caja.lang.css.CssSchema;
import com.google.caja.lexer.FilePosition;
import com.google.caja.parser.css.CssPropertySignature;
import com.google.caja.parser.js.ArrayConstructor;
import com.google.caja.parser.js.StringLiteral;
import com.google.caja.util.CajaTestCase;
import com.google.caja.util.Executor;
import com.google.caja.util.Name;
import com.google.caja.util.RhinoTestBed;
import java.util.ArrayList;

public class CssPropertyPatternsTest
extends CajaTestCase {
    public final void testKeywordPattern() {
        this.assertPattern("zoicks", "/^\\s*zoicks\\s*$/i");
        this.assertMatches("zoicks", "zoicks", "  zoicks", " ZOICKS ");
        this.assertDoesNotMatch("zoicks", "zoick", "zzoicks", "zoicks zoicks");
    }

    public final void testUnionPattern() {
        this.assertPattern("[ foo | bar ]", "/^\\s*(?:foo|bar)\\s*$/i");
        this.assertMatches("[ foo | bar ]", "foo", "bar", " foo ", " bar ");
        this.assertDoesNotMatch("[ foo | bar ]", "fo", "ar", " foo bar", " far ");
    }

    public final void testColor() {
        this.assertMatches("'color'", "#fff", "#aabbcc", "red", "rgb(0,0,255)", "rgb(0, 0, 255)");
    }

    public final void testExclusiveUnionPattern() {
        this.assertPattern("[ foo | [ a || b || c || d ] | bar ]", "/^\\s*(?:foo|[a-d](?:\\s+[a-d]){0,3}|bar)\\s*$/i");
    }

    public final void testReferencePattern() {
        this.assertPattern("'background-attachment'", "/^\\s*(?:scroll|fixed|local)(?:\\s*,\\s*(?:scroll|fixed|local))*\\s*$/i");
    }

    public final void testMultiFoo() {
        this.assertPattern("foo*", "/^\\s*(?:foo(?:\\s+foo)*)?\\s*$/i");
        this.assertMatches("foo*", "", "foo", "foo foo");
        this.assertDoesNotMatch("foo*", "bar", "foo bar", "bar foo foo", "foofoo");
        this.assertPattern("foo+", "/^\\s*foo(?:\\s+foo)*\\s*$/i");
        this.assertMatches("foo+", "foo", "foo foo", "foo  foo foo");
        this.assertDoesNotMatch("foo+", "", "bar", "foo bar", "bar  foo foo", "foofoo");
        this.assertPattern("foo?", "/^\\s*(?:foo)?\\s*$/i");
        this.assertMatches("foo?", "", "foo");
        this.assertDoesNotMatch("foo?", "bar", "foo bar", "foo foo", "foofoo");
    }

    public final void testConcatenations() {
        this.assertPattern("foo bar", "/^\\s*foo\\s+bar\\s*$/i");
        this.assertPattern("[ a b [ c || d ] ]", "/^\\s*a\\s+b(?:\\s+[cd]){1,2}\\s*$/i");
        this.assertMatches("foo bar", "foo bar", "foo  bar");
        this.assertDoesNotMatch("foo bar", "foo", "bar", "bar foo", "");
    }

    public final void testUnionsFolded() {
        this.assertPattern("[ foo | [ bar bar | baz ] | boo ]", "/^\\s*(?:foo|ba(?:r\\s+bar|z)|boo)\\s*$/i");
        this.assertMatches("[ foo | [ bar bar | baz ] | boo ]", "foo", "bar bar", "baz", "boo");
        this.assertDoesNotMatch("[ foo | [ bar bar | baz ] | boo ]", "bar", "", "faz", "fooo");
    }

    public final void testBackgroundImage() {
        this.assertPattern("<uri> | none | inherit", "/^\\s*(?:url\\(\"[^()\\\\\"\\r\\n]+\"\\)|none|inherit)\\s*$/i");
        this.assertMatches("<uri> | none | inherit", "none", "inherit", "url(\"foo.gif\")");
        this.assertDoesNotMatch("<uri> | none | inherit", "gurl(\"foo.gif\")", "\"foo.gif\"", "url(\"foo.gif)", "url(\"foo.gif)\")", "url(\"foo.gif\\\")", "url(\"foo.gif\"\")");
    }

    public final void testFontFamilies() {
        String fontFamilySignature = "[[ <family-name> | <generic-family> ] [, [ <family-name> | <generic-family> ]]* ] | inherit";
        this.assertMatches(fontFamilySignature, "\"Helvetica\"", "\"Arial Bold\" , sans-serif");
        this.assertDoesNotMatch(fontFamilySignature, "Arial Bold", "\"\"", "\"Helvetica\\\"", "\"Helvetica\\", "\"Helvetica", "\"@import\"", "\"!important\"");
    }

    public final void testOpacity() {
        this.assertMatches("<number:0,1>", "0", "0.0", ".5", "0.5", "0.707", "1", "1.0");
        this.assertDoesNotMatch("<number:0,1>", "1.1", "-0.5", "0px", "");
    }

    public final void testNumbers() {
        String leftSignature = "<length> | <percentage> | auto | inherit";
        this.assertMatches(leftSignature, "0", "10px", "-10.5px", "0.125em", "+10px", "110%");
        this.assertDoesNotMatch(leftSignature, ".in", "-px", "em");
    }

    public final void testPropertyNameToDom2Property() {
        CssPropertyPatternsTest.assertEquals((String)"color", (String)CssPropertyPatterns.propertyNameToDom2Property(Name.css("color")));
        CssPropertyPatternsTest.assertEquals((String)"float", (String)CssPropertyPatterns.propertyNameToDom2Property(Name.css("float")));
        CssPropertyPatternsTest.assertEquals((String)"listStyleImage", (String)CssPropertyPatterns.propertyNameToDom2Property(Name.css("list-style-image")));
    }

    private void assertPattern(String sig, String golden) {
        String actual = this.toPattern(sig);
        CssPropertyPatternsTest.assertEquals((String)actual, (String)golden, (String)actual);
    }

    private void assertMatches(String sig, String ... candidates) {
        RhinoTestBed.runJs(new Executor.Input("var pattern = " + this.toPattern(sig) + ";" + "var candidates = " + CssPropertyPatternsTest.render(this.toArrayList(candidates)) + ";" + "for (var i = candidates.length; --i >= 0;) {" + "  if (!pattern.test(candidates[i])) {" + "    throw new Error('' + candidates[i]);" + "  }" + "}", this.getName()));
    }

    private void assertDoesNotMatch(String sig, String ... candidates) {
        RhinoTestBed.runJs(new Executor.Input("var pattern = " + this.toPattern(sig) + ";" + "var candidates = " + CssPropertyPatternsTest.render(this.toArrayList(candidates)) + ";" + "for (var i = candidates.length; --i >= 0;) {" + "  if (pattern.test(candidates[i])) {" + "    throw new Error(candidates[i]);" + "  }" + "}", this.getName()));
    }

    private String toPattern(String sig) {
        CssPropertyPatterns pp = new CssPropertyPatterns(CssSchema.getDefaultCss21Schema(this.mq));
        return pp.cssPropertyToPattern(CssPropertyPatternsTest.parseSignature(sig));
    }

    private ArrayConstructor toArrayList(String ... values) {
        ArrayList<StringLiteral> literals = new ArrayList<StringLiteral>();
        for (String value : values) {
            literals.add(StringLiteral.valueOf(FilePosition.UNKNOWN, value));
        }
        return new ArrayConstructor(FilePosition.UNKNOWN, literals);
    }

    private static CssPropertySignature parseSignature(String sig) {
        return CssPropertySignature.Parser.parseSignature(sig);
    }
}

