/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.cache.future;

import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import org.exoplatform.commons.cache.future.FutureCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Retrieval<K, V, C>
implements Callable<V> {
    private final C context;
    private final K key;
    private final FutureCache<K, V, C> cache;
    final FutureTask<V> future;
    transient Thread current;

    public Retrieval(C context, K key, FutureCache<K, V, C> cache) {
        this.key = key;
        this.context = context;
        this.future = new FutureTask(this);
        this.cache = cache;
        this.current = null;
    }

    @Override
    public V call() throws Exception {
        Object value = this.cache.loader.retrieve(this.context, this.key);
        if (value != null) {
            this.cache.put(this.key, value);
            return value;
        }
        return null;
    }
}

