/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.federation.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.pc.api.InvokerUnavailableException;
import org.gatein.pc.api.NoSuchPortletException;
import org.gatein.pc.api.Portlet;
import org.gatein.pc.api.PortletContext;
import org.gatein.pc.api.PortletInvoker;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.pc.api.PortletStateType;
import org.gatein.pc.api.PortletStatus;
import org.gatein.pc.api.invocation.PortletInvocation;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.gatein.pc.api.state.DestroyCloneFailure;
import org.gatein.pc.api.state.PropertyChange;
import org.gatein.pc.api.state.PropertyMap;
import org.gatein.pc.federation.FederatedPortletInvoker;
import org.gatein.pc.federation.FederatingPortletInvoker;
import org.gatein.pc.federation.PortletInvokerResolver;
import org.gatein.pc.federation.impl.FederatedPortletInvokerService;

public class FederatingPortletInvokerService
implements FederatingPortletInvoker {
    private static final Logger log = LoggerFactory.getLogger(FederatingPortletInvokerService.class);
    private volatile Map<String, FederatedPortletInvoker> invokerCache = new HashMap<String, FederatedPortletInvoker>();
    private PortletInvokerResolver portletResolver = PortletInvokerResolver.DEFAULT_RESOLVER;

    @Override
    public synchronized FederatedPortletInvoker registerInvoker(String federatedId, PortletInvoker federatedInvoker) {
        if (federatedId == null) {
            throw new IllegalArgumentException("No null id");
        }
        if (federatedInvoker == null) {
            throw new IllegalArgumentException("No null invoker");
        }
        if (this.invokerCache.containsKey(federatedId)) {
            throw new IllegalArgumentException("Attempting dual registration of " + federatedId);
        }
        HashMap<String, FederatedPortletInvoker> copy = new HashMap<String, FederatedPortletInvoker>(this.invokerCache);
        FederatedPortletInvokerService invoker = new FederatedPortletInvokerService(this, federatedId, federatedInvoker);
        copy.put(federatedId, invoker);
        this.invokerCache = copy;
        return invoker;
    }

    @Override
    public synchronized void unregisterInvoker(String federatedId) {
        if (federatedId == null) {
            throw new IllegalArgumentException("No null id accepted");
        }
        if (!this.invokerCache.containsKey(federatedId) && !this.portletResolver.knows(federatedId)) {
            throw new IllegalArgumentException("Attempting to unregister unknown invoker " + federatedId);
        }
        HashMap<String, FederatedPortletInvoker> copy = new HashMap<String, FederatedPortletInvoker>(this.invokerCache);
        copy.remove(federatedId);
        this.invokerCache = copy;
    }

    @Override
    public FederatedPortletInvoker getFederatedInvoker(String federatedId) throws IllegalArgumentException {
        if (federatedId == null) {
            throw new IllegalArgumentException("No null id provided");
        }
        try {
            return this.getOrResolveFederatedInvoker(federatedId, null);
        }
        catch (NoSuchPortletException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FederatedPortletInvoker getOrResolveFederatedInvoker(String federatedId, String compoundPortletId) throws NoSuchPortletException {
        FederatedPortletInvoker federatedPortletInvoker = this.invokerCache.get(federatedId);
        if (federatedPortletInvoker == null && (federatedPortletInvoker = this.portletResolver.resolvePortletInvokerFor(federatedId, this, compoundPortletId)) != null) {
            FederatingPortletInvokerService federatingPortletInvokerService = this;
            synchronized (federatingPortletInvokerService) {
                this.invokerCache.put(federatedId, federatedPortletInvoker);
            }
        }
        return federatedPortletInvoker;
    }

    @Override
    public Collection<String> getFederatedInvokerIds() {
        Collection<String> resolvedIds = this.getResolvedInvokerIds();
        Collection<String> resolvableIds = this.portletResolver.getKnownInvokerIds();
        HashSet<String> ids = new HashSet<String>(resolvedIds.size() + resolvableIds.size());
        ids.addAll(resolvedIds);
        ids.addAll(resolvableIds);
        return ids;
    }

    @Override
    public Collection<String> getResolvedInvokerIds() {
        return this.invokerCache.keySet();
    }

    @Override
    public boolean isResolved(String federatedId) throws IllegalArgumentException {
        return this.invokerCache.containsKey(federatedId);
    }

    public Set<Portlet> getPortlets() throws PortletInvokerException {
        return this.getPortlets(true, true);
    }

    private Set<Portlet> getPortlets(boolean includeRemotePortlets, boolean includeLocalPortlets) throws PortletInvokerException {
        LinkedHashSet<Portlet> portlets = new LinkedHashSet<Portlet>();
        for (String invokerId : this.getFederatedInvokerIds()) {
            if (!"local".equals(invokerId) ? !includeRemotePortlets : !includeLocalPortlets) continue;
            FederatedPortletInvoker federated = this.getFederatedInvoker(invokerId);
            if (!federated.isActive()) {
                log.info((Object)("PortletInvoker with id: " + invokerId + " was skipped because it isn't active."));
                continue;
            }
            try {
                Set offeredPortlets = federated.getPortlets();
                portlets.addAll(offeredPortlets);
            }
            catch (InvokerUnavailableException e) {
                Throwable cause = e.getCause();
                log.debug((Object)e.fillInStackTrace());
                log.warn((Object)("PortletInvoker with id: " + invokerId + " is not available.\nReason: " + e.getMessage() + "\nCaused by:\n" + (cause == null ? e : cause)));
            }
        }
        return portlets;
    }

    @Override
    public Set<Portlet> getLocalPortlets() throws PortletInvokerException {
        return this.getPortlets(false, true);
    }

    @Override
    public Set<Portlet> getRemotePortlets() throws PortletInvokerException {
        return this.getPortlets(true, false);
    }

    public Portlet getPortlet(PortletContext compoundPortletContext) throws IllegalArgumentException, PortletInvokerException {
        FederatedPortletInvoker federated = this.getFederatedPortletInvokerFor(compoundPortletContext);
        return federated.getPortlet(compoundPortletContext);
    }

    public PortletStatus getStatus(PortletContext portletContext) throws IllegalArgumentException, PortletInvokerException {
        FederatedPortletInvoker federated = this.getFederatedPortletInvokerFor(portletContext);
        return federated.getStatus(portletContext);
    }

    public PortletInvocationResponse invoke(PortletInvocation invocation) throws PortletInvokerException {
        PortletContext compoundPortletContext = invocation.getTarget();
        FederatedPortletInvoker federated = this.getFederatedPortletInvokerFor(compoundPortletContext);
        return federated.invoke(invocation);
    }

    public PortletContext createClone(PortletStateType stateType, PortletContext compoundPortletContext) throws PortletInvokerException {
        FederatedPortletInvoker federated = this.getFederatedPortletInvokerFor(compoundPortletContext);
        return federated.createClone(stateType, compoundPortletContext);
    }

    public List<DestroyCloneFailure> destroyClones(List<PortletContext> portletContexts) throws IllegalArgumentException, PortletInvokerException, UnsupportedOperationException {
        if (portletContexts == null) {
            throw new IllegalArgumentException("No null list accepted");
        }
        if (portletContexts.size() == 0) {
            return Collections.emptyList();
        }
        FederatedPortletInvoker invoker = null;
        for (PortletContext compoundPortletContext : portletContexts) {
            FederatedPortletInvoker federated = this.getFederatedPortletInvokerFor(compoundPortletContext);
            if (invoker == null) {
                invoker = federated;
                continue;
            }
            if (invoker.equals(federated)) continue;
            throw new PortletInvokerException("Cannot destroy portlet lists that requires more than one federated invoker");
        }
        return invoker.destroyClones(portletContexts);
    }

    public PropertyMap getProperties(PortletContext compoundPortletContext, Set<String> keys) throws PortletInvokerException {
        FederatedPortletInvoker federated = this.getFederatedPortletInvokerFor(compoundPortletContext);
        return federated.getProperties(compoundPortletContext, keys);
    }

    public PropertyMap getProperties(PortletContext compoundPortletContext) throws PortletInvokerException {
        FederatedPortletInvoker federated = this.getFederatedPortletInvokerFor(compoundPortletContext);
        return federated.getProperties(compoundPortletContext);
    }

    public PortletContext setProperties(PortletContext compoundPortletContext, PropertyChange[] changes) throws IllegalArgumentException, PortletInvokerException, UnsupportedOperationException {
        FederatedPortletInvoker federated = this.getFederatedPortletInvokerFor(compoundPortletContext);
        return federated.setProperties(compoundPortletContext, changes);
    }

    public PortletContext exportPortlet(PortletStateType stateType, PortletContext compoundPortletContext) throws PortletInvokerException {
        FederatedPortletInvoker federated = this.getFederatedPortletInvokerFor(compoundPortletContext);
        return federated.exportPortlet(stateType, compoundPortletContext);
    }

    public PortletContext importPortlet(PortletStateType stateType, PortletContext compoundPortletContext) throws PortletInvokerException {
        FederatedPortletInvoker federated = this.getFederatedPortletInvokerFor(compoundPortletContext);
        return federated.importPortlet(stateType, compoundPortletContext);
    }

    public boolean isActive() {
        return true;
    }

    @Override
    public synchronized void setPortletInvokerResolver(PortletInvokerResolver portletResolver) {
        this.portletResolver = portletResolver == null ? PortletInvokerResolver.DEFAULT_RESOLVER : portletResolver;
    }

    protected FederatedPortletInvoker getFederatedPortletInvokerFor(PortletContext compoundPortletContext) throws IllegalArgumentException, NoSuchPortletException {
        String invokerId;
        if (compoundPortletContext == null) {
            throw new IllegalArgumentException("No null portlet id accepted");
        }
        PortletContext.PortletContextComponents components = compoundPortletContext.getComponents();
        String compoundPortletId = compoundPortletContext.getId();
        if (components == null) {
            compoundPortletContext = PortletContext.createPortletContext((String)compoundPortletId, (boolean)true);
            components = compoundPortletContext.getComponents();
        }
        if ((invokerId = components.getInvokerName()) == null) {
            throw new IllegalArgumentException("Bad portlet id format " + compoundPortletId);
        }
        return this.getOrResolveFederatedInvoker(invokerId, compoundPortletId);
    }
}

