/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.service;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.calendar.service.Attachment;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.JCRPageList;
import org.exoplatform.calendar.service.Reminder;
import org.exoplatform.calendar.service.Utils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.jcr.impl.core.query.QueryImpl;
import org.exoplatform.services.jcr.impl.core.query.lucene.QueryResultImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventPageListQuery
extends JCRPageList {
    private static final Log log = ExoLogger.getExoLogger(EventPageListQuery.class);
    private String username_;
    private NodeIterator iter_ = null;
    private String value_;
    private long pageReturn = 0L;
    private Session session_ = null;

    public EventPageListQuery(String username, String value, long pageSize) throws Exception {
        super(pageSize);
        this.username_ = username;
        this.value_ = value;
        Session session = this.getJCRSession(username);
        if (session != null) {
            this.setAvailablePage(((QueryResultImpl)this.createXPathQuery(session, username, this.value_).execute()).getTotalSize());
        }
    }

    @Override
    protected void populateCurrentPage(long page, String username) throws Exception {
        long pageSize = this.getPageSize();
        Session session = this.getJCRSession(username);
        long totalPage = 0L;
        QueryImpl queryImpl = this.createXPathQuery(session, username, this.value_);
        if (page > 1L) {
            long position = (page - 1L) * pageSize;
            if (this.pageReturn == page) {
                queryImpl.setOffset(position - 1L);
            } else {
                queryImpl.setOffset(position);
            }
        }
        queryImpl.setLimit(pageSize);
        QueryResult result = queryImpl.execute();
        this.iter_ = result.getNodes();
        totalPage = ((QueryResultImpl)result).getTotalSize();
        this.setAvailablePage(totalPage);
        this.currentListPage_ = new ArrayList();
        int i = 0;
        while ((long)i < pageSize && this.iter_ != null && this.iter_.hasNext()) {
            Node currentNode = this.iter_.nextNode();
            if (currentNode.isNodeType(Utils.EXO_CALENDAR_EVENT)) {
                CalendarEvent calendarEvent = this.getEvent(currentNode);
                this.currentListPage_.add(calendarEvent);
            }
            ++i;
        }
        this.iter_ = null;
    }

    public static CalendarEvent getEventFromNode(CalendarEvent event, Node eventNode, Node reminderFolder) throws Exception {
        block29: {
            StringBuilder namePattern = new StringBuilder(512);
            namePattern.append(Utils.EXO_ID).append('|').append(Utils.EXO_CALENDAR_ID).append('|').append(Utils.EXO_SUMMARY).append('|').append(Utils.EXO_EVENT_CATEGORYID).append('|').append(Utils.EXO_EVENT_CATEGORY_NAME).append('|').append(Utils.EXO_LOCATION).append('|').append(Utils.EXO_TASK_DELEGATOR).append('|').append(Utils.EXO_REPEAT).append('|').append(Utils.EXO_DESCRIPTION).append('|').append(Utils.EXO_FROM_DATE_TIME).append('|').append(Utils.EXO_TO_DATE_TIME).append('|').append(Utils.EXO_EVENT_TYPE).append('|').append(Utils.EXO_PRIORITY).append('|').append(Utils.EXO_IS_PRIVATE).append('|').append(Utils.EXO_EVENT_STATE).append('|').append(Utils.EXO_SEND_OPTION).append('|').append(Utils.EXO_MESSAGE).append('|').append(Utils.EXO_DATE_MODIFIED).append('|').append(Utils.EXO_INVITATION).append('|').append(Utils.EXO_PARTICIPANT).append('|').append(Utils.EXO_PARTICIPANT_STATUS);
            PropertyIterator it = eventNode.getProperties(namePattern.toString());
            while (it.hasNext()) {
                int i;
                Value[] values;
                Property p = it.nextProperty();
                String name = p.getName();
                if (name.equals(Utils.EXO_ID)) {
                    event.setId(p.getString());
                    continue;
                }
                if (name.equals(Utils.EXO_CALENDAR_ID)) {
                    event.setCalendarId(p.getString());
                    continue;
                }
                if (name.equals(Utils.EXO_SUMMARY)) {
                    event.setSummary(p.getString());
                    continue;
                }
                if (name.equals(Utils.EXO_EVENT_CATEGORYID)) {
                    event.setEventCategoryId(p.getString());
                    continue;
                }
                if (name.equals(Utils.EXO_EVENT_CATEGORY_NAME)) {
                    event.setEventCategoryName(p.getString());
                    continue;
                }
                if (name.equals(Utils.EXO_LOCATION)) {
                    event.setLocation(p.getString());
                    continue;
                }
                if (name.equals(Utils.EXO_TASK_DELEGATOR)) {
                    event.setTaskDelegator(p.getString());
                    continue;
                }
                if (name.equals(Utils.EXO_REPEAT)) {
                    event.setRepeatType(p.getString());
                    continue;
                }
                if (name.equals(Utils.EXO_DESCRIPTION)) {
                    event.setDescription(p.getString());
                    continue;
                }
                if (name.equals(Utils.EXO_FROM_DATE_TIME)) {
                    event.setFromDateTime(p.getDate().getTime());
                    continue;
                }
                if (name.equals(Utils.EXO_TO_DATE_TIME)) {
                    event.setToDateTime(p.getDate().getTime());
                    continue;
                }
                if (name.equals(Utils.EXO_EVENT_TYPE)) {
                    event.setEventType(p.getString());
                    continue;
                }
                if (name.equals(Utils.EXO_PRIORITY)) {
                    event.setPriority(p.getString());
                    continue;
                }
                if (name.equals(Utils.EXO_IS_PRIVATE)) {
                    event.setPrivate(p.getBoolean());
                    continue;
                }
                if (name.equals(Utils.EXO_EVENT_STATE)) {
                    event.setEventState(p.getString());
                    continue;
                }
                if (name.equals(Utils.EXO_SEND_OPTION)) {
                    event.setSendOption(p.getString());
                    continue;
                }
                if (name.equals(Utils.EXO_MESSAGE)) {
                    event.setMessage(p.getString());
                    continue;
                }
                if (name.equals(Utils.EXO_DATE_MODIFIED)) {
                    event.setLastUpdatedTime(p.getDate().getTime());
                    continue;
                }
                if (name.equals(Utils.EXO_INVITATION)) {
                    values = p.getValues();
                    if (values.length == 1) {
                        event.setInvitation(new String[]{values[0].getString()});
                        continue;
                    }
                    String[] invites = new String[values.length];
                    for (i = 0; i < values.length; ++i) {
                        invites[i] = values[i].getString();
                    }
                    event.setInvitation(invites);
                    continue;
                }
                if (name.equals(Utils.EXO_PARTICIPANT)) {
                    values = p.getValues();
                    if (values.length == 1) {
                        event.setParticipant(new String[]{values[0].getString()});
                        continue;
                    }
                    String[] participant = new String[values.length];
                    for (i = 0; i < values.length; ++i) {
                        participant[i] = values[i].getString();
                    }
                    event.setParticipant(participant);
                    continue;
                }
                if (!name.equals(Utils.EXO_PARTICIPANT_STATUS)) continue;
                values = p.getValues();
                if (values.length == 1) {
                    event.setParticipantStatus(new String[]{values[0].getString()});
                    continue;
                }
                String[] participantStatus = new String[values.length];
                for (i = 0; i < values.length; ++i) {
                    participantStatus[i] = values[i].getString();
                }
                event.setParticipantStatus(participantStatus);
            }
            try {
                event.setReminders(EventPageListQuery.getReminders(eventNode, reminderFolder));
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block29;
                log.debug((Object)"fail to set the reminders to the event", (Throwable)e);
            }
        }
        event.setAttachment(EventPageListQuery.getAttachments(eventNode));
        return event;
    }

    private CalendarEvent getEvent(Node eventNode) throws Exception {
        CalendarEvent event = new CalendarEvent();
        String emptyStr = String.valueOf("");
        if (eventNode.getPath().contains(this.getPublicServiceHome())) {
            event.setCalType(emptyStr + 2);
        } else if (eventNode.getPath().contains(this.getPrivateServiceHome())) {
            event.setCalType(emptyStr + 0);
        } else {
            event.setCalType(emptyStr + 1);
        }
        return EventPageListQuery.getEventFromNode(event, eventNode, null);
    }

    private static List<Attachment> getAttachments(Node eventNode) throws Exception {
        ArrayList<Attachment> attachments = new ArrayList<Attachment>();
        if (eventNode.hasNode(Utils.ATTACHMENT_NODE)) {
            Node attachHome = eventNode.getNode(Utils.ATTACHMENT_NODE);
            NodeIterator iter = attachHome.getNodes();
            while (iter.hasNext()) {
                Node contentNode;
                Node attchmentNode = iter.nextNode();
                if (!attchmentNode.isNodeType(Utils.EXO_EVEN_TATTACHMENT)) continue;
                Attachment attachment = new Attachment();
                attachment.setId(attchmentNode.getPath());
                if (attchmentNode.hasProperty(Utils.EXO_FILE_NAME)) {
                    attachment.setName(attchmentNode.getProperty(Utils.EXO_FILE_NAME).getString());
                }
                if ((contentNode = attchmentNode.getNode(Utils.JCR_CONTENT)) != null) {
                    if (contentNode.hasProperty(Utils.JCR_LASTMODIFIED)) {
                        attachment.setLastModified(contentNode.getProperty(Utils.JCR_LASTMODIFIED).getDate());
                    }
                    if (contentNode.hasProperty(Utils.JCR_MIMETYPE)) {
                        attachment.setMimeType(contentNode.getProperty(Utils.JCR_MIMETYPE).getString());
                    }
                    if (contentNode.hasProperty(Utils.JCR_DATA)) {
                        InputStream inputStream = contentNode.getProperty(Utils.JCR_DATA).getStream();
                        attachment.setSize(inputStream.available());
                        attachment.setInputStream(inputStream);
                    }
                }
                attachment.setWorkspace(attchmentNode.getSession().getWorkspace().getName());
                attachments.add(attachment);
            }
        }
        return attachments;
    }

    public static List<Reminder> getReminders(Node eventNode, Node reminderFolder) throws Exception {
        ArrayList<Reminder> reminders = new ArrayList<Reminder>();
        Date fromDate = eventNode.getProperty(Utils.EXO_FROM_DATE_TIME).getDate().getTime();
        if (reminderFolder == null) {
            return reminders;
        }
        if (reminderFolder.hasNode(eventNode.getName())) {
            NodeIterator iter = reminderFolder.getNode(eventNode.getName()).getNodes();
            while (iter.hasNext()) {
                Node reminderNode = iter.nextNode();
                if (!reminderNode.isNodeType(Utils.EXO_REMINDER)) continue;
                Reminder reminder = new Reminder();
                reminder.setId(reminderNode.getName());
                StringBuilder namePattern = new StringBuilder(128);
                namePattern.append(Utils.EXO_OWNER).append('|').append(Utils.EXO_EVENT_ID).append('|').append(Utils.EXO_REMINDER_TYPE).append('|').append(Utils.EXO_ALARM_BEFORE).append('|').append(Utils.EXO_EMAIL).append('|').append(Utils.EXO_IS_REPEAT).append('|').append(Utils.EXO_TIME_INTERVAL).append('|').append(Utils.EXO_DESCRIPTION);
                PropertyIterator it = reminderNode.getProperties(namePattern.toString());
                while (it.hasNext()) {
                    Property p = it.nextProperty();
                    String name = p.getName();
                    if (name.equals(Utils.EXO_OWNER)) {
                        reminder.setReminderOwner(p.getString());
                        continue;
                    }
                    if (name.equals(Utils.EXO_EVENT_ID)) {
                        reminder.setEventId(p.getString());
                        continue;
                    }
                    if (name.equals(Utils.EXO_REMINDER_TYPE)) {
                        reminder.setReminderType(p.getString());
                        continue;
                    }
                    if (name.equals(Utils.EXO_ALARM_BEFORE)) {
                        reminder.setAlarmBefore(p.getLong());
                        continue;
                    }
                    if (name.equals(Utils.EXO_EMAIL)) {
                        reminder.setEmailAddress(p.getString());
                        continue;
                    }
                    if (name.equals(Utils.EXO_IS_REPEAT)) {
                        reminder.setRepeate(p.getBoolean());
                        continue;
                    }
                    if (name.equals(Utils.EXO_TIME_INTERVAL)) {
                        reminder.setRepeatInterval(p.getLong());
                        continue;
                    }
                    if (!name.equals(Utils.EXO_DESCRIPTION)) continue;
                    reminder.setDescription(p.getString());
                }
                reminder.setFromDateTime(fromDate);
                reminders.add(reminder);
            }
        }
        return reminders;
    }

    @Override
    public List<CalendarEvent> getAll() throws Exception {
        Session session = this.getJCRSession(this.username_);
        QueryImpl queryImpl = this.createXPathQuery(session, this.username_, this.value_);
        QueryResult result = queryImpl.execute();
        this.iter_ = result.getNodes();
        ArrayList<CalendarEvent> events = new ArrayList<CalendarEvent>();
        while (this.iter_.hasNext()) {
            Node eventNode = this.iter_.nextNode();
            events.add(this.getEvent(eventNode));
        }
        return events;
    }

    private String getPublicServiceHome() throws Exception {
        SessionProvider provider = Utils.createSystemProvider();
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)container.getComponentInstanceOfType(NodeHierarchyCreator.class);
        Node publicApp = nodeHierarchyCreator.getPublicApplicationNode(provider);
        if (publicApp != null && publicApp.hasNode(Utils.CALENDAR_APP)) {
            return publicApp.getNode(Utils.CALENDAR_APP).getPath();
        }
        return null;
    }

    private String getPrivateServiceHome() throws Exception {
        SessionProvider provider = Utils.createSystemProvider();
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)container.getComponentInstanceOfType(NodeHierarchyCreator.class);
        Node privateApp = nodeHierarchyCreator.getUserApplicationNode(provider, this.username_);
        if (privateApp != null && privateApp.hasNode(Utils.CALENDAR_APP)) {
            return privateApp.getNode(Utils.CALENDAR_APP).getPath();
        }
        return null;
    }

    public void setSession(Session s) {
        this.session_ = s;
    }

    private Session getJCRSession(String username) throws Exception {
        try {
            RepositoryService repositoryService = (RepositoryService)PortalContainer.getComponent(RepositoryService.class);
            SessionProvider sessionProvider = Utils.createSystemProvider();
            String defaultWS = repositoryService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName();
            return sessionProvider.getSession(defaultWS, repositoryService.getCurrentRepository());
        }
        catch (NullPointerException e) {
            return this.session_;
        }
    }

    private QueryImpl createXPathQuery(Session session, String username, String xpath) throws Exception {
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        return (QueryImpl)queryManager.createQuery(xpath, "xpath");
    }
}

