/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cache.impl.jboss;

import java.io.Serializable;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.management.ObjectName;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cache.ExoCacheConfig;
import org.exoplatform.services.cache.ExoCacheFactory;
import org.exoplatform.services.cache.ExoCacheInitException;
import org.exoplatform.services.cache.impl.jboss.AbstractExoCacheConfig;
import org.exoplatform.services.cache.impl.jboss.ExoCacheCreator;
import org.exoplatform.services.cache.impl.jboss.ExoCacheCreatorPlugin;
import org.exoplatform.services.cache.impl.jboss.ExoCacheFactoryConfigPlugin;
import org.exoplatform.services.cache.impl.jboss.fifo.FIFOExoCacheCreator;
import org.exoplatform.services.cache.impl.jboss.util.PrivilegedCacheHelper;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.jboss.cache.Cache;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.EvictionConfig;
import org.jboss.cache.jmx.JmxRegistrationManager;
import org.picocontainer.Startable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExoCacheFactoryImpl
implements ExoCacheFactory,
Startable {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.kernel.component.ext.cache.impl.jboss.v3.ExoCacheFactoryImpl");
    private static final String CACHE_CONFIG_TEMPLATE_KEY = "cache.config.template";
    public static final String ALLOW_SHAREABLE_CACHE = "allow.shareable.cache";
    public static final boolean ALLOW_SHAREABLE_CACHE_DEFAULT = false;
    private final ConfigurationManager configManager;
    private final String cacheConfigTemplate;
    private final boolean allowShareableCache;
    private final ExoContainerContext ctx;
    private final Map<Class<? extends ExoCacheConfig>, ExoCacheCreator> mappingConfigTypeCreators = new HashMap<Class<? extends ExoCacheConfig>, ExoCacheCreator>();
    private final Map<String, ExoCacheCreator> mappingImplCreators = new HashMap<String, ExoCacheCreator>();
    private final Map<String, String> mappingCacheNameConfig = new HashMap<String, String>();
    private final Map<ConfigurationKey, Cache<Serializable, Object>> caches = new HashMap<ConfigurationKey, Cache<Serializable, Object>>();
    private final List<JmxRegistrationManager> jmxManagers = new CopyOnWriteArrayList<JmxRegistrationManager>();
    private final ExoCacheCreator defaultCreator = new FIFOExoCacheCreator();

    public ExoCacheFactoryImpl(ExoContainerContext ctx, InitParams params, ConfigurationManager configManager) {
        this(ctx, ExoCacheFactoryImpl.getValueParam(params, CACHE_CONFIG_TEMPLATE_KEY), configManager, ExoCacheFactoryImpl.getBooleanParam(params, ALLOW_SHAREABLE_CACHE, false));
    }

    ExoCacheFactoryImpl(ExoContainerContext ctx, String cacheConfigTemplate, ConfigurationManager configManager, boolean allowShareableCache) {
        this.ctx = ctx;
        this.configManager = configManager;
        this.cacheConfigTemplate = cacheConfigTemplate;
        this.allowShareableCache = allowShareableCache;
        if (cacheConfigTemplate == null) {
            throw new RuntimeException("The parameter 'cache.config.template' must be set");
        }
    }

    public ExoCache<Serializable, Object> createCache(ExoCacheConfig config) throws ExoCacheInitException {
        ExoCache<Serializable, Object> eXoCache;
        final String region = config.getName();
        String customConfig = this.mappingCacheNameConfig.get(region);
        DefaultCacheFactory factory = PrivilegedCacheHelper.createCacheFactory();
        try {
            Cache cache;
            if (customConfig != null) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("A custom configuration has been set for the cache '" + region + "'."));
                }
                cache = PrivilegedCacheHelper.createCache(factory, this.configManager.getInputStream(customConfig), false);
            } else {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("The configuration template will be used for the the cache '" + region + "'."));
                }
                cache = PrivilegedCacheHelper.createCache(factory, this.configManager.getInputStream(this.cacheConfigTemplate), false);
                if (!config.isDistributed()) {
                    cache.getConfiguration().setCacheMode(Configuration.CacheMode.LOCAL);
                }
                this.cleanConfigurationTemplate(cache, region);
            }
            ExoCacheCreator creator = this.getExoCacheCreator(config);
            final Cache<Serializable, Object> effectiveCacheInstance = this.getUniqueInstance(cache, config);
            eXoCache = creator.create(config, effectiveCacheInstance);
            SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    effectiveCacheInstance.create();
                    effectiveCacheInstance.start();
                    JmxRegistrationManager jmxManager = ExoCacheFactoryImpl.getJmxRegistrationManager(effectiveCacheInstance, region);
                    if (jmxManager != null) {
                        jmxManager.registerAllMBeans();
                        ExoCacheFactoryImpl.this.jmxManagers.add(jmxManager);
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw new ExoCacheInitException("The cache '" + region + "' could not be initialized", (Throwable)e);
        }
        return eXoCache;
    }

    private static JmxRegistrationManager getJmxRegistrationManager(Cache<?, ?> parentCache, String cacheName) {
        try {
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            ObjectName containerObjectName = container.getScopingObjectName();
            final String objectNameBase = (containerObjectName != null ? containerObjectName.toString() + "," : "exo:") + "cache-name=" + cacheName;
            return new JmxRegistrationManager(container.getMBeanServer(), parentCache, objectNameBase){

                public String getObjectName(String resourceName) {
                    return objectNameBase + ",jmx-resource=" + resourceName;
                }
            };
        }
        catch (IllegalArgumentException e) {
            LOG.error((Object)"Could not create the JMX Manager", (Throwable)e);
            return null;
        }
    }

    public void addCreator(ExoCacheCreatorPlugin plugin) {
        List<ExoCacheCreator> creators = plugin.getCreators();
        for (ExoCacheCreator creator : creators) {
            this.mappingConfigTypeCreators.put(creator.getExpectedConfigType(), creator);
            this.mappingImplCreators.put(creator.getExpectedImplementation(), creator);
        }
    }

    public void addConfig(ExoCacheFactoryConfigPlugin plugin) {
        Map<String, String> configs = plugin.getConfigs();
        this.mappingCacheNameConfig.putAll(configs);
    }

    private static String getValueParam(InitParams params, String key) {
        String result;
        if (params == null) {
            return null;
        }
        ValueParam vp = params.getValueParam(key);
        if (vp == null || (result = vp.getValue()) == null || (result = result.trim()).length() == 0) {
            return null;
        }
        return result;
    }

    private static boolean getBooleanParam(InitParams params, String key, boolean defaultValue) {
        String value = ExoCacheFactoryImpl.getValueParam(params, key);
        return value == null ? defaultValue : Boolean.valueOf(value);
    }

    protected ExoCacheCreator getExoCacheCreator(ExoCacheConfig config) {
        ExoCacheCreator creator = this.mappingConfigTypeCreators.get(config.getClass());
        if (creator == null && (creator = this.mappingImplCreators.get(config.getImplementation())) == null) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("No cache creator has been found for the the cache '" + config.getName() + "', the default one will be used."));
            }
            return this.defaultCreator;
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("The cache '" + config.getName() + "' will be created with '" + creator.getClass() + "'."));
        }
        return creator;
    }

    protected void cleanConfigurationTemplate(Cache<Serializable, Object> cache, String region) {
        Configuration config = cache.getConfiguration();
        EvictionConfig evictionConfig = config.getEvictionConfig();
        if (evictionConfig == null) {
            evictionConfig = new EvictionConfig();
            config.setEvictionConfig(evictionConfig);
        }
        evictionConfig.setEvictionRegionConfigs(new LinkedList());
    }

    private synchronized Cache<Serializable, Object> getUniqueInstance(Cache<Serializable, Object> cache, ExoCacheConfig config) throws ExoCacheInitException {
        ConfigurationKey key;
        Configuration cfg;
        String clusterName;
        AbstractExoCacheConfig aConfig;
        String region = config.getName();
        boolean allowShareableCache = this.allowShareableCache;
        if (config instanceof AbstractExoCacheConfig && (aConfig = (AbstractExoCacheConfig)config).getAllowShareableCache() != null) {
            allowShareableCache = aConfig.getAllowShareableCache();
        }
        if ((clusterName = (cfg = cache.getConfiguration()).getClusterName()) != null && (clusterName = clusterName.trim()).length() > 0) {
            cfg.setClusterName(clusterName + "-" + this.ctx.getName() + (!allowShareableCache ? "-" + region : ""));
        }
        if (!allowShareableCache) {
            return cache;
        }
        try {
            key = new ConfigurationKey(cfg);
        }
        catch (CloneNotSupportedException e) {
            throw new ExoCacheInitException("Cannot clone the configuration.", (Throwable)e);
        }
        if (this.caches.containsKey(key)) {
            cache = this.caches.get(key);
        } else {
            this.caches.put(key, cache);
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("A new eXo Cache based on JBoss Cache instance has been registered for the region " + region));
            }
        }
        return cache;
    }

    public void start() {
    }

    public void stop() {
        SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                for (JmxRegistrationManager jmxManager : ExoCacheFactoryImpl.this.jmxManagers) {
                    jmxManager.unregisterAllMBeans();
                }
                return null;
            }
        });
    }

    private static class ConfigurationKey {
        private final String jgroupsConfigFile;
        private final Configuration conf;

        public ConfigurationKey(Configuration initialConf) throws CloneNotSupportedException {
            this.conf = initialConf.clone();
            this.jgroupsConfigFile = this.conf.getJGroupsConfigFile() == null ? null : this.conf.getJGroupsConfigFile().toString();
            this.conf.setJgroupsConfigFile(null);
            this.conf.setEvictionConfig(null);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.conf == null ? 0 : this.conf.hashCode());
            result = 31 * result + (this.jgroupsConfigFile == null ? 0 : this.jgroupsConfigFile.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ConfigurationKey other = (ConfigurationKey)obj;
            if (this.conf == null ? other.conf != null : !this.conf.equals((Object)other.conf)) {
                return false;
            }
            return !(this.jgroupsConfigFile == null ? other.jgroupsConfigFile != null : !this.jgroupsConfigFile.equals(other.jgroupsConfigFile));
        }
    }
}

