/*
 * Decompiled with CFR 0.152.
 */
package groovy.sql;

import groovy.lang.GroovyObjectSupport;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.codehaus.groovy.runtime.InvokerHelper;

public class BatchingStatementWrapper
extends GroovyObjectSupport {
    private Statement delegate;
    private int batchSize;
    private int batchCount;
    private Connection connection;
    private Logger log;
    private List<Integer> results;

    public BatchingStatementWrapper(Statement delegate, int batchSize, Logger log, Connection connection) {
        this.delegate = delegate;
        this.batchSize = batchSize;
        this.connection = connection;
        this.log = log;
        this.batchCount = 0;
        this.results = new ArrayList<Integer>();
    }

    public Object invokeMethod(String name, Object args) {
        return InvokerHelper.invokeMethod(this.delegate, name, args);
    }

    public void addBatch(String sql) throws SQLException {
        this.delegate.addBatch(sql);
        ++this.batchCount;
        if (this.batchSize != 0 && this.batchCount % this.batchSize == 0) {
            int[] result = this.delegate.executeBatch();
            this.connection.commit();
            for (int i : result) {
                this.results.add(i);
            }
            this.log.fine("Successfully executed batch with " + result.length + " command(s)");
        }
    }

    public void clearBatch() throws SQLException {
        if (this.batchSize != 0) {
            this.results = new ArrayList<Integer>();
        }
        this.delegate.clearBatch();
    }

    public int[] executeBatch() throws SQLException {
        int[] lastResult;
        if (this.batchSize == 0) {
            int[] result = this.delegate.executeBatch();
            this.log.fine("Successfully executed batch with " + result.length + " command(s)");
            return result;
        }
        for (int i : lastResult = this.delegate.executeBatch()) {
            this.results.add(i);
        }
        this.log.fine("Successfully executed batch with " + lastResult.length + " command(s)");
        int[] result = new int[this.results.size()];
        for (int i = 0; i < this.results.size(); ++i) {
            result[i] = this.results.get(i);
        }
        this.results = new ArrayList<Integer>();
        return result;
    }

    public void close() throws SQLException {
        this.delegate.close();
    }
}

