/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend.headless;

import com.install4j.api.context.ProgressInterface;
import com.install4j.api.screens.Screen;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.config.LanguageConfig;
import com.install4j.runtime.installer.config.ScreenBeanConfig;
import com.install4j.runtime.installer.controller.ReturnToken;
import com.install4j.runtime.installer.frontend.FormPanel;
import com.install4j.runtime.installer.frontend.headless.AbstractHeadlessScreenExecutor;
import com.install4j.runtime.installer.helper.ConsoleImpl;
import java.io.File;
import java.util.List;
import java.util.Locale;

public abstract class UnattendedScreenExecutor
extends AbstractHeadlessScreenExecutor {
    private UnattendedProgressInterface progressInterface;
    private boolean quietOverwrite;

    public UnattendedScreenExecutor(boolean bl) {
        this.quietOverwrite = bl;
    }

    protected boolean handleScreen(ScreenBeanConfig screenBeanConfig) {
        Object[] objectArray = null;
        Screen screen = screenBeanConfig.getOrInstantiateScreen(false);
        if (screen.hasFormPanel()) {
            FormPanel formPanel = new FormPanel(screenBeanConfig.getFormComponentConfigs(), this.getContext(), false);
            screen.setFormPanel(formPanel, formPanel.getFormEnvironment());
            if (!formPanel.handleUnattended()) {
                return false;
            }
            objectArray = new Object[]{formPanel.getFormEnvironment()};
        }
        return screen.handleUnattended() && this.getContext().runBooleanScript(screenBeanConfig.getValidationClassName(), screen, objectArray);
    }

    public boolean isUnattended() {
        return true;
    }

    public boolean isConsole() {
        return false;
    }

    public ProgressInterface getProgressInterface() {
        if (this.progressInterface == null) {
            this.progressInterface = new UnattendedProgressInterface();
        }
        return this.progressInterface;
    }

    public void selectLanguage(ReturnToken returnToken) {
        String string = null;
        List list = InstallerConfig.getCurrentInstance().getLanguages();
        String string2 = Locale.getDefault().getLanguage();
        LanguageConfig languageConfig = InstallerConfig.getCurrentInstance().getLanguageById(string2);
        if (languageConfig != null) {
            string = languageConfig.getId();
        } else if (list.size() > 0) {
            string = ((LanguageConfig)list.get(0)).getId();
        }
        returnToken.returnToController(string);
    }

    private class UnattendedProgressInterface
    implements ProgressInterface {
        private UnattendedProgressInterface() {
        }

        public void setStatusMessage(String string) {
            ConsoleImpl.getInstance().setStatusMessage(string);
        }

        public void setDetailMessage(String string) {
        }

        public void setPercentCompleted(int n) {
        }

        public int getPercentCompleted() {
            return 0;
        }

        public void setIndeterminateProgress(boolean bl) {
        }

        public void showFailure(String string) {
            ConsoleImpl.getInstance().showFailure(string);
        }

        public int askOverwrite(File file) {
            if (UnattendedScreenExecutor.this.quietOverwrite) {
                return 2;
            }
            return 1;
        }

        public int askRetry(File file) {
            return 1;
        }

        public boolean askContinue(File file) {
            return true;
        }
    }
}

