/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.formcomponents;

import com.install4j.api.Util;
import com.install4j.runtime.beans.formcomponents.FormattedTextfieldComponent;
import java.text.ParseException;
import javax.swing.JFormattedTextField;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.MaskFormatter;

public class MaskTextfieldComponent
extends FormattedTextfieldComponent {
    private String inputMask = "###-##-####";
    private String placeholderCharacter = "0";
    private boolean valueContainsLiteralCharacters = true;
    private String validCharacters = "";
    private String invalidCharacters = "";
    private boolean allowsInvalid = false;

    public String getInputMask() {
        return this.inputMask;
    }

    public void setInputMask(String string) {
        this.inputMask = string;
    }

    public String getPlaceholderCharacter() {
        return this.placeholderCharacter;
    }

    public boolean isValueContainsLiteralCharacters() {
        return this.valueContainsLiteralCharacters;
    }

    public void setValueContainsLiteralCharacters(boolean bl) {
        this.valueContainsLiteralCharacters = bl;
    }

    public String getValidCharacters() {
        return this.validCharacters;
    }

    public void setValidCharacters(String string) {
        this.validCharacters = string;
    }

    public String getInvalidCharacters() {
        return this.invalidCharacters;
    }

    public void setInvalidCharacters(String string) {
        this.invalidCharacters = string;
    }

    public void setPlaceholderCharacter(String string) {
        this.placeholderCharacter = string.length() == 0 ? " " : string.substring(0, 1);
    }

    public boolean isAllowsInvalid() {
        return this.allowsInvalid;
    }

    public void setAllowsInvalid(boolean bl) {
        this.allowsInvalid = bl;
    }

    protected DefaultFormatter createFormatter() {
        try {
            MaskFormatter maskFormatter = new MaskFormatter(this.inputMask);
            maskFormatter.setPlaceholderCharacter(this.placeholderCharacter.charAt(0));
            maskFormatter.setValueContainsLiteralCharacters(this.valueContainsLiteralCharacters);
            if (this.validCharacters.trim().length() > 0) {
                maskFormatter.setValidCharacters(this.validCharacters);
            }
            if (this.invalidCharacters.trim().length() > 0) {
                maskFormatter.setInvalidCharacters(this.invalidCharacters);
            }
            maskFormatter.setAllowsInvalid(this.allowsInvalid);
            return maskFormatter;
        }
        catch (ParseException parseException) {
            Util.fatalError(parseException);
            return null;
        }
    }

    protected String getFormatDescription() {
        JFormattedTextField jFormattedTextField = (JFormattedTextField)this.getTextComponent();
        return " [" + ((MaskFormatter)jFormattedTextField.getFormatter()).getMask() + "]";
    }
}

