/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.util.jdbc;

import java.io.IOException;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.database.utils.ExceptionManagementHelper;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCUtils;
import org.exoplatform.services.jcr.impl.util.jdbc.DBInitializerException;
import org.exoplatform.services.jcr.impl.util.jdbc.DBInitializerHelper;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBInitializer {
    public static String SQL_CREATETABLE = "^(CREATE(\\s)+TABLE(\\s)+(IF(\\s)+NOT(\\s)+EXISTS(\\s)+)*){1}";
    public static String SQL_CREATEVIEW = "^(CREATE(\\s)+VIEW(\\s)+(IF(\\s)+NOT(\\s)+EXISTS(\\s)+)*){1}";
    public static String SQL_OBJECTNAME = "((JCR_[A-Z_]+){1}(\\s*?|(\\(\\))*?)+)+?";
    public static String SQL_CREATEINDEX = "^(CREATE(\\s)+(UNIQUE(\\s)+)*INDEX(\\s)+){1}";
    public static String SQL_ONTABLENAME = "(ON(\\s)+(JCR_[A-Z_]+){1}(\\s*?|(\\(\\))*?)+){1}";
    public static String SQL_CREATESEQUENCE = "^(CREATE(\\s)+SEQUENCE(\\s)+){1}";
    public static String SQL_CREATETRIGGER = "^(CREATE(\\s)+(OR(\\s){1}REPLACE(\\s)+)*TRIGGER(\\s)+){1}";
    public static String SQL_TRIGGERNAME = "(([A-Z_]+JCR_[A-Z_]+){1}(\\s*?|(\\(\\))*?)+)+?";
    protected final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.DBInitializer");
    protected final Connection connection;
    protected final String containerName;
    protected final String script;
    protected final Pattern creatTablePattern;
    protected final Pattern creatViewPattern;
    protected final Pattern dbObjectNamePattern;
    protected final Pattern creatIndexPattern;
    protected final Pattern onTableNamePattern;
    protected final Pattern creatSequencePattern;
    protected final Pattern creatTriggerPattern;
    protected final Pattern dbTriggerNamePattern;

    public DBInitializer(String containerName, Connection connection, String scriptPath) throws IOException {
        this.connection = connection;
        this.containerName = containerName;
        this.script = this.script(scriptPath);
        this.creatTablePattern = Pattern.compile(SQL_CREATETABLE, 2);
        this.creatViewPattern = Pattern.compile(SQL_CREATEVIEW, 2);
        this.dbObjectNamePattern = Pattern.compile(SQL_OBJECTNAME, 2);
        this.creatIndexPattern = Pattern.compile(SQL_CREATEINDEX, 2);
        this.onTableNamePattern = Pattern.compile(SQL_ONTABLENAME, 2);
        this.creatSequencePattern = Pattern.compile(SQL_CREATESEQUENCE, 2);
        this.creatTriggerPattern = Pattern.compile(SQL_CREATETRIGGER, 2);
        this.dbTriggerNamePattern = Pattern.compile(SQL_TRIGGERNAME, 2);
    }

    protected String script(String scriptPath) throws IOException {
        return DBInitializerHelper.readScriptResource(scriptPath);
    }

    protected boolean isTableExists(final Connection conn, final String tableName) throws SQLException {
        return (Boolean)SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return JDBCUtils.tableExists(tableName, conn);
            }
        });
    }

    protected boolean isSequenceExists(Connection conn, String sequenceName) throws SQLException {
        return false;
    }

    protected boolean isObjectExists(Connection conn, String sql, Set<String> existingTables) throws SQLException {
        Matcher tMatcher = this.creatTablePattern.matcher(sql);
        if (tMatcher.find()) {
            String tableName;
            tMatcher = this.dbObjectNamePattern.matcher(sql);
            if (tMatcher.find() && this.isTableExists(conn, tableName = sql.substring(tMatcher.start(), tMatcher.end()))) {
                if (this.LOG.isDebugEnabled()) {
                    this.LOG.debug((Object)("Table is already exists " + tableName));
                }
                existingTables.add(tableName);
                return true;
            }
        } else {
            tMatcher = this.creatViewPattern.matcher(sql);
            if (tMatcher.find()) {
                String tableName;
                tMatcher = this.dbObjectNamePattern.matcher(sql);
                if (tMatcher.find() && this.isTableExists(conn, tableName = sql.substring(tMatcher.start(), tMatcher.end()))) {
                    if (this.LOG.isDebugEnabled()) {
                        this.LOG.debug((Object)("View is already exists " + tableName));
                    }
                    existingTables.add(tableName);
                    return true;
                }
            } else {
                tMatcher = this.creatIndexPattern.matcher(sql);
                if (tMatcher.find()) {
                    tMatcher = this.dbObjectNamePattern.matcher(sql);
                    if (tMatcher.find()) {
                        String indexName = sql.substring(tMatcher.start(), tMatcher.end());
                        tMatcher = this.onTableNamePattern.matcher(sql);
                        if (tMatcher.find()) {
                            String onTableName = sql.substring(tMatcher.start(), tMatcher.end());
                            if ((tMatcher = this.dbObjectNamePattern.matcher(onTableName)).find()) {
                                String tableName = onTableName.substring(tMatcher.start(), tMatcher.end());
                                if (existingTables.contains(tableName)) {
                                    if (this.LOG.isDebugEnabled()) {
                                        this.LOG.debug((Object)("The table " + tableName + " already exists so we assume that the index " + indexName + " exists also."));
                                    }
                                    return true;
                                }
                            } else {
                                this.LOG.warn((Object)("Index found but $TABLE_NAME is not detected '" + sql + "'"));
                            }
                        } else {
                            this.LOG.warn((Object)("Index found but ON $TABLE_NAME clause is not detected '" + sql + "'"));
                        }
                    } else {
                        this.LOG.warn((Object)("Create index clause found but $INDEX_NAME is not detected '" + sql + "'"));
                    }
                } else {
                    tMatcher = this.creatSequencePattern.matcher(sql);
                    if (tMatcher.find()) {
                        String sequenceName;
                        tMatcher = this.dbObjectNamePattern.matcher(sql);
                        if (tMatcher.find() && this.isSequenceExists(conn, sequenceName = sql.substring(tMatcher.start(), tMatcher.end()))) {
                            if (this.LOG.isDebugEnabled()) {
                                this.LOG.debug((Object)("Sequence is already exists " + sequenceName));
                            }
                            return true;
                        }
                    } else {
                        tMatcher = this.creatTriggerPattern.matcher(sql);
                        if (tMatcher.find()) {
                            tMatcher = this.dbTriggerNamePattern.matcher(sql);
                            if (tMatcher.find()) {
                                String triggerName = sql.substring(tMatcher.start(), tMatcher.end());
                                if (!existingTables.isEmpty()) {
                                    if (this.LOG.isDebugEnabled()) {
                                        this.LOG.debug((Object)("At least one table has been created so we assume that the trigger " + triggerName + " exists also"));
                                    }
                                    return true;
                                }
                            }
                        } else if (this.LOG.isDebugEnabled()) {
                            this.LOG.debug((Object)("Command is not detected for check '" + sql + "'"));
                        }
                    }
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void init() throws DBInitializerException {
        block22: {
            SQLException e2;
            HashSet<String> existingTables;
            Statement st;
            String sql;
            block20: {
                String[] scripts = DBInitializerHelper.scripts(this.script);
                sql = null;
                st = null;
                existingTables = new HashSet<String>();
                st = this.connection.createStatement();
                this.connection.setAutoCommit(true);
                for (String scr : scripts) {
                    String s = DBInitializerHelper.cleanWhitespaces(scr.trim());
                    if (s.length() <= 0 || this.isObjectExists(this.connection, sql = s, existingTables)) continue;
                    if (this.LOG.isDebugEnabled()) {
                        this.LOG.debug((Object)("Execute script: \n[" + sql + "]"));
                    }
                    final Statement finalSt = st;
                    final String finalSql = this.updateQuery(sql);
                    SecurityHelper.doPrivilegedSQLExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                        @Override
                        public Object run() throws Exception {
                            finalSt.executeUpdate(finalSql);
                            return null;
                        }
                    });
                }
                this.postInit(this.connection);
                this.LOG.info((Object)("DB schema of DataSource: '" + this.containerName + "' initialized succesfully"));
                Object var13_16 = null;
                if (st == null) break block20;
                try {
                    st.close();
                }
                catch (SQLException e2) {
                    this.LOG.error((Object)("Can't close the Statement: " + e2));
                }
            }
            try {
                this.connection.close();
            }
            catch (SQLException e2) {
                this.LOG.error((Object)("Error of a connection closing. " + e2), (Throwable)e2);
            }
            break block22;
            {
                catch (SQLException e3) {
                    if (this.LOG.isDebugEnabled()) {
                        this.LOG.error((Object)"Problem creating database structure.", (Throwable)e3);
                    }
                    this.LOG.warn((Object)("Some tables were created and not rolled back. Please make sure to drop them manually in datasource : '" + this.containerName + "'"));
                    boolean isAlreadyCreated = false;
                    try {
                        isAlreadyCreated = this.isObjectExists(this.connection, sql, existingTables);
                    }
                    catch (SQLException ce) {
                        this.LOG.warn((Object)("Can not check does the objects from " + sql + " exists"));
                    }
                    if (!isAlreadyCreated) {
                        String msg = "Could not create db schema of DataSource: '" + this.containerName + "'. Reason: " + e3.getMessage() + "; " + ExceptionManagementHelper.getFullSQLExceptionMessage((SQLException)e3) + ". Last command: " + sql;
                        throw new DBInitializerException(msg, e3);
                    }
                    this.LOG.warn((Object)("Could not create db schema of DataSource: '" + this.containerName + "'. Reason: Objects form " + sql + " already exists"));
                    Object var13_17 = null;
                    if (st != null) {
                        try {
                            st.close();
                        }
                        catch (SQLException e2) {
                            this.LOG.error((Object)("Can't close the Statement: " + e2));
                        }
                    }
                    try {
                        this.connection.close();
                    }
                    catch (SQLException e2) {
                        this.LOG.error((Object)("Error of a connection closing. " + e2), (Throwable)e2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var13_18 = null;
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (SQLException e2) {
                        this.LOG.error((Object)("Can't close the Statement: " + e2));
                    }
                }
                try {
                    this.connection.close();
                }
                catch (SQLException e2) {
                    this.LOG.error((Object)("Error of a connection closing. " + e2), (Throwable)e2);
                }
                throw throwable;
            }
        }
    }

    protected void postInit(Connection connection) throws SQLException {
    }

    protected String updateQuery(String sql) {
        return sql;
    }
}

