/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.upgrade;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import org.exoplatform.calendar.service.Utils;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.commons.version.util.VersionComparator;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class UpgradeCalendarPlugin
extends UpgradeProductPlugin {
    private static final String SHARED_CALENDAR = "sharedCalendars";
    private static final String FEED = "eXoCalendarFeed";
    private static final Log log = ExoLogger.getLogger(UpgradeCalendarPlugin.class);
    private RepositoryService repoService_;
    private NodeHierarchyCreator nodeHierarchy_;

    public UpgradeCalendarPlugin(InitParams initParams) {
        super(initParams);
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        this.repoService_ = (RepositoryService)container.getComponentInstance(RepositoryService.class);
        this.nodeHierarchy_ = (NodeHierarchyCreator)container.getComponentInstance(NodeHierarchyCreator.class);
    }

    public void processUpgrade(String oldVersion, String newVersion) {
        try {
            Node publicCalendarHome = this.getOldRssHome();
            if (publicCalendarHome == null) {
                log.info((Object)"[UpgradeCalendarPlugin] There is nothing to migrate for Calendar.");
                return;
            }
            NodeIterator iterator = publicCalendarHome.getNodes();
            while (iterator.hasNext()) {
                Node feedNode = iterator.nextNode();
                String url = feedNode.getProperty(Utils.EXO_BASE_URL).getString();
                String username = url.substring(url.indexOf("/cs/calendar/feed/") + 18);
                username = username.substring(0, username.indexOf("/"));
                Node rssHome = this.getRssHome(username);
                Session session = feedNode.getSession();
                session.move(feedNode.getPath(), rssHome.getPath() + "/" + feedNode.getName());
                session.save();
            }
        }
        catch (Exception e) {
            log.warn((Object)"[UpgradeCalendarPlugin] Exception when migrate data from 2.1.x to 2.2.2 for Calendar.", (Throwable)e);
        }
    }

    public boolean shouldProceedToUpgrade(String newVersion, String previousVersion) {
        boolean doUpgrade = VersionComparator.isSame((String)"2.2.2-SNAPSHOT", (String)newVersion) || VersionComparator.isSame((String)"2.2.2", (String)newVersion);
        return doUpgrade;
    }

    private Node getOldRssHome() throws Exception {
        SessionProvider sessionProvider = this.createSystemProvider();
        String oldRssHomePath = this.nodeHierarchy_.getPublicApplicationNode(sessionProvider).getPath() + "/" + Utils.CALENDAR_APP + "/" + SHARED_CALENDAR + "/" + FEED;
        try {
            return (Node)this.getSession(sessionProvider).getItem(oldRssHomePath);
        }
        catch (Exception e) {
            return null;
        }
    }

    private Node getRssHome(String username) throws Exception {
        Node calendarServiceHome = this.getUserCalendarAppHomeNode(username);
        try {
            return calendarServiceHome.getNode(FEED);
        }
        catch (Exception e) {
            Node feed = calendarServiceHome.addNode(FEED, Utils.NT_UNSTRUCTURED);
            calendarServiceHome.getSession().save();
            return feed;
        }
    }

    private Node getUserCalendarAppHomeNode(String username) throws Exception {
        Node userNode = this.nodeHierarchy_.getUserApplicationNode(this.createSystemProvider(), username);
        try {
            return userNode.getNode(Utils.CALENDAR_APP);
        }
        catch (PathNotFoundException e) {
            return null;
        }
    }

    private Session getSession(SessionProvider sprovider) throws Exception {
        ManageableRepository currentRepo = this.repoService_.getCurrentRepository();
        return sprovider.getSession(currentRepo.getConfiguration().getDefaultWorkspaceName(), currentRepo);
    }

    private SessionProvider createSystemProvider() {
        SessionProviderService sessionProviderService = (SessionProviderService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(SessionProviderService.class);
        return sessionProviderService.getSystemSessionProvider(null);
    }
}

