/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.jmx;

import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import org.jboss.cache.jmx.CacheNotificationBroadcaster;
import org.jboss.cache.notifications.annotation.CacheListener;
import org.jboss.cache.notifications.annotation.CacheStarted;
import org.jboss.cache.notifications.annotation.CacheStopped;
import org.jboss.cache.notifications.annotation.NodeActivated;
import org.jboss.cache.notifications.annotation.NodeCreated;
import org.jboss.cache.notifications.annotation.NodeEvicted;
import org.jboss.cache.notifications.annotation.NodeLoaded;
import org.jboss.cache.notifications.annotation.NodeModified;
import org.jboss.cache.notifications.annotation.NodeMoved;
import org.jboss.cache.notifications.annotation.NodePassivated;
import org.jboss.cache.notifications.annotation.NodeRemoved;
import org.jboss.cache.notifications.annotation.NodeVisited;
import org.jboss.cache.notifications.annotation.ViewChanged;
import org.jboss.cache.notifications.event.Event;
import org.jboss.cache.notifications.event.NodeEvent;
import org.jboss.cache.notifications.event.NodeMovedEvent;
import org.jboss.cache.notifications.event.ViewChangedEvent;

@CacheListener
public class CacheNotificationListener {
    private static final String MSG_CACHE_STARTED = "Cache has been started.";
    private static final String MSG_CACHE_STOPPED = "Cache has been stopped.";
    private static final String MSG_NODE_CREATED = "Node has been created.";
    private static final String MSG_NODE_MODIFIED = "Node has been modifed.";
    private static final String MSG_NODE_REMOVED = "Node has been removed.";
    private static final String MSG_NODE_MOVED = "Node has been moved.";
    private static final String MSG_NODE_VISITED = "Node has been visited.";
    private static final String MSG_NODE_EVICTED = "Node has been evicted.";
    private static final String MSG_NODE_LOADED = "Node has been loaded.";
    private static final String MSG_NODE_ACTIVATED = "Node has been activated.";
    private static final String MSG_NODE_PASSIVATED = "Node has been passivated.";
    private static final String MSG_VIEW_CHANGED = "Cache cluster view has changed.";
    private static final String NOTIFICATION_NAME = Notification.class.getName();
    private static final String NOTIFICATION_DESCR = "JBossCache event notifications";
    private final CacheNotificationBroadcaster broadcaster;
    private String serviceName;

    CacheNotificationListener(CacheNotificationBroadcaster support) {
        this.broadcaster = support;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public static MBeanNotificationInfo[] getNotificationInfo() {
        String[] types = new String[]{"org.jboss.cache.CacheStarted", "org.jboss.cache.CacheStopped", "org.jboss.cache.NodeCreated", "org.jboss.cache.NodeEvicted", "org.jboss.cache.NodeLoaded", "org.jboss.cache.NodeModified", "org.jboss.cache.NodeActivated", "org.jboss.cache.NodePassivated", "org.jboss.cache.NodeRemoved", "org.jboss.cache.NodeVisited", "org.jboss.cache.ViewChanged"};
        MBeanNotificationInfo info = new MBeanNotificationInfo(types, NOTIFICATION_NAME, NOTIFICATION_DESCR);
        return new MBeanNotificationInfo[]{info};
    }

    @CacheStarted
    @CacheStopped
    @NodeCreated
    @NodeEvicted
    @NodeLoaded
    @NodeModified
    @NodeRemoved
    @NodeMoved
    @NodeVisited
    @NodeActivated
    @NodePassivated
    @ViewChanged
    public void broadcast(Event e) {
        Notification n = null;
        switch (e.getType()) {
            case CACHE_STARTED: {
                n = new Notification("org.jboss.cache.CacheStarted", (Object)this.broadcaster, this.seq(), MSG_CACHE_STARTED);
                n.setUserData(this.serviceName);
                break;
            }
            case CACHE_STOPPED: {
                n = new Notification("org.jboss.cache.CacheStopped", (Object)this.broadcaster, this.seq(), MSG_CACHE_STOPPED);
                n.setUserData(this.serviceName);
                break;
            }
            case NODE_CREATED: {
                n = new Notification("org.jboss.cache.NodeCreated", (Object)this.broadcaster, this.seq(), MSG_NODE_CREATED);
                NodeEvent ne = (NodeEvent)e;
                n.setUserData(new Object[]{ne.getFqn().toString(), e.isPre(), ne.isOriginLocal()});
                break;
            }
            case NODE_EVICTED: {
                n = new Notification("org.jboss.cache.NodeEvicted", (Object)this.broadcaster, this.seq(), MSG_NODE_EVICTED);
                NodeEvent ne = (NodeEvent)e;
                n.setUserData(new Object[]{ne.getFqn().toString(), e.isPre(), ne.isOriginLocal()});
                break;
            }
            case NODE_LOADED: {
                n = new Notification("org.jboss.cache.NodeLoaded", (Object)this.broadcaster, this.seq(), MSG_NODE_LOADED);
                NodeEvent ne = (NodeEvent)e;
                n.setUserData(new Object[]{ne.getFqn().toString(), e.isPre()});
                break;
            }
            case NODE_MODIFIED: {
                n = new Notification("org.jboss.cache.NodeModified", (Object)this.broadcaster, this.seq(), MSG_NODE_MODIFIED);
                NodeEvent ne = (NodeEvent)e;
                n.setUserData(new Object[]{ne.getFqn().toString(), e.isPre(), ne.isOriginLocal()});
                break;
            }
            case NODE_REMOVED: {
                n = new Notification("org.jboss.cache.NodeRemoved", (Object)this.broadcaster, this.seq(), MSG_NODE_REMOVED);
                NodeEvent ne = (NodeEvent)e;
                n.setUserData(new Object[]{ne.getFqn().toString(), e.isPre(), ne.isOriginLocal()});
                break;
            }
            case NODE_MOVED: {
                n = new Notification("org.jboss.cache.NodeMoved", (Object)this.broadcaster, this.seq(), MSG_NODE_MOVED);
                NodeMovedEvent nme = (NodeMovedEvent)e;
                n.setUserData(new Object[]{nme.getFqn().toString(), nme.getTargetFqn().toString(), e.isPre()});
                break;
            }
            case NODE_VISITED: {
                n = new Notification("org.jboss.cache.NodeVisited", (Object)this.broadcaster, this.seq(), MSG_NODE_VISITED);
                NodeEvent ne = (NodeEvent)e;
                n.setUserData(new Object[]{ne.getFqn().toString(), e.isPre()});
                break;
            }
            case NODE_ACTIVATED: {
                n = new Notification("org.jboss.cache.NodeActivated", (Object)this.broadcaster, this.seq(), MSG_NODE_ACTIVATED);
                NodeEvent ne = (NodeEvent)e;
                n.setUserData(new Object[]{ne.getFqn().toString(), e.isPre()});
                break;
            }
            case NODE_PASSIVATED: {
                n = new Notification("org.jboss.cache.NodePassivated", (Object)this.broadcaster, this.seq(), MSG_NODE_PASSIVATED);
                NodeEvent ne = (NodeEvent)e;
                n.setUserData(new Object[]{ne.getFqn().toString(), e.isPre()});
                break;
            }
            case VIEW_CHANGED: {
                n = new Notification("org.jboss.cache.ViewChanged", (Object)this.broadcaster, this.seq(), MSG_VIEW_CHANGED);
                n.setUserData(((ViewChangedEvent)e).getNewView().toString());
            }
        }
        this.broadcaster.sendNotification(n);
    }

    private long seq() {
        return this.broadcaster.getNextNotificationSequenceNumber();
    }
}

