/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.portlet.aspects;

import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.pc.api.invocation.PortletInvocation;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.gatein.pc.api.spi.ServerContext;
import org.gatein.pc.portlet.PortletInvokerInterceptor;
import org.gatein.pc.portlet.container.PortletApplication;
import org.gatein.pc.portlet.container.PortletContainer;
import org.gatein.wci.RequestDispatchCallback;
import org.gatein.wci.ServletContainer;
import org.gatein.wci.ServletContainerFactory;

public class ContextDispatcherInterceptor
extends PortletInvokerInterceptor {
    public static final String REQ_ATT_COMPONENT_INVOCATION = "org.jboss.portal.attribute.component_invocation";
    private ServletContainerFactory servletContainerFactory;
    private final RequestDispatchCallback callback = new RequestDispatchCallback(){

        public Object doCallback(ServletContext dispatchedServletContext, HttpServletRequest req, HttpServletResponse resp, Object handback) throws ServletException, IOException {
            PortletInvocation invocation = (PortletInvocation)handback;
            try {
                invocation.setDispatchedRequest(req);
                invocation.setDispatchedResponse(resp);
                req.setAttribute(ContextDispatcherInterceptor.REQ_ATT_COMPONENT_INVOCATION, (Object)invocation);
                PortletInvocationResponse portletInvocationResponse = ContextDispatcherInterceptor.super.invoke(invocation);
                return portletInvocationResponse;
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
            finally {
                req.setAttribute(ContextDispatcherInterceptor.REQ_ATT_COMPONENT_INVOCATION, null);
                invocation.setDispatchedRequest(null);
                invocation.setDispatchedResponse(null);
            }
        }
    };

    public ServletContainerFactory getServletContainerFactory() {
        return this.servletContainerFactory;
    }

    public void setServletContainerFactory(ServletContainerFactory servletContainerFactory) {
        this.servletContainerFactory = servletContainerFactory;
    }

    @Override
    public PortletInvocationResponse invoke(PortletInvocation invocation) throws IllegalArgumentException, PortletInvokerException {
        PortletContainer container = (PortletContainer)invocation.getAttribute("PORTLET_CONTAINER");
        PortletApplication portletApplication = container.getPortletApplication();
        ServerContext reqCtx = invocation.getServerContext();
        ServletContext targetCtx = portletApplication.getContext().getServletContext();
        ServletContainer servletContainer = this.servletContainerFactory.getServletContainer();
        try {
            return (PortletInvocationResponse)reqCtx.dispatch(servletContainer, targetCtx, this.callback, (Object)invocation);
        }
        catch (Exception e) {
            ServletException se;
            if (e instanceof PortletInvokerException) {
                throw (PortletInvokerException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof ServletException && (se = (ServletException)e).getRootCause() != null && se.getRootCause() instanceof Exception) {
                e = (Exception)se.getRootCause();
            }
            throw new PortletInvokerException((Throwable)e);
        }
    }
}

