/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.service.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.fortuna.ical4j.data.CalendarBuilder;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.NumberList;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.Recur;
import net.fortuna.ical4j.model.WeekDay;
import net.fortuna.ical4j.model.WeekDayList;
import net.fortuna.ical4j.model.component.VAlarm;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.component.VFreeBusy;
import net.fortuna.ical4j.model.component.VToDo;
import net.fortuna.ical4j.model.property.Attach;
import net.fortuna.ical4j.model.property.Attendee;
import net.fortuna.ical4j.model.property.Clazz;
import net.fortuna.ical4j.model.property.ExDate;
import net.fortuna.ical4j.model.property.RRule;
import net.fortuna.ical4j.model.property.RecurrenceId;
import net.fortuna.ical4j.util.CompatibilityHints;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.OptionsMethod;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.jackrabbit.webdav.MultiStatus;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.client.methods.ReportMethod;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.jackrabbit.webdav.version.report.ReportInfo;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.exoplatform.calendar.service.Attachment;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.EventCategory;
import org.exoplatform.calendar.service.EventQuery;
import org.exoplatform.calendar.service.RemoteCalendar;
import org.exoplatform.calendar.service.RemoteCalendarService;
import org.exoplatform.calendar.service.Utils;
import org.exoplatform.calendar.service.impl.JCRDataStorage;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteCalendarServiceImpl
implements RemoteCalendarService {
    private static final Namespace CALDAV_NAMESPACE = Namespace.getNamespace((String)"C", (String)"urn:ietf:params:xml:ns:caldav");
    private static final String CALDAV_XML_CALENDAR_MULTIGET = "calendar-multiget";
    private static final String CALDAV_XML_CALENDAR_QUERY = "calendar-query";
    private static final String CALDAV_XML_CALENDAR_DATA = "calendar-data";
    private static final String CALDAV_XML_FILTER = "filter";
    private static final String CALDAV_XML_COMP_FILTER = "comp-filter";
    private static final String CALDAV_XML_TIME_RANGE = "time-range";
    private static final String CALDAV_XML_START = "start";
    private static final String CALDAV_XML_END = "end";
    private static final String CALDAV_XML_COMP_FILTER_NAME = "name";
    public static final String ICAL_PROPS_CALENDAR_NAME = "X-WR-CALNAME";
    public static final String ICAL_PROPS_CALENDAR_DESCRIPTION = "X-WR-CALDESC";
    private static final Log logger = ExoLogger.getLogger((String)"cs.calendar.service.remote");
    private JCRDataStorage storage_;

    public RemoteCalendarServiceImpl(JCRDataStorage storage) {
        this.storage_ = storage;
    }

    @Override
    public InputStream connectToRemoteServer(RemoteCalendar remoteCalendar) throws Exception {
        HttpClient client = this.getRemoteClient(remoteCalendar);
        GetMethod get = new GetMethod(remoteCalendar.getRemoteUrl());
        try {
            client.executeMethod((HttpMethod)get);
            InputStream icalInputStream = get.getResponseBodyAsStream();
            return icalInputStream;
        }
        catch (IOException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Connect to %s failed!", remoteCalendar.getRemoteUrl()), (Throwable)e);
            }
            throw e;
        }
    }

    @Override
    public boolean isValidRemoteUrl(String url, String type, String remoteUser, String remotePassword) throws IOException, UnsupportedOperationException {
        try {
            HttpClient client = new HttpClient();
            HostConfiguration hostConfig = new HostConfiguration();
            String host = new URL(url).getHost();
            if (StringUtils.isEmpty((String)host)) {
                host = url;
            }
            hostConfig.setHost(host);
            client.setHostConfiguration(hostConfig);
            UsernamePasswordCredentials credentials = null;
            client.setHostConfiguration(hostConfig);
            if (!StringUtils.isEmpty((String)remoteUser)) {
                credentials = new UsernamePasswordCredentials(remoteUser, remotePassword);
                client.getState().setCredentials(new AuthScope(host, -1, AuthScope.ANY_REALM), (Credentials)credentials);
            }
            if (CalendarService.ICALENDAR.equals(type)) {
                GetMethod get = new GetMethod(url);
                client.executeMethod((HttpMethod)get);
                int statusCode = get.getStatusCode();
                get.releaseConnection();
                return statusCode == 200;
            }
            if (CalendarService.CALDAV.equals(type)) {
                OptionsMethod options = new OptionsMethod(url);
                client.executeMethod((HttpMethod)options);
                Header header = options.getResponseHeader("DAV");
                options.releaseConnection();
                if (header == null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Cannot connect to remoter server or not support WebDav access");
                    }
                    return false;
                }
                Boolean support = header.toString().contains("calendar-access");
                options.releaseConnection();
                if (!support.booleanValue()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Remote server does not support CalDav access");
                    }
                    throw new UnsupportedOperationException("Remote server does not support CalDav access");
                }
                return support;
            }
            return false;
        }
        catch (MalformedURLException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)e.getMessage(), (Throwable)e);
            }
            throw new IOException("URL is invalid. Maybe no legal protocol or URl could not be parsed");
        }
        catch (IOException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)e.getMessage(), (Throwable)e);
            }
            throw new IOException("Error occurs when connecting to remote server");
        }
    }

    @Override
    public Calendar importRemoteCalendar(RemoteCalendar remoteCalendar) throws Exception {
        Calendar eXoCalendar = this.storage_.createRemoteCalendar(remoteCalendar);
        if (CalendarService.ICALENDAR.equals(remoteCalendar.getType())) {
            remoteCalendar.setCalendarId(eXoCalendar.getId());
            remoteCalendar.setLastUpdated(Utils.getGreenwichMeanTime());
            InputStream icalInputStream = this.connectToRemoteServer(remoteCalendar);
            CalendarService calService = (CalendarService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(CalendarService.class);
            calService.getCalendarImportExports(CalendarService.ICALENDAR).importCalendar(remoteCalendar.getUsername(), icalInputStream, remoteCalendar.getCalendarId(), null, remoteCalendar.getBeforeTime(), remoteCalendar.getAfterTime(), false);
            return eXoCalendar;
        }
        if (CalendarService.CALDAV.equals(remoteCalendar.getType())) {
            MultiStatus multiStatus = this.connectToCalDavServer(remoteCalendar);
            for (int i = 0; i < multiStatus.getResponses().length; ++i) {
                MultiStatusResponse multiRes = multiStatus.getResponses()[i];
                String href = multiRes.getHref();
                DavPropertySet propSet = multiRes.getProperties(200);
                net.fortuna.ical4j.model.Calendar iCalEvent = this.getCalDavResource(remoteCalendar, href);
                DavProperty etag = propSet.get(DavPropertyName.GETETAG.getName(), DavConstants.NAMESPACE);
                try {
                    this.importCaldavEvent(remoteCalendar.getUsername(), eXoCalendar.getId(), null, iCalEvent, href, etag.getValue().toString(), true);
                    this.storage_.setRemoteCalendarLastUpdated(remoteCalendar.getUsername(), eXoCalendar.getId(), Utils.getGreenwichMeanTime());
                    continue;
                }
                catch (Exception e) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("Exception occurs when import calendar component " + href + ". Skip this component."), (Throwable)e);
                }
            }
            return eXoCalendar;
        }
        return null;
    }

    @Override
    public Calendar refreshRemoteCalendar(String username, String remoteCalendarId) throws Exception {
        if (!this.storage_.isRemoteCalendar(username, remoteCalendarId)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"This calendar is not remote calendar.");
            }
            return null;
        }
        RemoteCalendar remoteCalendar = this.storage_.getRemoteCalendar(username, remoteCalendarId);
        if (CalendarService.ICALENDAR.equals(remoteCalendar.getType())) {
            ArrayList<String> calendarIds = new ArrayList<String>();
            calendarIds.add(remoteCalendarId);
            EventQuery eventQuery = new EventQuery();
            eventQuery.setCalendarId(new String[]{remoteCalendarId});
            eventQuery.setFromDate(remoteCalendar.getBeforeTime());
            eventQuery.setToDate(remoteCalendar.getAfterTime());
            List<CalendarEvent> events = this.storage_.getUserEvents(username, eventQuery);
            if (events != null && events.size() > 0) {
                for (CalendarEvent event : events) {
                    if (Utils.isExceptionOccurrence(event)) continue;
                    if (Utils.isRepeatEvent(event)) {
                        this.storage_.removeRecurrenceSeries(username, event);
                        continue;
                    }
                    this.storage_.removeUserEvent(username, remoteCalendarId, event.getId());
                }
            }
            Calendar eXoCalendar = this.storage_.getUserCalendar(username, remoteCalendarId);
            InputStream icalInputStream = this.connectToRemoteServer(remoteCalendar);
            CalendarService calService = (CalendarService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(CalendarService.class);
            calService.getCalendarImportExports(CalendarService.ICALENDAR).importCalendar(username, icalInputStream, remoteCalendarId, null, remoteCalendar.getBeforeTime(), remoteCalendar.getAfterTime(), false);
            this.storage_.setRemoteCalendarLastUpdated(username, eXoCalendar.getId(), Utils.getGreenwichMeanTime());
            return eXoCalendar;
        }
        if (CalendarService.CALDAV.equals(remoteCalendar.getType())) {
            Calendar eXoCalendar = this.synchronizeWithCalDavServer(remoteCalendar);
            this.storage_.setRemoteCalendarLastUpdated(username, eXoCalendar.getId(), Utils.getGreenwichMeanTime());
            return eXoCalendar;
        }
        return null;
    }

    public MultiStatus connectToCalDavServer(RemoteCalendar remoteCalendar) throws Exception {
        HttpClient client = this.getRemoteClient(remoteCalendar);
        return this.doCalendarQuery(client, remoteCalendar.getRemoteUrl(), remoteCalendar.getBeforeTime(), remoteCalendar.getAfterTime());
    }

    public net.fortuna.ical4j.model.Calendar getCalDavResource(RemoteCalendar remoteCalendar, String href) throws Exception {
        HttpClient client = this.getRemoteClient(remoteCalendar);
        CalendarBuilder builder = new CalendarBuilder();
        CompatibilityHints.setHintEnabled((String)"ical4j.unfolding.relaxed", (boolean)true);
        try {
            MultiStatus multiStatus = this.doCalendarMultiGet(client, remoteCalendar.getRemoteUrl(), new String[]{href});
            if (multiStatus == null) {
                return null;
            }
            MultiStatusResponse multiRes = multiStatus.getResponses()[0];
            DavPropertySet propSet = multiRes.getProperties(200);
            DavProperty calendarData = propSet.get(CALDAV_XML_CALENDAR_DATA, CALDAV_NAMESPACE);
            return builder.build((Reader)new StringReader(calendarData.getValue().toString()));
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Can't get resource from CalDav server", (Throwable)e);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getEntityTags(HttpClient client, String uri, java.util.Calendar from, java.util.Calendar to) throws Exception {
        HashMap<String, String> etags = new HashMap<String, String>();
        ReportMethod report = this.makeCalDavQueryReport(uri, from, to);
        if (report == null) {
            return null;
        }
        try {
            client.executeMethod((HttpMethod)report);
            MultiStatus multiStatus = report.getResponseBodyAsMultiStatus();
            for (int i = 0; i < multiStatus.getResponses().length; ++i) {
                MultiStatusResponse multiRes = multiStatus.getResponses()[i];
                String href = multiRes.getHref();
                DavPropertySet propSet = multiRes.getProperties(200);
                DavProperty etag = propSet.get(DavPropertyName.GETETAG.getName(), DavConstants.NAMESPACE);
                etags.put(href, etag.getValue().toString());
            }
            HashMap<String, String> hashMap = etags;
            return hashMap;
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Exception occurs when querying entity tags from CalDav server", (Throwable)e);
            }
            Map<String, String> map = null;
            return map;
        }
        finally {
            if (report != null) {
                report.releaseConnection();
            }
        }
    }

    public Calendar synchronizeWithCalDavServer(RemoteCalendar remoteCalendar) throws Exception {
        MultiStatus multiStatus;
        DavProperty etag;
        DavProperty calendarData;
        DavPropertySet propSet;
        MultiStatusResponse multiRes;
        String href;
        String remoteCalendarId;
        String username = remoteCalendar.getUsername();
        if (!this.storage_.isRemoteCalendar(username, remoteCalendarId = remoteCalendar.getCalendarId())) {
            return null;
        }
        if (!CalendarService.CALDAV.equals(remoteCalendar.getType())) {
            throw new UnsupportedOperationException("Not support");
        }
        CalendarService calService = (CalendarService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(CalendarService.class);
        if (calService == null) {
            calService = (CalendarService)ExoContainerContext.getContainerByName((String)PortalContainer.getCurrentPortalContainerName()).getComponentInstanceOfType(CalendarService.class);
        }
        CalendarBuilder calendarBuilder = new CalendarBuilder();
        CompatibilityHints.setHintEnabled((String)"ical4j.unfolding.relaxed", (boolean)true);
        HttpClient client = this.getRemoteClient(remoteCalendar);
        java.util.Calendar from = remoteCalendar.getBeforeTime();
        java.util.Calendar to = remoteCalendar.getAfterTime();
        Map<String, String> entityTags = this.getEntityTags(client, remoteCalendar.getRemoteUrl(), from, to);
        EventQuery eventQuery = new EventQuery();
        eventQuery.setCalendarId(new String[]{remoteCalendarId});
        eventQuery.setFromDate(from);
        eventQuery.setToDate(to);
        List<CalendarEvent> eXoEvents = calService.getUserEvents(username, eventQuery);
        Iterator<CalendarEvent> it = eXoEvents.iterator();
        HashMap<String, String> events = new HashMap<String, String>();
        while (it.hasNext()) {
            CalendarEvent event = it.next();
            if (Utils.isExceptionOccurrence(event)) continue;
            events.put(calService.getCalDavResourceHref(username, remoteCalendarId, event.getId()), event.getId());
        }
        ArrayList<String> created = new ArrayList<String>();
        HashMap<String, String> updated = new HashMap<String, String>();
        ArrayList<String> deleted = new ArrayList<String>();
        for (Map.Entry<String, String> entry : entityTags.entrySet()) {
            href = entry.getKey();
            String etag2 = entry.getValue();
            if (!events.containsKey(href)) {
                created.add(href);
                continue;
            }
            String eventId = (String)events.get(href);
            String calendarId = calService.getEvent(username, eventId).getCalendarId();
            String localEtag = calService.getCalDavResourceEtag(username, calendarId, eventId);
            if (localEtag.equals(etag2)) continue;
            updated.put(href, eventId);
        }
        for (Map.Entry<String, String> entry : events.entrySet()) {
            href = entry.getKey();
            if (entityTags.containsKey(href)) continue;
            deleted.add(entry.getValue());
        }
        MultiStatus multiStatus2 = this.doCalendarMultiGet(client, remoteCalendar.getRemoteUrl(), created.toArray(new String[0]));
        if (multiStatus2 != null) {
            for (int i = 0; i < multiStatus2.getResponses().length; ++i) {
                multiRes = multiStatus2.getResponses()[i];
                href = multiRes.getHref();
                propSet = multiRes.getProperties(200);
                calendarData = propSet.get(CALDAV_XML_CALENDAR_DATA, CALDAV_NAMESPACE);
                etag = propSet.get(DavPropertyName.GETETAG.getName(), DavConstants.NAMESPACE);
                try {
                    net.fortuna.ical4j.model.Calendar iCalEvent = calendarBuilder.build((Reader)new StringReader(calendarData.getValue().toString()));
                    this.importCaldavEvent(username, remoteCalendarId, null, iCalEvent, href, etag.getValue().toString(), true);
                    continue;
                }
                catch (Exception e) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("Exception occurs when import calendar component " + href + ". Skip this component."));
                }
            }
        }
        if ((multiStatus = this.doCalendarMultiGet(client, remoteCalendar.getRemoteUrl(), updated.keySet().toArray(new String[0]))) != null) {
            for (int i = 0; i < multiStatus.getResponses().length; ++i) {
                multiRes = multiStatus.getResponses()[i];
                href = multiRes.getHref();
                propSet = multiRes.getProperties(200);
                calendarData = propSet.get(CALDAV_XML_CALENDAR_DATA, CALDAV_NAMESPACE);
                etag = propSet.get(DavPropertyName.GETETAG.getName(), DavConstants.NAMESPACE);
                String eventId = (String)updated.get(href);
                try {
                    net.fortuna.ical4j.model.Calendar iCalEvent = calendarBuilder.build((Reader)new StringReader(calendarData.getValue().toString()));
                    this.importCaldavEvent(username, remoteCalendarId, eventId, iCalEvent, null, etag.getValue().toString(), false);
                    continue;
                }
                catch (Exception e) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("Exception occurs when import calendar component " + href + ". Skip this component."));
                }
            }
        }
        for (String eventId : deleted) {
            CalendarEvent event = this.storage_.getUserEvent(username, remoteCalendarId, eventId);
            event.setCalType(String.valueOf(0));
            if (Utils.isRepeatEvent(event)) {
                this.storage_.removeRecurrenceSeries(username, event);
                continue;
            }
            calService.removeUserEvent(username, remoteCalendarId, eventId);
        }
        return calService.getUserCalendar(remoteCalendar.getUsername(), remoteCalendar.getCalendarId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiStatus doCalendarMultiGet(HttpClient client, String uri, String[] hrefs) throws Exception {
        if (hrefs.length == 0) {
            return null;
        }
        ReportMethod report = null;
        try {
            MultiStatus multiStatus;
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element calendarMultiGet = DomUtil.createElement((Document)doc, (String)CALDAV_XML_CALENDAR_MULTIGET, (Namespace)CALDAV_NAMESPACE);
            calendarMultiGet.setAttributeNS(Namespace.XMLNS_NAMESPACE.getURI(), Namespace.XMLNS_NAMESPACE.getPrefix() + ":" + DavConstants.NAMESPACE.getPrefix(), DavConstants.NAMESPACE.getURI());
            ReportInfo reportInfo = new ReportInfo(calendarMultiGet, 0);
            DavPropertyNameSet propNameSet = reportInfo.getPropertyNameSet();
            propNameSet.add(DavPropertyName.GETETAG);
            DavPropertyName calendarData = DavPropertyName.create((String)CALDAV_XML_CALENDAR_DATA, (Namespace)CALDAV_NAMESPACE);
            propNameSet.add(calendarData);
            for (int i = 0; i < hrefs.length; ++i) {
                Element href = DomUtil.createElement((Document)doc, (String)"href", (Namespace)DavConstants.NAMESPACE, (String)hrefs[i]);
                reportInfo.setContentElement(href);
            }
            report = new ReportMethod(uri, reportInfo);
            client.executeMethod((HttpMethod)report);
            MultiStatus multiStatus2 = multiStatus = report.getResponseBodyAsMultiStatus();
            return multiStatus2;
        }
        finally {
            if (report != null) {
                report.releaseConnection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiStatus doCalendarQuery(HttpClient client, String uri, java.util.Calendar from, java.util.Calendar to) throws Exception {
        ReportMethod report = this.makeCalDavQueryReport(uri, from, to);
        if (report == null) {
            return null;
        }
        try {
            MultiStatus multiStatus;
            client.executeMethod((HttpMethod)report);
            MultiStatus multiStatus2 = multiStatus = report.getResponseBodyAsMultiStatus();
            return multiStatus2;
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Exception occurs when querying calendar events from CalDav server", (Throwable)e);
            }
            MultiStatus multiStatus = null;
            return multiStatus;
        }
        finally {
            if (report != null) {
                report.releaseConnection();
            }
        }
    }

    public void importCaldavEvent(String username, String calendarId, String eventId, net.fortuna.ical4j.model.Calendar iCalendar, String href, String etag, Boolean isNew) throws Exception {
        VEvent event;
        CalendarEvent exoEvent;
        CalendarService calService = (CalendarService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(CalendarService.class);
        if (calService == null) {
            calService = (CalendarService)PortalContainer.getInstance().getComponentInstanceOfType(CalendarService.class);
        }
        HashMap<String, VFreeBusy> vFreeBusyData = new HashMap<String, VFreeBusy>();
        HashMap<String, VAlarm> vAlarmData = new HashMap<String, VAlarm>();
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
        CalendarEvent original = null;
        ArrayList<CalendarEvent> exceptions = new ArrayList<CalendarEvent>();
        ComponentList componentList = iCalendar.getComponents();
        if (!isNew.booleanValue()) {
            List<CalendarEvent> oldExceptions;
            exoEvent = this.storage_.getEvent(username, eventId);
            exoEvent.setCalType(String.valueOf(0));
            if (Utils.isRepeatEvent(exoEvent) && (oldExceptions = this.storage_.getExceptionEvents(username, exoEvent)) != null && oldExceptions.size() > 0) {
                for (CalendarEvent exception : oldExceptions) {
                    this.storage_.removeUserEvent(username, calendarId, exception.getId());
                }
            }
        }
        for (Object obj : componentList) {
            if (obj instanceof VEvent && !(event = (VEvent)obj).getAlarms().isEmpty()) {
                for (Object o : event.getAlarms()) {
                    if (!(o instanceof VAlarm)) continue;
                    VAlarm va = (VAlarm)o;
                    vAlarmData.put(event.getUid().getValue() + ":" + va.getProperty("ACTION").getName(), va);
                }
            }
            if (!(obj instanceof VFreeBusy)) continue;
            vFreeBusyData.put(((VFreeBusy)obj).getUid().getValue(), (VFreeBusy)obj);
        }
        for (Object obj : componentList) {
            if (obj instanceof VEvent) {
                String uuid;
                event = (VEvent)obj;
                exoEvent = isNew != false ? new CalendarEvent() : this.storage_.getUserEvent(username, calendarId, eventId);
                exoEvent = RemoteCalendarServiceImpl.generateEvent(event, exoEvent, username, calendarId);
                String sValue = Utils.EMPTY_STR;
                String eValue = Utils.EMPTY_STR;
                if (event.getStartDate() != null) {
                    sValue = event.getStartDate().getValue();
                    exoEvent.setFromDateTime((java.util.Date)event.getStartDate().getDate());
                }
                if (event.getEndDate() != null) {
                    eValue = event.getEndDate().getValue();
                    exoEvent.setToDateTime((java.util.Date)event.getEndDate().getDate());
                }
                exoEvent = RemoteCalendarServiceImpl.setEventAttachment(event, exoEvent, eValue, sValue);
                if (event.getProperty("RECURRENCE-ID") != null) {
                    RecurrenceId recurId = (RecurrenceId)event.getProperty("RECURRENCE-ID");
                    exoEvent.setRecurrenceId(format.format(new java.util.Date(recurId.getDate().getTime())));
                    if (original != null) {
                        Node originalNode = this.storage_.getUserCalendarHome(username).getNode(calendarId).getNode(original.getId());
                        uuid = originalNode.getUUID();
                        exoEvent.setId(originalNode.getName());
                        exoEvent.setOriginalReference(uuid);
                        ArrayList<Object> excludeId = original.getExcludeId() != null && original.getExcludeId().length > 0 ? new ArrayList<String>(Arrays.asList(original.getExcludeId())) : new ArrayList<String>();
                        excludeId.add(exoEvent.getRecurrenceId());
                        original.setExcludeId(excludeId.toArray(new String[0]));
                        this.storage_.saveUserEvent(username, calendarId, original, false);
                    } else {
                        exceptions.add(exoEvent);
                    }
                    this.storage_.saveOccurrenceEvent(username, calendarId, exoEvent, true);
                } else if (event.getProperty("RRULE") != null && event.getProperty("RECURRENCE-ID") == null) {
                    original = exoEvent = RemoteCalendarServiceImpl.calculateEvent(event, exoEvent);
                    ArrayList<String> excludeIds = new ArrayList<String>();
                    PropertyList exdates = event.getProperties("EXDATE");
                    if (exdates != null && exdates.size() > 0) {
                        for (Object exdate : exdates) {
                            for (Object date : ((ExDate)exdate).getDates()) {
                                excludeIds.add(format.format(new java.util.Date(((DateTime)date).getTime())));
                            }
                        }
                    }
                    if (exceptions != null && exceptions.size() > 0) {
                        for (CalendarEvent exception : exceptions) {
                            excludeIds.add(exception.getRecurrenceId());
                        }
                    }
                    exoEvent.setExcludeId(excludeIds.toArray(new String[0]));
                    this.storage_.saveUserEvent(username, calendarId, exoEvent, isNew);
                    uuid = this.storage_.getUserCalendarHome(username).getNode(calendarId).getNode(exoEvent.getId()).getUUID();
                    if (exceptions != null && exceptions.size() > 0) {
                        for (CalendarEvent exception : exceptions) {
                            exception.setOriginalReference(uuid);
                            this.storage_.saveOccurrenceEvent(username, calendarId, exception, false);
                        }
                    }
                } else {
                    this.storage_.saveUserEvent(username, calendarId, exoEvent, isNew);
                }
                this.storage_.setRemoteEvent(username, calendarId, exoEvent.getId(), href, etag);
                continue;
            }
            if (!(obj instanceof VToDo)) continue;
            event = (VToDo)obj;
            exoEvent = new CalendarEvent();
            if (event.getProperty(Utils.X_STATUS) != null) {
                exoEvent.setEventState(event.getProperty(Utils.X_STATUS).getValue());
            }
            exoEvent = RemoteCalendarServiceImpl.setTaskAttachment((VToDo)event, exoEvent, username, calendarId, vFreeBusyData);
            this.storage_.saveUserEvent(username, calendarId, exoEvent, isNew);
            this.storage_.setRemoteEvent(username, calendarId, exoEvent.getId(), href, etag);
        }
    }

    public static CalendarEvent generateEvent(VEvent event, CalendarEvent exoEvent, String username, String calendarId) throws Exception {
        CalendarService calService = (CalendarService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(CalendarService.class);
        if (event.getProperty("CATEGORIES") != null) {
            EventCategory evCate;
            block7: {
                evCate = new EventCategory();
                evCate.setName(event.getProperty("CATEGORIES").getValue().trim());
                try {
                    calService.saveEventCategory(username, evCate, true);
                }
                catch (ItemExistsException e) {
                    evCate = calService.getEventCategoryByName(username, evCate.getName());
                }
                catch (Exception e) {
                    if (!logger.isDebugEnabled()) break block7;
                    logger.debug((Object)("Exception occurs when saving new event category '" + evCate.getName() + "' for iCalendar component: " + event.getUid()), (Throwable)e);
                }
            }
            exoEvent.setEventCategoryId(evCate.getId());
            exoEvent.setEventCategoryName(evCate.getName());
        }
        exoEvent.setCalType(String.valueOf(0));
        exoEvent.setCalendarId(calendarId);
        if (event.getSummary() != null) {
            exoEvent.setSummary(event.getSummary().getValue());
        }
        if (event.getDescription() != null) {
            exoEvent.setDescription(event.getDescription().getValue());
        }
        if (event.getStatus() != null) {
            exoEvent.setStatus(event.getStatus().getValue());
        }
        exoEvent.setEventType(CalendarEvent.TYPE_EVENT);
        return exoEvent;
    }

    public static CalendarEvent setEventAttachment(VEvent event, CalendarEvent exoEvent, String eValue, String sValue) throws Exception {
        block11: {
            PropertyList attendees;
            if (sValue.length() == 8 && eValue.length() == 8) {
                exoEvent.setToDateTime(new java.util.Date(event.getEndDate().getDate().getTime() - 1L));
            }
            if (sValue.length() > 8 && eValue.length() > 8 && "0000".equals(sValue.substring(9, 13)) && "0000".equals(eValue.substring(9, 13))) {
                exoEvent.setToDateTime(new java.util.Date(event.getEndDate().getDate().getTime() - 1L));
            }
            if (event.getLocation() != null) {
                exoEvent.setLocation(event.getLocation().getValue());
            }
            if (event.getPriority() != null) {
                exoEvent.setPriority(CalendarEvent.PRIORITY[Integer.parseInt(event.getPriority().getValue())]);
            }
            if (event.getProperty(Utils.X_STATUS) != null) {
                exoEvent.setEventState(event.getProperty(Utils.X_STATUS).getValue());
            }
            if (event.getClassification() != null) {
                exoEvent.setPrivate(Clazz.PRIVATE.getValue().equals(event.getClassification().getValue()));
            }
            if (!(attendees = event.getProperties("ATTENDEE")).isEmpty()) {
                String[] invitation = new String[attendees.size()];
                for (int i = 0; i < attendees.size(); ++i) {
                    invitation[i] = ((Attendee)attendees.get(i)).getValue();
                }
                exoEvent.setInvitation(invitation);
            }
            try {
                PropertyList dataList = event.getProperties("ATTACH");
                List<Attachment> attachments = RemoteCalendarServiceImpl.calculateAtt(dataList);
                if (!attachments.isEmpty()) {
                    exoEvent.setAttachment(attachments);
                }
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) break block11;
                logger.debug((Object)("Exception occurs when importing attachments for iCalendar component: " + event.getUid()), (Throwable)e);
            }
        }
        return exoEvent;
    }

    public static CalendarEvent setTaskAttachment(VToDo task, CalendarEvent exoEvent, String username, String calendarId, Map<String, VFreeBusy> vFreeBusyData) throws Exception {
        block20: {
            PropertyList attendees;
            CalendarService calService = (CalendarService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(CalendarService.class);
            exoEvent = new CalendarEvent();
            if (task.getProperty("CATEGORIES") != null) {
                EventCategory evCate;
                block19: {
                    evCate = new EventCategory();
                    evCate.setName(task.getProperty("CATEGORIES").getValue().trim());
                    try {
                        calService.saveEventCategory(username, evCate, true);
                    }
                    catch (ItemExistsException e) {
                        evCate = calService.getEventCategoryByName(username, evCate.getName());
                    }
                    catch (Exception e) {
                        if (!logger.isDebugEnabled()) break block19;
                        logger.debug((Object)("Exception occurs when saving new event category '" + evCate.getName() + "' for CalDav event: " + task.getUid()), (Throwable)e);
                    }
                }
                exoEvent.setEventCategoryId(evCate.getId());
                exoEvent.setEventCategoryName(evCate.getName());
            }
            exoEvent.setCalType(String.valueOf(0));
            exoEvent.setCalendarId(calendarId);
            if (task.getSummary() != null) {
                exoEvent.setSummary(task.getSummary().getValue());
            }
            if (task.getDescription() != null) {
                exoEvent.setDescription(task.getDescription().getValue());
            }
            if (task.getProperty(Utils.X_STATUS) != null) {
                exoEvent.setEventState(task.getProperty(Utils.X_STATUS).getValue());
            }
            if (task.getStatus() != null) {
                exoEvent.setStatus(task.getStatus().getValue());
            }
            exoEvent.setEventType(CalendarEvent.TYPE_TASK);
            if (task.getStartDate() != null) {
                exoEvent.setFromDateTime((java.util.Date)task.getStartDate().getDate());
            }
            if (task.getDue() != null) {
                exoEvent.setToDateTime((java.util.Date)task.getDue().getDate());
            }
            if (task.getLocation() != null) {
                exoEvent.setLocation(task.getLocation().getValue());
            }
            if (task.getPriority() != null) {
                exoEvent.setPriority(CalendarEvent.PRIORITY[Integer.parseInt(task.getPriority().getValue())]);
            }
            if (vFreeBusyData.get(task.getUid().getValue()) != null) {
                exoEvent.setStatus(CalendarEvent.ST_BUSY);
            }
            if (task.getClassification() != null) {
                exoEvent.setPrivate(Clazz.PRIVATE.getValue().equals(task.getClassification().getValue()));
            }
            if (!(attendees = task.getProperties("ATTENDEE")).isEmpty()) {
                String[] invitation = new String[attendees.size()];
                for (int i = 0; i < attendees.size(); ++i) {
                    invitation[i] = ((Attendee)attendees.get(i)).getValue();
                }
                exoEvent.setInvitation(invitation);
            }
            try {
                PropertyList dataList = task.getProperties("ATTACH");
                List<Attachment> attachments = RemoteCalendarServiceImpl.calculateAtt(dataList);
                if (!attachments.isEmpty()) {
                    exoEvent.setAttachment(attachments);
                }
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) break block20;
                logger.debug((Object)("Exception occurs when importing attachments for iCalendar component: " + task.getUid()), (Throwable)e);
            }
        }
        return exoEvent;
    }

    private static List<Attachment> calculateAtt(PropertyList dataList) throws Exception {
        ArrayList<Attachment> attachments = new ArrayList<Attachment>();
        for (Object o : dataList) {
            Attach a = (Attach)o;
            Attachment att = new Attachment();
            att.setName(a.getParameter("CN").getValue());
            att.setMimeType(a.getParameter("FMTTYPE").getValue());
            ByteArrayInputStream in = new ByteArrayInputStream(a.getBinary());
            att.setSize(((InputStream)in).available());
            att.setInputStream(in);
            attachments.add(att);
        }
        return attachments;
    }

    public static CalendarEvent calculateEvent(VEvent event, CalendarEvent exoEvent) throws Exception {
        WeekDayList weekDays;
        RRule rrule = (RRule)event.getProperty("RRULE");
        Recur recur = rrule.getRecur();
        String repeatType = recur.getFrequency();
        int interval = recur.getInterval();
        if (interval < 1) {
            interval = 1;
        }
        int count = recur.getCount();
        Date until = recur.getUntil();
        exoEvent.setRepeatInterval(interval);
        if (count > 0) {
            exoEvent.setRepeatCount(count);
            exoEvent.setRepeatUntilDate(null);
        } else if (until != null) {
            java.util.Date repeatUntil = new java.util.Date(until.getTime());
            exoEvent.setRepeatUntilDate(repeatUntil);
            exoEvent.setRepeatCount(0L);
        } else {
            exoEvent.setRepeatCount(0L);
            exoEvent.setRepeatUntilDate(null);
        }
        if ("DAILY".equals(repeatType)) {
            exoEvent.setRepeatType(CalendarEvent.RP_DAILY);
        } else if ("YEARLY".equals(repeatType)) {
            exoEvent.setRepeatType(CalendarEvent.RP_YEARLY);
        } else if ("WEEKLY".equals(repeatType)) {
            exoEvent.setRepeatType(CalendarEvent.RP_WEEKLY);
            weekDays = recur.getDayList();
            if (weekDays != null && weekDays.size() > 0) {
                String[] byDays = new String[weekDays.size()];
                for (int i = 0; i < byDays.length; ++i) {
                    WeekDay weekDay = (WeekDay)weekDays.get(i);
                    String day = weekDay.getDay();
                    int offset = weekDay.getOffset();
                    byDays[i] = offset != 0 ? String.valueOf(offset) + day : day;
                }
                exoEvent.setRepeatByDay(byDays);
            } else {
                exoEvent.setRepeatByDay(null);
            }
        } else if ("MONTHLY".equals(repeatType)) {
            exoEvent.setRepeatType(CalendarEvent.RP_MONTHLY);
            weekDays = recur.getDayList();
            if (weekDays != null && weekDays.size() > 0) {
                String[] byDays = new String[weekDays.size()];
                for (int i = 0; i < byDays.length; ++i) {
                    WeekDay weekDay = (WeekDay)weekDays.get(i);
                    String day = weekDay.getDay();
                    int offset = weekDay.getOffset();
                    byDays[i] = offset != 0 ? String.valueOf(offset) + day : day;
                }
                exoEvent.setRepeatByDay(byDays);
                exoEvent.setRepeatByMonthDay(null);
            } else {
                NumberList monthdays = recur.getMonthDayList();
                if (monthdays != null && monthdays.size() > 0) {
                    long[] byMonthDays = new long[monthdays.size()];
                    for (int i = 0; i < byMonthDays.length; ++i) {
                        int monthday = (Integer)monthdays.get(i);
                        byMonthDays[i] = monthday;
                    }
                    exoEvent.setRepeatByDay(null);
                    exoEvent.setRepeatByMonthDay(byMonthDays);
                }
            }
        }
        return exoEvent;
    }

    public HttpClient getRemoteClient(RemoteCalendar remoteCalendar) throws Exception {
        HostConfiguration hostConfig = new HostConfiguration();
        String host = new URL(remoteCalendar.getRemoteUrl()).getHost();
        if (Utils.isEmpty(host)) {
            host = remoteCalendar.getRemoteUrl();
        }
        hostConfig.setHost(host);
        HttpClient client = new HttpClient();
        client.setHostConfiguration(hostConfig);
        client.getHttpConnectionManager().getParams().setConnectionTimeout(10000);
        client.getHttpConnectionManager().getParams().setSoTimeout(10000);
        if (!Utils.isEmpty(remoteCalendar.getRemoteUser())) {
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(remoteCalendar.getRemoteUser(), remoteCalendar.getRemotePassword());
            client.getState().setCredentials(new AuthScope(host, -1, AuthScope.ANY_REALM), (Credentials)credentials);
        }
        return client;
    }

    public ReportMethod makeCalDavQueryReport(String uri, java.util.Calendar from, java.util.Calendar to) throws Exception {
        ReportMethod report = null;
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element calendarQuery = DomUtil.createElement((Document)doc, (String)CALDAV_XML_CALENDAR_QUERY, (Namespace)CALDAV_NAMESPACE);
            calendarQuery.setAttributeNS(Namespace.XMLNS_NAMESPACE.getURI(), Namespace.XMLNS_NAMESPACE.getPrefix() + ":" + DavConstants.NAMESPACE.getPrefix(), DavConstants.NAMESPACE.getURI());
            ReportInfo reportInfo = new ReportInfo(calendarQuery, 0);
            DavPropertyNameSet propNameSet = reportInfo.getPropertyNameSet();
            propNameSet.add(DavPropertyName.GETETAG);
            Element filter = DomUtil.createElement((Document)doc, (String)CALDAV_XML_FILTER, (Namespace)CALDAV_NAMESPACE);
            Element calendarComp = DomUtil.createElement((Document)doc, (String)CALDAV_XML_COMP_FILTER, (Namespace)CALDAV_NAMESPACE);
            calendarComp.setAttribute(CALDAV_XML_COMP_FILTER_NAME, "VCALENDAR");
            Element eventComp = DomUtil.createElement((Document)doc, (String)CALDAV_XML_COMP_FILTER, (Namespace)CALDAV_NAMESPACE);
            eventComp.setAttribute(CALDAV_XML_COMP_FILTER_NAME, "VEVENT");
            Element todoComp = DomUtil.createElement((Document)doc, (String)CALDAV_XML_COMP_FILTER, (Namespace)CALDAV_NAMESPACE);
            todoComp.setAttribute(CALDAV_XML_COMP_FILTER_NAME, "VTODO");
            Element timeRange = DomUtil.createElement((Document)doc, (String)CALDAV_XML_TIME_RANGE, (Namespace)CALDAV_NAMESPACE);
            SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
            timeRange.setAttribute(CALDAV_XML_START, format.format(from.getTime()));
            timeRange.setAttribute(CALDAV_XML_END, format.format(to.getTime()));
            eventComp.appendChild(timeRange);
            todoComp.appendChild(timeRange);
            calendarComp.appendChild(eventComp);
            calendarComp.appendChild(todoComp);
            filter.appendChild(calendarComp);
            reportInfo.setContentElement(filter);
            report = new ReportMethod(uri, reportInfo);
            return report;
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Cannot build report method for CalDav query", (Throwable)e);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteCalendar getRemoteCalendar(String url, String type, String remoteUser, String remotePassword) throws Exception {
        RemoteCalendar remoteCalendar = null;
        if (CalendarService.ICALENDAR.equals(type)) {
            remoteCalendar = new RemoteCalendar();
            remoteCalendar.setRemoteUrl(url);
            remoteCalendar.setType(type);
            InputStream inputStream = this.connectToRemoteServer(remoteCalendar);
            try {
                CalendarBuilder calendarBuilder = new CalendarBuilder();
                net.fortuna.ical4j.model.Calendar iCalendar = calendarBuilder.build(inputStream);
                remoteCalendar.setCalendarName(iCalendar.getProperty(ICAL_PROPS_CALENDAR_NAME).getValue());
                remoteCalendar.setDescription(iCalendar.getProperty(ICAL_PROPS_CALENDAR_DESCRIPTION).getValue());
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        return remoteCalendar;
    }
}

