/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.security.jaas;

import javax.security.auth.login.LoginException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.Credential;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.PasswordCredential;
import org.exoplatform.services.security.UsernameCredential;
import org.exoplatform.services.security.jaas.AbstractLoginModule;

public final class SharedStateLoginModule
extends AbstractLoginModule {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.core.component.security.core.SharedStateLoginModule");

    public boolean login() throws LoginException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"in login");
        }
        try {
            String username = (String)this.sharedState.get("javax.security.auth.login.name");
            String password = (String)this.sharedState.get("javax.security.auth.login.password");
            if (username == null || password == null) {
                return false;
            }
            Authenticator authenticator = (Authenticator)this.getContainer().getComponentInstanceOfType(Authenticator.class);
            if (authenticator == null) {
                throw new LoginException("No Authenticator component found, check your configuration");
            }
            Credential[] credentials = new Credential[]{new UsernameCredential(username), new PasswordCredential(password)};
            String userId = authenticator.validateUser(credentials);
            Identity identity = authenticator.createIdentity(userId);
            this.sharedState.put("exo.security.identity", identity);
            this.sharedState.put("javax.security.auth.login.name", userId);
            this.subject.getPrivateCredentials().add(password);
            this.subject.getPublicCredentials().add(new UsernameCredential(username));
            return true;
        }
        catch (Throwable e) {
            LoginException le = new LoginException(e.getMessage());
            le.initCause(e);
            throw le;
        }
    }

    public boolean abort() throws LoginException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"in abort");
        }
        return true;
    }

    public boolean commit() throws LoginException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"in commit");
        }
        return true;
    }

    public void afterInitialize() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"in initialize");
        }
    }

    public boolean logout() throws LoginException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"in logout");
        }
        return true;
    }

    protected Log getLogger() {
        return LOG;
    }
}

