/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jdbc.impl;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloseableDataSource
implements DataSource {
    private DataSource ds;

    public CloseableDataSource(DataSource ds) {
        this.ds = ds;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        this.checkValid();
        return this.ds.getLogWriter();
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        this.checkValid();
        return this.ds.getLoginTimeout();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.checkValid();
        this.ds.setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.checkValid();
        this.ds.setLoginTimeout(seconds);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        this.checkValid();
        return this.ds.isWrapperFor(iface);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        this.checkValid();
        return this.ds.unwrap(iface);
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.checkValid();
        return this.ds.getConnection();
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        this.checkValid();
        return this.ds.getConnection(username, password);
    }

    public void close() {
        this.ds = null;
    }

    private void checkValid() throws SQLException {
        if (this.ds == null) {
            throw new SQLException("The datasource is closed");
        }
    }
}

