/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.authentication.rest;

import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.jaas.BasicCallbackHandler;

@Path(value="/organization/authenticate")
public class RESTAuthenticator
implements ResourceContainer {
    private static final Log log = ExoLogger.getExoLogger(RESTAuthenticator.class);

    @POST
    @Path(value="/authenticate/")
    public Response authenticate(@FormParam(value="username") String username, @FormParam(value="password") String password) {
        username = RESTAuthenticator.decodeUsername(username);
        try {
            LoginContext loginContext = new LoginContext(ExoContainerContext.getCurrentContainer().getContext().getRealmName(), (CallbackHandler)new BasicCallbackHandler(username, password.toCharArray()));
            loginContext.login();
            loginContext.logout();
            return Response.ok().build();
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Exception in method authenticate", (Throwable)e);
            }
            return Response.status((int)403).entity((Object)e.getMessage()).build();
        }
    }

    public static String decodeUsername(String username) {
        if (username == null || username.indexOf("s220w748s8xn3btua") < 0) {
            return username;
        }
        String[] tokens = username.split("s220w748s8xn3btua");
        StringBuilder sb = new StringBuilder("");
        for (int i = 0; i < tokens.length; ++i) {
            if (i > 0 && tokens[i].length() > 0) {
                tokens[i] = tokens[i].substring(0, 1).toUpperCase() + tokens[i].substring(1);
            }
            sb.append(tokens[i]);
        }
        return sb.toString();
    }
}

