/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mail.service.impl;

import com.sun.mail.imap.IMAPFolder;
import com.sun.mail.smtp.SMTPMessage;
import com.sun.mail.smtp.SMTPSendFailedException;
import com.sun.mail.smtp.SMTPTransport;
import com.sun.mail.util.MailSSLSocketFactory;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import javax.activation.CommandMap;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.MailcapCommandMap;
import javax.jcr.Node;
import javax.mail.Address;
import javax.mail.AuthenticationFailedException;
import javax.mail.BodyPart;
import javax.mail.Flags;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.URLName;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import javax.mail.search.AndTerm;
import javax.mail.search.BodyTerm;
import javax.mail.search.FlagTerm;
import javax.mail.search.FromStringTerm;
import javax.mail.search.NotTerm;
import javax.mail.search.OrTerm;
import javax.mail.search.RecipientStringTerm;
import javax.mail.search.SearchTerm;
import javax.mail.search.SentDateTerm;
import javax.mail.search.SubjectTerm;
import javax.mail.util.ByteArrayDataSource;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.mail.connection.Connector;
import org.exoplatform.mail.connection.impl.BaseConnector;
import org.exoplatform.mail.connection.impl.ImapConnector;
import org.exoplatform.mail.connection.impl.Pop3Connector;
import org.exoplatform.mail.service.Account;
import org.exoplatform.mail.service.Attachment;
import org.exoplatform.mail.service.BufferAttachment;
import org.exoplatform.mail.service.CheckMailJob;
import org.exoplatform.mail.service.CheckingInfo;
import org.exoplatform.mail.service.Folder;
import org.exoplatform.mail.service.Info;
import org.exoplatform.mail.service.MailService;
import org.exoplatform.mail.service.MailSetting;
import org.exoplatform.mail.service.MailSettingConfigPlugin;
import org.exoplatform.mail.service.MailUpdateStorageEventListener;
import org.exoplatform.mail.service.Message;
import org.exoplatform.mail.service.MessageFilter;
import org.exoplatform.mail.service.MessagePageList;
import org.exoplatform.mail.service.MimeMessageParser;
import org.exoplatform.mail.service.ServerConfiguration;
import org.exoplatform.mail.service.SpamFilter;
import org.exoplatform.mail.service.Tag;
import org.exoplatform.mail.service.Utils;
import org.exoplatform.mail.service.impl.DispositionNotification;
import org.exoplatform.mail.service.impl.EMLImportExport;
import org.exoplatform.mail.service.impl.ExoMailTrustManager;
import org.exoplatform.mail.service.impl.JCRDataStorage;
import org.exoplatform.mail.service.impl.MultipartReport;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.scheduler.JobInfo;
import org.exoplatform.services.scheduler.JobSchedulerService;
import org.exoplatform.services.scheduler.PeriodInfo;
import org.exoplatform.ws.frameworks.cometd.ContinuationService;
import org.exoplatform.ws.frameworks.json.impl.JsonException;
import org.exoplatform.ws.frameworks.json.impl.JsonGeneratorImpl;
import org.exoplatform.ws.frameworks.json.value.JsonValue;
import org.gatein.common.util.ParameterValidation;
import org.picocontainer.Startable;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MailServiceImpl
implements MailService,
Startable {
    public static final String COMMA = ",";
    private static final Log logger = ExoLogger.getLogger((String)"cs.mail.service");
    private JCRDataStorage storage_;
    private EMLImportExport emlImportExport_;
    private Map<String, CheckingInfo> checkingLog_;
    private JobSchedulerService schedulerService_;
    private ContinuationService continuationService_;
    private RepositoryService repositoryService;
    private String folderStr = "";
    private Map<String, MailSettingConfigPlugin> settingPlugins = new HashMap<String, MailSettingConfigPlugin>();
    private Map<String, Map<String, Object>> connectionStore = new HashMap<String, Map<String, Object>>();
    private List<MailUpdateStorageEventListener> listeners_ = new ArrayList<MailUpdateStorageEventListener>();

    public MailServiceImpl(InitParams initParams, NodeHierarchyCreator nodeHierarchyCreator, JobSchedulerService schedulerService, RepositoryService reposervice, ContinuationService continuationService) throws Exception {
        this.storage_ = new JCRDataStorage(nodeHierarchyCreator, reposervice);
        this.emlImportExport_ = new EMLImportExport(this.storage_);
        this.checkingLog_ = new ConcurrentHashMap<String, CheckingInfo>();
        this.repositoryService = reposervice;
        this.schedulerService_ = schedulerService;
        this.continuationService_ = continuationService;
    }

    @Override
    public String getMailHierarchyNode() throws Exception {
        return this.storage_.getMailHierarchyNode();
    }

    @Override
    public void removeCheckingInfo(String userName, String accountId) throws Exception {
        String key = userName + ":" + accountId;
        this.checkingLog_.remove(key);
    }

    @Override
    public CheckingInfo getCheckingInfo(String userName, String accountId) {
        String key = userName + ":" + accountId;
        CheckingInfo info = this.checkingLog_.get(key);
        return info;
    }

    @Override
    public List<Account> getAccounts(String userName) throws Exception {
        return this.storage_.getAccounts(userName);
    }

    @Override
    public Account getAccountById(String userName, String id) throws Exception {
        return this.storage_.getAccountById(userName, id);
    }

    private void saveAccount(String userName, Account account, boolean isNew) throws Exception {
        this.storage_.saveAccount(userName, account, isNew);
    }

    @Override
    public void updateAccount(String userName, Account account) throws Exception {
        this.saveAccount(userName, account, false);
    }

    @Override
    public void updateErrorAccount(String userName, Account account) throws Exception {
        this.saveAccount(userName, account, false);
        String accountId = account.getId();
        CheckingInfo info = this.getCheckingInfo(userName, accountId);
        String key = userName + ":" + accountId;
        if (info == null) {
            this.checkingLog_.put(key, new CheckingInfo());
        }
        if (account.getProtocol().equals(Utils.IMAP)) {
            this.synchImapFolders(userName, accountId);
        }
    }

    @Override
    public void removeAccount(String userName, String accountId) throws Exception {
        block4: {
            this.stopAllJobs(userName, accountId);
            try {
                Map<String, String> persm = this.storage_.getAccountById(userName, accountId).getPermissions();
                if (persm != null) {
                    for (String key : persm.keySet()) {
                        this.storage_.removeDelegateAccount(key, accountId);
                    }
                }
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) break block4;
                logger.debug((Object)(" remmove deletage account error :  " + e.getMessage()));
            }
        }
        this.storage_.removeAccount(userName, accountId);
    }

    @Override
    public Folder getFolderById(String username, String accountId, String folderId) throws Exception {
        return this.storage_.getFolderById(username, accountId, folderId);
    }

    @Override
    public Folder getFolder(String userName, String accountId, String folderPath) throws Exception {
        return this.storage_.getFolder(userName, accountId, folderPath);
    }

    @Override
    public String getFolderParentId(String userName, String accountId, String folderId) throws Exception {
        return this.storage_.getFolderParentId(userName, accountId, folderId);
    }

    @Override
    public boolean isExistFolder(String userName, String accountId, String parentId, String folderName) throws Exception {
        return this.storage_.isExistFolder(userName, accountId, parentId, folderName);
    }

    @Override
    public void saveFolder(String userName, String accountId, Folder folder) throws Exception {
        Account account = this.getAccountById(userName, accountId);
        this.saveFolder(userName, account, folder, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveFolderImapOnline(String userName, String accountId, Folder folder) throws Exception {
        Account account;
        Account delegatedAcc = this.getDelegatedAccount(userName, accountId);
        if (delegatedAcc != null) {
            userName = delegatedAcc.getDelegateFrom();
        }
        if ((account = this.getAccountById(userName, accountId)).getProtocol().equalsIgnoreCase(Utils.IMAP) && folder.isPersonalFolder()) {
            IMAPFolder imapFolder = null;
            try {
                ImapConnector connector = this.openIMAPConnection(userName, account, null);
                imapFolder = connector.createFolder(folder);
                this.saveFolder(userName, account, null, (javax.mail.Folder)imapFolder);
            }
            finally {
                if (imapFolder != null && imapFolder.isOpen()) {
                    imapFolder.close(true);
                }
            }
        } else {
            this.storage_.saveFolder(userName, accountId, folder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveFolder(String userName, Account account, Folder folder, boolean b) throws Exception {
        if (account.getProtocol().equalsIgnoreCase(Utils.IMAP) && folder.isPersonalFolder() && b) {
            IMAPFolder imapFolder = null;
            try {
                ImapConnector connector = this.openIMAPConnection(userName, account, null);
                imapFolder = connector.createFolder(folder);
                this.saveFolder(userName, account, null, (javax.mail.Folder)imapFolder);
            }
            catch (Exception e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Exception in method saveFolder", (Throwable)e);
                }
                return;
            }
            finally {
                if (imapFolder != null && imapFolder.isOpen()) {
                    imapFolder.close(true);
                }
            }
        } else {
            this.storage_.saveFolder(userName, account.getId(), folder);
        }
    }

    @Override
    public void saveFolder(String userName, String accountId, String parentId, Folder folder) throws Exception {
        Account account = this.getAccountById(userName, accountId);
        Folder parentFolder = this.getFolderById(userName, accountId, parentId);
        this.saveFolder(userName, account, parentFolder, folder, true);
    }

    @Override
    public void saveFolderImapOnline(String userName, String accountId, String parentId, Folder folder) throws Exception {
        Account account = this.getAccountById(userName, accountId);
        if (account.getProtocol().equalsIgnoreCase(Utils.IMAP) && folder.isPersonalFolder()) {
            Folder parentFolder = this.getFolderById(userName, accountId, parentId);
            ImapConnector connector = this.openIMAPConnection(userName, account, null);
            IMAPFolder imapFolder = connector.createFolder(parentFolder, folder);
            if (imapFolder != null) {
                this.saveFolder(userName, account, parentFolder, (javax.mail.Folder)imapFolder);
            }
        } else {
            this.storage_.saveFolder(userName, accountId, parentId, folder);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void saveFolder(String userName, Account account, Folder parentFolder, Folder folder, boolean b) throws Exception {
        String accountId = account.getId();
        if (account.getProtocol().equalsIgnoreCase(Utils.IMAP) && folder.isPersonalFolder() && b) {
            try {
                ImapConnector connector = this.openIMAPConnection(userName, account, null);
                IMAPFolder imapFolder = connector.createFolder(parentFolder, folder);
                if (imapFolder == null) return;
                this.saveFolder(userName, account, parentFolder, (javax.mail.Folder)imapFolder);
                return;
            }
            catch (Exception e) {
                return;
            }
        } else {
            this.storage_.saveFolder(userName, accountId, parentFolder.getId(), folder);
        }
    }

    private void saveFolder(String userName, Account account, Folder parentFolder, javax.mail.Folder serverFolder) throws Exception {
        String folderId;
        String accountId = account.getId();
        Folder folder = this.storage_.getFolderById(userName, accountId, folderId = serverFolder.getType() != 2 ? Utils.generateFID(accountId, String.valueOf(((IMAPFolder)serverFolder).getUIDValidity()), true) : Utils.escapeIllegalJcrChars(serverFolder.getName()));
        if (folder == null) {
            folder = new Folder();
            folder.setId(folderId);
            folder.setName(serverFolder.getName());
            folder.setURLName(serverFolder.getURLName().toString());
            folder.setNumberOfUnreadMessage(0L);
            folder.setTotalMessage(0L);
            folder.setPersonalFolder(true);
            folder.setType(serverFolder.getType());
            try {
                if (parentFolder == null) {
                    this.storage_.saveFolder(userName, accountId, folder);
                } else {
                    this.storage_.saveFolder(userName, accountId, parentFolder.getId(), folder);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    @Override
    public void renameFolder(String userName, String accountId, String newName, String folderId) throws Exception {
        Account account = this.getAccountById(userName, accountId);
        Folder folder = this.getFolderById(userName, accountId, folderId);
        if (account.getProtocol().equalsIgnoreCase(Utils.IMAP) && folder.isPersonalFolder()) {
            try {
                ImapConnector connector = this.openIMAPConnection(userName, account, null);
                folder = connector.renameFolder(newName, folder);
            }
            catch (Exception e) {
                return;
            }
        }
        if (folder != null) {
            this.storage_.renameFolder(userName, accountId, newName, folder);
        }
    }

    private void deleteLocalFolder(String userName, Account account, Folder folder) throws Exception {
        this.storage_.removeUserFolder(userName, account.getId(), folder.getId());
    }

    @Override
    public void removeUserFolder(String userName, String accountId, String folderId) throws Exception {
        Account account = this.getAccountById(userName, accountId);
        Folder folder = this.getFolderById(userName, accountId, folderId);
        boolean success = true;
        if (account.getProtocol().equalsIgnoreCase(Utils.IMAP) && folder.isPersonalFolder()) {
            ImapConnector connector = this.openIMAPConnection(userName, account, null);
            success = connector.deleteFolder(folder);
        }
        if (success) {
            this.storage_.removeUserFolder(userName, accountId, folderId);
        }
    }

    @Override
    public List<MessageFilter> getFilters(String userName, String accountId) throws Exception {
        Account delegatorAcc = this.getDelegatedAccount(userName, accountId);
        if (Utils.isDelegatedAccount(delegatorAcc, userName)) {
            userName = this.getDelegatedAccount(userName, accountId).getDelegateFrom();
        }
        return this.storage_.getFilters(userName, accountId);
    }

    @Override
    public MessageFilter getFilterById(String userName, String accountId, String filterId) throws Exception {
        Account delegatorAcc = this.getDelegatedAccount(userName, accountId);
        if (Utils.isDelegatedAccount(delegatorAcc, userName)) {
            userName = this.getDelegatedAccount(userName, accountId).getDelegateFrom();
        }
        return this.storage_.getFilterById(userName, accountId, filterId);
    }

    @Override
    public void saveFilter(String userName, String accountId, MessageFilter filter, boolean applyAll) throws Exception {
        String toFolder = filter.getApplyFolder();
        List<Message> messageList = this.storage_.getMessagePageList(userName, filter).getAll(userName);
        String fromFolder = null;
        if (messageList.size() > 0) {
            fromFolder = messageList.get(0).getFolders()[0];
        }
        this.moveMessages(userName, accountId, messageList, fromFolder, toFolder);
        this.storage_.saveFilter(userName, accountId, filter, applyAll);
    }

    @Override
    public void removeFilter(String userName, String accountId, String filterId) throws Exception {
        this.storage_.removeFilter(userName, accountId, filterId);
    }

    @Override
    public Message getMessageById(String userName, String accountId, String msgId) throws Exception {
        return this.storage_.getMessageById(userName, accountId, msgId);
    }

    @Override
    public void removeMessage(String userName, String accountId, Message message) throws Exception {
        this.storage_.removeMessage(userName, accountId, message);
    }

    @Override
    public void removeMessages(String userName, String accountId, List<Message> messages, boolean moveReference) throws Exception {
        this.storage_.removeMessages(userName, accountId, messages, moveReference);
    }

    @Override
    public List<Message> moveMessages(String userName, String accountId, List<Message> msgList, String currentFolderId, String destFolderId) throws Exception {
        Account account = this.getAccountById(userName, accountId);
        Folder currentFolder = this.getFolderById(userName, accountId, currentFolderId);
        List<Message> successList = new ArrayList<Message>();
        Folder destFolder = this.getFolderById(userName, accountId, destFolderId);
        if (account.getProtocol().equalsIgnoreCase(Utils.IMAP)) {
            try {
                ImapConnector connector = this.openIMAPConnection(userName, account, null);
                successList = connector.moveMessage(msgList, currentFolder, destFolder);
            }
            catch (Exception e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("MailServiceImpl: Move message error " + e.getMessage()));
                }
            }
        } else if (account.getProtocol().equals(Utils.POP3)) {
            successList.addAll(msgList);
        }
        if (successList != null && successList.size() > 0) {
            this.storage_.moveMessages(userName, accountId, successList, currentFolderId, destFolderId);
        }
        return successList;
    }

    @Override
    public List<Message> moveMessages(String userName, String accountId, List<Message> msgList, String currentFolderId, String destFolderId, boolean updateReference) throws Exception {
        Account account = this.getAccountById(userName, accountId);
        Folder currentFolder = this.getFolderById(userName, accountId, currentFolderId);
        Folder destFolder = this.getFolderById(userName, accountId, destFolderId);
        List<Message> successList = new ArrayList<Message>();
        if (account.getProtocol().equalsIgnoreCase(Utils.IMAP)) {
            try {
                ImapConnector connector = this.openIMAPConnection(userName, account, null);
                successList = connector.moveMessage(msgList, currentFolder, destFolder);
            }
            catch (Exception e) {
                logger.error((Object)"Mailservice: Move message to trash folder error", (Throwable)e);
            }
        } else if (account.getProtocol().equals(Utils.POP3)) {
            successList.addAll(msgList);
        }
        if (successList != null && successList.size() > 0) {
            this.storage_.moveMessages(userName, accountId, successList, currentFolderId, destFolderId, updateReference);
        }
        return successList;
    }

    @Override
    public Message moveMessage(String userName, String accountId, Message msg, String currentFolderId, String destFolderId) throws Exception {
        Account account = this.getAccountById(userName, accountId);
        Folder currentFolder = this.getFolderById(userName, accountId, currentFolderId);
        Folder destFolder = this.getFolderById(userName, accountId, destFolderId);
        List<Message> successList = new ArrayList<Message>();
        if (account.getProtocol().equalsIgnoreCase(Utils.IMAP)) {
            try {
                ArrayList<Message> msgList = new ArrayList<Message>();
                ImapConnector connector = this.openIMAPConnection(userName, account, null);
                msgList.add(msg);
                successList = connector.moveMessage(msgList, currentFolder, destFolder);
            }
            catch (Exception e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Mailservice: Move message fail. ", (Throwable)e);
                }
            }
        } else if (account.getProtocol().equals(Utils.POP3)) {
            successList.add(msg);
        }
        if (successList != null && successList.size() > 0) {
            this.storage_.moveMessage(userName, accountId, msg, currentFolderId, destFolderId, true);
            return msg;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void moveMessage(String userName, String accountId, Message msg, String currentFolderId, String destFolderId, boolean updateReference) throws Exception {
        boolean success;
        block5: {
            Account account = this.getAccountById(userName, accountId);
            Folder currentFolder = this.getFolderById(userName, accountId, currentFolderId);
            Folder destFolder = this.getFolderById(userName, accountId, destFolderId);
            success = true;
            if (account.getProtocol().equalsIgnoreCase(Utils.IMAP)) {
                try {
                    ImapConnector connector = this.openIMAPConnection(userName, account, null);
                    List<Message> msgList = new ArrayList<Message>();
                    msgList.add(msg);
                    msgList = connector.moveMessage(msgList, currentFolder, destFolder);
                    if (msgList == null) return;
                    if (msgList.size() <= 0) {
                        return;
                    }
                    break block5;
                }
                catch (Exception e) {
                    return;
                }
            }
            if (account.getProtocol().equals(Utils.POP3)) {
                success = true;
            }
        }
        if (!success) return;
        this.storage_.moveMessage(userName, accountId, msg, currentFolderId, destFolderId, updateReference);
    }

    @Override
    public MessagePageList getMessagePageList(String userName, MessageFilter filter) throws Exception {
        Account delegatorAcc = this.getDelegatedAccount(userName, filter.getAccountId());
        if (Utils.isDelegatedAccount(delegatorAcc, userName)) {
            userName = this.getDelegatedAccount(userName, filter.getAccountId()).getDelegateFrom();
        }
        return this.storage_.getMessagePageList(userName, filter);
    }

    @Override
    public boolean saveMessage(String userName, Account account, String targetMsgPath, Message message, boolean isNew) throws Exception {
        ArrayList<Message> msgList = new ArrayList<Message>();
        List<Message> successList = null;
        msgList.add(message);
        String folderId = message.getFolders()[0];
        Folder destFolder = null;
        boolean success = false;
        if (folderId != null) {
            destFolder = this.getFolderById(userName, account.getId(), folderId);
        }
        if (destFolder != null && account.getProtocol().equalsIgnoreCase(Utils.IMAP)) {
            ImapConnector connector = this.openIMAPConnection(userName, account, null);
            try {
                successList = connector.createMessage(msgList, destFolder);
            }
            catch (Exception e) {
                logger.warn((Object)("Cannot add sent message into \"" + destFolder.getName() + "\" folder on server"));
            }
        } else if (account.getProtocol().equalsIgnoreCase(Utils.POP3)) {
            success = true;
        }
        this.storage_.saveMessage(userName, account.getId(), targetMsgPath, message, isNew);
        if (successList != null && successList.size() > 0) {
            success = true;
        }
        return success;
    }

    @Override
    public void saveMessage(String userName, String accountId, String targetMsgPath, Message message, boolean isNew) throws Exception {
        Account account = this.getAccountById(userName, accountId);
        this.saveMessage(userName, account, targetMsgPath, message, isNew);
    }

    @Override
    public List<Message> getMessagesByTag(String userName, String accountId, String tagId) throws Exception {
        MessageFilter filter = new MessageFilter("Tag");
        filter.setAccountId(accountId);
        filter.setFolder(new String[]{tagId});
        if (!Utils.isEmptyField(this.getDelegatorUserName(userName, accountId))) {
            userName = this.getDelegatorUserName(userName, accountId);
        }
        return this.getMessages(userName, filter);
    }

    @Override
    public List<Message> getMessagesByFolder(String userName, String accountId, String folderId) throws Exception {
        MessageFilter filter = new MessageFilter("Folder");
        filter.setAccountId(accountId);
        filter.setFolder(new String[]{folderId});
        List<Message> list = this.getMessages(userName, filter);
        return list;
    }

    @Override
    public List<Message> getMessages(String userName, MessageFilter filter) throws Exception {
        return this.storage_.getMessages(userName, filter);
    }

    @Override
    public void saveMessage(String userName, String accountId, Message message, boolean isNew) throws Exception {
        this.storage_.saveMessage(userName, accountId, message, isNew);
    }

    @Override
    public Message sendMessage(String userName, String accId, Message message) throws Exception {
        Account acc = this.getAccountById(userName, accId);
        return this.sendMessage(userName, acc, message);
    }

    private Properties generateSMTPConfig(Account acc) {
        Properties props = new Properties();
        this.fillGeneralSMTPConfig(props, acc);
        if ("starttls".equalsIgnoreCase(acc.getSecureAuthsOutgoing())) {
            this.fillSMTPConfig4STARTTLS(props, acc, "smtp");
        } else if ("ssl/tls".equalsIgnoreCase(acc.getSecureAuthsOutgoing())) {
            this.fillSMTPConfig4SSLTLS(props, acc, "smtps");
        }
        return props;
    }

    private void fillGeneralSMTPConfig(Properties props, Account acc) {
        String protocol = "smtp";
        if ("ssl/tls".equalsIgnoreCase(acc.getSecureAuthsOutgoing())) {
            protocol = "smtps";
        }
        props.put("mail.transport.protocol", protocol);
        props.put(Utils.getMailConfigPropertyName(protocol, Utils.SVR_SMTP_AUTH), (Object)acc.isOutgoingAuthentication());
        props.put(Utils.getMailConfigPropertyName(protocol, Utils.SVR_SMTP_USER), acc.getOutgoingUserName());
        props.put(Utils.getMailConfigPropertyName(protocol, Utils.SVR_SMTP_PASSWORD), acc.getOutgoingPassword());
        props.put(Utils.getMailConfigPropertyName(protocol, Utils.SVR_SMTP_HOST), acc.getOutgoingHost());
        props.put(Utils.getMailConfigPropertyName(protocol, Utils.SVR_SMTP_PORT), acc.getOutgoingPort());
        props.put(Utils.getMailConfigPropertyName(protocol, Utils.SMTP_AUTH_MECHS), acc.getAuthMechsOutgoing());
        props.put(Utils.getMailConfigPropertyName(protocol, Utils.SMTP_DNS_NOTIFY), "SUCCESS,FAILURE ORCPT=rfc822;" + acc.getEmailAddress());
        props.put(Utils.getMailConfigPropertyName(protocol, Utils.SMTP_DNS_RET), "FULL");
        props.put(Utils.getMailConfigPropertyName(protocol, Utils.SVR_SMTP_SOCKET_FACTORY_CLASS), Utils.SOCKET_FACTORY);
        props.put(Utils.getMailConfigPropertyName(protocol, Utils.SVR_SMTP_SOCKET_FACTORY_FALLBACK), (Object)false);
        props.put(Utils.getMailConfigPropertyName(protocol, Utils.SVR_SMTP_SOCKET_FACTORY_PORT), acc.getOutgoingPort());
    }

    private void fillSMTPConfig4STARTTLS(Properties props, Account acc, String protocol) {
        props.put(Utils.getMailConfigPropertyName(protocol, Utils.SVR_SMTP_STARTTLS_ENABLE), (Object)true);
        props.put(Utils.getMailConfigPropertyName(protocol, Utils.SMTP_SSL_FACTORY), this.getSSLSocketFactory(acc.getOutgoingHost()));
    }

    private void fillSMTPConfig4SSLTLS(Properties props, Account acc, String protocol) {
        props.put("mail.transport.protocol", protocol);
        props.put(Utils.getMailConfigPropertyName(protocol, Utils.SVR_SMTP_SSL_ENABLE), (Object)true);
        props.put(Utils.getMailConfigPropertyName(protocol, Utils.SMTP_SSL_FACTORY), this.getSSLSocketFactory(acc.getOutgoingHost()));
        props.put(Utils.getMailConfigPropertyName(protocol, "ssl.socketFactory.port"), acc.getOutgoingPort());
        props.put(Utils.getMailConfigPropertyName(protocol, Utils.SMTP_SSL_PROTOCOLS), "SSLv3 TLSv1");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message sendMessage(String userName, Account acc, Message message) throws Exception {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)acc, (String)"acc");
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)userName, (String)"username", null);
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)message, (String)"message");
        Properties props = this.generateSMTPConfig(acc);
        String smtpUser = acc.getIncomingUser();
        String outgoingHost = acc.getOutgoingHost();
        String outgoingPort = acc.getOutgoingPort();
        Session session = Session.getInstance((Properties)props, null);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format(" #### Sending email with account '%1$s' ...", acc.getOutgoingUserName()));
        }
        if ("ssl/tls".equalsIgnoreCase(acc.getSecureAuthsOutgoing())) {
            session.setProtocolForAddress("rfc822", "smtps");
        }
        SMTPTransport transport = (SMTPTransport)session.getTransport();
        try {
            if (!acc.isOutgoingAuthentication()) {
                transport.connect();
            } else if (acc.useIncomingSettingForOutgoingAuthent()) {
                transport.connect(outgoingHost, Integer.parseInt(outgoingPort), smtpUser, acc.getIncomingPassword());
            } else {
                transport.connect(outgoingHost, Integer.parseInt(outgoingPort), acc.getOutgoingUserName(), acc.getOutgoingPassword());
            }
        }
        catch (Exception ex) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"#### Can not connect to smtp server ...", (Throwable)ex);
            }
            throw ex;
        }
        Message msg = null;
        try {
            msg = this.send(session, (Transport)transport, message);
        }
        finally {
            transport.close();
        }
        return msg;
    }

    @Override
    public Message sendMessage(String userName, Message message) throws Exception {
        return this.sendMessage(userName, message.getAccountId(), message);
    }

    @Override
    public void sendMessage(Message message) throws Exception {
        ArrayList<Message> msgList = new ArrayList<Message>();
        msgList.add(message);
        this.sendMessages(msgList, message.getServerConfiguration());
    }

    @Override
    @Deprecated
    public void sendMessages(List<Message> msgList, ServerConfiguration serverConfig) throws Exception {
        Properties props = System.getProperties();
        String protocolName = "smtp";
        String propSmtpPort = Utils.SVR_SMTP_SOCKET_FACTORY_PORT;
        String smtpSslProtocols = "mail.smtp.ssl.protocols";
        String smtpSsl = Utils.SVR_SMTP_SSL_ENABLE;
        String smtpAuth = Utils.SVR_SMTP_AUTH;
        String propSmtpSslSocketFactory = Utils.SMTP_SSL_FACTORY;
        boolean isSMTPAuth = serverConfig.isOutgoingAuthentication();
        if (serverConfig.isOutgoingSsl()) {
            protocolName = "smtps";
            MailSSLSocketFactory socketFactory = this.getSSLSocketFactory(serverConfig.getOutgoingHost());
            props.put(propSmtpSslSocketFactory.replace("smtp", "smtps"), socketFactory);
            propSmtpPort = "ssl.socketFactory.port";
            props.put(smtpSsl.replace("smtp", "smtps"), (Object)true);
            props.put(smtpSslProtocols.replace("smtp", "smtps"), "SSLv3 TLSv1");
        }
        if (Utils.isGmailAccount(serverConfig.getUserName())) {
            protocolName = "smtps";
            if (isSMTPAuth) {
                props.put(smtpAuth.replace("smtp", "smtps"), (Object)true);
            }
        }
        if (protocolName.equalsIgnoreCase("smtp")) {
            props.put(Utils.SVR_INCOMING_USERNAME, serverConfig.getUserName());
            props.put(Utils.SVR_INCOMING_PASSWORD, serverConfig.getPassword());
            props.put(Utils.SVR_SMTP_USER, serverConfig.getUserName());
            props.put(Utils.SVR_SMTP_HOST, serverConfig.getOutgoingHost());
            props.put(Utils.SVR_SMTP_PORT, serverConfig.getOutgoingPort());
            props.put(propSmtpPort, serverConfig.getOutgoingPort());
            props.put(Utils.SVR_SMTP_SOCKET_FACTORY_FALLBACK, "false");
            if (isSMTPAuth) {
                props.put(Utils.SVR_SMTP_AUTH, (Object)true);
            } else {
                props.put(Utils.SVR_SMTP_AUTH, (Object)false);
            }
        } else {
            props.put(Utils.SVR_INCOMING_USERNAME, serverConfig.getUserName());
            props.put(Utils.SVR_INCOMING_PASSWORD, serverConfig.getPassword());
            props.put(Utils.SVR_SMTP_USER.replace("smtp", "smtps"), serverConfig.getUserName());
            props.put(Utils.SVR_SMTP_HOST.replace("smtp", "smtps"), serverConfig.getOutgoingHost());
            props.put(Utils.SVR_SMTP_PORT.replace("smtp", "smtps"), serverConfig.getOutgoingPort());
            props.put(propSmtpPort.replace("smtp", "smtps"), serverConfig.getOutgoingPort());
            props.put(Utils.SVR_SMTP_SOCKET_FACTORY_FALLBACK.replace("smtp", "smtps"), "false");
            if (isSMTPAuth) {
                props.put(Utils.SVR_SMTP_AUTH.replace("smtp", "smtps"), (Object)true);
            } else {
                props.put(Utils.SVR_SMTP_AUTH.replace("smtp", "smtps"), (Object)false);
            }
        }
        Session session = Session.getDefaultInstance((Properties)props, null);
        Transport transport = session.getTransport(protocolName);
        try {
            if (!isSMTPAuth) {
                transport.connect();
            } else {
                transport.connect(serverConfig.getOutgoingHost(), serverConfig.getUserName(), serverConfig.getPassword());
            }
        }
        catch (Exception e) {
            try {
                transport.connect();
            }
            catch (Exception ex) {
                logger.debug((Object)"#### Can not connect to smtp server ...");
                return;
            }
        }
        logger.debug((Object)" #### Sending email ... ");
        int i = 0;
        for (Message msg : msgList) {
            msg.setServerConfiguration(serverConfig);
            try {
                this.send(session, transport, msg);
                ++i;
            }
            catch (Exception e) {
                logger.error((Object)(" #### Info : send fail at message " + i + " \n"), (Throwable)e);
                StringWriter sw = new StringWriter();
                StringBuffer sb = sw.getBuffer();
                logger.error((Object)sb.toString());
            }
        }
        logger.debug((Object)(" #### Info : Sent " + i + " email(s)"));
        transport.close();
    }

    private Message send(Session session, Transport transport, Message message) throws Exception {
        MimeMessage mimeMessage = new MimeMessage(session);
        SMTPMessage smtpMessage = null;
        String status = "";
        mimeMessage.setHeader("Message-ID", message.getId());
        mimeMessage.setHeader("Content-Transfer-Encoding", "utf-8");
        InternetAddress addressFrom = message.getFrom() != null ? new InternetAddress(message.getFrom()) : new InternetAddress(session.getProperties().getProperty(Utils.SVR_SMTP_USER));
        mimeMessage.setFrom((Address)addressFrom);
        if (message.getMessageTo() != null) {
            mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)message.getMessageTo()));
        }
        if (message.getMessageCc() != null) {
            mimeMessage.setRecipients(Message.RecipientType.CC, (Address[])InternetAddress.parse((String)message.getMessageCc(), (boolean)true));
        }
        if (message.getMessageBcc() != null) {
            mimeMessage.setRecipients(Message.RecipientType.BCC, (Address[])InternetAddress.parse((String)message.getMessageBcc(), (boolean)false));
        }
        if (message.getReplyTo() != null) {
            mimeMessage.setReplyTo((Address[])Utils.getInternetAddress(message.getReplyTo()));
        }
        mimeMessage.setSubject(message.getSubject(), "UTF-8");
        mimeMessage.setSentDate(message.getSendDate());
        List<Attachment> attachList = message.getAttachments();
        if (attachList != null && attachList.size() > 0) {
            MimeBodyPart contentPartRoot = new MimeBodyPart();
            if (message.getContentType() != null && message.getContentType().indexOf("text/plain") > -1) {
                contentPartRoot.setContent((Object)message.getMessageBody(), "text/plain; charset=utf-8");
            } else {
                contentPartRoot.setContent((Object)message.getMessageBody(), "text/html; charset=utf-8");
            }
            MimeMultipart multipPartContent = new MimeMultipart("mixed");
            MimeBodyPart mimeBodyPart1 = new MimeBodyPart();
            mimeBodyPart1.setContent((Object)message.getMessageBody(), message.getContentType());
            multipPartContent.addBodyPart((BodyPart)mimeBodyPart1);
            for (Attachment att : attachList) {
                MimeBodyPart mimeBodyPart = new MimeBodyPart();
                InputStream inputStream = att.getInputStream();
                String contentType = att.getMimeType();
                ByteArrayDataSource dataSource = new ByteArrayDataSource(inputStream, contentType);
                mimeBodyPart.setDataHandler(new DataHandler((DataSource)dataSource));
                mimeBodyPart.setDisposition("attachment");
                String fileName = att.getName();
                if (fileName != null && fileName.length() > 0) {
                    mimeBodyPart.setFileName(MimeUtility.encodeText((String)fileName, (String)"utf-8", null));
                }
                multipPartContent.addBodyPart((BodyPart)mimeBodyPart);
            }
            mimeMessage.setContent((Multipart)multipPartContent);
        } else if (message.getContentType() != null && message.getContentType().indexOf("text/plain") > -1) {
            mimeMessage.setContent((Object)message.getMessageBody(), "text/plain; charset=utf-8");
        } else {
            mimeMessage.setContent((Object)message.getMessageBody(), "text/html; charset=utf-8");
        }
        if (message.isReturnReceipt()) {
            mimeMessage.setHeader("Disposition-Notification-To", message.getReplyTo());
        }
        mimeMessage = Utils.setHeader(mimeMessage, message);
        try {
            smtpMessage = new SMTPMessage(mimeMessage);
            smtpMessage.setNotifyOptions(2);
            smtpMessage.saveChanges();
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            transport.sendMessage((javax.mail.Message)smtpMessage, smtpMessage.getAllRecipients());
            message.setId(MimeMessageParser.getMessageId((javax.mail.Message)smtpMessage));
            Enumeration enu = smtpMessage.getAllHeaders();
            while (enu.hasMoreElements()) {
                Header header = (Header)enu.nextElement();
                message.setHeader(header.getName(), header.getValue());
            }
            status = "Mail Delivered !";
        }
        catch (AddressException e) {
            status = "There was an error parsing the addresses. Sending Failed !" + e.getMessage();
            throw e;
        }
        catch (AuthenticationFailedException e) {
            status = "The Username or Password may be wrong. Sending Failed !" + e.getMessage();
            throw e;
        }
        catch (SMTPSendFailedException e) {
            status = "Sorry, There was an error sending the message. Sending Failed !" + e.getMessage();
            throw e;
        }
        catch (MessagingException e) {
            status = "There was an unexpected error. Sending Failed ! " + e.getMessage();
            throw e;
        }
        catch (Exception e) {
            status = "There was an unexpected error. Sending Falied !" + e.getMessage();
            throw e;
        }
        finally {
            logger.debug((Object)(" #### Info : " + status));
        }
        logger.debug((Object)(" #### Info : " + status));
        return message;
    }

    @Override
    public void checkMail(String userName, String accountId) throws Exception {
        Account account = this.getAccountById(userName, accountId);
        this.loadCheckmailJob(userName, account);
    }

    @Override
    public void checkMail(String userName, String accountId, String folderId) throws Exception {
        if (Utils.isEmptyField(folderId)) {
            this.checkMail(userName, accountId);
        } else {
            Account account = this.getAccountById(userName, accountId);
            Folder folder = this.getFolderById(userName, accountId, folderId);
            this.loadCheckmailJob(userName, account, folder);
        }
    }

    private void executeJob(JobDetail job) {
        if (job != null) {
            try {
                this.schedulerService_.executeJob(job.getName(), job.getGroup(), job.getJobDataMap());
            }
            catch (Exception e) {
                logger.error((Object)("Failed to execute job " + job.getName()), (Throwable)e);
            }
        }
    }

    @Override
    public void stopCheckMail(String userName, String accountId) {
        String accoutOwner;
        block5: {
            accoutOwner = userName;
            try {
                Account delegateAcc = this.getDelegatedAccount(userName, accountId);
                if (this.isDelegatedAccount(userName, accountId)) {
                    accoutOwner = delegateAcc.getDelegateFrom();
                }
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) break block5;
                logger.debug((Object)"Exception in method stopCheckMail", (Throwable)e);
            }
        }
        CheckingInfo checkingInfo = this.getCheckingInfo(accoutOwner, accountId);
        if (checkingInfo != null) {
            if (logger.isDebugEnabled()) {
                logger.info((Object)(" user [ " + userName + " ] request to stop checking emails"));
            }
            checkingInfo.setRequestStop(true);
            checkingInfo.setStatusCode(200);
            this.updateCheckingMailStatusByCometd(userName, accountId, checkingInfo);
        }
    }

    @Override
    public void stopAllJobs(String userName, String accountId) throws Exception {
        JobInfo info = CheckMailJob.getJobInfo(userName, accountId);
        this.stopCheckMail(userName, accountId);
        this.schedulerService_.removeJob(info);
    }

    private JobDetail loadCheckmailJob(String userName, Account account) throws Exception {
        return this.loadCheckmailJob(userName, account, null);
    }

    private JobDetail loadCheckmailJob(String userName, Account account, Folder folder) throws Exception {
        String accountId = account.getId();
        JobInfo info = CheckMailJob.getJobInfo(userName, accountId);
        JobDetail job = this.findCheckmailJob(userName, accountId);
        JobDataMap jobData = new JobDataMap();
        jobData.put("repository", this.repositoryService.getCurrentRepository().getConfiguration().getName());
        jobData.put("userName", userName);
        jobData.put("acountId", accountId);
        if (folder != null) {
            jobData.put("folderId", folder.getId());
        }
        if (job == null) {
            PeriodInfo periodInfo = new PeriodInfo(null, null, 0, 86400000L);
            this.schedulerService_.addPeriodJob(info, periodInfo, jobData);
        } else {
            JobDetail activeJob = this.findActiveCheckmailJob(userName, accountId);
            job.setJobDataMap(jobData);
            if (activeJob == null) {
                this.executeJob(job);
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("job [ " + job.getName() + " ] still exist. Can not start new job!"));
                }
                job = new JobDetail(info.getJobName(), info.getGroupName(), info.getJob());
            }
        }
        return job;
    }

    private JobDetail findActiveCheckmailJob(String userName, String accountId) throws Exception {
        List list = this.schedulerService_.getAllExcutingJobs();
        for (Object obj : list) {
            JobExecutionContext jec = (JobExecutionContext)obj;
            JobDetail tmp = jec.getJobDetail();
            if (!tmp.getName().equals(userName + ":" + accountId)) continue;
            return tmp;
        }
        return null;
    }

    private JobDetail findCheckmailJob(String userName, String accountId) throws Exception {
        List list = this.schedulerService_.getAllJobs();
        for (Object obj : list) {
            JobDetail tmp = (JobDetail)obj;
            if (!tmp.getName().equals(userName + ":" + accountId)) continue;
            return tmp;
        }
        return null;
    }

    private LinkedHashMap<javax.mail.Message, List<String>> getMessages(LinkedHashMap<javax.mail.Message, List<String>> msgMap, javax.mail.Folder folder, boolean isImap, Date fromDate, Date toDate, List<MessageFilter> filters) throws Exception {
        javax.mail.Message msg;
        javax.mail.Message[] messages;
        Object searchTerm = null;
        if (fromDate != null && toDate != null && fromDate.equals(toDate)) {
            return msgMap;
        }
        if (!folder.isOpen()) {
            folder.open(2);
        }
        if (fromDate == null && toDate == null) {
            messages = folder.getMessages();
        } else {
            searchTerm = new FlagTerm(new Flags(Flags.Flag.SEEN), false);
            Object dateTerm = null;
            if (fromDate != null) {
                dateTerm = new SentDateTerm(5, fromDate);
            }
            if (toDate != null) {
                dateTerm = dateTerm != null ? new AndTerm((SearchTerm)dateTerm, (SearchTerm)new SentDateTerm(1, toDate)) : new SentDateTerm(1, toDate);
            }
            searchTerm = !isImap ? new OrTerm((SearchTerm)searchTerm, (SearchTerm)dateTerm) : dateTerm;
            messages = folder.search((SearchTerm)searchTerm);
        }
        boolean beforeTime = false;
        boolean betweenTime = false;
        int filteredMsgNumber = 0;
        int getFrom = 0;
        for (MessageFilter filter : filters) {
            int k;
            beforeTime = false;
            betweenTime = false;
            SearchTerm st = this.getSearchTerm((SearchTerm)searchTerm, filter);
            javax.mail.Message[] filteredMsg = folder.search(st);
            filteredMsgNumber = filteredMsg.length;
            if (filteredMsgNumber <= 0) continue;
            getFrom = 0;
            if (fromDate != null) {
                for (k = 0; k < filteredMsgNumber && MimeMessageParser.getReceivedDate(filteredMsg[k]).getTime().before(fromDate); ++k) {
                    ++getFrom;
                }
            }
            for (k = filteredMsgNumber - 1; k >= 0; --k) {
                msg = filteredMsg[k];
                List<Object> filterList = msgMap.containsKey(msg) ? msgMap.get(msg) : new ArrayList();
                if (filterList == null) {
                    filterList = new ArrayList();
                }
                if (!filterList.contains(filter.getId())) {
                    filterList.add(filter.getId());
                }
                if (fromDate != null && toDate != null) {
                    if (!betweenTime && isImap && !MimeMessageParser.getReceivedDate(msg).getTime().before(toDate)) continue;
                    betweenTime = true;
                    if (!isImap || k > getFrom) {
                        msgMap.put(msg, filterList);
                        continue;
                    }
                    betweenTime = false;
                    continue;
                }
                if (fromDate != null) {
                    if (isImap && k <= getFrom) continue;
                    msgMap.put(msg, filterList);
                    continue;
                }
                if (toDate != null) {
                    if (!beforeTime && isImap && !MimeMessageParser.getReceivedDate(msg).getTime().before(toDate)) continue;
                    beforeTime = true;
                    msgMap.put(msg, filterList);
                    continue;
                }
                msgMap.put(msg, filterList);
            }
        }
        if (messages.length > 0) {
            beforeTime = false;
            betweenTime = false;
            getFrom = 0;
            if (fromDate != null) {
                Date receivedDate;
                for (int l = 0; l < messages.length && ((receivedDate = MimeMessageParser.getReceivedDate(messages[l]).getTime()).before(fromDate) || receivedDate.equals(fromDate)); ++l) {
                    ++getFrom;
                }
            }
            for (int l = messages.length; l > 0; --l) {
                msg = messages[l - 1];
                if (!msgMap.containsKey(msg)) {
                    if (fromDate != null && toDate != null) {
                        if (!betweenTime && isImap && !MimeMessageParser.getReceivedDate(msg).getTime().before(toDate)) continue;
                        betweenTime = true;
                        if (!isImap || l > getFrom) {
                            msgMap.put(msg, null);
                            continue;
                        }
                        betweenTime = false;
                        continue;
                    }
                    if (fromDate != null) {
                        if (isImap && l <= getFrom) continue;
                        msgMap.put(msg, null);
                        continue;
                    }
                    if (toDate != null) {
                        if (!beforeTime && isImap && !MimeMessageParser.getReceivedDate(msg).getTime().before(toDate)) continue;
                        beforeTime = true;
                        msgMap.put(msg, null);
                        continue;
                    }
                    msgMap.put(msg, null);
                    continue;
                }
                List<String> temp = msgMap.get(msg);
                msgMap.remove(msg);
                msgMap.put(msg, temp);
            }
        }
        return msgMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void synchImapFolders(String userName, String accountId) throws Exception {
        CheckingInfo info = this.getCheckingInfo(userName, accountId);
        try {
            Account account;
            ImapConnector connector;
            Account dAccount = this.getDelegatedAccount(userName, accountId);
            String uId = userName;
            if (this.isDelegatedAccount(userName, accountId)) {
                uId = dAccount.getDelegateFrom();
            }
            if ((connector = this.openIMAPConnection(uId, account = this.getAccountById(uId, accountId), info)) != null) {
                String key = userName + ":" + accountId;
                if (info == null) {
                    info = new CheckingInfo();
                    this.checkingLog_.put(key, info);
                }
                this.synchImapFolders(uId, account, null, connector.getDefaultFolder().list());
                info.setSyncFolderStatus(302);
            }
        }
        catch (Exception e) {
            if (info != null) {
                info.setSyncFolderStatus(302);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Exception in method synchImapFolders", (Throwable)e);
            }
        }
        finally {
            if (info != null) {
                info.setSyncFolderStatus(302);
            }
        }
    }

    private List<javax.mail.Folder> synchImapFolders(String userName, Account account, Folder parentFolder, javax.mail.Folder[] folders) throws Exception {
        ArrayList<javax.mail.Folder> folderList = new ArrayList<javax.mail.Folder>();
        ArrayList<String> serverFolderId = new ArrayList<String>();
        String accountId = account.getId();
        for (javax.mail.Folder fd : folders) {
            String folderName = fd.getName();
            if (parentFolder == null && (folderName.equalsIgnoreCase(Utils.FD_DRAFTS) || folderName.equalsIgnoreCase(Utils.FD_SENT) || folderName.equalsIgnoreCase(Utils.FD_SPAM)) || folderName.equalsIgnoreCase(Utils.FD_TRASH)) continue;
            int folderType = fd.getType();
            if (!folderName.equalsIgnoreCase(Utils.FD_INBOX)) {
                String folderId = folderType != 2 ? Utils.generateFID(accountId, String.valueOf(((IMAPFolder)fd).getUIDValidity()), true) : Utils.escapeIllegalJcrChars(folderName);
                serverFolderId.add(folderId);
                Folder folder = this.storage_.getFolderById(userName, accountId, folderId);
                if (folder == null) {
                    folder = new Folder();
                    folder.setId(folderId);
                    folder.setName(folderName);
                    folder.setURLName(fd.getURLName().toString());
                    folder.setNumberOfUnreadMessage(0L);
                    folder.setTotalMessage(0L);
                    folder.setPersonalFolder(true);
                    folder.setType(folderType);
                    try {
                        if (parentFolder == null) {
                            this.storage_.saveFolder(userName, accountId, folder);
                        } else {
                            this.storage_.saveFolder(userName, accountId, parentFolder.getId(), folder);
                        }
                        folder = this.storage_.getFolderById(userName, accountId, folderId);
                    }
                    catch (Exception e) {
                        logger.warn((Object)e);
                    }
                } else if (!folder.getName().equalsIgnoreCase(folderName)) {
                    folder.setName(folderName);
                    folder.setURLName(fd.getURLName().toString());
                    this.saveFolder(userName, account, folder, false);
                }
                folderList.add(fd);
                if (folderType != 2 && fd.list().length <= 0) continue;
                folderList.addAll(this.synchImapFolders(userName, account, folder, fd.list()));
                continue;
            }
            Folder inbox = this.getFolderById(userName, accountId, Utils.generateFID(accountId, Utils.FD_INBOX, false));
            inbox.setNumberOfUnreadMessage(fd.getNewMessageCount());
            inbox.setURLName(fd.getURLName().toString());
            this.saveFolder(userName, account, inbox, false);
        }
        List<Folder> localFolders = null;
        localFolders = parentFolder == null ? this.getFolders(userName, accountId, true) : this.getSubFolders(userName, accountId, parentFolder.getPath());
        if (localFolders != null) {
            for (Folder f : localFolders) {
                if (serverFolderId.contains(f.getId())) continue;
                this.deleteLocalFolder(userName, account, f);
            }
        }
        return folderList;
    }

    private MailSSLSocketFactory getSSLSocketFactory(String host) {
        MailSSLSocketFactory sslsocket = null;
        try {
            sslsocket = new MailSSLSocketFactory();
            sslsocket.setTrustedHosts(new String[]{host});
            TrustManager[] trusts = new TrustManager[]{new ExoMailTrustManager(null, false, host, null)};
            sslsocket.setTrustManagers(trusts);
        }
        catch (GeneralSecurityException gse) {
            logger.error((Object)"Imap SSL: Cannot create a ssl socket between client and server. All host will trusted.", (Throwable)gse);
            sslsocket = this.trustAllHost();
        }
        catch (Exception e) {
            logger.error((Object)"Your email was not trusted by Mail server", (Throwable)e);
        }
        return sslsocket;
    }

    private MailSSLSocketFactory trustAllHost() {
        MailSSLSocketFactory sslsocket = null;
        try {
            sslsocket = new MailSSLSocketFactory();
            sslsocket.setTrustAllHosts(true);
            sslsocket.setTrustManagers(new TrustManager[]{new X509TrustManager(){

                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }

                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }
            }});
        }
        catch (Exception e) {
            logger.warn((Object)("Your sun cacerts file may be broken. Pls check it at " + ExoMailTrustManager.PATH_CERTS_FILE + "/cacerts"), (Throwable)e);
        }
        return sslsocket;
    }

    private ImapConnector openIMAPConnection(String userName, Account account, CheckingInfo info) {
        String key;
        ImapConnector imapConnector;
        Map<String, Object> connectionCache = this.connectionStore.get(userName);
        if (connectionCache == null) {
            connectionCache = new HashMap<String, Object>();
            this.connectionStore.put(userName, connectionCache);
        }
        if (!((imapConnector = (ImapConnector)connectionCache.get(key = account.getId() + "_" + account.getProtocol())) != null && imapConnector.isConnected() || (imapConnector = this.getIMAPConnection(userName, account, info)) == null)) {
            connectionCache.put(key, imapConnector);
        }
        return imapConnector;
    }

    private ImapConnector getIMAPConnection(String userName, Account account, CheckingInfo info) {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(" #### Opening IMap connection to " + account.getIncomingHost() + " ... !"));
            }
            MailSSLSocketFactory sslSocket = null;
            if (account.isIncomingSsl()) {
                sslSocket = this.getSSLSocketFactory(account.getIncomingHost());
            }
            try {
                return new ImapConnector(account, sslSocket);
            }
            catch (AuthenticationFailedException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)String.format("Authentication failed with email '%s'", account.getIncomingUser()), (Throwable)e);
                }
                if (!account.isSavePassword()) {
                    account.setIncomingPassword("");
                    this.updateAccount(userName, account);
                }
                if (info != null) {
                    info.setStatusCode(103);
                    this.updateCheckingMailStatusByCometd(userName, account.getId(), info);
                }
            }
            catch (MessagingException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Exception while connecting to server : " + e.getMessage()));
                }
                if (info != null) {
                    info.setStatusCode(102);
                    this.updateCheckingMailStatusByCometd(userName, account.getId(), info);
                }
            }
            catch (IllegalStateException e) {
                logger.error((Object)"Exception while connecting to server", (Throwable)e);
            }
            catch (Exception e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Exception while connecting to server : ", (Throwable)e);
                }
                StringWriter sw = new StringWriter();
                StringBuffer sb = sw.getBuffer();
                logger.error((Object)sb.toString());
                if (info != null) {
                    info.setStatusCode(102);
                    this.updateCheckingMailStatusByCometd(userName, account.getId(), info);
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception while connecting to server", (Throwable)ex);
        }
        return null;
    }

    private Pop3Connector openPOPConnection(String userName, Account account, CheckingInfo info) {
        String key;
        Pop3Connector pop3Connector;
        Map<String, Object> connectionCache = this.connectionStore.get(userName);
        if (connectionCache == null) {
            connectionCache = new HashMap<String, Object>();
            this.connectionStore.put(userName, connectionCache);
        }
        if (!((pop3Connector = (Pop3Connector)connectionCache.get(key = account.getId() + "_" + account.getProtocol())) != null && pop3Connector.isConnected() || (pop3Connector = this.getPOPConnection(userName, account, info)) == null)) {
            connectionCache.put(key, pop3Connector);
        }
        return pop3Connector;
    }

    private Pop3Connector getPOPConnection(String userName, Account account, CheckingInfo info) {
        try {
            logger.debug((Object)(" #### Opening IMap connection to " + account.getIncomingHost() + " ... !"));
            if (info != null) {
                info.setStatusCode(101);
                this.updateCheckingMailStatusByCometd(userName, account.getId(), info);
            }
            MailSSLSocketFactory socketFactory = null;
            if (account.isIncomingSsl()) {
                try {
                    socketFactory = this.getSSLSocketFactory(account.getIncomingHost());
                }
                catch (Exception e) {
                    logger.error((Object)"Pop3 SSL: Cannot create a ssl socket between client and server. All host will trusted.");
                    socketFactory = this.trustAllHost();
                }
            }
            try {
                return new Pop3Connector(account, socketFactory);
            }
            catch (AuthenticationFailedException e) {
                if (!account.isSavePassword()) {
                    account.setIncomingPassword("");
                    this.updateAccount(userName, account);
                    logger.debug((Object)"Exception while connecting to server", (Throwable)e);
                }
                if (info != null) {
                    info.setStatusCode(103);
                    this.updateCheckingMailStatusByCometd(userName, account.getId(), info);
                }
            }
            catch (MessagingException e) {
                logger.debug((Object)"Exception while connecting to server", (Throwable)e);
                if (info != null) {
                    info.setStatusCode(102);
                    this.updateCheckingMailStatusByCometd(userName, account.getId(), info);
                }
            }
            catch (Exception e) {
                logger.debug((Object)"Exception while connecting to server", (Throwable)e);
                if (info != null) {
                    info.setStatusCode(102);
                    this.updateCheckingMailStatusByCometd(userName, account.getId(), info);
                }
            }
        }
        catch (Exception ex) {
            logger.debug((Object)"Exception while connecting to server", (Throwable)ex);
        }
        return null;
    }

    private void mergeMessageBetweenJcrAndServerMail(ImapConnector connector, String userName, Account account, Folder folder, CheckingInfo info) throws Exception {
        IMAPFolder mailServerFolder;
        if (folder == null || Utils.isEmptyField(folder.getURLName())) {
            folder = this.getFolderById(userName, account.getId(), Utils.generateFID(account.getId(), Utils.FD_INBOX, false));
        }
        if ((mailServerFolder = connector.openFolderForReadWrite(folder.getURLName())) != null) {
            this.synchImapMessage(userName, account, (javax.mail.Folder)mailServerFolder, info);
        }
    }

    private CheckingInfo createCheckingInfo(String userName, String accountId) {
        String key = userName + ":" + accountId;
        CheckingInfo info = new CheckingInfo();
        this.checkingLog_.put(key, info);
        return info;
    }

    private void getSynchnizeImapServer(String userName, Account account, Folder folder, boolean synchFolders) throws Exception {
        String accountId = account.getId();
        CheckingInfo info = this.getCheckingInfo(userName, accountId);
        if (info == null) {
            info = this.createCheckingInfo(userName, accountId);
        } else {
            info.resetValues();
        }
        info.setAccountId(accountId);
        info.setStatusCode(101);
        this.updateCheckingMailStatusByCometd(userName, accountId, info);
        ImapConnector connector = this.openIMAPConnection(userName, account, info);
        if (info.isRequestStop()) {
            throw new CheckMailInteruptedException("stopped checking emails!");
        }
        if (connector != null) {
            List<javax.mail.Folder> folderList = null;
            if (synchFolders) {
                info.setSyncFolderStatus(301);
                info.setStatusCode(301);
                this.updateCheckingMailStatusByCometd(userName, accountId, info);
                folderList = this.synchImapFolders(userName, account, null, connector.getDefaultFolder().list());
                info.setSyncFolderStatus(302);
                info.setStatusCode(302);
                this.updateCheckingMailStatusByCometd(userName, accountId, info);
            }
            if (info.isRequestStop()) {
                throw new CheckMailInteruptedException("stopped checking emails!");
            }
        } else {
            return;
        }
        this.mergeMessageBetweenJcrAndServerMail(connector, userName, account, folder, info);
        logger.debug((Object)"/////////////////////////////////////////////////////////////");
        logger.debug((Object)"/////////////////////////////////////////////////////////////");
        if (info != null) {
            if (info.getStatusCode() != 200) {
                info.setStatusCode(200);
            }
            this.updateCheckingMailStatusByCometd(userName, accountId, info);
        }
    }

    private List<String> getListOfMessageIdsInFolder(String username, String accountId, String folderId, Calendar fromDate, Calendar toDate) throws Exception {
        MessageFilter filter = new MessageFilter("Folder");
        filter.setAccountId(accountId);
        filter.setFolder(new String[]{folderId});
        if (fromDate != null) {
            filter.setFromDate(fromDate);
        }
        if (toDate != null) {
            filter.setToDate(toDate);
        }
        return this.storage_.getListOfMessageIds(username, filter);
    }

    private void synchImapMessage(String userName, Account account, javax.mail.Folder folder, CheckingInfo info) throws Exception {
        String[] localFolders;
        String accountId = account.getId();
        boolean saved = false;
        int totalNew = -1;
        if (folder == null) {
            return;
        }
        String folderId = null;
        String folderName = folder.getName();
        logger.warn((Object)(" #### Getting mails from folder " + folderName + " !"));
        try {
            if (!folder.isOpen()) {
                folder.open(1);
            }
        }
        catch (MessagingException ex) {
            return;
        }
        if (info != null) {
            info.setStatusCode(150);
            this.updateCheckingMailStatusByCometd(userName, accountId, info);
        }
        folderId = Utils.generateFID(accountId, String.valueOf(((IMAPFolder)folder).getUIDValidity()), true);
        for (String localFolder : localFolders = Utils.DEFAULT_FOLDERS) {
            if (!localFolder.equalsIgnoreCase(folderName)) continue;
            folderId = Utils.generateFID(accountId, localFolder, false);
        }
        Folder eXoFolder = this.getFolderById(userName, accountId, folderId);
        if (eXoFolder != null) {
            boolean leaveOnserver;
            long unreadMsgCount = eXoFolder.getNumberOfUnreadMessage();
            Date checkFromDate = eXoFolder.getCheckFromDate();
            if (account.getCheckFromDate() == null) {
                checkFromDate = null;
            } else if (checkFromDate == null || checkFromDate.before(account.getCheckFromDate())) {
                checkFromDate = account.getCheckFromDate();
            }
            boolean isImap = account.getProtocol().equals(Utils.IMAP);
            boolean bl = leaveOnserver = isImap && Boolean.valueOf(account.getServerProperties().get(Utils.SVR_LEAVE_ON_SERVER)) != false;
            if (info.isRequestStop()) {
                throw new CheckMailInteruptedException("stopped checking emails!");
            }
            LinkedHashMap<javax.mail.Message, List<String>> msgMap = this.getMessageMap(userName, account, folder, null, checkFromDate, null);
            if (info.isRequestStop()) {
                throw new CheckMailInteruptedException("stopped checking emails!");
            }
            Calendar c = null;
            if (checkFromDate != null) {
                c = Calendar.getInstance();
                c.setTime(checkFromDate);
            }
            HashSet<String> savedMsgList = new HashSet<String>(this.getListOfMessageIdsInFolder(userName, accountId, folderId, c, null));
            totalNew = msgMap.size();
            logger.debug((Object)(" #### Folder " + folderName + " contains " + totalNew + " messages !"));
            if (totalNew > 0) {
                int i = 0;
                Date lastFromDate = null;
                Date receivedDate = null;
                ArrayList<javax.mail.Message> msgList = new ArrayList<javax.mail.Message>(msgMap.keySet());
                info.setStatusCode(150);
                this.updateCheckingMailStatusByCometd(userName, accountId, info);
                while (i < totalNew) {
                    block26: {
                        if (info != null && info.isRequestStop()) {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("Stop requested on checkmail for " + account.getId()));
                            }
                            throw new CheckMailInteruptedException("Stop getting mails from folder " + folder.getName() + " !");
                        }
                        if (info != null && !Utils.isEmptyField(info.getRequestingForFolder_()) && !String.valueOf(((IMAPFolder)folder).getUIDValidity()).equals(Utils.getFolderNameFromFolderId(info.getRequestingForFolder_())) || info == null) break;
                        javax.mail.Message msg = (javax.mail.Message)msgList.get(i);
                        MimeMessage mimeMessage = (MimeMessage)msg;
                        String msgId = mimeMessage.getMessageID();
                        try {
                            if (savedMsgList.contains(msgId)) {
                                savedMsgList.remove(msgId);
                                ++i;
                                continue;
                            }
                            saved = this.saveMessage(true, folderId, msgMap, userName, accountId, msg, folder);
                            if (saved) {
                                if (!leaveOnserver) {
                                    msg.setFlag(Flags.Flag.DELETED, true);
                                }
                                if (!msg.isSet(Flags.Flag.SEEN)) {
                                    ++unreadMsgCount;
                                }
                            }
                            receivedDate = MimeMessageParser.getReceivedDate(msg).getTime();
                            if (i == 0) {
                                lastFromDate = receivedDate;
                            }
                            eXoFolder.setLastCheckedDate(receivedDate);
                            if (i == totalNew - 1) {
                                eXoFolder.setCheckFromDate(lastFromDate);
                            }
                            if (lastFromDate == null || eXoFolder.getLastStartCheckingTime() != null && !eXoFolder.getLastStartCheckingTime().before(lastFromDate)) break block26;
                            eXoFolder.setLastStartCheckingTime(lastFromDate);
                        }
                        catch (Exception e) {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)"Exception in method synchImapMessage", (Throwable)e);
                            }
                            ++i;
                            continue;
                        }
                    }
                    ++i;
                }
                eXoFolder.setNumberOfUnreadMessage(unreadMsgCount);
                this.saveFolder(userName, account, eXoFolder, false);
            }
        }
    }

    private LinkedHashMap<javax.mail.Message, List<String>> getMessageMap(String userName, Account account, javax.mail.Folder folder, Date lastCheckedDate, Date checkFromDate, Date lastCheckedFromDate) throws Exception {
        boolean isImap;
        LinkedHashMap<javax.mail.Message, List<String>> msgMap = new LinkedHashMap<javax.mail.Message, List<String>>();
        String accountId = account.getId();
        List<MessageFilter> filters = this.getFilters(userName, accountId);
        boolean bl = isImap = account.getProtocol().equals(Utils.IMAP);
        if (checkFromDate == null) {
            if (lastCheckedDate != null && lastCheckedFromDate != null) {
                msgMap = this.getMessages(msgMap, folder, isImap, lastCheckedFromDate, null, filters);
                msgMap = this.getMessages(msgMap, folder, isImap, null, lastCheckedDate, filters);
            } else {
                msgMap = lastCheckedFromDate != null ? this.getMessages(msgMap, folder, isImap, lastCheckedFromDate, null, filters) : (lastCheckedDate != null ? this.getMessages(msgMap, folder, isImap, null, lastCheckedDate, filters) : this.getMessages(msgMap, folder, isImap, null, null, filters));
            }
        } else if (lastCheckedDate != null && lastCheckedFromDate != null) {
            msgMap = this.getMessages(msgMap, folder, isImap, lastCheckedFromDate, null, filters);
            msgMap = this.getMessages(msgMap, folder, isImap, checkFromDate, lastCheckedDate, filters);
        } else {
            msgMap = lastCheckedFromDate != null ? this.getMessages(msgMap, folder, isImap, lastCheckedFromDate, null, filters) : (lastCheckedDate != null && lastCheckedDate.after(checkFromDate) ? this.getMessages(msgMap, folder, isImap, checkFromDate, lastCheckedDate, filters) : this.getMessages(msgMap, folder, isImap, checkFromDate, null, filters));
        }
        return msgMap;
    }

    @Override
    public void checkNewMessage(String userName, String accountId) throws Exception {
        this.checkNewMessage(userName, accountId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkNewMessage(String username, String accountId, String folderId) throws Exception {
        Account account;
        String reciever = username;
        Account dAccount = this.getDelegatedAccount(username, accountId);
        if (this.isDelegatedAccount(username, accountId)) {
            reciever = dAccount.getDelegateFrom();
        }
        if ((account = this.getAccountById(reciever, accountId)) != null) {
            try {
                if (account.getProtocol().equals(Utils.POP3)) {
                    this.checkPop3Server(reciever, account);
                } else if (account.getProtocol().equals(Utils.IMAP) && reciever != null) {
                    Folder folder = Utils.isEmptyField(folderId) ? null : this.getFolderById(username, accountId, folderId);
                    boolean isSyncFolder = this.getFolders(username, accountId, true).size() == 0;
                    this.getSynchnizeImapServer(reciever, account, folder, isSyncFolder);
                }
            }
            catch (CheckMailInteruptedException cme) {
                CheckingInfo info = this.getCheckingInfo(username, accountId);
                info.setRequestStop(false);
                info.assignInterruptedStatus();
                this.updateCheckingMailStatusByCometd(username, accountId, info);
            }
            catch (MessagingException e) {
                CheckingInfo info;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)String.format("Error when getting new messages for user '%s' account '%s', folderid '%s'", reciever, accountId, folderId), (Throwable)e);
                }
                if ((info = this.getCheckingInfo(username, accountId)) != null) {
                    info.setStatusCode(102);
                    this.updateCheckingMailStatusByCometd(username, accountId, info);
                }
            }
            finally {
                if (!account.isSavePassword()) {
                    account.setIncomingPassword("");
                    if (reciever != null) {
                        this.updateAccount(reciever, account);
                    } else {
                        this.updateAccount(username, account);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkPop3Server(String userName, Account account) throws Exception {
        String accountId = account.getId();
        if (account != null) {
            CheckingInfo info;
            block25: {
                info = null;
                info = this.getCheckingInfo(userName, accountId);
                if (info == null) {
                    info = this.createCheckingInfo(userName, accountId);
                } else {
                    info.resetValues();
                }
                info.setAccountId(accountId);
                if (Utils.isEmptyField(account.getIncomingPassword())) {
                    info.setStatusCode(103);
                    this.updateCheckingMailStatusByCometd(userName, accountId, info);
                    return;
                }
                logger.debug((Object)(" #### Getting mail from " + account.getIncomingHost() + " ... !"));
                info.setStatusCode(101);
                this.updateCheckingMailStatusByCometd(userName, accountId, info);
                int totalNew = 0;
                String incomingFolder = account.getIncomingFolder().trim();
                URLName storeURL = new URLName(account.getProtocol(), account.getIncomingHost(), Integer.valueOf(account.getIncomingPort()).intValue(), incomingFolder, account.getIncomingUser(), account.getIncomingPassword());
                Pop3Connector connector = this.openPOPConnection(userName, account, info);
                if (connector == null) {
                    return;
                }
                if (info.isRequestStop()) {
                    throw new CheckMailInteruptedException("stopped checking emails");
                }
                javax.mail.Folder folder = connector.getFolder(storeURL.getFile());
                if (info.isRequestStop()) {
                    throw new CheckMailInteruptedException("stopped checking emails");
                }
                try {
                    if (!folder.exists()) {
                        logger.debug((Object)(" #### Folder " + incomingFolder + " is not exists !"));
                        info.setStatusCode(104);
                        this.updateCheckingMailStatusByCometd(userName, accountId, info);
                        return;
                    }
                    logger.debug((Object)(" #### Getting mails from folder " + incomingFolder + " !"));
                    info.setStatusCode(150);
                    this.updateCheckingMailStatusByCometd(userName, accountId, info);
                    folder.open(2);
                    Date lastCheckedDate = account.getLastCheckedDate();
                    Date lastCheckedFromDate = account.getLastStartCheckingTime();
                    Date checkFromDate = account.getCheckFromDate();
                    LinkedHashMap<javax.mail.Message, List<String>> msgMap = this.getMessageMap(userName, account, folder, lastCheckedDate, checkFromDate, lastCheckedFromDate);
                    if (info.isRequestStop()) {
                        throw new CheckMailInteruptedException("stopped checking emails");
                    }
                    totalNew = msgMap.size();
                    logger.debug((Object)"=============================================================");
                    logger.debug((Object)"=============================================================");
                    logger.debug((Object)(" #### Folder contains " + totalNew + " messages !"));
                    long tt1 = System.currentTimeMillis();
                    boolean saved = false;
                    if (totalNew > 0) {
                        boolean leaveOnServer = Boolean.valueOf(account.getServerProperties().get(Utils.SVR_LEAVE_ON_SERVER));
                        info.setTotalMsg(totalNew);
                        int i = 0;
                        Date lastFromDate = null;
                        Date receivedDate = null;
                        ArrayList<javax.mail.Message> msgList = new ArrayList<javax.mail.Message>(msgMap.keySet());
                        String folderId = this.makeStoreFolder(userName, accountId, incomingFolder, totalNew);
                        this.updateCheckingMailStatusByCometd(userName, accountId, info);
                        while (i < totalNew) {
                            long t1;
                            block24: {
                                if (info != null && info.isRequestStop()) {
                                    if (logger.isDebugEnabled()) {
                                        logger.debug((Object)("Stop requested on checkmail for " + account.getId()));
                                    }
                                    throw new CheckMailInteruptedException("Stop getting mails from folder " + folder.getName() + " !");
                                }
                                javax.mail.Message msg = (javax.mail.Message)msgList.get(i);
                                info.setFetching(i + 1);
                                logger.debug((Object)("Fetching message " + (i + 1) + " ..."));
                                t1 = System.currentTimeMillis();
                                try {
                                    saved = this.saveMessage(false, folderId, msgMap, userName, accountId, msg, folder);
                                    if (saved) {
                                        msg.setFlag(Flags.Flag.SEEN, true);
                                        if (!leaveOnServer) {
                                            msg.setFlag(Flags.Flag.DELETED, true);
                                        }
                                        info.setFetchingToFolders(this.folderStr);
                                        info.setMsgId(MimeMessageParser.getMessageId(msg));
                                    }
                                    receivedDate = MimeMessageParser.getReceivedDate(msg).getTime();
                                    if (i == 0) {
                                        lastFromDate = receivedDate;
                                    }
                                    account.setLastCheckedDate(receivedDate);
                                    if (i == totalNew - 1) {
                                        account.setCheckFromDate(lastFromDate);
                                    }
                                    if (lastFromDate == null || account.getLastStartCheckingTime() != null && !account.getLastStartCheckingTime().before(lastFromDate)) break block24;
                                    account.setLastStartCheckingTime(lastFromDate);
                                }
                                catch (Exception e) {
                                    info.setStatusCode(104);
                                    this.updateCheckingMailStatusByCometd(userName, accountId, info);
                                    ++i;
                                    continue;
                                }
                            }
                            long t2 = System.currentTimeMillis();
                            logger.debug((Object)("Message " + ++i + " saved : " + (t2 - t1) + " ms"));
                        }
                        long tt2 = System.currentTimeMillis();
                        logger.debug((Object)(" ### Check mail finished total took: " + (tt2 - tt1) + " ms"));
                        break block25;
                    }
                    if (info != null) {
                        info.setStatusCode(200);
                        this.updateCheckingMailStatusByCometd(userName, accountId, info);
                        return;
                    }
                }
                finally {
                    folder.close(true);
                }
            }
            info.setStatusCode(200);
            this.updateCheckingMailStatusByCometd(userName, accountId, info);
            logger.debug((Object)"/////////////////////////////////////////////////////////////");
            logger.debug((Object)"/////////////////////////////////////////////////////////////");
        }
    }

    private String makeStoreFolder(String userName, String accountId, String incomingFolder, int unReadMsg) throws Exception {
        String folderId = Utils.generateFID(accountId, incomingFolder, false);
        Folder storeFolder = this.storage_.getFolderById(userName, accountId, folderId);
        if (storeFolder == null) {
            folderId = Utils.generateFID(accountId, incomingFolder, true);
            Folder storeUserFolder = this.storage_.getFolderById(userName, accountId, folderId);
            storeFolder = storeUserFolder != null ? storeUserFolder : new Folder();
            storeFolder.setNumberOfUnreadMessage(unReadMsg);
            storeFolder.setId(folderId);
            storeFolder.setName(incomingFolder);
            storeFolder.setPersonalFolder(true);
            this.storage_.saveFolder(userName, accountId, storeFolder);
        } else if (unReadMsg > 0) {
            long numUnReadMsg = 0L;
            numUnReadMsg = storeFolder.getNumberOfUnreadMessage();
            numUnReadMsg = numUnReadMsg > 0L ? numUnReadMsg : 0L;
            storeFolder.setNumberOfUnreadMessage(numUnReadMsg + (long)unReadMsg);
            this.storage_.saveFolder(userName, accountId, storeFolder);
        }
        return folderId;
    }

    private SearchTerm getSearchTerm(SearchTerm sTerm, MessageFilter filter) throws Exception {
        if (!Utils.isEmptyField(filter.getFrom())) {
            FromStringTerm fsTerm = new FromStringTerm(filter.getFrom());
            if (filter.getFromCondition() == 0) {
                sTerm = sTerm == null ? fsTerm : new AndTerm(sTerm, (SearchTerm)fsTerm);
            } else if (filter.getFromCondition() == 1) {
                sTerm = sTerm == null ? new NotTerm((SearchTerm)fsTerm) : new AndTerm(sTerm, (SearchTerm)new NotTerm((SearchTerm)fsTerm));
            }
        }
        if (!Utils.isEmptyField(filter.getTo())) {
            RecipientStringTerm toTerm = new RecipientStringTerm(MimeMessage.RecipientType.TO, filter.getTo());
            if (filter.getToCondition() == 0) {
                sTerm = sTerm == null ? toTerm : new AndTerm(sTerm, (SearchTerm)toTerm);
            } else if (filter.getToCondition() == 1) {
                sTerm = sTerm == null ? new NotTerm((SearchTerm)toTerm) : new AndTerm(sTerm, (SearchTerm)new NotTerm((SearchTerm)toTerm));
            }
        }
        if (!Utils.isEmptyField(filter.getSubject())) {
            SubjectTerm subjectTerm = new SubjectTerm(filter.getSubject());
            if (filter.getSubjectCondition() == 0) {
                sTerm = sTerm == null ? subjectTerm : new AndTerm(sTerm, (SearchTerm)subjectTerm);
            } else if (filter.getSubjectCondition() == 1) {
                sTerm = sTerm == null ? new NotTerm((SearchTerm)subjectTerm) : new AndTerm(sTerm, (SearchTerm)new NotTerm((SearchTerm)subjectTerm));
            }
        }
        if (!Utils.isEmptyField(filter.getBody())) {
            BodyTerm bodyTerm = new BodyTerm(filter.getBody());
            if (filter.getBodyCondition() == 0) {
                sTerm = sTerm == null ? bodyTerm : new AndTerm(sTerm, (SearchTerm)bodyTerm);
            } else if (filter.getBodyCondition() == 1) {
                sTerm = sTerm == null ? new NotTerm((SearchTerm)bodyTerm) : new AndTerm(sTerm, (SearchTerm)new NotTerm((SearchTerm)bodyTerm));
            }
        }
        return sTerm;
    }

    @Override
    public void createAccount(String userName, Account account) throws Exception {
        this.saveAccount(userName, account, true);
    }

    @Override
    public List<Folder> getFolders(String userName, String accountId) throws Exception {
        List<Folder> gottenFolderList = this.storage_.getFolders(userName, accountId);
        CheckingInfo info = this.getCheckingInfo(userName, accountId);
        if (info != null) {
            Connector connector = null;
            for (Folder folder : gottenFolderList) {
                String urlName = folder.getURLName();
                if (folder.isPersonalFolder() || !Utils.isEmptyField(urlName)) continue;
                if (connector == null) {
                    Account account = this.getAccountById(userName, accountId);
                    if (Utils.POP3.equalsIgnoreCase(account.getProtocol())) {
                        connector = this.openPOPConnection(userName, account, info);
                    }
                    if (Utils.IMAP.equalsIgnoreCase(account.getProtocol())) {
                        connector = this.openIMAPConnection(userName, account, info);
                    }
                }
                if (connector == null || !connector.isConnected()) continue;
                javax.mail.Folder fd = connector.getFolder(folder.getName());
                folder.setURLName(fd.getURLName().toString());
                this.storage_.saveFolder(userName, accountId, folder);
            }
        }
        return gottenFolderList;
    }

    @Override
    public List<Folder> getFolders(String userName, String accountId, boolean isPersonal) throws Exception {
        List<Folder> folders = this.getFolders(userName, accountId);
        ArrayList<Folder> resultList = new ArrayList<Folder>();
        for (Folder folder : folders) {
            if (folder.isPersonalFolder() != isPersonal) continue;
            resultList.add(folder);
        }
        return resultList;
    }

    @Override
    public void addTag(String userName, String accountId, Tag tag) throws Exception {
        if (!Utils.isEmptyField(this.getDelegatorUserName(userName, accountId))) {
            userName = this.getDelegatorUserName(userName, accountId);
        }
        this.storage_.addTag(userName, accountId, tag);
    }

    @Override
    public void addTag(String userName, String accountId, List<Message> messages, List<Tag> tag) throws Exception {
        if (this.isDelegatedAccount(userName, accountId)) {
            userName = this.getDelegatedAccount(userName, accountId).getDelegateFrom();
        }
        this.storage_.addTag(userName, accountId, messages, tag);
    }

    @Override
    public List<Tag> getTags(String userName, String accountId) throws Exception {
        if (this.isDelegatedAccount(userName, accountId)) {
            userName = this.getDelegatedAccount(userName, accountId).getDelegateFrom();
        }
        return this.storage_.getTags(userName, accountId);
    }

    @Override
    public Tag getTag(String userName, String accountId, String tagId) throws Exception {
        if (!Utils.isEmptyField(this.getDelegatorUserName(userName, accountId))) {
            userName = this.getDelegatorUserName(userName, accountId);
        }
        return this.storage_.getTag(userName, accountId, tagId);
    }

    @Override
    public void removeTagsInMessages(String userName, String accountId, List<Message> msgList, List<String> tagIdList) throws Exception {
        if (!Utils.isEmptyField(this.getDelegatorUserName(userName, accountId))) {
            userName = this.getDelegatorUserName(userName, accountId);
        }
        this.storage_.removeTagsInMessages(userName, accountId, msgList, tagIdList);
    }

    @Override
    public void removeTag(String userName, String accountId, String tag) throws Exception {
        if (!Utils.isEmptyField(this.getDelegatorUserName(userName, accountId))) {
            userName = this.getDelegatorUserName(userName, accountId);
        }
        this.storage_.removeTag(userName, accountId, tag);
    }

    @Override
    public void updateTag(String userName, String accountId, Tag tag) throws Exception {
        if (!Utils.isEmptyField(this.getDelegatorUserName(userName, accountId))) {
            userName = this.getDelegatorUserName(userName, accountId);
        }
        this.storage_.updateTag(userName, accountId, tag);
    }

    @Override
    public List<Message> getMessageByTag(String userName, String accountId, String tagName) throws Exception {
        if (!Utils.isEmptyField(this.getDelegatorUserName(userName, accountId))) {
            userName = this.getDelegatorUserName(userName, accountId);
        }
        return this.storage_.getMessageByTag(userName, accountId, tagName);
    }

    @Override
    public MessagePageList getMessagePagelistByTag(String userName, String accountId, String tagId) throws Exception {
        MessageFilter filter = new MessageFilter("Filter By Tag");
        filter.setAccountId(accountId);
        filter.setTag(new String[]{tagId});
        if (!Utils.isEmptyField(this.getDelegatorUserName(userName, accountId))) {
            userName = this.getDelegatorUserName(userName, accountId);
        }
        return this.getMessagePageList(userName, filter);
    }

    @Override
    public MessagePageList getMessagePageListByFolder(String userName, String accountId, String folderId) throws Exception {
        MessageFilter filter = new MessageFilter("Filter By Folder");
        filter.setAccountId(accountId);
        filter.setFolder(new String[]{folderId});
        return this.getMessagePageList(userName, filter);
    }

    @Override
    public MailSetting getMailSetting(String userName) throws Exception {
        return this.storage_.getMailSetting(userName);
    }

    @Override
    public void saveMailSetting(String userName, MailSetting newSetting) throws Exception {
        this.storage_.saveMailSetting(userName, newSetting);
    }

    @Override
    public void importMessage(String userName, String accountId, String folderId, InputStream inputStream, String type) throws Exception {
        Properties props = System.getProperties();
        Session session = Session.getDefaultInstance((Properties)props, null);
        MimeMessage mimeMessage = new MimeMessage(session, inputStream);
        Account account = this.getAccountById(userName, accountId);
        Folder folder = this.getFolderById(userName, accountId, folderId);
        long[] msgUID = new long[]{0L};
        if (this.isDelegatedAccount(userName, accountId)) {
            userName = this.getDelegatedAccount(userName, accountId).getDelegateFrom();
        }
        ImapConnector connector = this.openIMAPConnection(userName, account, null);
        connector.importMessageIntoServerMail(folder.getURLName(), mimeMessage, msgUID);
        this.emlImportExport_.importMessage(userName, accountId, folderId, mimeMessage, msgUID);
    }

    @Override
    public OutputStream exportMessage(String userName, String accountId, Message message) throws Exception {
        return this.emlImportExport_.exportMessage(userName, accountId, message);
    }

    @Override
    public SpamFilter getSpamFilter(String userName, String accountId) throws Exception {
        return this.storage_.getSpamFilter(userName, accountId);
    }

    @Override
    public void saveSpamFilter(String userName, String accountId, SpamFilter spamFilter) throws Exception {
        this.storage_.saveSpamFilter(userName, accountId, spamFilter);
    }

    @Override
    public void toggleMessageProperty(String userName, String accountId, List<Message> msgList, String folderId, String property, boolean value) throws Exception {
        Account account = this.getAccountById(userName, accountId);
        Folder folder = this.getFolderById(userName, accountId, folderId);
        boolean success = true;
        if (account.getProtocol().equalsIgnoreCase(Utils.IMAP)) {
            try {
                ImapConnector connector = this.openIMAPConnection(userName, account, null);
                if (property.equals(Utils.EXO_STAR)) {
                    if (folder != null && !Utils.isEmptyField(folder.getName())) {
                        success = connector.markIsReadStared(msgList, folder, null, value);
                    } else {
                        ArrayList<Message> l = new ArrayList<Message>();
                        for (Message m : msgList) {
                            folder = this.getFolderById(userName, accountId, m.getFolders()[0]);
                            if (folder == null) continue;
                            l.add(m);
                            success = connector.markIsReadStared(l, folder, null, value);
                        }
                    }
                } else if (property.equals(Utils.EXO_ISUNREAD)) {
                    if (folder != null && !Utils.isEmptyField(folder.getName())) {
                        success = value ? connector.markIsReadStared(msgList, folder, false, null) : connector.markIsReadStared(msgList, folder, true, null);
                    } else {
                        for (Message m : msgList) {
                            folder = this.getFolderById(userName, accountId, m.getFolders()[0]);
                            if (folder == null) continue;
                            ArrayList<Message> l = new ArrayList<Message>();
                            l.add(m);
                            if (value) {
                                success = connector.markIsReadStared(msgList, folder, false, null);
                                continue;
                            }
                            success = connector.markIsReadStared(msgList, folder, true, null);
                        }
                    }
                }
            }
            catch (Exception e) {
                return;
            }
        }
        if (success) {
            this.storage_.toggleMessageProperty(userName, accountId, msgList, property, value);
        }
    }

    @Override
    public String getFolderHomePath(String userName, String accountId) throws Exception {
        return this.storage_.getFolderHomePath(userName, accountId);
    }

    @Override
    public List<Folder> getSubFolders(String userName, String accountId, String parentPath) throws Exception {
        if (this.isDelegatedAccount(userName, accountId)) {
            userName = this.getDelegatedAccount(userName, accountId).getDelegateFrom();
        }
        return this.storage_.getSubFolders(userName, accountId, parentPath);
    }

    @Override
    public List<Message> getReferencedMessages(String userName, String accountId, String msgPath) throws Exception {
        return this.storage_.getReferencedMessages(userName, accountId, msgPath);
    }

    @Override
    public Account getDefaultAccount(String userName) throws Exception {
        MailSetting mailSetting = this.storage_.getMailSetting(userName);
        String defaultAccount = mailSetting.getDefaultAccount();
        Account account = null;
        if (defaultAccount != null) {
            account = this.getAccountById(userName, defaultAccount);
        } else {
            List<Account> accList = this.getAccounts(userName);
            if (accList.size() > 0) {
                account = this.getAccounts(userName).get(0);
            }
        }
        return account;
    }

    @Override
    public Message loadTotalMessage(String userName, String accountId, Message msg) throws Exception {
        Account account = this.getAccountById(userName, accountId);
        try {
            if (account.getProtocol().equals(Utils.IMAP)) {
                if (msg.isLoaded()) {
                    msg = this.storage_.loadTotalMessage(userName, accountId, msg);
                } else {
                    ImapConnector connector = this.openIMAPConnection(userName, account, null);
                    if (connector != null) {
                        String url = this.getFolderById(userName, accountId, msg.getFolders()[0]).getURLName();
                        javax.mail.Message message = connector.getMessageByUID(msg.getUID(), url);
                        msg = this.storage_.loadTotalMessage(userName, accountId, msg, message);
                    }
                }
            } else if (account.getProtocol().equals(Utils.POP3)) {
                msg = this.storage_.loadTotalMessage(userName, accountId, msg);
            }
        }
        catch (Exception e) {
            try {
                msg = this.storage_.loadTotalMessage(userName, accountId, msg, null);
            }
            catch (Exception ex) {
                // empty catch block
            }
            logger.info((Object)"Download content failure", (Throwable)e);
        }
        return msg;
    }

    public void start() {
        for (MailUpdateStorageEventListener updateListener : this.listeners_) {
            updateListener.preUpdate();
        }
    }

    public void stop() {
    }

    @Override
    public synchronized void addListenerPlugin(ComponentPlugin listener) throws Exception {
        if (listener instanceof MailUpdateStorageEventListener) {
            this.listeners_.add((MailUpdateStorageEventListener)listener);
        }
    }

    private Properties getAccountProperties(Account acc) {
        Properties props = System.getProperties();
        String smtpUser = acc.getIncomingUser();
        String outgoingHost = acc.getOutgoingHost();
        String outgoingPort = acc.getOutgoingPort();
        String isSSl = acc.getServerProperties().get(Utils.SVR_OUTGOING_SSL);
        props.put(Utils.SVR_SMTP_USER, smtpUser);
        props.put(Utils.SVR_SMTP_HOST, outgoingHost);
        props.put(Utils.SVR_SMTP_PORT, outgoingPort);
        props.put("mail.smtp.dsn.notify", "SUCCESS,FAILURE ORCPT=rfc822;" + acc.getEmailAddress());
        props.put("mail.smtp.dsn.ret", "FULL");
        props.put("mail.smtp.socketFactory.port", outgoingPort);
        props.put(Utils.SVR_SMTP_AUTH, "true");
        props.put(Utils.SVR_SMTP_SOCKET_FACTORY_FALLBACK, "true");
        props.put("mail.smtp.connectiontimeout", "0");
        props.put("mail.smtp.timeout", "0");
        String socketFactoryClass = "javax.net.SocketFactory";
        if (Boolean.valueOf(isSSl).booleanValue()) {
            socketFactoryClass = Utils.SSL_FACTORY;
            props.put(Utils.SVR_SMTP_STARTTLS_ENABLE, "true");
            props.put("mail.smtp.ssl.protocols", "SSLv3 TLSv1");
        }
        props.put(Utils.SVR_SMTP_SOCKET_FACTORY_CLASS, socketFactoryClass);
        return props;
    }

    @Override
    public boolean sendReturnReceipt(String userName, String accId, String msgId, ResourceBundle res) throws Exception {
        Account acc = this.getAccountById(userName, accId);
        Message msg = this.getMessageById(userName, accId, msgId);
        String subject = new String("Disposition notification");
        String text = new String("The message sent on {0} to {1} with subject \"{2}\" has been displayed. This is no guarantee that the message has been read or understood.");
        if (res != null) {
            try {
                subject = res.getString("UIMessagePreview.msg.return-receipt-subject");
            }
            catch (MissingResourceException e) {
                subject = new String("Disposition notification");
            }
            try {
                text = res.getString("UIMessagePreview.msg.return-receipt-text");
            }
            catch (MissingResourceException e) {
                text = new String("The message sent on {0} to {1} with subject \"{2}\" has been displayed. This is no guarantee that the message has been read or understood.");
            }
        }
        text = text.replace("{0}", msg.getSendDate().toString());
        text = text.replace("{1}", msg.getMessageTo());
        text = text.replace("{2}", msg.getSubject());
        Message receiptMsg = new Message();
        receiptMsg.setMessageTo(msg.getFrom());
        receiptMsg.setSubject(subject);
        receiptMsg.setSendDate(new Date());
        DispositionNotification disNotification = new DispositionNotification();
        disNotification.getNotifications().setHeader("Reporting-UA", "cs.exoplatform.com; CS-Mail");
        disNotification.getNotifications().setHeader("MDN-Gateway", "smtp; " + acc.getOutgoingHost());
        disNotification.getNotifications().setHeader("Original-Recipient", "rfc822; " + msg.getFrom());
        disNotification.getNotifications().setHeader("Final-Recipient", "rfc822; " + acc.getUserDisplayName() + "<" + acc.getEmailAddress() + ">");
        disNotification.getNotifications().setHeader("Original-Message-ID", msg.getId());
        disNotification.getNotifications().setHeader("Disposition", "manual-action/MDN-sent-automatically; displayed");
        MultipartReport report = new MultipartReport(text, disNotification);
        Properties props = this.getAccountProperties(acc);
        Session session = Session.getDefaultInstance((Properties)props, null);
        logger.debug((Object)" #### Sending email ... ");
        SMTPTransport transport = (SMTPTransport)session.getTransport("smtp");
        try {
            if (!acc.isOutgoingAuthentication()) {
                transport.connect();
            } else if (acc.useIncomingSettingForOutgoingAuthent()) {
                transport.connect(acc.getOutgoingHost(), Integer.parseInt(acc.getOutgoingPort()), acc.getIncomingUser(), acc.getIncomingPassword());
            } else {
                transport.connect(acc.getOutgoingHost(), Integer.parseInt(acc.getOutgoingPort()), acc.getOutgoingUserName(), acc.getOutgoingPassword());
            }
        }
        catch (Exception ex) {
            logger.debug((Object)"#### Can not connect to smtp server ...");
            throw ex;
        }
        MailcapCommandMap mailcap = (MailcapCommandMap)CommandMap.getDefaultCommandMap();
        mailcap.addMailcap("message/disposition-notification;; x-java-content-handler=org.exoplatform.mail.service.impl.Message_DispositionNotification");
        CommandMap.setDefaultCommandMap((CommandMap)mailcap);
        this.sendReturnReceipt(session, (Transport)transport, receiptMsg, report);
        transport.close();
        return true;
    }

    private void sendReturnReceipt(Session session, Transport transport, Message message, MultipartReport report) throws Exception {
        MimeMessage mimeMessage = new MimeMessage(session);
        String status = "";
        mimeMessage.setHeader("Message-ID", message.getId());
        mimeMessage.setHeader("Content-Transfer-Encoding", "utf-8");
        InternetAddress addressFrom = message.getFrom() != null ? new InternetAddress(message.getFrom()) : new InternetAddress(session.getProperties().getProperty(Utils.SVR_SMTP_USER));
        mimeMessage.setFrom((Address)addressFrom);
        if (message.getMessageTo() != null) {
            mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)message.getMessageTo()));
        }
        mimeMessage.setSubject(message.getSubject(), "UTF-8");
        mimeMessage.setSentDate(message.getSendDate());
        mimeMessage.setContent((Multipart)report);
        mimeMessage.saveChanges();
        try {
            transport.sendMessage((javax.mail.Message)mimeMessage, mimeMessage.getAllRecipients());
            status = "Mail Delivered !";
        }
        catch (AddressException e) {
            status = "There was an error parsing the addresses. Sending Failed !" + e.getMessage();
            throw e;
        }
        catch (AuthenticationFailedException e) {
            status = "The Username or Password may be wrong. Sending Failed !" + e.getMessage();
            throw e;
        }
        catch (SMTPSendFailedException e) {
            status = "Sorry, There was an error sending the message. Sending Failed !" + e.getMessage();
            throw e;
        }
        catch (MessagingException e) {
            status = "There was an unexpected error. Sending Failed ! " + e.getMessage();
            throw e;
        }
        catch (Exception e) {
            status = "There was an unexpected error. Sending Falied !" + e.getMessage();
            throw e;
        }
        logger.debug((Object)(" #### Info : " + status));
    }

    @Override
    public ContinuationService getContinuationService() {
        return this.continuationService_;
    }

    @Override
    public void setContinuationService(ContinuationService continuationService) {
        this.continuationService_ = continuationService;
    }

    @Override
    public void updateCheckingMailStatusByCometd(String userName, String accountId, CheckingInfo info) {
        block4: {
            if (info != null && info.hasChanged()) {
                try {
                    JsonGeneratorImpl generatorImpl = new JsonGeneratorImpl();
                    JsonValue json = generatorImpl.createJsonObject((Object)info.getStatus());
                    this.continuationService_.sendMessage(userName, "/eXo/Application/mail/ckmailsts/" + accountId, (Object)json);
                    info.setHasChanged(false);
                }
                catch (JsonException je) {
                    logger.warn((Object)("can not send cometd message to client [ " + userName + " ]!"), (Throwable)je);
                }
                catch (Exception e) {
                    if (!logger.isDebugEnabled()) break block4;
                    logger.debug((Object)("n\n can not send update message to UI " + e.getMessage()));
                }
            }
        }
    }

    @Override
    public BufferAttachment getAttachmentFromDMS(String userName, String relPath) throws Exception {
        return this.storage_.getAttachmentFromDMS(userName, relPath);
    }

    @Override
    public String[] getDMSDataInfo(String userName) throws Exception {
        return this.storage_.getDMSDataInfo(userName);
    }

    @Override
    public Node getDMSSelectedNode(String userName, String relPath) throws Exception {
        return this.storage_.getDMSSelectedNode(userName, relPath);
    }

    @Override
    public void delegateAccount(String sender, String revieve, String accountId, String permisison) throws Exception {
        Account acc = this.storage_.getAccountById(sender, accountId);
        this.storage_.delegateAccount(sender, revieve, accountId);
        Map<String, String> oldPermission = acc.getPermissions();
        if (oldPermission == null) {
            oldPermission = new HashMap<String, String>();
        }
        oldPermission.put(revieve, permisison);
        acc.setPermissions(oldPermission);
        this.storage_.saveAccount(sender, acc, false);
    }

    @Override
    public List<Account> getDelegatedAccounts(String userId) throws Exception {
        return this.storage_.getDelegateAccounts(userId);
    }

    @Override
    public void removeDelegateAccount(String userId, String receiver, String accountId) throws Exception {
        Account acc = this.storage_.getAccountById(userId, accountId);
        this.storage_.removeDelegateAccount(receiver, accountId);
        Map<String, String> oldPermission = acc.getPermissions();
        oldPermission.remove(receiver);
        acc.setPermissions(oldPermission);
        this.storage_.saveAccount(userId, acc, false);
    }

    @Override
    public Account getDelegatedAccount(String userId, String accountId) throws Exception {
        for (Account acc : this.storage_.getDelegateAccounts(userId)) {
            if (!accountId.equalsIgnoreCase(acc.getId())) continue;
            return acc;
        }
        return null;
    }

    private boolean isDelegatedAccount(String id, String accId) {
        try {
            return this.getDelegatedAccount(id, accId) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public String getDelegatorUserName(String currentUserName, String accountId) throws Exception {
        if (this.isDelegatedAccount(currentUserName, accountId)) {
            return this.getDelegatedAccount(currentUserName, accountId).getDelegateFrom();
        }
        return null;
    }

    private boolean saveMessage(boolean isImap, String folderId, LinkedHashMap<javax.mail.Message, List<String>> msgMap, String username, String accountId, javax.mail.Message msg, javax.mail.Folder folder) {
        String[] folderIds = new String[]{folderId};
        ArrayList<String> folderList = new ArrayList<String>();
        ArrayList<String> tagList = new ArrayList<String>();
        List<String> filterList = msgMap.get(msg);
        boolean saved = false;
        if (filterList != null && filterList.size() > 0) {
            for (int j = 0; j < filterList.size(); ++j) {
                MessageFilter filter = null;
                try {
                    filter = this.getFilterById(username, accountId, filterList.get(j));
                }
                catch (Exception e) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Cannot get Filter. ", (Throwable)e);
                    }
                    return false;
                }
                folderList.add(filter.getApplyFolder());
                String tagId = filter.getApplyTag();
                if (tagId == null || tagId.trim().length() <= 0) continue;
                tagList.add(tagId);
            }
            folderIds = folderList.toArray(new String[0]);
        }
        for (int k = 0; k < folderIds.length; ++k) {
            if (this.folderStr.indexOf(folderIds[k] + COMMA) != -1) continue;
            this.folderStr = this.folderStr + folderIds[k] + COMMA;
        }
        Info infoObj = new Info();
        infoObj.setFolders(this.folderStr);
        try {
            SpamFilter spamFilter = this.getSpamFilter(username, this.getAccountById(username, accountId).getId());
            if (isImap) {
                long msgUID = ((IMAPFolder)folder).getUID(msg);
                saved = this.storage_.saveMessage(username, accountId, msgUID, msg, folderIds, tagList, spamFilter, infoObj, this.continuationService_, false, username);
            } else {
                saved = this.storage_.savePOP3Message(username, accountId, msg, folderIds, tagList, spamFilter, infoObj, this.continuationService_, username);
            }
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Cannot save message. ", (Throwable)e);
            }
            return false;
        }
        return saved;
    }

    @Override
    public void addPlugin(ComponentPlugin plugin) {
        if (plugin instanceof MailSettingConfigPlugin) {
            MailSettingConfigPlugin mailConfigPlugin = (MailSettingConfigPlugin)plugin;
            this.settingPlugins.put(mailConfigPlugin.getName(), mailConfigPlugin);
        }
    }

    @Override
    public Map<String, MailSettingConfigPlugin> getSettingConfig() {
        return this.settingPlugins;
    }

    @Override
    public List<String> getListOfMessageIds(String username, MessageFilter filter) throws Exception {
        return this.storage_.getListOfMessageIds(username, filter);
    }

    @Override
    public void closeAllMailConnectionByUser(String username) throws Exception {
        Map<String, Object> connectionCache = this.connectionStore.get(username);
        if (connectionCache != null) {
            for (Object obj : connectionCache.values()) {
                if (!(obj instanceof BaseConnector)) continue;
                BaseConnector connector = (BaseConnector)obj;
                connector.close();
            }
            this.connectionStore.remove(username);
        }
    }

    class CheckMailInteruptedException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private String message;

        public CheckMailInteruptedException(String msg) {
            this.message = msg;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

