/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.config.parsing.element;

import java.util.LinkedList;
import java.util.Properties;
import org.jboss.cache.config.ConfigurationException;
import org.jboss.cache.config.EvictionAlgorithmConfig;
import org.jboss.cache.config.EvictionConfig;
import org.jboss.cache.config.EvictionRegionConfig;
import org.jboss.cache.config.MissingPolicyException;
import org.jboss.cache.config.parsing.XmlConfigHelper;
import org.jboss.cache.config.parsing.XmlParserBase;
import org.jboss.cache.eviction.EvictionAlgorithm;
import org.jboss.cache.util.Util;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class EvictionElementParser
extends XmlParserBase {
    public EvictionElementParser() {
        this("urn:jboss:jbosscache-core:config:3.2");
    }

    public EvictionElementParser(String coreNamespace) {
        this.coreNamespace = coreNamespace;
    }

    public EvictionConfig parseEvictionElement(Element evictionElement) {
        this.assertNotLegacyElement(evictionElement);
        EvictionConfig evictionConfig = new EvictionConfig();
        String wakeUpInterval = this.getAttributeValue(evictionElement, "wakeUpInterval");
        if (!this.existsAttribute(wakeUpInterval)) {
            throw new ConfigurationException("Missing mandatory attribute wakeUpInterval");
        }
        evictionConfig.setWakeupInterval(this.getInt(wakeUpInterval));
        LinkedList<EvictionRegionConfig> evictionRegionConfigs = new LinkedList<EvictionRegionConfig>();
        Element defaultRegion = this.getSingleElementInCoreNS("default", evictionElement);
        if (defaultRegion != null) {
            EvictionRegionConfig defaultRegionConfig = this.getEvictionRegionConfig(defaultRegion, null, true);
            if (defaultRegionConfig.getEvictionAlgorithmConfig() == null) {
                throw new MissingPolicyException("Default eviction region should have an evictionAlgorithmClass defined.");
            }
            evictionConfig.setDefaultEvictionRegionConfig(defaultRegionConfig);
        }
        NodeList regions = evictionElement.getElementsByTagName("region");
        for (int i = 0; i < regions.getLength(); ++i) {
            Element regionConfig = (Element)regions.item(i);
            EvictionRegionConfig erc = this.getEvictionRegionConfig(regionConfig, evictionConfig.getDefaultEvictionRegionConfig(), false);
            evictionConfig.applyDefaults(erc);
            evictionRegionConfigs.add(erc);
        }
        evictionConfig.setEvictionRegionConfigs(evictionRegionConfigs);
        return evictionConfig;
    }

    private EvictionRegionConfig getEvictionRegionConfig(Element element, EvictionRegionConfig defaultRegion, boolean isDefault) {
        String actionPolicyClass;
        EvictionRegionConfig erc = new EvictionRegionConfig();
        erc.setRegionName(this.getAttributeValue(element, "name"));
        String queueSize = this.getAttributeValue(element, "eventQueueSize");
        if (this.existsAttribute(queueSize)) {
            erc.setEventQueueSize(this.getInt(queueSize));
        } else if (defaultRegion == null) {
            erc.setEventQueueSize(200000);
        }
        String algorithmClassName = this.getAttributeValue(element, "algorithmClass");
        EvictionAlgorithmConfig algorithmConfig = null;
        if (this.existsAttribute(algorithmClassName)) {
            EvictionAlgorithm algorithm;
            Class algorithmClass;
            try {
                algorithmClass = Util.loadClass(algorithmClassName);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to load eviction algorithm class [" + algorithmClassName + "]", e);
            }
            try {
                algorithm = (EvictionAlgorithm)Util.getInstance(algorithmClass);
            }
            catch (Exception e) {
                throw new ConfigurationException("Unable to construct eviction algorithm class [" + algorithmClassName + "]", e);
            }
            try {
                algorithmConfig = Util.getInstance(algorithm.getConfigurationClass());
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to instantiate eviction algorithm configuration class [" + algorithm.getConfigurationClass() + "]", e);
            }
        }
        if (!isDefault) {
            if (defaultRegion == null || defaultRegion.getEvictionAlgorithmConfig() == null) {
                throw new MissingPolicyException("There is no Eviction Algorithm Class specified on the region or for the entire cache!");
            }
            try {
                algorithmConfig = defaultRegion.getEvictionAlgorithmConfig().clone();
            }
            catch (CloneNotSupportedException e) {
                throw new ConfigurationException("Unable to clone eviction algorithm configuration from default", e);
            }
        }
        if (algorithmConfig != null) {
            EvictionElementParser.parseEvictionPolicyConfig(element, algorithmConfig);
            erc.setEvictionAlgorithmConfig(algorithmConfig);
        }
        if (this.existsAttribute(actionPolicyClass = this.getAttributeValue(element, "actionPolicyClass"))) {
            erc.setEvictionActionPolicyClassName(actionPolicyClass);
        } else if (defaultRegion == null) {
            erc.setEvictionActionPolicyClassName(EvictionConfig.EVICTION_ACTION_POLICY_CLASS_DEFAULT);
        }
        return erc;
    }

    public static void parseEvictionPolicyConfig(Element element, EvictionAlgorithmConfig target) {
        Properties p = XmlConfigHelper.extractProperties(element);
        XmlConfigHelper.setValues(target, p, false, true);
    }
}

