/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.starter;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;
import org.jivesoftware.openfire.starter.JiveClassLoader;
import org.jivesoftware.util.Log;

public class ServerStarter {
    private static final String DEFAULT_LIB_DIR = "../lib";
    private static final String DEFAULT_ADMIN_LIB_DIR = "../plugins/admin/webapp/WEB-INF/lib";

    public static void main(String[] args) {
        new ServerStarter().start();
    }

    private void start() {
        try {
            File libDir;
            ClassLoader parent = this.findParentClassLoader();
            String libDirString = System.getProperty("openfire.lib.dir");
            if (libDirString != null) {
                libDir = new File(libDirString);
                if (!libDir.exists()) {
                    Log.warn((String)("Lib directory " + libDirString + " does not exist. Using default " + DEFAULT_LIB_DIR));
                    libDir = new File(DEFAULT_LIB_DIR);
                }
            } else {
                libDir = new File(DEFAULT_LIB_DIR);
            }
            this.unpackArchives(libDir, true);
            String adminLibDirString = System.getProperty("openfireHome");
            adminLibDirString = adminLibDirString == null ? DEFAULT_ADMIN_LIB_DIR : adminLibDirString + "/plugins/admin/webapp/WEB-INF/lib";
            File adminLibDir = new File(adminLibDirString);
            if (adminLibDir.exists()) {
                this.unpackArchives(adminLibDir, false);
            } else {
                Log.warn((String)("Admin Lib Directory " + adminLibDirString + " does not exist. Web admin console may not work."));
            }
            JiveClassLoader loader = new JiveClassLoader(parent, libDir);
            Thread.currentThread().setContextClassLoader(loader);
            Class<?> containerClass = loader.loadClass("org.jivesoftware.openfire.XMPPServer");
            containerClass.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ClassLoader findParentClassLoader() {
        ClassLoader parent = Thread.currentThread().getContextClassLoader();
        if (parent == null && (parent = this.getClass().getClassLoader()) == null) {
            parent = ClassLoader.getSystemClassLoader();
        }
        return parent;
    }

    private void unpackArchives(File libDir, boolean printStatus) {
        File[] packedFiles = libDir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".pack");
            }
        });
        if (packedFiles == null) {
            return;
        }
        boolean unpacked = false;
        for (File packedFile : packedFiles) {
            try {
                String jarName = packedFile.getName().substring(0, packedFile.getName().length() - ".pack".length());
                File jarFile = new File(libDir, jarName);
                if (jarFile.exists()) {
                    jarFile.delete();
                }
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(packedFile));
                JarOutputStream out = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(new File(libDir, jarName))));
                Pack200.Unpacker unpacker = Pack200.newUnpacker();
                if (printStatus) {
                    System.out.print(".");
                }
                unpacker.unpack((InputStream)in, out);
                ((InputStream)in).close();
                out.close();
                packedFile.delete();
                unpacked = true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (unpacked && printStatus) {
            System.out.println();
        }
    }
}

