/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core.mapper.property;

import org.chromattic.core.ArrayType;
import org.chromattic.core.ObjectContext;
import org.chromattic.core.mapper.PropertyMapper;
import org.chromattic.core.vt2.ValueDefinition;
import org.chromattic.metamodel.bean.PropertyInfo;
import org.chromattic.metamodel.bean.SimpleValueInfo;
import org.chromattic.metamodel.bean.ValueKind;
import org.chromattic.metamodel.mapping.ValueMapping;
import org.chromattic.spi.type.SimpleTypeProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCRPropertyMultiValuedPropertyMapper<O extends ObjectContext<O>, E, I, K extends ValueKind.Multi>
extends PropertyMapper<PropertyInfo<SimpleValueInfo<K>, ValueKind.Single>, SimpleValueInfo<K>, O, ValueKind.Single> {
    private final String jcrPropertyName;
    private final ArrayType<?, E> arrayType;
    private final SimpleValueInfo elementType;
    private final ValueDefinition<I, E> vt;

    public JCRPropertyMultiValuedPropertyMapper(Class<O> contextType, SimpleTypeProvider<I, E> vt, ValueMapping<K> info) {
        super(contextType, info);
        ArrayType arrayType;
        Class effective = (Class)((SimpleValueInfo)info.getValue()).getEffectiveType().unwrap();
        ValueKind.Multi valueKind = (ValueKind.Multi)((SimpleValueInfo)info.getValue()).getValueKind();
        if (valueKind == ValueKind.ARRAY) {
            arrayType = effective.isPrimitive() ? ArrayType.primitiveArray(effective) : ArrayType.array(effective);
        } else if (valueKind == ValueKind.LIST) {
            arrayType = ArrayType.list(effective);
        } else {
            throw new AssertionError();
        }
        this.arrayType = arrayType;
        this.jcrPropertyName = info.getPropertyDefinition().getName();
        this.elementType = (SimpleValueInfo)info.getValue();
        this.vt = new ValueDefinition<I, E>(effective, info.getPropertyDefinition().getMetaType(), vt, info.getPropertyDefinition().getDefaultValue());
    }

    @Override
    public Object get(O context) throws Throwable {
        return ((ObjectContext)context).getPropertyValues(this.jcrPropertyName, this.vt, this.arrayType);
    }

    @Override
    public void set(O context, Object value) throws Throwable {
        ((ObjectContext)context).setPropertyValues(this.jcrPropertyName, this.vt, this.arrayType, (Object)value);
    }
}

