/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.bench;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarCategory;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.CalendarSetting;
import org.exoplatform.calendar.service.EventCategory;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.bench.DataInjector;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalendarDataInjector
extends DataInjector {
    private static final Log log = ExoLogger.getLogger(CalendarDataInjector.class);
    private static final String EMPTY = "".intern();
    private int maxCategories = 3;
    private int maxEventCategories = 3;
    private int maxCalendars = 3;
    private int maxEvents = 4;
    private int maxTasks = 4;
    private String baseURL = EMPTY;
    private String typeOfInject = "all";
    private boolean randomize = true;
    private CalendarService calService;
    private String currentUser = EMPTY;
    private CalendarSetting setting = new CalendarSetting();
    private List<EventCategory> eventCategory = new ArrayList<EventCategory>();
    private List<CalendarCategory> categories = new ArrayList<CalendarCategory>();
    private Set<String> eventCategorys = new HashSet<String>();
    private Set<String> categoryIds = new HashSet<String>();
    private Set<String> publicCalendar = new HashSet<String>();
    private Set<String> privateCalendar = new HashSet<String>();
    private List<String> name = new ArrayList<String>();
    private String[] groupShare = new String[]{EMPTY};
    private String[] groups = new String[]{EMPTY};
    private Random rand = new Random();
    private static int clIndex = -1;
    private static int l = 1;

    public CalendarDataInjector(CalendarService calService, InitParams params) {
        this.initParams(params);
        this.calService = calService;
    }

    private void initDatas() {
        String str = "/:*.*";
        this.rand = new Random();
        try {
            Identity identity = ConversationState.getCurrent().getIdentity();
            this.currentUser = identity.getUserId();
            HashSet<String> set = new HashSet<String>(identity.getGroups());
            this.groupShare = new String[set.size() + 1];
            int i = 0;
            for (String string : set) {
                this.groupShare[i] = string + str;
                ++i;
            }
            this.groupShare[i] = this.currentUser;
            set.add(this.currentUser);
            this.groups = set.toArray(new String[set.size()]);
        }
        catch (Exception e) {
            log.info((Object)"Can not inint user...", (Throwable)e);
        }
    }

    public Log getLog() {
        return log;
    }

    private int getParam(InitParams initParams, String param, int df) {
        try {
            return Integer.parseInt(initParams.getValueParam(param).getValue());
        }
        catch (Exception e) {
            return df;
        }
    }

    private boolean getParam(InitParams initParams, String param) {
        try {
            return Boolean.parseBoolean(initParams.getValueParam(param).getValue());
        }
        catch (Exception e) {
            return false;
        }
    }

    private String getParam(InitParams initParams, String param, String df) {
        try {
            return String.valueOf(initParams.getValueParam(param).getValue());
        }
        catch (Exception e) {
            return df;
        }
    }

    public void initParams(InitParams initParams) {
        this.maxCategories = this.getParam(initParams, "mCt", this.maxCategories);
        this.maxEventCategories = this.getParam(initParams, "mEcat", this.maxEventCategories);
        this.maxCalendars = this.getParam(initParams, "mCal", this.maxCalendars);
        this.maxEvents = this.getParam(initParams, "mEv", this.maxEvents);
        this.maxTasks = this.getParam(initParams, "mTa", this.maxTasks);
        this.baseURL = this.getParam(initParams, "baseURL", this.baseURL);
        this.typeOfInject = this.getParam(initParams, "typeOfInject", this.typeOfInject);
        this.randomize = this.getParam(initParams, "rand");
    }

    public void inject(HashMap<String, String> queryParams) throws Exception {
        log.info((Object)"Start inject datas for calendar....");
        this.setHistoryInject();
        if ("all".equals(this.typeOfInject)) {
            if (this.currentUser.length() > 0) {
                this.initPrivateCalendar();
            }
            this.initPublicCalendar();
        } else if ("public".equals(this.typeOfInject)) {
            this.initPublicCalendar();
        } else if (this.currentUser.length() > 0) {
            this.initPrivateCalendar();
        }
    }

    private void removePrivateData() throws Exception {
        try {
            log.info((Object)String.format("removing private datas..... \n  removing %s calendars.....", this.privateCalendar.size()));
            for (String calId : this.privateCalendar) {
                if (this.isEmpty(calId)) continue;
                this.calService.removeUserCalendar(this.currentUser, calId);
            }
            log.info((Object)String.format("removing %s event catetories.....", this.eventCategorys.size()));
            for (String evCatId : this.eventCategorys) {
                if (this.isEmpty(evCatId)) continue;
                this.calService.removeEventCategory(this.currentUser, evCatId);
            }
            log.info((Object)String.format("removing %s catetories.....", this.categoryIds.size()));
            for (String catId : this.categoryIds) {
                if (this.isEmpty(catId)) continue;
                this.calService.removeCalendarCategory(this.currentUser, catId);
            }
        }
        catch (Exception e) {
            log.debug((Object)"Failed to remove private injecter datas", (Throwable)e);
        }
    }

    private void removePublicData() throws Exception {
        try {
            log.info((Object)String.format("remove public datas..... \n  removing %s calendars.....", this.publicCalendar.size()));
            for (String calId : this.publicCalendar) {
                if (this.isEmpty(calId)) continue;
                this.calService.removePublicCalendar(calId);
            }
        }
        catch (Exception e) {
            log.debug((Object)"Failed to remove public injecter datas", (Throwable)e);
        }
    }

    public void reject(HashMap<String, String> queryParams) throws Exception {
        this.setHistoryInject();
        if ("all".equals(this.typeOfInject)) {
            this.removePublicData();
            if (this.currentUser.length() > 0) {
                this.removePrivateData();
            }
        } else if ("public".equals(this.typeOfInject)) {
            this.removePublicData();
        } else if (this.currentUser.length() > 0) {
            this.removePrivateData();
        }
        log.info((Object)"Complated reject datas..");
        this.publicCalendar.clear();
        this.privateCalendar.clear();
        this.eventCategorys.clear();
        this.categoryIds.clear();
        this.saveHistoryInject();
    }

    private void initPublicCalendar() throws Exception {
        List<Calendar> calendars = this.findCalendars(true);
        log.info((Object)"Inject public datas ....");
        int index = 0;
        int size = calendars.size();
        int evs = 0;
        int tas = 0;
        long t1 = System.currentTimeMillis();
        for (Calendar calendar : calendars) {
            long t = System.currentTimeMillis();
            int tasCal = 0;
            int evsCal = 0;
            this.calService.savePublicCalendar(calendar, true);
            this.publicCalendar.add(calendar.getId());
            for (CalendarEvent event : this.findCalendarEvent(calendar.getId(), "2", CalendarEvent.TYPE_EVENT, true)) {
                this.calService.savePublicEvent(calendar.getId(), event, true);
                ++evsCal;
            }
            for (CalendarEvent event : this.findCalendarEvent(calendar.getId(), "2", CalendarEvent.TYPE_TASK, true)) {
                this.calService.savePublicEvent(calendar.getId(), event, true);
                ++tasCal;
            }
            log.info((Object)String.format("Saved Calendar %s/%s with %s Events and %s Tasks in %sms", ++index, size, evsCal, tasCal, System.currentTimeMillis() - t));
            evs += evsCal;
            tas += tasCal;
        }
        log.info((Object)String.format("INITIALIZED: Calendars=%s / Events=%s / Tasks=%s in %sms", this.publicCalendar.size(), evs, tas, System.currentTimeMillis() - t1));
        this.saveHistoryInject();
    }

    private void initPrivateCalendar() throws Exception {
        long t;
        log.info((Object)"Inject private datas ....");
        try {
            this.setting = this.calService.getCalendarSetting(this.currentUser);
            log.info((Object)String.format("Save calendar setting for user %s ....", this.currentUser));
        }
        catch (Exception e) {
            this.setting = this.newCalendarSetting();
            this.calService.saveCalendarSetting(this.currentUser, this.setting);
        }
        long t1 = t = System.currentTimeMillis();
        for (CalendarCategory cate : this.findCalendarCategorys()) {
            this.calService.saveCalendarCategory(this.currentUser, cate, true);
            this.categories.add(cate);
            this.categoryIds.add(cate.getId());
        }
        log.info((Object)String.format("Saved %s calendarCategorys in %sms", this.categories.size(), System.currentTimeMillis() - t));
        t = System.currentTimeMillis();
        List<EventCategory> eventCategories = this.findEventCategorys();
        for (EventCategory evCat : eventCategories) {
            this.calService.saveEventCategory(this.currentUser, evCat, true);
            this.eventCategory.add(evCat);
            this.eventCategorys.add(evCat.getId());
        }
        log.info((Object)String.format("Saved %s eventCategories in %sms", eventCategories.size(), System.currentTimeMillis() - t));
        List<Calendar> calendars = this.findCalendars(false);
        int index = 0;
        int size = calendars.size();
        int evs = 0;
        int tas = 0;
        for (Calendar calendar : calendars) {
            t = System.currentTimeMillis();
            this.calService.saveUserCalendar(this.currentUser, calendar, true);
            this.privateCalendar.add(calendar.getId());
            List<CalendarEvent> events = this.findCalendarEvent(calendar.getId(), "0", CalendarEvent.TYPE_EVENT, false);
            for (CalendarEvent event : events) {
                this.calService.saveUserEvent(this.currentUser, calendar.getId(), event, true);
            }
            int evsCal = events.size();
            evs += evsCal;
            events = this.findCalendarEvent(calendar.getId(), "0", CalendarEvent.TYPE_TASK, false);
            tas += events.size();
            for (CalendarEvent event : events) {
                this.calService.saveUserEvent(this.currentUser, calendar.getId(), event, true);
            }
            log.info((Object)String.format("Saved Calendar %s/%s with %s Events and %s Tasks in %sms", ++index, size, evsCal, events.size(), System.currentTimeMillis() - t));
        }
        log.info((Object)String.format("INITIALIZED CalendarCategorys=%s / EventCategorys=%s / Calendars=%s / Events=%s / Tasks=%s in %sms", this.categories.size(), eventCategories.size(), calendars.size(), evs, tas, System.currentTimeMillis() - t1));
        this.categories.clear();
        this.saveHistoryInject();
    }

    private List<EventCategory> findEventCategorys() throws Exception {
        ArrayList<EventCategory> categories = new ArrayList<EventCategory>();
        int mCat = this.getMaxItem(this.maxEventCategories);
        this.name.clear();
        for (int i = 0; i < mCat; ++i) {
            categories.add(this.newEventCategory());
        }
        return categories;
    }

    private List<CalendarCategory> findCalendarCategorys() throws Exception {
        ArrayList<CalendarCategory> categories = new ArrayList<CalendarCategory>();
        int mCat = this.getMaxItem(this.maxCategories);
        this.name.clear();
        for (int i = 0; i < mCat; ++i) {
            categories.add(this.newCalendarCategory());
        }
        return categories;
    }

    private List<Calendar> findCalendars(boolean isPublic) throws Exception {
        ArrayList<Calendar> calendars = new ArrayList<Calendar>();
        int mCal = this.getMaxItem(this.maxCalendars);
        this.name.clear();
        for (int i = 0; i < mCal; ++i) {
            calendars.add(isPublic ? this.newPublicCalendar() : this.newPrivateCalendar());
        }
        return calendars;
    }

    private List<CalendarEvent> findCalendarEvent(String calendarId, String CalType, String type, boolean isPublic) throws Exception {
        ArrayList<CalendarEvent> calendars = new ArrayList<CalendarEvent>();
        int mCe = type.equals(CalendarEvent.TYPE_EVENT) ? this.getMaxItem(this.maxEvents) : this.getMaxItem(this.maxTasks);
        this.name.clear();
        for (int i = 0; i < mCe; ++i) {
            calendars.add(this.newCalendarEvent(calendarId, CalType, type, isPublic));
        }
        return calendars;
    }

    private int getMaxItem(int maxType) {
        return this.randomize ? new Random(maxType + 1).nextInt(maxType) + 1 : maxType;
    }

    private CalendarCategory newCalendarCategory() {
        CalendarCategory category = new CalendarCategory();
        category.setName(this.calRandomWords(10));
        category.setDescription(this.randomWords(20));
        return category;
    }

    private CalendarSetting newCalendarSetting() {
        CalendarSetting setting = new CalendarSetting();
        setting.setViewType("1");
        setting.setBaseURL(this.baseURL);
        setting.setWeekStartOn(String.valueOf(2));
        setting.setWorkingTimeBegin("08:00");
        setting.setWorkingTimeEnd("18:00");
        setting.setShowWorkingTime(false);
        setting.setLocation("VNM");
        setting.setTimeZone("Asia/Ho_Chi_Minh");
        return setting;
    }

    private Calendar newPrivateCalendar() {
        Calendar calendar = new Calendar();
        calendar.setCalendarOwner(this.currentUser);
        calendar.setCategoryId(this.randomCategory().getId());
        calendar.setDataInit(true);
        calendar.setName(this.calRandomWords(5));
        calendar.setDescription(this.randomWords(20));
        calendar.setCalendarColor(this.getRandomColor());
        calendar.setEditPermission(new String[0]);
        calendar.setGroups(new String[0]);
        calendar.setViewPermission(new String[0]);
        calendar.setPrivateUrl(EMPTY);
        calendar.setPublicUrl(EMPTY);
        calendar.setPublic(false);
        calendar.setLocale(this.setting.getLocation());
        calendar.setTimeZone(this.setting.getTimeZone());
        return calendar;
    }

    private Calendar newPublicCalendar() {
        Calendar calendar = new Calendar();
        calendar.setCalendarOwner(this.currentUser);
        calendar.setDataInit(true);
        calendar.setName(this.calRandomWords(5));
        calendar.setDescription(this.randomWords(20));
        calendar.setCalendarColor(this.getRandomColor());
        calendar.setEditPermission(this.groupShare);
        calendar.setGroups(this.groups);
        calendar.setViewPermission(new String[]{"*.*"});
        calendar.setPrivateUrl(EMPTY);
        calendar.setPublicUrl(EMPTY);
        calendar.setPublic(true);
        calendar.setLocale("VNM");
        calendar.setTimeZone("Asia/Ho_Chi_Minh");
        return calendar;
    }

    private EventCategory newEventCategory() {
        EventCategory eventCategory = new EventCategory();
        eventCategory.setDataInit(true);
        eventCategory.setDescription(this.randomWords(20));
        eventCategory.setName(this.calRandomWords(5));
        return eventCategory;
    }

    private CalendarEvent newCalendarEvent(String calendarId, String CalType, String type, boolean isPublic) {
        CalendarEvent categoryEvent = new CalendarEvent();
        categoryEvent.setCalendarId(calendarId);
        categoryEvent.setCalType(CalType);
        categoryEvent.setDescription(this.randomWords(20));
        if (!isPublic) {
            EventCategory eventCategory = this.randomEventCategory();
            categoryEvent.setEventCategoryId(eventCategory.getId());
            categoryEvent.setEventCategoryName(eventCategory.getName());
        }
        categoryEvent.setEventState(this.randomState());
        categoryEvent.setEventType(type);
        long time = this.randomDateTime(this.rand.nextInt(365), 0L);
        categoryEvent.setFromDateTime(this.getTime(time));
        time = this.randomDateTime(this.rand.nextInt(5), time);
        categoryEvent.setToDateTime(this.getTime(time));
        categoryEvent.setLocation(this.setting.getLocation());
        categoryEvent.setMessage(this.randomWords(30));
        categoryEvent.setInvitation(new String[]{EMPTY});
        categoryEvent.setParticipant(new String[]{this.currentUser});
        categoryEvent.setParticipantStatus(new String[]{this.currentUser + ":"});
        categoryEvent.setPriority(CalendarEvent.PRIORITY[this.rand.nextInt(CalendarEvent.PRIORITY.length)]);
        categoryEvent.setSendOption(CalendarSetting.ACTION_NEVER);
        categoryEvent.setStatus(EMPTY);
        categoryEvent.setTaskDelegator(EMPTY);
        categoryEvent.setRepeatType(CalendarEvent.REPEATTYPES[this.rand.nextInt(CalendarEvent.REPEATTYPES.length)]);
        categoryEvent.setSummary(this.calRandomWords(5));
        categoryEvent.setPrivate(!isPublic);
        return categoryEvent;
    }

    private String randomState() {
        String[] srts = new String[]{CalendarEvent.ST_AVAILABLE, CalendarEvent.ST_BUSY, CalendarEvent.ST_OUTSIDE};
        return srts[this.rand.nextInt(srts.length)];
    }

    private String calRandomWords(int i) {
        String s = "qwertyuiopasdfghjkzxcvbnm";
        s = this.randomWords(i) + String.valueOf(s.charAt(new Random().nextInt(s.length())));
        if (this.name.contains(s)) {
            return this.calRandomWords(i + 1);
        }
        this.name.add(s);
        return s;
    }

    private String getRandomColor() {
        if (clIndex <= 0) {
            l = 1;
        } else if (clIndex >= Calendar.COLORS.length - 1) {
            l = -1;
        }
        return Calendar.COLORS[clIndex += l];
    }

    private long randomDateTime(long days, long oldTime) {
        long time = (this.rand.nextInt(107) + 7) * 600000;
        if (days > 0L) {
            time = days * 86400000L + time / 10L;
        }
        if (oldTime > 0L) {
            time += oldTime;
        }
        return time;
    }

    private Date getTime(long time) {
        java.util.Calendar calendar = GregorianCalendar.getInstance();
        calendar.setLenient(false);
        long gmtoffset = calendar.get(16) + calendar.get(15);
        calendar.setTimeInMillis(System.currentTimeMillis() - gmtoffset + time);
        return calendar.getTime();
    }

    private CalendarCategory randomCategory() {
        int i = this.categories.size();
        return this.categories.get(new Random().nextInt(i));
    }

    private EventCategory randomEventCategory() {
        int i = this.eventCategory.size();
        return this.eventCategory.get(new Random().nextInt(i));
    }

    private void saveHistoryInject() throws Exception {
        this.baseURL = this.publicCalendar.toString();
        this.baseURL = this.baseURL + ";" + this.privateCalendar.toString();
        this.baseURL = this.baseURL + ";" + this.eventCategorys.toString();
        this.baseURL = this.baseURL + ";" + this.categoryIds.toString();
        this.setting.setBaseURL(this.baseURL);
        this.calService.saveCalendarSetting(this.currentUser, this.setting);
    }

    private void setHistoryInject() {
        this.initDatas();
        try {
            String s = this.calService.getCalendarSetting(this.currentUser).getBaseURL();
            if (!this.isEmpty(s) && s.indexOf(";") > 0) {
                String[] strs = s.split(";");
                this.publicCalendar.addAll(this.convertStringToList(strs[0]));
                this.privateCalendar.addAll(this.convertStringToList(strs[1]));
                this.eventCategorys.addAll(this.convertStringToList(strs[2]));
                this.categoryIds.addAll(this.convertStringToList(strs[3]));
            }
        }
        catch (Exception e) {
            log.warn((Object)"Failed to get calendar settings", (Throwable)e);
        }
    }

    private List<String> convertStringToList(String s) {
        s = s.replace("[", "").replace("]", "");
        s = s.trim().replaceAll("(,\\s*)", ",").replaceAll("(\\s*,)", ",");
        String[] strs = s.split(",");
        return new ArrayList<String>(Arrays.asList(strs));
    }

    private boolean isEmpty(String s) {
        return s == null || s.trim().length() <= 0;
    }

    public Object execute(HashMap<String, String> arg0) throws Exception {
        return new Object();
    }
}

