/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.frameworks.jcr.cli;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import org.exoplatform.frameworks.jcr.cli.AbstractCliCommand;
import org.exoplatform.frameworks.jcr.cli.CliAppContext;

public class GetNodesCommand
extends AbstractCliCommand {
    public boolean perform(CliAppContext ctx) {
        StringBuilder output = new StringBuilder();
        try {
            if (ctx.getCurrentItem().isNode()) {
                Node currentNode = (Node)ctx.getCurrentItem();
                PropertyIterator propertyIterator = currentNode.getProperties();
                output.append("Properties list for ").append(currentNode.getPath()).append(":\n");
                while (propertyIterator.hasNext()) {
                    Property property = propertyIterator.nextProperty();
                    output.append(property.getName()).append("\n");
                }
                NodeIterator nodeIterator = currentNode.getNodes();
                output.append("Nodes list for ").append(currentNode.getPath()).append(":\n");
                while (nodeIterator.hasNext()) {
                    Node node = nodeIterator.nextNode();
                    output.append(node.getPath()).append("\n");
                }
            } else {
                output.append("Current item is property: ").append(((Property)ctx.getCurrentItem()).getName()).append("\n");
            }
        }
        catch (RepositoryException e) {
            output = new StringBuilder("Can't execute command - ").append(e.getMessage()).append("\n");
        }
        ctx.setOutput(output.toString());
        return false;
    }
}

