/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webservice.cs.chat;

import javax.jcr.Node;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.rest.HTTPMethod;
import org.exoplatform.services.rest.InputTransformer;
import org.exoplatform.services.rest.OutputTransformer;
import org.exoplatform.services.rest.Response;
import org.exoplatform.services.rest.URIParam;
import org.exoplatform.services.rest.URITemplate;
import org.exoplatform.services.rest.container.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.webservice.cs.bean.UIStateDataBean;
import org.exoplatform.ws.frameworks.json.transformer.Bean2JsonOutputTransformer;
import org.exoplatform.ws.frameworks.json.transformer.Json2BeanInputTransformer;

public class UIStateService
implements ResourceContainer {
    public static final String JSON_CONTENT_TYPE = "application/json";
    public static final String APPLICATION_NAME = "eXoChat";
    private static final Log LOG = ExoLogger.getLogger((String)"lr.webservice");
    public static final String JCR_STATE_DATA_NODE_PATH = "eXoChat/uistate";
    public static final String JCR_STATE_NOTE_TYPE = "lr:state";
    public static final String JCR_UI_STATE_NOTE_PROPERTY = "lr:ui";
    private NodeHierarchyCreator nodeHierarchyCreator;

    public UIStateService(NodeHierarchyCreator nodeHierarchyCreator) {
        this.nodeHierarchyCreator = nodeHierarchyCreator;
    }

    @HTTPMethod(value="POST")
    @URITemplate(value="/chat/uistateservice/save/{username}/")
    @InputTransformer(value=Json2BeanInputTransformer.class)
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response saveState(@URIParam(value="username") String userName, UIStateDataBean stateData) throws Exception {
        try {
            Node uiStateNode = this.getPrivateNode(userName);
            uiStateNode.setProperty(JCR_UI_STATE_NOTE_PROPERTY, stateData.getData());
            if (!uiStateNode.isNew()) {
                uiStateNode.save();
            } else {
                uiStateNode.getSession().save();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        UIStateDataBean stateDataBean = new UIStateDataBean("null");
        return Response.Builder.ok((Object)stateDataBean, (String)JSON_CONTENT_TYPE).build();
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/chat/uistateservice/get/{username}/")
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response getState(@URIParam(value="username") String username) throws Exception {
        Node uiStateNode = this.getPrivateNode(username);
        if (uiStateNode.hasProperty(JCR_UI_STATE_NOTE_PROPERTY)) {
            UIStateDataBean stateDataBean = new UIStateDataBean(uiStateNode.getProperty(JCR_UI_STATE_NOTE_PROPERTY).getString());
            return Response.Builder.ok((Object)stateDataBean, (String)JSON_CONTENT_TYPE).build();
        }
        UIStateDataBean stateDataBean = new UIStateDataBean();
        return Response.Builder.ok((Object)stateDataBean, (String)JSON_CONTENT_TYPE).build();
    }

    private Node getPrivateNode(String userName) throws Exception {
        Node applicationNode = this.nodeHierarchyCreator.getUserApplicationNode(this.getSessionProvider(), userName);
        if (!applicationNode.hasNode(APPLICATION_NAME)) {
            applicationNode.addNode(APPLICATION_NAME);
        }
        if (!applicationNode.hasNode(JCR_STATE_DATA_NODE_PATH)) {
            applicationNode.addNode(JCR_STATE_DATA_NODE_PATH, JCR_STATE_NOTE_TYPE);
        }
        applicationNode.getSession().save();
        return applicationNode.getNode(JCR_STATE_DATA_NODE_PATH);
    }

    private SessionProvider getSessionProvider() {
        return new SessionProvider(ConversationState.getCurrent());
    }
}

