/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webservice.cs.calendar;

import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.Utils;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.rest.CacheControl;
import org.exoplatform.services.rest.HTTPMethod;
import org.exoplatform.services.rest.OutputTransformer;
import org.exoplatform.services.rest.Response;
import org.exoplatform.services.rest.URIParam;
import org.exoplatform.services.rest.URITemplate;
import org.exoplatform.services.rest.container.ResourceContainer;
import org.exoplatform.services.rest.transformer.StringOutputTransformer;

public class CalendarWebservice
implements ResourceContainer {
    public static final String JSON_CONTENT_TYPE = "application/json";
    public static final String XML_CONTENT_TYPE = "plain/text";
    public static final String SERVICE_BASED_URL = "/portal/rest/";

    @HTTPMethod(value="GET")
    @URITemplate(value="/cs/calendar/checkPermission/{username}/{calendarId}/{type}/")
    @OutputTransformer(value=StringOutputTransformer.class)
    public Response checkPermission(@URIParam(value="username") String username, @URIParam(value="calendarId") String calendarId, @URIParam(value="type") String type) throws Exception {
        StringBuffer buffer = new StringBuffer();
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        try {
            CalendarService calService = (CalendarService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(CalendarService.class);
            Calendar cal = null;
            buffer.append("{canEdit:0}");
            if (0 == Integer.parseInt(type)) {
                buffer = new StringBuffer("{canEdit:1}");
            } else if (2 == Integer.parseInt(type)) {
                OrganizationService oService = (OrganizationService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(OrganizationService.class);
                if (Utils.canEdit((OrganizationService)oService, (String[])(cal = calService.getGroupCalendar(calendarId)).getEditPermission(), (String)username)) {
                    buffer = new StringBuffer("{canEdit:1}");
                }
            } else if (1 == Integer.parseInt(type) && calService.getSharedCalendars(username, true) != null && Utils.canEdit(null, (String[])(cal = calService.getSharedCalendars(username, true).getCalendarById(calendarId)).getEditPermission(), (String)username)) {
                buffer = new StringBuffer("{canEdit:1}");
            }
        }
        catch (Exception e) {
            buffer = new StringBuffer("{ERROR:500 " + e + "}");
        }
        return Response.Builder.ok((Object)buffer.toString(), (String)JSON_CONTENT_TYPE).cacheControl(cacheControl).build();
    }
}

