/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webservice.cs.mail;

import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.mail.service.CheckingInfo;
import org.exoplatform.mail.service.MailService;
import org.exoplatform.services.rest.CacheControl;
import org.exoplatform.services.rest.HTTPMethod;
import org.exoplatform.services.rest.OutputTransformer;
import org.exoplatform.services.rest.Response;
import org.exoplatform.services.rest.URIParam;
import org.exoplatform.services.rest.URITemplate;
import org.exoplatform.services.rest.container.ResourceContainer;
import org.exoplatform.services.rest.transformer.StringOutputTransformer;

public class MailWebservice
implements ResourceContainer {
    public static final int MIN_SLEEP_TIMEOUT = 100;
    public static final int MAX_TIMEOUT = 16;

    @HTTPMethod(value="GET")
    @URITemplate(value="/cs/mail/checkmail/{username}/{accountId}/{folderId}/")
    @OutputTransformer(value=StringOutputTransformer.class)
    public Response checkMail(@URIParam(value="username") String userName, @URIParam(value="accountId") String accountId, @URIParam(value="folderId") String folderId) throws Exception {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        MailService mailService = (MailService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(MailService.class);
        CheckingInfo checkingInfo = mailService.getCheckingInfo(userName, accountId);
        if (checkingInfo == null) {
            mailService.checkMail(userName, accountId, folderId);
        } else if (folderId != null && folderId.trim().length() > 0 && !folderId.equalsIgnoreCase("checkall")) {
            checkingInfo.setRequestingForFolder_(folderId);
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("<info>");
        buffer.append("  <checkingmail>");
        buffer.append("    <status>101</status>");
        if (checkingInfo != null) {
            buffer.append("    <statusmsg>" + checkingInfo.getStatusMsg() + "</statusmsg>");
        }
        buffer.append("  </checkingmail>");
        buffer.append("</info>");
        return Response.Builder.ok((Object)buffer.toString(), (String)"text/xml").cacheControl(cacheControl).build();
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/cs/mail/stopcheckmail/{username}/{accountId}/")
    @OutputTransformer(value=StringOutputTransformer.class)
    public Response stopCheckMail(@URIParam(value="username") String userName, @URIParam(value="accountId") String accountId) throws Exception {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        MailService mailService = (MailService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(MailService.class);
        StringBuffer buffer = new StringBuffer();
        CheckingInfo checkingInfo = mailService.getCheckingInfo(userName, accountId);
        if (checkingInfo == null) {
            return Response.Builder.serverError().build();
        }
        buffer.append("<info>");
        buffer.append("  <checkingmail>");
        buffer.append("    <status>" + checkingInfo.getStatusCode() + "</status>");
        buffer.append("    <statusmsg>" + checkingInfo.getStatusMsg() + "</statusmsg>");
        buffer.append("  </checkingmail>");
        buffer.append("</info>");
        checkingInfo.setRequestStop(true);
        return Response.Builder.ok((Object)buffer.toString(), (String)"text/xml").cacheControl(cacheControl).build();
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/cs/mail/checkmailjobinfo/{username}/{accountId}/")
    @OutputTransformer(value=StringOutputTransformer.class)
    public Response getCheckMailJobInfo(@URIParam(value="username") String userName, @URIParam(value="accountId") String accountId) throws Exception {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        MailService mailService = (MailService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(MailService.class);
        CheckingInfo checkingInfo = mailService.getCheckingInfo(userName, accountId);
        if (checkingInfo == null) {
            Thread.sleep(100L);
            checkingInfo = mailService.getCheckingInfo(userName, accountId);
            return Response.Builder.serverError().build();
        }
        if (!checkingInfo.hasChanged()) {
            Thread.sleep(100L);
            for (int i = 1; i < 1600 && !checkingInfo.hasChanged(); ++i) {
                Thread.sleep(100L);
            }
        }
        StringBuffer buffer = new StringBuffer();
        if (checkingInfo != null) {
            if (checkingInfo.getStatusCode() == 200 || checkingInfo.getStatusCode() == 102 || checkingInfo.getStatusCode() == 103) {
                buffer.append("<info>");
                buffer.append("  <checkingmail>");
                buffer.append("    <status>" + checkingInfo.getStatusCode() + "</status>");
                buffer.append("    <statusmsg>" + checkingInfo.getStatusMsg() + "</statusmsg>");
                buffer.append("  </checkingmail>");
                buffer.append("</info>");
                mailService.removeCheckingInfo(userName, accountId);
                return Response.Builder.ok((Object)buffer.toString(), (String)"text/xml").cacheControl(cacheControl).build();
            }
            if (checkingInfo.hasChanged()) {
                buffer.append("<info>");
                buffer.append("  <checkingmail>");
                buffer.append("    <status>150</status>");
                buffer.append("    <statusmsg>" + checkingInfo.getStatusMsg() + "</statusmsg>");
                buffer.append("    <total>" + checkingInfo.getTotalMsg() + "</total>");
                buffer.append("    <syncFolderStatus>" + checkingInfo.getSyncFolderStatus() + "</syncFolderStatus>");
                buffer.append("    <completed>" + checkingInfo.getFetching() + "</completed>");
                buffer.append("    <fetchingtofolders>" + checkingInfo.getFetchingToFolders() + "</fetchingtofolders>");
                if (checkingInfo.getMsgId() != null && !checkingInfo.getMsgId().equals("")) {
                    buffer.append("    <messageid>" + checkingInfo.getMsgId().replace("<", "&lt;").replace(">", "&gt;") + "</messageid>");
                }
                buffer.append("  </checkingmail>");
                buffer.append("</info>");
                checkingInfo.setHasChanged(false);
            } else {
                buffer.append("<info>");
                buffer.append("  <checkingmail>");
                buffer.append("    <status>201</status>");
                buffer.append("    <statusmsg>" + checkingInfo.getStatusMsg() + "</statusmsg>");
                buffer.append("  </checkingmail>");
                buffer.append("</info>");
            }
        }
        return Response.Builder.ok((Object)buffer.toString(), (String)"text/xml").cacheControl(cacheControl).build();
    }
}

