/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webservice.cs.calendar;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.Utils;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/cs/calendar")
public class CalendarWebservice
implements ResourceContainer {
    public static final String JSON_CONTENT_TYPE = "application/json";
    public static final String XML_CONTENT_TYPE = "plain/text";
    public static final String SERVICE_BASED_URL = "/portal/rest/";

    @GET
    @Path(value="/checkPermission/{username}/{calendarId}/{type}/")
    public Response checkPermission(@PathParam(value="username") String username, @PathParam(value="calendarId") String calendarId, @PathParam(value="type") String type) throws Exception {
        StringBuffer buffer = new StringBuffer();
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        try {
            CalendarService calService = (CalendarService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(CalendarService.class);
            Calendar cal = null;
            buffer.append("{canEdit:0}");
            if (0 == Integer.parseInt(type)) {
                buffer = new StringBuffer("{canEdit:1}");
            } else if (2 == Integer.parseInt(type)) {
                OrganizationService oService = (OrganizationService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(OrganizationService.class);
                if (Utils.canEdit((OrganizationService)oService, (String[])(cal = calService.getGroupCalendar(calendarId)).getEditPermission(), (String)username)) {
                    buffer = new StringBuffer("{canEdit:1}");
                }
            } else if (1 == Integer.parseInt(type) && calService.getSharedCalendars(username, true) != null && Utils.canEdit(null, (String[])(cal = calService.getSharedCalendars(username, true).getCalendarById(calendarId)).getEditPermission(), (String)username)) {
                buffer = new StringBuffer("{canEdit:1}");
            }
        }
        catch (Exception e) {
            buffer = new StringBuffer("{ERROR:500 " + e + "}");
        }
        return Response.ok((Object)buffer.toString(), (String)JSON_CONTENT_TYPE).cacheControl(cacheControl).build();
    }
}

