/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.webdav.model.constant;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.exoplatform.documents.webdav.model.WebDavItemProperty;

public class PropertyConstants {
    public static final String ALLOW_METHODS = "CANCELUPLOAD, CHECKIN, CHECKOUT, COPY, DELETE, GET, HEAD, LOCK, MKCALENDAR, MKCOL, MOVE, OPTIONS, POST, PROPFIND, PROPPATCH, PUT, REPORT, SEARCH, UNCHECKOUT, UNLOCK, UPDATE, VERSION-CONTROL";
    public static final List<String> ALLOW_METHODS_LIST = Arrays.stream("CANCELUPLOAD, CHECKIN, CHECKOUT, COPY, DELETE, GET, HEAD, LOCK, MKCALENDAR, MKCOL, MOVE, OPTIONS, POST, PROPFIND, PROPPATCH, PUT, REPORT, SEARCH, UNCHECKOUT, UNLOCK, UPDATE, VERSION-CONTROL".split(",")).map(String::trim).toList();
    public static final String REQUEST_SINGLE_PROP = "prop";
    public static final String REQUEST_SINGLE_PROP_NAME = "propname";
    public static final String REQUEST_INCLUDED_PROPS = "include";
    public static final String REQUEST_ALL_PROPS = "allprop";
    public static final List<String> ALLOWED_REQUEST_PROP_TYPES = List.of("allprop", "include", "prop", "propname");
    public static final String SUPPORTED_METHOD = "supported-method";
    public static final QName SUPPORTEDMETHOD = new QName("DAV:", "supported-method");
    public static final QName LOCKENTRY = new QName("DAV:", "lockentry");
    public static final QName COLLECTION = new QName("DAV:", "collection");
    public static final QName LOCKTOKEN = new QName("DAV:", "locktoken");
    public static final QName TIMEOUT = new QName("DAV:", "timeout");
    public static final QName DEPTH = new QName("DAV:", "depth");
    public static final QName ACTIVELOCK = new QName("DAV:", "activelock");
    public static final QName CHILDCOUNT = new QName("DAV:", "childcount");
    public static final QName CREATIONDATE = new QName("DAV:", "creationdate");
    public static final QName GET_ETAG = new QName("DAV:", "getetag");
    public static final QName DISPLAYNAME = new QName("DAV:", "displayname");
    public static final QName GETCONTENTLANGUAGE = new QName("DAV:", "getcontentlanguage");
    public static final QName GETCONTENTLENGTH = new QName("DAV:", "getcontentlength");
    public static final QName GETCONTENTTYPE = new QName("DAV:", "getcontenttype");
    public static final QName GETLASTMODIFIED = new QName("DAV:", "getlastmodified");
    public static final QName HASCHILDREN = new QName("DAV:", "haschildren");
    public static final QName ISCOLLECTION = new QName("DAV:", "iscollection");
    public static final QName ISFOLDER = new QName("DAV:", "isfolder");
    public static final QName ISROOT = new QName("DAV:", "isroot");
    public static final QName ISVERSIONED = new QName("DAV:", "isversioned");
    public static final QName PARENTNAME = new QName("DAV:", "parentname");
    public static final QName RESOURCETYPE = new QName("DAV:", "resourcetype");
    public static final QName SUPPORTEDLOCK = new QName("DAV:", "supportedlock");
    public static final QName LOCKDISCOVERY = new QName("DAV:", "lockdiscovery");
    public static final QName SUPPORTEDMETHODSET = new QName("DAV:", "supported-method-set");
    public static final QName LOCKSCOPE = new QName("DAV:", "lockscope");
    public static final QName LOCKTYPE = new QName("DAV:", "locktype");
    public static final QName OWNER = new QName("DAV:", "owner");
    public static final QName EXCLUSIVE = new QName("DAV:", "exclusive");
    public static final QName WRITE = new QName("DAV:", "write");
    public static final QName ORDERING_TYPE = new QName("DAV:", "ordering-type");
    public static final QName JCR_DATA = new QName("jcr:", "data");
    public static final QName JCR_CONTENT = new QName("jcr:", "content");
    public static final QName IS_READ_ONLY = new QName("DAV:", "isreadonly");
    public static final QName DAV_ALLPROP_INCLUDE = new QName("DAV:", "include");
    public static final QName DAV_ALLPROP = new QName("DAV:", "allprop");
    public static final QName PREDECESSORSET = new QName("DAV:", "predecessor-set");
    public static final QName SUCCESSORSET = new QName("DAV:", "successor-set");
    public static final QName VERSIONHISTORY = new QName("DAV:", "version-history");
    public static final QName VERSIONNAME = new QName("DAV:", "version-name");
    public static final QName CHECKEDIN = new QName("DAV:", "checked-in");
    public static final QName CHECKEDOUT = new QName("DAV:", "checked-out");
    public static final QName HREF = new QName("DAV:", "href");
    public static final String CREATION_PATTERN = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    public static final String MODIFICATION_PATTERN = "EEE, dd MMM yyyy HH:mm:ss z";
    public static final String HTTPVER = "HTTP/1.1";
    protected static final Map<Integer, String> HTTP_STATUS_DESCRIPTIONS = new HashMap<Integer, String>();

    private PropertyConstants() {
    }

    public static String getStatusDescription(int status) {
        return String.format("%s %d %s", HTTPVER, status, HTTP_STATUS_DESCRIPTIONS.getOrDefault(status, ""));
    }

    public static WebDavItemProperty getSupportedLock() {
        WebDavItemProperty supportedLock = new WebDavItemProperty(SUPPORTEDLOCK);
        WebDavItemProperty lockEntry = new WebDavItemProperty(LOCKENTRY);
        supportedLock.addChild(lockEntry);
        WebDavItemProperty lockScope = new WebDavItemProperty(LOCKSCOPE);
        lockScope.addChild(new WebDavItemProperty(EXCLUSIVE));
        lockEntry.addChild(lockScope);
        WebDavItemProperty lockType = new WebDavItemProperty(LOCKTYPE);
        lockType.addChild(new WebDavItemProperty(WRITE));
        lockEntry.addChild(lockType);
        return supportedLock;
    }

    public static WebDavItemProperty getLockDiscovery(String token, String lockOwner, String timeOut) {
        WebDavItemProperty lockDiscovery = new WebDavItemProperty(LOCKDISCOVERY);
        WebDavItemProperty activeLock = lockDiscovery.addChild(new WebDavItemProperty(ACTIVELOCK));
        WebDavItemProperty lockType = activeLock.addChild(new WebDavItemProperty(LOCKTYPE));
        lockType.addChild(new WebDavItemProperty(WRITE));
        WebDavItemProperty lockScope = activeLock.addChild(new WebDavItemProperty(LOCKSCOPE));
        lockScope.addChild(new WebDavItemProperty(EXCLUSIVE));
        WebDavItemProperty depth = activeLock.addChild(new WebDavItemProperty(DEPTH));
        depth.setValue("Infinity");
        if (lockOwner != null) {
            WebDavItemProperty owner = activeLock.addChild(new WebDavItemProperty(OWNER));
            owner.setValue(lockOwner);
        }
        WebDavItemProperty timeout = activeLock.addChild(new WebDavItemProperty(TIMEOUT));
        timeout.setValue("Second-" + timeOut);
        if (token != null) {
            WebDavItemProperty lockToken = activeLock.addChild(new WebDavItemProperty(LOCKTOKEN));
            WebDavItemProperty lockHref = lockToken.addChild(new WebDavItemProperty(HREF));
            lockHref.setValue(token);
        }
        return lockDiscovery;
    }

    public static WebDavItemProperty getSupportedMethodSet() {
        WebDavItemProperty supportedMethodProp = new WebDavItemProperty(SUPPORTEDMETHODSET);
        ALLOW_METHODS_LIST.forEach(m -> supportedMethodProp.addChild(new WebDavItemProperty(SUPPORTEDMETHOD)).setAttribute("name", (String)m));
        return supportedMethodProp;
    }

    public static WebDavItemProperty getIsFolderItemProperty() {
        WebDavItemProperty collectionProp = new WebDavItemProperty(COLLECTION);
        WebDavItemProperty resourceType = new WebDavItemProperty(RESOURCETYPE);
        resourceType.addChild(collectionProp);
        return resourceType;
    }

    static {
        HTTP_STATUS_DESCRIPTIONS.put(100, "Continue");
        HTTP_STATUS_DESCRIPTIONS.put(101, "Switching Protocols");
        HTTP_STATUS_DESCRIPTIONS.put(200, "OK");
        HTTP_STATUS_DESCRIPTIONS.put(201, "Created");
        HTTP_STATUS_DESCRIPTIONS.put(202, "Accepted");
        HTTP_STATUS_DESCRIPTIONS.put(203, "Non-Authoritative Information");
        HTTP_STATUS_DESCRIPTIONS.put(204, "No Content");
        HTTP_STATUS_DESCRIPTIONS.put(205, "Reset Content");
        HTTP_STATUS_DESCRIPTIONS.put(206, "Partial Content");
        HTTP_STATUS_DESCRIPTIONS.put(207, "Multi Status");
        HTTP_STATUS_DESCRIPTIONS.put(300, "Multiple Choices");
        HTTP_STATUS_DESCRIPTIONS.put(301, "Moved Permanently");
        HTTP_STATUS_DESCRIPTIONS.put(302, "Found");
        HTTP_STATUS_DESCRIPTIONS.put(303, "See Other");
        HTTP_STATUS_DESCRIPTIONS.put(304, "Not Modified");
        HTTP_STATUS_DESCRIPTIONS.put(305, "Use Proxy");
        HTTP_STATUS_DESCRIPTIONS.put(307, "Temporary Redirect");
        HTTP_STATUS_DESCRIPTIONS.put(400, "Bad Request");
        HTTP_STATUS_DESCRIPTIONS.put(401, "Unauthorized");
        HTTP_STATUS_DESCRIPTIONS.put(402, "Payment Required");
        HTTP_STATUS_DESCRIPTIONS.put(403, "Forbidden");
        HTTP_STATUS_DESCRIPTIONS.put(404, "Not Found");
        HTTP_STATUS_DESCRIPTIONS.put(405, "Method Not Allowed");
        HTTP_STATUS_DESCRIPTIONS.put(406, "Not Acceptable");
        HTTP_STATUS_DESCRIPTIONS.put(407, "Proxy Authentication Required");
        HTTP_STATUS_DESCRIPTIONS.put(408, "Request Timeout");
        HTTP_STATUS_DESCRIPTIONS.put(409, "Conflict");
        HTTP_STATUS_DESCRIPTIONS.put(410, "Gone");
        HTTP_STATUS_DESCRIPTIONS.put(411, "Length Required");
        HTTP_STATUS_DESCRIPTIONS.put(412, "Precondition Failed");
        HTTP_STATUS_DESCRIPTIONS.put(414, "Request Entity Too Large");
        HTTP_STATUS_DESCRIPTIONS.put(414, "Request-URI Too Long");
        HTTP_STATUS_DESCRIPTIONS.put(415, "Unsupported Media Type");
        HTTP_STATUS_DESCRIPTIONS.put(416, "Requested Range Not Satisfiable");
        HTTP_STATUS_DESCRIPTIONS.put(417, "Expectation Failed");
        HTTP_STATUS_DESCRIPTIONS.put(500, "Internal Server Error");
        HTTP_STATUS_DESCRIPTIONS.put(501, "Not Implemented");
        HTTP_STATUS_DESCRIPTIONS.put(502, "Bad Gateway");
        HTTP_STATUS_DESCRIPTIONS.put(503, "Service Unavailable");
        HTTP_STATUS_DESCRIPTIONS.put(504, "Gateway Timeout");
        HTTP_STATUS_DESCRIPTIONS.put(505, "HTTP Version Not Supported");
    }
}

