/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.rest;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.Map;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.documents.constant.DocumentSortField;
import org.exoplatform.documents.constant.FileListingType;
import org.exoplatform.documents.model.AbstractNode;
import org.exoplatform.documents.model.DocumentFolderFilter;
import org.exoplatform.documents.model.DocumentGroupsSize;
import org.exoplatform.documents.model.DocumentNodeFilter;
import org.exoplatform.documents.model.DocumentTimelineFilter;
import org.exoplatform.documents.rest.model.AbstractNodeEntity;
import org.exoplatform.documents.rest.model.FileNodeEntity;
import org.exoplatform.documents.rest.model.NodePermissionEntity;
import org.exoplatform.documents.rest.util.EntityBuilder;
import org.exoplatform.documents.rest.util.RestUtils;
import org.exoplatform.documents.service.DocumentFileService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.http.PATCH;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.metadata.MetadataService;

@Path(value="/v1/documents")
@Tag(name="/v1/documents", description="Manages documents associated to users and spaces")
public class DocumentFileRest
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(DocumentFileRest.class);
    private final DocumentFileService documentFileService;
    private final SpaceService spaceService;
    private final MetadataService metadataService;
    private final IdentityManager identityManager;

    public DocumentFileRest(DocumentFileService documentFileService, SpaceService spaceService, IdentityManager identityManager, MetadataService metadataService) {
        this.documentFileService = documentFileService;
        this.identityManager = identityManager;
        this.spaceService = spaceService;
        this.metadataService = metadataService;
    }

    @GET
    @Produces(value={"text/plain"})
    @RolesAllowed(value={"users"})
    @Path(value="/canAddDocument")
    @Operation(summary="check if the current user can add document", method="GET", description="This checks if the current user can add document.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input")})
    public Response canAddDocument(@Parameter(description="Space technical identifier") @QueryParam(value="spaceId") String spaceId) {
        if (StringUtils.isBlank((CharSequence)spaceId)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"spaceId_is_mandatory").build();
        }
        String currentUserName = RestUtils.getCurrentUser();
        boolean canAdd = this.documentFileService.canAddDocument(spaceId, currentUserName);
        return Response.ok((Object)String.valueOf(canAdd)).build();
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Retrieves the list of document items (folders and files) for an authenticated user switch filter", method="GET", description="Retrieves the list of document items (folders and files) for an authenticated user switch filter.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="404", description="Not found"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getDocumentItems(@Parameter(description="Identity technical identifier") @QueryParam(value="ownerId") Long ownerId, @Parameter(description="Parent folder technical identifier") @QueryParam(value="parentFolderId") String parentFolderId, @Parameter(description="Symlink technical identifier") @QueryParam(value="symlinkFolderId") String symlinkFolderId, @Parameter(description="Parent folder path") @QueryParam(value="folderPath") String folderPath, @Parameter(description="Listing type of folder. Can be 'TIMELINE' or 'FOLDER'.") @QueryParam(value="listingType") FileListingType listingType, @Parameter(description="Search query entered by the user") @QueryParam(value="query") String query, @Parameter(description="extendedSearch") @QueryParam(value="extendedSearch") boolean extendedSearch, @Parameter(description="userId") @QueryParam(value="userId") String userId, @Parameter(description="favorites") @Schema(defaultValue="false") @QueryParam(value="favorites") boolean favorites, @Parameter(description="File properties to expand.") @QueryParam(value="expand") String expand, @Parameter(description="Document items sort field") @QueryParam(value="sortField") String sortField, @Parameter(description="Sort ascending or descending") @QueryParam(value="ascending") boolean ascending, @Parameter(description="Offset of results to return") @Schema(defaultValue="10") @QueryParam(value="offset") int offset, @Parameter(description="Limit of results to return") @Schema(defaultValue="10") @QueryParam(value="limit") int limit, @Parameter(description="showHiddenFiles of results to return") @Schema(defaultValue="false") @QueryParam(value="showHiddenFiles") boolean showHiddenFiles) {
        if (ownerId == null && StringUtils.isBlank((CharSequence)parentFolderId)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"either_ownerId_or_folderId_is_mandatory").build();
        }
        if (listingType == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"listingType_is_mandatory").build();
        }
        long userIdentityId = RestUtils.getCurrentUserIdentityId(this.identityManager);
        try {
            DocumentTimelineFilter filter = listingType == FileListingType.TIMELINE ? new DocumentTimelineFilter(ownerId) : new DocumentFolderFilter(parentFolderId, folderPath, ownerId, symlinkFolderId);
            filter.setQuery(query);
            filter.setExtendedSearch(extendedSearch);
            filter.setFavorites(Boolean.valueOf(favorites));
            filter.setUserId(userId);
            filter.setAscending(ascending);
            filter.setSortField(DocumentSortField.getFromAlias((String)sortField));
            List documents = this.documentFileService.getDocumentItems(listingType, (DocumentNodeFilter)filter, offset, limit, userIdentityId, showHiddenFiles);
            List<AbstractNodeEntity> documentEntities = EntityBuilder.toDocumentItemEntities(this.documentFileService, this.identityManager, this.spaceService, this.metadataService, documents, expand, userIdentityId);
            return Response.ok(documentEntities).build();
        }
        catch (IllegalAccessException e) {
            LOG.warn("User '{}' attempts to access not authorized documents of owner Id '{}'", new Object[]{RestUtils.getCurrentUser(), ownerId, e});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
        catch (ObjectNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error retrieving list of documents", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Path(value="/group/count")
    @Operation(summary="Get documents groups sizes", method="GET", description="Get documents groups sizes")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="404", description="Not found"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getDocumentGroupsCount(@Parameter(description="Identity technical identifier") @QueryParam(value="ownerId") Long ownerId, @QueryParam(value="parentFolderId") String parentFolderId, @Parameter(description="Search query entered by the user") @QueryParam(value="query") String query, @Parameter(description="favorites") @Schema(defaultValue="false") @QueryParam(value="favorites") boolean favorites) {
        if (ownerId == null && StringUtils.isBlank((CharSequence)parentFolderId)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"either_ownerId_or_folderId_is_mandatory").build();
        }
        long userIdentityId = RestUtils.getCurrentUserIdentityId(this.identityManager);
        try {
            DocumentTimelineFilter filter = new DocumentTimelineFilter(ownerId);
            filter.setQuery(query);
            filter.setFavorites(Boolean.valueOf(favorites));
            DocumentGroupsSize documentGroupsSize = this.documentFileService.getGroupDocumentsCount(filter, userIdentityId);
            return Response.ok((Object)documentGroupsSize).build();
        }
        catch (IllegalAccessException e) {
            LOG.warn("User '{}' attempts to access not authorized documents of owner Id '{}'", new Object[]{RestUtils.getCurrentUser(), ownerId, e});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
        catch (ObjectNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error retrieving list of documents", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Path(value="/breadcrumb")
    @Operation(summary="Get breadcrumb of given", method="GET", description="Get breadcrumb of given")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="404", description="Not found"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getBreadcrumb(@Parameter(description="Identity technical identifier", required=false) @QueryParam(value="ownerId") Long ownerId, @Parameter(description="Folder technical identifier") @QueryParam(value="folderId") String folderId, @Parameter(description="Folder path") @QueryParam(value="folderPath") String folderPath) {
        if (ownerId == null && StringUtils.isBlank((CharSequence)folderId)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"either_ownerId_or_folderId_is_mandatory").build();
        }
        long userIdentityId = RestUtils.getCurrentUserIdentityId(this.identityManager);
        try {
            return Response.ok(EntityBuilder.toBreadCrumbItemEntities(this.documentFileService.getBreadcrumb(ownerId.longValue(), folderId, folderPath, userIdentityId))).build();
        }
        catch (IllegalAccessException e) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
        catch (ObjectNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error retrieving breadcrumb", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Path(value="/fullTree")
    @Operation(summary="Get Full Tree of given folder", method="GET", description="Get Full Tree of given folder")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="404", description="Not found"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getFullTreeData(@Parameter(description="Identity technical identifier") @QueryParam(value="ownerId") Long ownerId, @Parameter(description="Folder technical identifier") @QueryParam(value="folderId") String folderId) {
        if (ownerId == null && StringUtils.isBlank((CharSequence)folderId)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"either_ownerId_or_folderId_is_mandatory").build();
        }
        long userIdentityId = RestUtils.getCurrentUserIdentityId(this.identityManager);
        try {
            return Response.ok(EntityBuilder.toFullTreeItemEntities(this.documentFileService.getFullTreeData(ownerId.longValue(), folderId, userIdentityId))).build();
        }
        catch (IllegalAccessException e) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
        catch (ObjectNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error retrieving tree folder", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @POST
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Path(value="/duplicate")
    @Operation(summary="POST DUPLICATE of given document", method="POST", description="POST DUPLICATE of given document")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="404", description="Not found"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response duplicateDocument(@Parameter(description="Identity technical identifier") @QueryParam(value="ownerId") Long ownerId, @Parameter(description="File technical identifier") @QueryParam(value="fileId") String fileId, @Parameter(description="File prefix Clone") @QueryParam(value="prefixClone") String prefixClone, @Parameter(description="File properties to expand.") @QueryParam(value="expand") String expand) {
        if (ownerId == null && StringUtils.isBlank((CharSequence)fileId)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"either_ownerId_or_FileID_is_mandatory").build();
        }
        long userIdentityId = RestUtils.getCurrentUserIdentityId(this.identityManager);
        try {
            AbstractNode abstractNode = this.documentFileService.duplicateDocument(ownerId.longValue(), fileId, prefixClone, userIdentityId);
            AbstractNodeEntity abstractNodeEntity = EntityBuilder.toDocumentItemEntity(this.documentFileService, this.identityManager, this.spaceService, this.metadataService, abstractNode, expand, userIdentityId);
            return Response.ok((Object)abstractNodeEntity).build();
        }
        catch (IllegalAccessException e) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
        catch (ObjectNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error retrieving duplicate file", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @PUT
    @Path(value="/move")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Move documents", method="POST", description="This rename a giving document.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="403", description="Unauthorized operation"), @ApiResponse(responseCode="404", description="Resource not found")})
    public Response moveDocument(@Parameter(description="document id") @QueryParam(value="documentID") String documentID, @Parameter(description="ownerId") @QueryParam(value="ownerId") Long ownerId, @Parameter(description="new path") @QueryParam(value="destPath") String destPath, @Parameter(description="conflict action name") @QueryParam(value="conflictAction") String conflictAction) {
        if (ownerId == null && StringUtils.isBlank((CharSequence)documentID)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"either_ownerId_or_documentID_is_mandatory").build();
        }
        if (StringUtils.isEmpty((CharSequence)destPath)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Document destination path should not be empty").build();
        }
        try {
            long userIdentityId = RestUtils.getCurrentUserIdentityId(this.identityManager);
            this.documentFileService.moveDocument(ownerId.longValue(), documentID, destPath, userIdentityId, conflictAction);
            return Response.ok().build();
        }
        catch (ObjectAlreadyExistsException e) {
            LOG.warn((Object)"Document with same name already exist", (Throwable)e);
            return Response.status((int)409).entity(e.getExistingObject()).type("application/json").build();
        }
        catch (Exception ex) {
            LOG.warn((Object)"Failed to rename Document", (Throwable)ex);
            return Response.status((int)500).build();
        }
    }

    @POST
    @Path(value="/folder")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Add a new Folder", method="POST", description="This adds a new Folder under givin Folder.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="403", description="Unauthorized operation"), @ApiResponse(responseCode="404", description="Resource not found")})
    public Response createFolder(@Parameter(description="parent id") @QueryParam(value="parentid") String parentid, @Parameter(description="folder Path") @QueryParam(value="folderPath") String folderPath, @Parameter(description="owner id") @QueryParam(value="ownerId") Long ownerId, @Parameter(description="folder name") @QueryParam(value="name") String name) {
        if (ownerId == null && StringUtils.isBlank((CharSequence)parentid)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"either_ownerId_or_parentid_is_mandatory").build();
        }
        if (StringUtils.isEmpty((CharSequence)name)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Folder Name should not be empty").build();
        }
        try {
            long userIdentityId = RestUtils.getCurrentUserIdentityId(this.identityManager);
            AbstractNode createdFolder = this.documentFileService.createFolder(ownerId.longValue(), parentid, folderPath, name, userIdentityId);
            AbstractNodeEntity abstractNodeEntity = EntityBuilder.toDocumentItemEntity(this.documentFileService, this.identityManager, this.spaceService, this.metadataService, createdFolder, null, userIdentityId);
            return Response.ok((Object)abstractNodeEntity).build();
        }
        catch (ObjectAlreadyExistsException e) {
            LOG.warn((Object)"Folder with same name already exists", (Throwable)e);
            return Response.status((int)409).build();
        }
        catch (Exception ex) {
            LOG.warn((Object)"Failed to create Folder", (Throwable)ex);
            return Response.status((int)500).build();
        }
    }

    @GET
    @Path(value="/newname")
    @Produces(value={"text/plain"})
    @RolesAllowed(value={"users"})
    @Operation(summary="propose a new name for Folder is there is already a folder with the provided name", method="GET", description="propose a new name for Folder is there is already a folder with the provided name")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="403", description="Unauthorized operation"), @ApiResponse(responseCode="404", description="Resource not found")})
    public Response getNewName(@Parameter(description="parent id") @QueryParam(value="parentid") String parentid, @Parameter(description="folder Path") @QueryParam(value="folderPath") String folderPath, @Parameter(description="ownerId") @QueryParam(value="ownerId") Long ownerId, @Parameter(description="folder name") @QueryParam(value="name") String name) {
        if (ownerId == null && StringUtils.isBlank((CharSequence)parentid)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"either_ownerId_or_parentid_is_mandatory").build();
        }
        if (StringUtils.isEmpty((CharSequence)name)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Folder Name should not be empty").build();
        }
        if (NumberUtils.isNumber((String)name)) {
            LOG.warn((Object)"Folder Name should not be number");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Folder Name should not be number").build();
        }
        try {
            return Response.ok((Object)this.documentFileService.getNewName(ownerId.longValue(), parentid, folderPath, name)).build();
        }
        catch (Exception ex) {
            LOG.warn((Object)"Failed to propose new Folder name", (Throwable)ex);
            return Response.status((int)500).build();
        }
    }

    @PUT
    @Path(value="/rename")
    @RolesAllowed(value={"users"})
    @Operation(summary="Rename documents", method="POST", description="This rename a giving document.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="403", description="Unauthorized operation"), @ApiResponse(responseCode="404", description="Resource not found")})
    public Response renameDocument(@Parameter(description="document id") @QueryParam(value="documentID") String documentID, @Parameter(description="ownerId") @QueryParam(value="ownerId") Long ownerId, @Parameter(description="new name") @QueryParam(value="newName") String newName) {
        if (ownerId == null && StringUtils.isBlank((CharSequence)documentID)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"either_ownerId_or_documentID_is_mandatory").build();
        }
        if (StringUtils.isEmpty((CharSequence)newName)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Document Name should not be empty").build();
        }
        try {
            long userIdentityId = RestUtils.getCurrentUserIdentityId(this.identityManager);
            this.documentFileService.renameDocument(ownerId.longValue(), documentID, newName, userIdentityId);
            return Response.ok().build();
        }
        catch (ObjectAlreadyExistsException ex) {
            LOG.warn((Object)"Document with same name already exists", (Throwable)ex);
            return Response.status((int)409).build();
        }
        catch (Exception ex) {
            LOG.warn((Object)"Failed to rename Document", (Throwable)ex);
            return Response.status((int)500).build();
        }
    }

    @DELETE
    @Path(value="{documentId}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Delete document", method="DELETE", description="This deletes document")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Document deleted"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="User not authorized to delete the document"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response deleteDocument(@Parameter(description="Document id", required=true) @PathParam(value="documentId") String documentId, @Parameter(description="folder path", required=true) @QueryParam(value="document path") String documentPath, @Parameter(description="Is favorite document", required=false) @QueryParam(value="favorite") boolean favorite, @Parameter(description="Time to effectively delete document", required=false) @QueryParam(value="delay") long delay) {
        if (StringUtils.isBlank((CharSequence)documentId)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"document_id_is_mandatory").build();
        }
        long userIdentityId = RestUtils.getCurrentUserIdentityId(this.identityManager);
        try {
            this.documentFileService.deleteDocument(documentPath, documentId, favorite, delay, userIdentityId);
            return Response.ok().build();
        }
        catch (IllegalAccessException e) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            LOG.error((Object)("Error when deleting the news target with name " + userIdentityId), (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="{documentId}/undoDelete")
    @POST
    @RolesAllowed(value={"users"})
    @Operation(summary="Undo deleting document if not yet effectively deleted", method="POST", description="Undo deleting document if not yet effectively deleted")
    @ApiResponses(value={@ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="403", description="Forbidden operation")})
    public Response undoDeleteDocument(@Parameter(description="Document identifier", required=true) @PathParam(value="documentId") String documentId) {
        if (StringUtils.isBlank((CharSequence)documentId)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"document_id_is_mandatory").build();
        }
        long userIdentityId = RestUtils.getCurrentUserIdentityId(this.identityManager);
        this.documentFileService.undoDeleteDocument(documentId, userIdentityId);
        return Response.noContent().build();
    }

    @Path(value="permissions")
    @POST
    @RolesAllowed(value={"users"})
    @Operation(summary="Undo deleting document if not yet effectively deleted", method="POST", description="Undo deleting document if not yet effectively deleted")
    @ApiResponses(value={@ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="403", description="Forbidden operation")})
    public Response updatePermissions(@Parameter(description="Permission object", required=true) FileNodeEntity nodeEntity) {
        if (nodeEntity == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"node_object_is_mandatory").build();
        }
        NodePermissionEntity nodePermissionEntity = nodeEntity.getAcl();
        if (nodePermissionEntity == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"permissions_object_is_mandatory").build();
        }
        long userIdentityId = RestUtils.getCurrentUserIdentityId(this.identityManager);
        try {
            this.documentFileService.updatePermissions(nodeEntity.getId(), EntityBuilder.toNodePermission(nodeEntity, this.documentFileService, this.spaceService, this.identityManager), userIdentityId);
        }
        catch (IllegalAccessException e) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
        return Response.noContent().build();
    }

    @PUT
    @Path(value="/description")
    @RolesAllowed(value={"users"})
    @Operation(summary="update or create a document's description", method="PUT", description="This creates or updates a given document's description.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="403", description="Unauthorized operation"), @ApiResponse(responseCode="404", description="Resource not found")})
    public Response updateDocumentDescription(@Parameter(description="owner id", required=true) @QueryParam(value="ownerId") long ownerId, @Parameter(description="document id", required=true) @QueryParam(value="documentId") String documentId, @Parameter(description="document id", required=true) @QueryParam(value="description") String description) {
        try {
            long userIdentityId = RestUtils.getCurrentUserIdentityId(this.identityManager);
            this.documentFileService.updateDocumentDescription(ownerId, documentId, description, userIdentityId);
            return Response.noContent().build();
        }
        catch (Exception ex) {
            LOG.warn((Object)"Failed to update document description", (Throwable)ex);
            return Response.status((int)500).build();
        }
    }

    @POST
    @Path(value="/shortcut")
    @RolesAllowed(value={"users"})
    @Operation(summary="document shortcut", method="POST", description="Creates a document shortcut.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="403", description="Unauthorized operation"), @ApiResponse(responseCode="404", description="Resource not found")})
    public Response createShortcut(@Parameter(description="document id") @QueryParam(value="documentID") String documentID, @Parameter(description="new path") @QueryParam(value="destPath") String destPath, @Parameter(description="conflict action name") @QueryParam(value="conflictAction") String conflictAction) {
        if (StringUtils.isEmpty((CharSequence)documentID)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Document's id should not be empty").build();
        }
        if (StringUtils.isEmpty((CharSequence)destPath)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Document destination path should not be empty").build();
        }
        try {
            this.documentFileService.createShortcut(documentID, destPath, RestUtils.getCurrentUser(), conflictAction);
            return Response.ok().build();
        }
        catch (ObjectAlreadyExistsException e) {
            LOG.warn((Object)"Document with same name already exists", (Throwable)e);
            return Response.status((int)409).build();
        }
        catch (Exception ex) {
            LOG.warn((Object)"Failed to create document shortcut", (Throwable)ex);
            return Response.status((int)500).build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Path(value="/versions")
    @Operation(summary="Get versions list of a a given document", method="GET", description="Get versions list of a a given document")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="404", description="Not found"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getFileVersions(@Parameter(description="Identity technical identifier", required=true) @QueryParam(value="fileId") String fileId) {
        if (StringUtils.isBlank((CharSequence)fileId)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"file id is mandatory").build();
        }
        long userIdentityId = RestUtils.getCurrentUserIdentityId(this.identityManager);
        if (userIdentityId == 0L) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            return Response.ok((Object)EntityBuilder.toVersionEntities(this.documentFileService.getFileVersions(fileId, RestUtils.getCurrentUser()))).build();
        }
        catch (IllegalArgumentException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error retrieving versions list", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @PATCH
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Path(value="/versions")
    @Operation(summary="update version summary of a give document version", method="GET", description="update version summary of a give document version")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="404", description="Not found"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response updateVersionSummary(@Parameter(description="version summary to update", required=true) Map<String, String> summary, @Parameter(description="original file node identifier", required=true) @QueryParam(value="originFileId") String originFileId, @Parameter(description="version file node identifier", required=true) @QueryParam(value="versionId") String versionId) {
        if (StringUtils.isBlank((CharSequence)versionId) || StringUtils.isBlank((CharSequence)originFileId)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"version fil id and original file id are mandatory").build();
        }
        long userIdentityId = RestUtils.getCurrentUserIdentityId(this.identityManager);
        if (userIdentityId == 0L) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            return Response.ok((Object)EntityBuilder.toVersionEntity(this.documentFileService.updateVersionSummary(originFileId, versionId, summary.get("value"), RestUtils.getCurrentUser()))).build();
        }
        catch (IllegalArgumentException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error while updating version summary", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @PUT
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Path(value="/versions")
    @Operation(summary="Restore a document to a specific version", method="GET", description="Restore a document to a specific version")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="404", description="Not found"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response restoreVersion(@Parameter(description="version file node identifier", required=true) @QueryParam(value="versionId") String versionId) {
        if (StringUtils.isBlank((CharSequence)versionId)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"version fil id is mandatory").build();
        }
        long userIdentityId = RestUtils.getCurrentUserIdentityId(this.identityManager);
        if (userIdentityId == 0L) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            return Response.ok((Object)EntityBuilder.toVersionEntity(this.documentFileService.restoreVersion(versionId, RestUtils.getCurrentUser()))).build();
        }
        catch (IllegalArgumentException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error while restoring version", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }
}

