/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.notification.provider;

import java.io.Writer;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.NotificationMessageUtils;
import org.exoplatform.commons.api.notification.annotation.TemplateConfig;
import org.exoplatform.commons.api.notification.annotation.TemplateConfigs;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.channel.template.TemplateProvider;
import org.exoplatform.commons.api.notification.model.ChannelKey;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.service.template.TemplateContext;
import org.exoplatform.commons.notification.template.TemplateUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.documents.notification.utils.NotificationConstants;
import org.exoplatform.documents.notification.utils.NotificationUtils;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.webui.utils.TimeConvertUtils;

@TemplateConfigs(templates={@TemplateConfig(pluginId="AddDocumentCollaboratorPlugin", template="war:/notification/templates/web/AddDocumentCollaboratorPlugin.gtmpl")})
public class WebTemplateProvider
extends TemplateProvider {
    private final IdentityManager identityManager;

    public WebTemplateProvider(InitParams initParams, IdentityManager identityManager) {
        super(initParams);
        this.templateBuilders.put(PluginKey.key((String)"AddDocumentCollaboratorPlugin"), new TemplateBuilder());
        this.identityManager = identityManager;
    }

    private class TemplateBuilder
    extends AbstractTemplateBuilder {
        private TemplateBuilder() {
        }

        protected MessageInfo makeMessage(NotificationContext notificationContext) {
            NotificationInfo notificationInfo = notificationContext.getNotificationInfo();
            String pluginId = notificationInfo.getKey().getId();
            String fromUser = notificationInfo.getValueOwnerParameter(NotificationConstants.FROM_USER.getKey());
            String documentUrl = notificationInfo.getValueOwnerParameter(NotificationConstants.DOCUMENT_URL.getKey());
            String documentName = notificationInfo.getValueOwnerParameter(NotificationConstants.DOCUMENT_NAME.getKey());
            String language = this.getLanguage(notificationInfo);
            TemplateContext templateContext = TemplateContext.newChannelInstance((ChannelKey)WebTemplateProvider.this.getChannelKey(), (String)pluginId, (String)language);
            templateContext.put((Object)"DOCUMENT_URL", (Object)documentUrl);
            templateContext.put((Object)"DOCUMENT_NAME", (Object)documentName);
            Profile userProfile = NotificationUtils.getUserProfile(WebTemplateProvider.this.identityManager, fromUser);
            templateContext.put((Object)"USER", (Object)userProfile.getFullName());
            templateContext.put((Object)"PROFILE_URL", (Object)userProfile.getUrl());
            templateContext.put((Object)"AVATAR", (Object)userProfile.getAvatarUrl());
            Calendar lastModified = Calendar.getInstance();
            lastModified.setTimeInMillis(notificationInfo.getLastModifiedDate());
            templateContext.put((Object)"LAST_UPDATED_TIME", (Object)TimeConvertUtils.convertXTimeAgoByTimeServer((Date)lastModified.getTime(), (String)"EE, dd yyyy", (Locale)new Locale(language), (int)TimeConvertUtils.YEAR));
            boolean isRead = Boolean.parseBoolean(notificationInfo.getValueOwnerParameter(NotificationMessageUtils.READ_PORPERTY.getKey()));
            templateContext.put((Object)"READ", (Object)(isRead ? "read" : "unread"));
            templateContext.put((Object)"NOTIFICATION_ID", (Object)notificationInfo.getId());
            String body = TemplateUtils.processGroovy((TemplateContext)templateContext);
            notificationContext.setException(templateContext.getException());
            MessageInfo messageInfo = new MessageInfo();
            return messageInfo.body(body).end();
        }

        protected boolean makeDigest(NotificationContext notificationContext, Writer writer) {
            return false;
        }
    }
}

