/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.storage;

import org.exoplatform.documents.dao.PublicDocumentAccessDAO;
import org.exoplatform.documents.entity.PublicDocumentAccessEntity;
import org.exoplatform.documents.model.PublicDocumentAccess;
import org.exoplatform.documents.storage.PublicDocumentAccessStorage;
import org.exoplatform.documents.utils.EntityMapper;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;

public class PublicDocumentAccessStorageImpl
implements PublicDocumentAccessStorage {
    private PublicDocumentAccessDAO publicDocumentAccessDAO;
    private IdentityManager identityManager;

    public PublicDocumentAccessStorageImpl(PublicDocumentAccessDAO publicDocumentAccessDAO, IdentityManager identityManager) {
        this.publicDocumentAccessDAO = publicDocumentAccessDAO;
        this.identityManager = identityManager;
    }

    public PublicDocumentAccess getPublicDocumentAccessByNodeId(String nodeId) {
        return EntityMapper.toDocumentPublicAccess(this.publicDocumentAccessDAO.getPublicDocumentAccessByNodeId(nodeId));
    }

    public void removePublicDocumentAccess(String nodeId) {
        PublicDocumentAccess publicDocumentAccess = this.getPublicDocumentAccessByNodeId(nodeId);
        if (publicDocumentAccess != null) {
            this.publicDocumentAccessDAO.delete(EntityMapper.toPublicDocumentAccessEntity(publicDocumentAccess));
        }
    }

    public PublicDocumentAccess savePublicDocumentAccess(PublicDocumentAccess publicDocumentAccess, long userId) {
        if (publicDocumentAccess == null) {
            throw new IllegalArgumentException("document access object argument is null");
        }
        Identity identity = this.identityManager.getIdentity(String.valueOf(userId));
        if (identity == null) {
            throw new IllegalArgumentException("identity is not exist");
        }
        PublicDocumentAccessEntity publicDocumentAccessEntity = EntityMapper.toPublicDocumentAccessEntity(publicDocumentAccess);
        if (publicDocumentAccessEntity.getId() == 0L) {
            publicDocumentAccessEntity.setId(null);
            return EntityMapper.toDocumentPublicAccess((PublicDocumentAccessEntity)this.publicDocumentAccessDAO.create(publicDocumentAccessEntity));
        }
        return EntityMapper.toDocumentPublicAccess((PublicDocumentAccessEntity)this.publicDocumentAccessDAO.update(publicDocumentAccessEntity));
    }
}

