/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.notification.pwa;

import io.meeds.pwa.model.PwaNotificationMessage;
import io.meeds.pwa.plugin.PwaNotificationPlugin;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.documents.notification.utils.NotificationConstants;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.social.core.manager.IdentityManager;

public class AddDocumentCollaboratorPwaPlugin
implements PwaNotificationPlugin {
    public static final String ID = "AddDocumentCollaboratorPlugin";
    private ResourceBundleService resourceBundleService;
    private static final String TITLE_LABEL_KEY = "pwa.notification.AddDocumentCollaboratorPwaPlugin.title";
    private IdentityManager identityManager;

    public AddDocumentCollaboratorPwaPlugin(ResourceBundleService resourceBundleService, IdentityManager identityManager) {
        this.resourceBundleService = resourceBundleService;
        this.identityManager = identityManager;
    }

    public IdentityManager getIdentityManager() {
        return this.identityManager;
    }

    public String getId() {
        return ID;
    }

    public PwaNotificationMessage process(NotificationInfo notification, LocaleConfig localeConfig) {
        PwaNotificationMessage notificationMessage = new PwaNotificationMessage();
        String userFullName = this.getFullName(notification.getValueOwnerParameter(NotificationConstants.FROM_USER.getKey()));
        String title = this.resourceBundleService.getSharedString(TITLE_LABEL_KEY, localeConfig.getLocale()).replace("{0}", userFullName).replace("{1}", notification.getValueOwnerParameter(NotificationConstants.DOCUMENT_NAME.getKey()));
        notificationMessage.setTitle(title);
        String url = notification.getValueOwnerParameter(NotificationConstants.DOCUMENT_URL.getKey());
        url = url.replace(CommonsUtils.getCurrentDomain(), "");
        notificationMessage.setUrl(url);
        return notificationMessage;
    }
}

